/*
 * Decompiled with CFR 0.152.
 */
import DartPackage.AboutBox;
import DartPackage.AdultPassageDialog;
import DartPackage.DartImpl;
import DartPackage.DartInterface;
import DartPackage.DartObservable;
import DartPackage.DartUtils;
import DartPackage.DataContainer;
import DartPackage.GraphFrame;
import DartPackage.HelpFrame;
import DartPackage.JuvenilePassageDialog;
import DartPackage.RiverEnvDialog;
import DartPackage.ThreeColumnDialog;
import DartPackage.nullThreeColumn;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DartApplet
extends Applet
implements Observer {
    boolean startedAsApp = false;
    DartInterface dartInter = null;
    private static String version = "2.11";
    static JFrame appFrame;
    public static DartApplet applt;
    protected ThreeColumnDialog tcd;
    protected ThreeColumnDialog AdultTCD = null;
    protected ThreeColumnDialog RiverEnvTCD = null;
    protected ThreeColumnDialog JuvenileTCD = null;
    protected ThreeColumnDialog[] tcdArr = new ThreeColumnDialog[3];
    protected File favDirecory = null;
    protected Font AppFont = Font.decode("Arial");
    JPanel mainPanel = new JPanel();
    Panel contentPanel = new Panel(null);
    JLabel MainLabel = new JLabel();
    JButton GraphWindowButton = new JButton();
    JButton QuitButton = new JButton();
    JLabel versionWarningLabel = new JLabel();
    JButton HelpButton = new JButton();
    JToggleButton JuvenilePassButton = new JToggleButton();
    JToggleButton RiverEnvirButton = new JToggleButton();
    JToggleButton AdultPassButton = new JToggleButton();
    ButtonGroup TCDButttons = new ButtonGroup();
    JPanel LogoPanel = new JPanel();
    JButton AboutButton = new JButton();
    JLabel label1 = new JLabel();
    JLabel label2 = new JLabel();
    JComboBox FavoritesChoice = new JComboBox();
    JLabel label3 = new JLabel();
    JButton findFavs = new JButton();
    JLabel logoLabel = new JLabel();
    static File favDir;
    static String favDirPath;
    static DartObservable favOb;

    void terminate() {
        this.stop();
        appFrame.setVisible(false);
        appFrame.dispose();
        System.exit(0);
    }

    void addListener() {
        appFrame.addWindowListener(new listener());
    }

    public static void main(String[] stringArray) {
        DartImpl.clearCache();
        appFrame = new JFrame("Columbia Basin Research - JavaDART");
        applt = new DartApplet();
        DartApplet.applt.startedAsApp = true;
        appFrame.setResizable(false);
        appFrame.setSize(790, 440);
        applt.addListener();
        appFrame.getContentPane().add(applt);
        applt.init();
        applt.start();
        appFrame.setVisible(true);
        appFrame.pack();
    }

    public void init() {
        String string;
        try {
            this.dartInter = new DartImpl();
        }
        catch (Exception exception) {
            System.out.println("Applet exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.mainPanel.setLayout(null);
        this.setSize(790, 415);
        this.resize(790, 415);
        this.contentPanel.setBackground(Color.lightGray);
        this.mainPanel.setSize(220, 415);
        this.mainPanel.setLocation(0, 0);
        this.mainPanel.add(this.MainLabel);
        this.mainPanel.setFont(this.AppFont);
        this.RiverEnvirButton.setText("River Environment");
        this.RiverEnvirButton.setToolTipText("Create Graphs from River Data");
        this.RiverEnvirButton.setFont(this.AppFont);
        this.QuitButton.setFont(this.AppFont);
        this.AdultPassButton.setFont(this.AppFont);
        this.versionWarningLabel.setFont(this.AppFont);
        this.JuvenilePassButton.setFont(this.AppFont);
        this.LogoPanel.setFont(this.AppFont);
        this.HelpButton.setFont(this.AppFont);
        this.label1.setFont(this.AppFont);
        this.label2.setFont(this.AppFont);
        this.label3.setFont(this.AppFont);
        this.AboutButton.setFont(this.AppFont);
        this.findFavs.setFont(this.AppFont);
        this.logoLabel.setFont(this.AppFont);
        this.mainPanel.add(this.RiverEnvirButton);
        this.RiverEnvirButton.setBounds(50, 31, 132, 24);
        this.AdultPassButton.setText("Adult Passage");
        this.AdultPassButton.setToolTipText("Create Graphs from Adult Passage Data");
        this.mainPanel.add(this.AdultPassButton);
        this.AdultPassButton.setBounds(50, 55, 132, 24);
        this.QuitButton.setText("Quit");
        this.mainPanel.add(this.QuitButton);
        this.QuitButton.setBounds(12, 335, 60, 24);
        this.versionWarningLabel.setText("<html><b>New client software is available at: </b></html>");
        this.mainPanel.add(this.versionWarningLabel);
        this.versionWarningLabel.setForeground(Color.red);
        this.versionWarningLabel.setBounds(12, 360, 373, 24);
        this.versionWarningLabel.setFont(this.AppFont);
        this.JuvenilePassButton.setText("Juvenile Passage");
        this.JuvenilePassButton.setToolTipText("Create Graphs from Juvenile Passage Data");
        this.mainPanel.add(this.JuvenilePassButton);
        this.JuvenilePassButton.setBounds(50, 79, 132, 24);
        this.LogoPanel.setLayout(new BorderLayout(0, 0));
        this.LogoPanel.setBounds(60, 196, 214, 185);
        this.AboutButton.setText("About");
        this.mainPanel.add(this.AboutButton);
        this.HelpButton.setText("Help");
        this.HelpButton.setBounds(155, 335, 65, 24);
        this.mainPanel.add(this.HelpButton);
        this.AboutButton.setBounds(80, 335, 65, 24);
        this.label1.setText("Graph Type:");
        this.label1.setHorizontalAlignment(0);
        this.mainPanel.add(this.label1);
        this.label1.setBounds(52, 6, 134, 24);
        this.label2.setText("Favorites List:");
        this.label2.setHorizontalAlignment(4);
        this.mainPanel.add(this.label2);
        this.label2.setBounds(40, 273, 108, 24);
        this.mainPanel.add(this.FavoritesChoice);
        this.FavoritesChoice.setBounds(12, 300, 140, 21);
        this.label3.setText("www.cbr.washington.edu/dart/javadart");
        this.label3.setFont(this.AppFont);
        this.mainPanel.add(this.label3);
        this.label3.setBounds(12, 385, 335, 12);
        this.findFavs.setSize(60, 21);
        this.findFavs.setLocation(160, 300);
        this.findFavs.setText("Browse");
        this.findFavs.setMargin(new Insets(5, 0, 5, 0));
        this.mainPanel.add(this.findFavs);
        URL uRL = this.getClass().getResource("DartPackage/javaDART.gif");
        this.logoLabel.setLocation(20, 115);
        this.logoLabel.setSize(189, 159);
        this.logoLabel.setIcon(new ImageIcon(uRL));
        this.mainPanel.add(this.logoLabel);
        this.tcd = new nullThreeColumn(this.dartInter, favOb);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("prob look and feel");
        }
        this.add(this.contentPanel);
        this.setLayout(null);
        this.contentPanel.setSize(790, 415);
        this.contentPanel.setLocation(0, 0);
        this.contentPanel.add(this.mainPanel);
        this.contentPanel.add(this.tcd);
        this.tcd.setLocation(220, 0);
        this.tcd.setSize(600, 415);
        SwingUtilities.updateComponentTreeUI(this.contentPanel);
        this.tcd.setLocation(220, 0);
        this.tcd.setSize(600, 415);
        SymAction symAction = new SymAction();
        this.GraphWindowButton.addActionListener(symAction);
        this.RiverEnvirButton.addActionListener(symAction);
        this.AdultPassButton.addActionListener(symAction);
        this.QuitButton.addActionListener(symAction);
        this.JuvenilePassButton.addActionListener(symAction);
        this.AboutButton.addActionListener(symAction);
        this.HelpButton.addActionListener(symAction);
        this.findFavs.addActionListener(symAction);
        if (!this.startedAsApp) {
            this.QuitButton.setVisible(false);
        }
        this.MainLabel.setText(this.MainLabel.getText() + version);
        this.fillFavorites();
        favOb.addObserver(this);
        if (this.startedAsApp) {
            SymItem symItem = new SymItem();
            this.FavoritesChoice.addItemListener(symItem);
            if (favDirPath != null) {
                this.findFavs.setVisible(false);
            }
        }
        boolean bl = false;
        if (!this.dartInter.okToAccess()) {
            DartUtils.showAccessRefusedBox(this);
            System.exit(0);
        }
        if ((string = this.dartInter.getVersion()) == null || string.equals("error")) {
            bl = true;
        }
        this.versionWarningLabel.setVisible(!version.equals(string));
        int n = this.dartInter.getFirstYear();
        int n2 = this.dartInter.getLastYear();
        if (n == -1 || n2 == -1) {
            bl = true;
        }
        if (bl) {
            try {
                DartUtils.showConnectionErrorBox(this, this.dartInter.getStr());
            }
            catch (Exception exception) {
                DartUtils.showConnectionErrorBox(this, exception.getMessage());
            }
            System.exit(0);
        }
        this.JuvenileTCD = new JuvenilePassageDialog(this.dartInter, favOb, this.tcdArr, n, n2);
        this.RiverEnvTCD = new RiverEnvDialog(this.dartInter, favOb, this.tcdArr, n, n2);
        this.AdultTCD = new AdultPassageDialog(this.dartInter, favOb, this.tcdArr, n, n2);
        this.tcdArr[0] = this.RiverEnvTCD;
        this.tcdArr[1] = this.AdultTCD;
        this.tcdArr[2] = this.JuvenileTCD;
        this.TCDButttons.add(this.RiverEnvirButton);
        this.TCDButttons.add(this.JuvenilePassButton);
        this.TCDButttons.add(this.AdultPassButton);
        DataContainer.cacheDir.mkdir();
    }

    public void start() {
    }

    public void stop() {
        try {
            this.dartInter.closeConnection();
        }
        catch (Exception exception) {
            System.out.println("DartApplet exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        DartImpl.clearCache();
    }

    public void destroy() {
    }

    public void paint(Graphics graphics) {
        graphics.setFont(new Font("SansSerif", 0, 12));
        super.paint(graphics);
    }

    void findFavs_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Find Favorites");
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            favDir = jFileChooser.getSelectedFile();
            favDirPath = jFileChooser.getSelectedFile().getAbsolutePath();
            System.out.println(favDir);
            this.fillFavorites();
            SymItem symItem = new SymItem();
            this.FavoritesChoice.addItemListener(symItem);
        }
    }

    void HelpButton_acitonPerformed(ActionEvent actionEvent) {
        if (!HelpFrame.open) {
            HelpFrame helpFrame = new HelpFrame();
        } else {
            HelpFrame.instance.toFront();
        }
    }

    void RiverEnvirButton_ActionPerformed(ActionEvent actionEvent) {
        this.contentPanel.remove(this.tcd);
        this.tcd = this.RiverEnvTCD;
        this.tcd.setLocation(220, 0);
        this.tcd.setSize(600, 415);
        this.contentPanel.add(this.tcd);
        this.tcd.validate();
        this.tcd.repaint();
    }

    void AdultPassButton_ActionPerformed(ActionEvent actionEvent) {
        this.contentPanel.remove(this.tcd);
        this.tcd = this.AdultTCD;
        this.tcd.setLocation(220, 0);
        this.tcd.setSize(600, 415);
        this.contentPanel.add(this.tcd);
        this.tcd.validate();
        this.tcd.repaint();
    }

    void JuvenilePassButton_ActionPerformed(ActionEvent actionEvent) {
        this.contentPanel.remove(this.tcd);
        this.tcd = this.JuvenileTCD;
        this.tcd.setLocation(220, 0);
        this.tcd.setSize(600, 415);
        this.contentPanel.add(this.tcd);
        this.tcd.validate();
        this.tcd.repaint();
    }

    void QuitButton_actionPerformed(ActionEvent actionEvent) {
        this.terminate();
    }

    void AboutButton_ActionPerformed(ActionEvent actionEvent) {
        new AboutBox();
    }

    void makeSelections(ThreeColumnDialog threeColumnDialog) {
    }

    void fillFavorites() {
        this.FavoritesChoice.removeAllItems();
        this.FavoritesChoice.addItem(" ");
        if (favDirPath == null) {
            try {
                favDir = new File("DARTFavorites");
                favDirPath = favDir.getAbsolutePath();
                System.out.println(favDir.getAbsolutePath());
            }
            catch (Exception exception) {
                System.out.println("Exception caught");
                favDir = null;
                favDirPath = null;
                return;
            }
        }
        try {
            String[] stringArray = favDir.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith(".") || !stringArray[i].endsWith(".gcf")) continue;
                    this.FavoritesChoice.addItem(stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(Observable observable, Object object) {
        if (observable.equals(favOb)) {
            this.fillFavorites();
        }
    }

    void FavoritesChoice_ItemStateChanged(ItemEvent itemEvent) {
        String string = (String)this.FavoritesChoice.getSelectedItem();
        if (string == null) {
            return;
        }
        if (string.compareTo(" ") == 0 || itemEvent.getStateChange() != 1) {
            return;
        }
        GraphFrame graphFrame = new GraphFrame(this.dartInter, favOb, this.tcdArr, null, null);
        graphFrame.readSelfFrom(favDirPath + File.separator + string, this.tcdArr, true);
        this.FavoritesChoice.setSelectedItem(" ");
        if (graphFrame.getSelectionParams().graphType == 0) {
            this.RiverEnvirButton.doClick();
        } else if (graphFrame.getSelectionParams().graphType == 1) {
            this.AdultPassButton.doClick();
        } else if (graphFrame.getSelectionParams().graphType == 2) {
            this.JuvenilePassButton.doClick();
        }
    }

    static {
        favDir = null;
        favDirPath = null;
        favOb = new DartObservable();
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == DartApplet.this.FavoritesChoice) {
                DartApplet.this.FavoritesChoice_ItemStateChanged(itemEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == DartApplet.this.RiverEnvirButton) {
                DartApplet.this.RiverEnvirButton_ActionPerformed(actionEvent);
            } else if (object == DartApplet.this.AdultPassButton) {
                DartApplet.this.AdultPassButton_ActionPerformed(actionEvent);
            } else if (object == DartApplet.this.QuitButton) {
                DartApplet.this.QuitButton_actionPerformed(actionEvent);
            } else if (object == DartApplet.this.JuvenilePassButton) {
                DartApplet.this.JuvenilePassButton_ActionPerformed(actionEvent);
            } else if (object == DartApplet.this.AboutButton) {
                DartApplet.this.AboutButton_ActionPerformed(actionEvent);
            } else if (object == DartApplet.this.HelpButton) {
                DartApplet.this.HelpButton_acitonPerformed(actionEvent);
            } else if (object == DartApplet.this.findFavs) {
                DartApplet.this.findFavs_actionPerformed(actionEvent);
            }
        }
    }

    class listener
    extends WindowAdapter {
        listener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            applt.terminate();
        }
    }
}

