/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.Positionable;
import DartPackage.SingleExtFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.FileInputStream;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class DartUtils {
    static String getProperPathname(JFileChooser jFileChooser) {
        FileFilter fileFilter;
        String string = jFileChooser.getSelectedFile().getPath();
        if (DartUtils.getFilenameExtension(string) == null && (fileFilter = jFileChooser.getFileFilter()) instanceof SingleExtFileFilter) {
            SingleExtFileFilter singleExtFileFilter = (SingleExtFileFilter)fileFilter;
            return string + "." + singleExtFileFilter.getExtension();
        }
        return string;
    }

    static String getFilenameExtension(String string) {
        int n;
        int n2 = string.lastIndexOf(".");
        if (n2 > (n = string.lastIndexOf(System.getProperty("file.separator"))) && n2 < string.length() - 1) {
            return string.substring(n2 + 1);
        }
        return null;
    }

    public static void centerWindow(Window window, Window window2) {
        Rectangle rectangle;
        int n;
        int n2;
        int n3;
        int n4;
        if (window2 == null) {
            n4 = 0;
            n3 = 0;
            Dimension dimension = window.getToolkit().getScreenSize();
            n2 = dimension.width;
            n = dimension.height;
        } else {
            rectangle = window2.getBounds();
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
        }
        rectangle = window.getBounds();
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = n4 + (n2 - n5) / 2;
        int n8 = n3 + (n - n6) / 2;
        window.setBounds(n7, n8, n5, n6);
    }

    static void positionDialog(Positionable positionable, Frame frame) {
        int n = positionable.getPrefX();
        int n2 = positionable.getPrefY();
        if (n >= 0 && n2 >= 0) {
            positionable.setPos(n, n2);
        } else if (frame != null) {
            Dimension dimension = frame.getToolkit().getScreenSize();
            Rectangle rectangle = positionable.getBoundsRect();
            Rectangle rectangle2 = frame.getBounds();
            if (rectangle2.y + rectangle2.height + rectangle.height <= dimension.height) {
                n2 = rectangle2.y + rectangle2.height;
                n = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
            } else if (rectangle2.y >= rectangle.height) {
                n2 = rectangle2.y = rectangle.height;
                n = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
            } else if (rectangle2.x + rectangle2.width + rectangle.width <= dimension.width) {
                n2 = rectangle2.y;
                n = rectangle2.x + rectangle2.width;
            } else if (rectangle2.x >= rectangle.width) {
                n2 = rectangle2.y;
                n = rectangle2.x - rectangle.width;
            } else {
                n = rectangle2.x + (rectangle2.width - rectangle.width) / 2;
                n2 = rectangle2.y + (rectangle2.height - rectangle.height) / 2;
            }
            positionable.setPrefPos(n, n2);
            positionable.setPos(n, n2);
        }
    }

    static ImageIcon readImageIcon(Object object, String string) {
        ImageIcon imageIcon = null;
        byte[] byArray = new byte[4000];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            while (fileInputStream.available() > 0) {
                fileInputStream.read(byArray);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("exception caugt reading file" + exception);
        }
        imageIcon = new ImageIcon(byArray);
        return imageIcon;
    }

    public static void showConnectionErrorBox(Component component, String string) {
        String string2 = "Could not connect to DART server.\nThe DART server is down daily 1:00am-3:30am and 5:30am-8:30am, PST.\nMessage from DART server was:\n" + string + "\nEmail web@cbr.washington.edu with questions.";
        JOptionPane.showMessageDialog(component, string2, "javaDART", 1);
    }

    public static void showAccessRefusedBox(Component component) {
        String string = "The DART server has refused client access.\nThe DART server is down daily 1:00am-3:30am and 5:30am-8:30am, PST.\nThe DART server may be down briefly at other times for maintenance.\nEmail web@cbr.washington.edu with questions.";
        JOptionPane.showMessageDialog(component, string, "javaDART", 1);
    }
}

