/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.DartUtils;
import DartPackage.GraphDecoration;
import DartPackage.GraphFrame;
import DartPackage.Positionable;
import DartPackage.SelectionObject;
import DartPackage.SelectionObjectFactory;
import DartPackage.StringListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;

class DataConDialog
extends JDialog
implements Positionable {
    protected SelectionObject mySO;
    protected GraphFrame myFrame;
    protected boolean succeeded = false;
    static Font AppFont = new Font("Dialog", 0, 12);
    protected boolean changedData = false;
    MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                DataConDialog.this.OKButton_actionPerformed(null);
            }
        }
    };
    protected static int prefXPos = -1;
    protected static int prefYPos = -1;
    JPanel JPanel1 = new JPanel();
    JLabel MainLabel = new JLabel();
    JTextField NameTextField = new JTextField();
    JLabel NameLabel = new JLabel();
    JTextField AbbrevTextField = new JTextField();
    JLabel AbbrevLabel = new JLabel();
    JScrollPane ColorScrollPane = new JScrollPane();
    JList ColorList = new JList();
    JLabel ColorLabel = new JLabel();
    JScrollPane DecorationScrollPane = new JScrollPane();
    JList DecorationList = new JList();
    JLabel DecorationLabel = new JLabel();
    JScrollPane FeatureScrollPane = new JScrollPane();
    JList FeatureList = new JList();
    JLabel FeatureLabel = new JLabel();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JTextField StartYearTextField = new JTextField();
    JLabel StartYearLabel = new JLabel();
    JLabel EndYearLabel = new JLabel();
    JTextField EndYearTextField = new JTextField();
    JLabel JLabel1 = new JLabel();
    JButton DataFilterButton = new JButton();
    JButton UseDefaultNamesButton = new JButton();
    JCheckBox AccumulateCheckBox = new JCheckBox();
    JCheckBox FilterDataCheckBox = new JCheckBox();
    JCheckBox HighLightCheckBox = new JCheckBox();
    JCheckBox HistSumCheckBox = new JCheckBox();
    JCheckBox HistAverageCheckBox = new JCheckBox();
    StringListModel stringListModel1 = new StringListModel();
    StringListModel stringListModel2 = new StringListModel();
    StringListModel stringListModel3 = new StringListModel();
    ButtonGroup HistogramGroup = new ButtonGroup();

    boolean succeeded() {
        return this.succeeded;
    }

    boolean changedData() {
        return this.changedData;
    }

    public int getPrefX() {
        return prefXPos;
    }

    public int getPrefY() {
        return prefYPos;
    }

    public void setPrefPos(int n, int n2) {
        prefXPos = n;
        prefYPos = n2;
    }

    public void setPos(int n, int n2) {
        this.setLocation(n, n2);
    }

    public Rectangle getBoundsRect() {
        return this.getBounds();
    }

    DataConDialog(GraphFrame graphFrame, SelectionObject selectionObject) {
        this.mySO = selectionObject;
        this.myFrame = graphFrame;
        this.setTitle("Customize Selection Object");
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(519, 458);
        this.setVisible(false);
        this.JPanel1.setLayout(null);
        this.getContentPane().add("Center", this.JPanel1);
        this.MainLabel.setHorizontalAlignment(0);
        this.MainLabel.setText("Edit a displayable selection object");
        this.JPanel1.add(this.MainLabel);
        this.MainLabel.setForeground(Color.black);
        this.MainLabel.setFont(AppFont);
        this.MainLabel.setBounds(36, 12, 300, 12);
        this.NameTextField.setColumns(20);
        this.NameTextField.setCursor(Cursor.getPredefinedCursor(2));
        this.JPanel1.add(this.NameTextField);
        this.NameTextField.setBounds(96, 36, 336, 24);
        this.NameLabel.setHorizontalTextPosition(2);
        this.NameLabel.setHorizontalAlignment(0);
        this.NameLabel.setText("Full Name:");
        this.JPanel1.add(this.NameLabel);
        this.NameLabel.setForeground(Color.black);
        this.NameLabel.setFont(AppFont);
        this.NameLabel.setBounds(12, 36, 84, 24);
        this.AbbrevTextField.setColumns(20);
        this.AbbrevTextField.setCursor(Cursor.getPredefinedCursor(2));
        this.JPanel1.add(this.AbbrevTextField);
        this.AbbrevTextField.setBounds(96, 72, 132, 24);
        this.AbbrevLabel.setHorizontalAlignment(0);
        this.AbbrevLabel.setText("Abbreviation:");
        this.JPanel1.add(this.AbbrevLabel);
        this.AbbrevLabel.setForeground(Color.black);
        this.AbbrevLabel.setFont(AppFont);
        this.AbbrevLabel.setBounds(12, 72, 84, 21);
        this.ColorScrollPane.setOpaque(true);
        this.JPanel1.add(this.ColorScrollPane);
        this.ColorScrollPane.setBounds(300, 132, 84, 96);
        this.ColorList.setSelectionMode(0);
        this.ColorScrollPane.getViewport().add(this.ColorList);
        this.ColorList.setBounds(0, 0, 81, 93);
        this.ColorLabel.setHorizontalAlignment(0);
        this.ColorLabel.setText("Color");
        this.JPanel1.add(this.ColorLabel);
        this.ColorLabel.setForeground(Color.black);
        this.ColorLabel.setFont(AppFont);
        this.ColorLabel.setBounds(300, 108, 82, 23);
        this.DecorationScrollPane.setOpaque(true);
        this.JPanel1.add(this.DecorationScrollPane);
        this.DecorationScrollPane.setBounds(396, 132, 84, 97);
        this.DecorationList.setSelectionMode(0);
        this.DecorationScrollPane.getViewport().add(this.DecorationList);
        this.DecorationList.setBounds(0, 0, 81, 94);
        this.DecorationLabel.setHorizontalAlignment(0);
        this.DecorationLabel.setText("Decoration");
        this.JPanel1.add(this.DecorationLabel);
        this.DecorationLabel.setForeground(Color.black);
        this.DecorationLabel.setFont(AppFont);
        this.DecorationLabel.setBounds(396, 108, 81, 24);
        this.FeatureScrollPane.setOpaque(true);
        this.JPanel1.add(this.FeatureScrollPane);
        this.FeatureScrollPane.setBounds(12, 132, 264, 276);
        this.FeatureList.setSelectionMode(0);
        this.FeatureScrollPane.getViewport().add(this.FeatureList);
        this.FeatureList.setBounds(0, 0, 261, 273);
        this.FeatureLabel.setHorizontalAlignment(0);
        this.FeatureLabel.setText("Projects and Locations");
        this.JPanel1.add(this.FeatureLabel);
        this.FeatureLabel.setForeground(Color.black);
        this.FeatureLabel.setFont(AppFont);
        this.FeatureLabel.setBounds(12, 108, 128, 24);
        this.OKButton.setText("OK");
        this.OKButton.setActionCommand("OK");
        this.JPanel1.add(this.OKButton);
        this.OKButton.setFont(AppFont);
        this.OKButton.setBounds(408, 384, 60, 24);
        this.CancelButton.setText("Cancel");
        this.CancelButton.setActionCommand("Cancel");
        this.JPanel1.add(this.CancelButton);
        this.CancelButton.setFont(AppFont);
        this.CancelButton.setBounds(312, 384, 86, 24);
        this.JPanel1.add(this.StartYearTextField);
        this.StartYearTextField.setBounds(348, 240, 48, 24);
        this.StartYearLabel.setHorizontalAlignment(4);
        this.StartYearLabel.setText("Start Year:");
        this.JPanel1.add(this.StartYearLabel);
        this.StartYearLabel.setForeground(Color.black);
        this.StartYearLabel.setFont(AppFont);
        this.StartYearLabel.setBounds(288, 240, 60, 24);
        this.EndYearLabel.setHorizontalAlignment(4);
        this.EndYearLabel.setText("End Year:");
        this.JPanel1.add(this.EndYearLabel);
        this.EndYearLabel.setForeground(Color.black);
        this.EndYearLabel.setFont(AppFont);
        this.EndYearLabel.setBounds(396, 240, 60, 24);
        this.JPanel1.add(this.EndYearTextField);
        this.EndYearTextField.setBounds(456, 240, 48, 24);
        this.JLabel1.setText("...");
        this.JPanel1.add(this.JLabel1);
        this.JLabel1.setForeground(Color.black);
        this.JLabel1.setFont(AppFont);
        this.JLabel1.setBounds(240, 420, 9, 25);
        this.DataFilterButton.setText("DF Params...");
        this.DataFilterButton.setActionCommand("DF Params...");
        this.DataFilterButton.setFont(AppFont);
        this.DataFilterButton.setBounds(396, 348, 107, 27);
        this.UseDefaultNamesButton.setText("Use Default Names");
        this.UseDefaultNamesButton.setActionCommand("Use Default Names");
        this.JPanel1.add(this.UseDefaultNamesButton);
        this.UseDefaultNamesButton.setFont(AppFont);
        this.UseDefaultNamesButton.setBounds(264, 72, 172, 25);
        this.AccumulateCheckBox.setText("Accumulate");
        this.AccumulateCheckBox.setActionCommand("Accumulate");
        this.JPanel1.add(this.AccumulateCheckBox);
        this.AccumulateCheckBox.setFont(AppFont);
        this.AccumulateCheckBox.setBounds(396, 312, 108, 24);
        this.FilterDataCheckBox.setText("Data Filter");
        this.FilterDataCheckBox.setActionCommand("Data Filter");
        this.JPanel1.add(this.FilterDataCheckBox);
        this.FilterDataCheckBox.setFont(AppFont);
        this.FilterDataCheckBox.setBounds(300, 348, 95, 24);
        this.HighLightCheckBox.setText("Highlight");
        this.HighLightCheckBox.setActionCommand("Highlight");
        this.JPanel1.add(this.HighLightCheckBox);
        this.HighLightCheckBox.setFont(AppFont);
        this.HighLightCheckBox.setBounds(300, 312, 96, 24);
        this.HistSumCheckBox.setText("Hist. Sum");
        this.HistSumCheckBox.setActionCommand("Hist. Sum");
        this.JPanel1.add(this.HistSumCheckBox);
        this.HistSumCheckBox.setFont(AppFont);
        this.HistSumCheckBox.setBounds(300, 276, 95, 24);
        this.HistAverageCheckBox.setText("Hist. Average");
        this.HistAverageCheckBox.setActionCommand("Hist. Average");
        this.JPanel1.add(this.HistAverageCheckBox);
        this.HistAverageCheckBox.setFont(AppFont);
        this.HistAverageCheckBox.setBounds(396, 276, 108, 24);
        SymAction symAction = new SymAction();
        this.OKButton.addActionListener(symAction);
        this.CancelButton.addActionListener(symAction);
        this.NameTextField.addActionListener(symAction);
        this.AbbrevTextField.addActionListener(symAction);
        SymFocus symFocus = new SymFocus();
        this.NameTextField.addFocusListener(symFocus);
        this.AbbrevTextField.addFocusListener(symFocus);
        this.StartYearTextField.addActionListener(symAction);
        this.EndYearTextField.addActionListener(symAction);
        this.DataFilterButton.addActionListener(symAction);
        this.UseDefaultNamesButton.addActionListener(symAction);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        this.FeatureList.setFont(AppFont);
        this.DecorationList.setFont(AppFont);
        this.ColorList.setFont(AppFont);
        this.NameTextField.setFont(AppFont);
        this.EndYearTextField.setFont(AppFont);
        this.StartYearTextField.setFont(AppFont);
        this.AbbrevTextField.setFont(AppFont);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.HistogramGroup.add(this.HistSumCheckBox);
        this.HistogramGroup.add(this.HistAverageCheckBox);
        this.ColorList.addMouseListener(this.mouseListener);
        this.DecorationList.addMouseListener(this.mouseListener);
        this.FeatureList.addMouseListener(this.mouseListener);
        this.ColorList.setModel(this.stringListModel1);
        this.DecorationList.setModel(this.stringListModel2);
        this.FeatureList.setModel(this.stringListModel3);
        this.fillDialog();
        DartUtils.positionDialog(this, this.myFrame);
        this.show();
    }

    void OKButton_actionPerformed(ActionEvent actionEvent) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        String string = null;
        String string2 = "Configuring Selection Object";
        ListSelectionModel listSelectionModel = this.FeatureList.getSelectionModel();
        n3 = listSelectionModel.getMinSelectionIndex();
        if (n3 == -1) {
            JOptionPane.showMessageDialog(this, "You must select a physical location", string2, 1);
            return;
        }
        listSelectionModel = this.DecorationList.getSelectionModel();
        n5 = listSelectionModel.getMinSelectionIndex();
        if (n5 == -1) {
            JOptionPane.showMessageDialog(this, "You must select a decoration (perhaps NONE)", string2, 1);
            return;
        }
        listSelectionModel = this.ColorList.getSelectionModel();
        n4 = listSelectionModel.getMinSelectionIndex();
        if (n4 == -1) {
            JOptionPane.showMessageDialog(this, "You must select a color", string2, 1);
            return;
        }
        n = this.getStartYear();
        if (n < 0) {
            return;
        }
        n2 = this.getEndYear();
        if (n2 < 0) {
            return;
        }
        if (n > n2) {
            JOptionPane.showMessageDialog(this, "Start year must be <= end year", string2, 1);
            return;
        }
        this.mySO.setNameStr(this.NameTextField.getText());
        this.mySO.setAbbrevNameStr(this.AbbrevTextField.getText());
        if (this.mySO.minYear() != n) {
            this.mySO.setMinYear(n);
            this.changedData = true;
        }
        if (this.mySO.maxYear() != n2) {
            this.mySO.setMaxYear(n2);
            this.changedData = true;
        }
        switch (n4) {
            case 0: {
                this.mySO.setColor(Color.black);
                break;
            }
            case 1: {
                this.mySO.setColor(Color.blue);
                break;
            }
            case 2: {
                this.mySO.setColor(Color.green);
                break;
            }
            case 3: {
                this.mySO.setColor(Color.red);
                break;
            }
            case 4: {
                this.mySO.setColor(new Color(102, 51, 0));
                break;
            }
            case 5: {
                this.mySO.setColor(Color.cyan);
                break;
            }
            case 6: {
                this.mySO.setColor(new Color(0, 102, 51));
                break;
            }
            case 7: {
                this.mySO.setColor(Color.gray);
                break;
            }
            case 8: {
                this.mySO.setColor(Color.magenta);
                break;
            }
            case 9: {
                this.mySO.setColor(new Color(153, 0, 51));
                break;
            }
            case 10: {
                this.mySO.setColor(new Color(255, 204, 51));
                break;
            }
            case 11: {
                this.mySO.setColor(new Color(0, 0, 153));
                break;
            }
            case 12: {
                this.mySO.setColor(new Color(255, 102, 51));
                break;
            }
            case 13: {
                this.mySO.setColor(new Color(102, 0, 153));
                break;
            }
            case 14: {
                this.mySO.setColor(new Color(51, 153, 153));
            }
        }
        if (n5 == 0) {
            this.mySO.setDecoration(null);
        } else {
            this.mySO.setDecoration((GraphDecoration)GraphDecoration.decorationList().get(n5 - 1));
        }
        StringListModel stringListModel = (StringListModel)this.FeatureList.getModel();
        string = (String)stringListModel.elementAt(n3);
        if (!string.equals(this.mySO.getFeatureName())) {
            this.mySO.setFeatureName(string);
            this.changedData = true;
        }
        this.mySO.setAccumulate(this.AccumulateCheckBox.isSelected());
        this.mySO.setHighlight(this.HighLightCheckBox.isSelected());
        this.mySO.setFilterData(this.FilterDataCheckBox.isSelected());
        this.mySO.setHistAverage(this.HistAverageCheckBox.isSelected());
        this.succeeded = true;
        this.rememberLocation();
        this.dispose();
    }

    protected int getStartYear() {
        return this.getAYear(this.StartYearTextField.getText());
    }

    protected int getEndYear() {
        return this.getAYear(this.EndYearTextField.getText());
    }

    protected int getAYear(String string) {
        int n = -1;
        boolean bl = true;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (!bl || n < 1900 || n > 2020) {
            JOptionPane.showMessageDialog(this, "You must enter a year between 1900 and 2020", "Configuring Selection Object", 1);
            return -1;
        }
        return n;
    }

    protected void rememberLocation() {
        Point point = this.getLocation();
        prefXPos = point.x;
        prefYPos = point.y;
    }

    void CancelButton_actionPerformed(ActionEvent actionEvent) {
        this.rememberLocation();
        this.dispose();
    }

    protected void fillDialog() {
        this.NameTextField.setText(this.mySO.nameStr());
        this.AbbrevTextField.setText(this.mySO.abbrevNameStr());
        this.MainLabel.setText("Edit a " + this.mySO.typeString() + " selection object");
        StringListModel stringListModel = (StringListModel)this.ColorList.getModel();
        stringListModel.addElement("Black");
        stringListModel.addElement("Blue");
        stringListModel.addElement("Green");
        stringListModel.addElement("Red");
        stringListModel.addElement("Brown");
        stringListModel.addElement("Cyan");
        stringListModel.addElement("Forest");
        stringListModel.addElement("Gray");
        stringListModel.addElement("Magenta");
        stringListModel.addElement("Maroon");
        stringListModel.addElement("Mustard");
        stringListModel.addElement("Navy");
        stringListModel.addElement("Orange");
        stringListModel.addElement("Purple");
        stringListModel.addElement("Teal");
        ListSelectionModel listSelectionModel = this.ColorList.getSelectionModel();
        if (this.mySO.color().equals(Color.black)) {
            listSelectionModel.addSelectionInterval(0, 0);
        } else if (this.mySO.color().equals(Color.blue)) {
            listSelectionModel.addSelectionInterval(1, 1);
        } else if (this.mySO.color().equals(Color.green)) {
            listSelectionModel.addSelectionInterval(2, 2);
        } else if (this.mySO.color().equals(Color.red)) {
            listSelectionModel.addSelectionInterval(3, 3);
        } else if (this.mySO.color().equals(new Color(102, 51, 0))) {
            listSelectionModel.addSelectionInterval(4, 4);
        } else if (this.mySO.color().equals(Color.cyan)) {
            listSelectionModel.addSelectionInterval(5, 5);
        } else if (this.mySO.color().equals(new Color(0, 102, 51))) {
            listSelectionModel.addSelectionInterval(6, 6);
        } else if (this.mySO.color().equals(Color.gray)) {
            listSelectionModel.addSelectionInterval(7, 7);
        } else if (this.mySO.color().equals(Color.magenta)) {
            listSelectionModel.addSelectionInterval(8, 8);
        } else if (this.mySO.color().equals(new Color(153, 0, 51))) {
            listSelectionModel.addSelectionInterval(9, 9);
        } else if (this.mySO.color().equals(new Color(255, 204, 51))) {
            listSelectionModel.addSelectionInterval(10, 10);
        } else if (this.mySO.color().equals(new Color(0, 0, 153))) {
            listSelectionModel.addSelectionInterval(11, 11);
        } else if (this.mySO.color().equals(new Color(255, 102, 51))) {
            listSelectionModel.addSelectionInterval(12, 12);
        } else if (this.mySO.color().equals(new Color(102, 0, 153))) {
            listSelectionModel.addSelectionInterval(13, 13);
        } else if (this.mySO.color().equals(new Color(51, 153, 153))) {
            listSelectionModel.addSelectionInterval(14, 14);
        }
        stringListModel = (StringListModel)this.DecorationList.getModel();
        stringListModel.addElement("None");
        ListIterator listIterator = GraphDecoration.decorationIter();
        int n = 1;
        int n2 = 0;
        while (listIterator.hasNext()) {
            GraphDecoration graphDecoration = (GraphDecoration)listIterator.next();
            stringListModel.addElement(graphDecoration.name());
            if (this.mySO.decoration() != null && this.mySO.decoration().getClass() == graphDecoration.getClass()) {
                n2 = n;
            }
            ++n;
        }
        listSelectionModel = this.DecorationList.getSelectionModel();
        listSelectionModel.addSelectionInterval(n2, n2);
        stringListModel = (StringListModel)this.FeatureList.getModel();
        n = 0;
        n2 = -1;
        if (this.mySO.validAtDam()) {
            for (int i = 0; i < SelectionObject.damArr.length; ++i) {
                stringListModel.addElement(SelectionObject.damArr[i]);
                if (this.mySO.getFeature().equals(SelectionObject.nameToFeatureDam.get(SelectionObject.damArr[i]))) {
                    n2 = n;
                }
                ++n;
            }
        } else if (this.mySO.validAtProj()) {
            for (int i = 0; i < SelectionObject.projArr.length; ++i) {
                stringListModel.addElement(SelectionObject.projArr[i]);
                if (this.mySO.getFeature().equals(SelectionObject.nameToFeatureProj.get(SelectionObject.projArr[i]))) {
                    n2 = n;
                }
                ++n;
            }
        } else if (this.mySO.validAtSmolt()) {
            for (int i = 0; i < SelectionObject.smoltArr.length; ++i) {
                stringListModel.addElement(SelectionObject.smoltArr[i]);
                if (this.mySO.getFeature().equals(SelectionObject.nameToFeatureSmolt.get(SelectionObject.smoltArr[i]))) {
                    n2 = n;
                }
                ++n;
            }
        }
        listSelectionModel = this.FeatureList.getSelectionModel();
        if (n2 >= 0) {
            listSelectionModel.addSelectionInterval(n2, n2);
        }
        this.AccumulateCheckBox.setSelected(this.mySO.accumulate());
        this.FilterDataCheckBox.setSelected(this.mySO.filterData());
        this.HighLightCheckBox.setSelected(this.mySO.highlight());
        this.HistAverageCheckBox.setSelected(this.mySO.histAverage());
        this.HistSumCheckBox.setSelected(!this.mySO.histAverage());
        if (this.mySO.minYear() == 0) {
            this.mySO.setMinYear(this.myFrame.minYr());
        }
        if (this.mySO.maxYear() == 0) {
            this.mySO.setMaxYear(this.myFrame.maxYr());
        }
        this.StartYearTextField.setText(Integer.toString(this.mySO.minYear()));
        this.EndYearTextField.setText(Integer.toString(this.mySO.maxYear()));
    }

    void NameTextField_actionPerformed(ActionEvent actionEvent) {
        this.OKButton_actionPerformed(actionEvent);
    }

    void AbbrevTextField_actionPerformed(ActionEvent actionEvent) {
        this.OKButton_actionPerformed(actionEvent);
    }

    void StartYearTextField_actionPerformed(ActionEvent actionEvent) {
        this.OKButton_actionPerformed(actionEvent);
    }

    void EndYearTextField_actionPerformed(ActionEvent actionEvent) {
        this.OKButton_actionPerformed(actionEvent);
    }

    void NameTextField_focusLost(FocusEvent focusEvent) {
    }

    void AbbrevTextField_focusLost(FocusEvent focusEvent) {
    }

    void UseDefaultNamesButton_actionPerformed(ActionEvent actionEvent) {
        String string;
        ListSelectionModel listSelectionModel;
        int n = -1;
        SelectionObject selectionObject = null;
        boolean bl = this.AccumulateCheckBox.isSelected();
        ListIterator listIterator = SelectionObjectFactory.factoryList.listIterator(0);
        while (listIterator.hasNext()) {
            SelectionObjectFactory selectionObjectFactory = (SelectionObjectFactory)listIterator.next();
            selectionObject = selectionObjectFactory.captiveObject;
            if (selectionObject.getClass() != this.mySO.getClass()) continue;
        }
        if ((n = (listSelectionModel = this.FeatureList.getSelectionModel()).getMinSelectionIndex()) == -1) {
            string = "Nowhere";
        } else {
            StringListModel stringListModel = (StringListModel)this.FeatureList.getModel();
            String string2 = (String)stringListModel.elementAt(n);
            string = SelectionObject.featureFromName(string2);
        }
        int n2 = this.getStartYear();
        if (n2 < 0) {
            return;
        }
        int n3 = this.getEndYear();
        if (n3 < 0) {
            return;
        }
        this.AbbrevTextField.setText(SelectionObject.defaultAbbrevName(selectionObject, string, n2, n3, bl));
        this.NameTextField.setText(SelectionObject.defaultName(selectionObject, string, n2, n3, bl));
    }

    void DataConDialog_windowClosing(WindowEvent windowEvent) {
        this.rememberLocation();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == DataConDialog.this) {
                DataConDialog.this.DataConDialog_windowClosing(windowEvent);
            }
        }
    }

    class SymFocus
    extends FocusAdapter {
        SymFocus() {
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == DataConDialog.this.NameTextField) {
                DataConDialog.this.NameTextField_focusLost(focusEvent);
            } else if (object == DataConDialog.this.AbbrevTextField) {
                DataConDialog.this.AbbrevTextField_focusLost(focusEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == DataConDialog.this.OKButton) {
                DataConDialog.this.OKButton_actionPerformed(actionEvent);
            } else if (object == DataConDialog.this.CancelButton) {
                DataConDialog.this.CancelButton_actionPerformed(actionEvent);
            } else if (object == DataConDialog.this.NameTextField) {
                DataConDialog.this.NameTextField_actionPerformed(actionEvent);
            } else if (object == DataConDialog.this.AbbrevTextField) {
                DataConDialog.this.AbbrevTextField_actionPerformed(actionEvent);
            } else if (object == DataConDialog.this.StartYearTextField) {
                DataConDialog.this.StartYearTextField_actionPerformed(actionEvent);
            } else if (object == DataConDialog.this.EndYearTextField) {
                DataConDialog.this.EndYearTextField_actionPerformed(actionEvent);
            } else if (object == DataConDialog.this.UseDefaultNamesButton) {
                DataConDialog.this.UseDefaultNamesButton_actionPerformed(actionEvent);
            }
        }
    }
}

