/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.DartImpl;
import DartPackage.SelectionObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;

public class DataContainer
implements Serializable {
    protected float[] yval;
    protected boolean errorFlag;
    protected boolean refusedFlag;
    protected double yMin;
    protected double yMax;
    protected int minYear;
    protected int maxYear;
    public static File cacheDir = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "DARTDataCache");

    float yVal(int n) {
        return this.yval[n];
    }

    boolean errorFlag() {
        return this.errorFlag;
    }

    boolean refusedFlag() {
        return this.refusedFlag;
    }

    boolean yValExists(int n) {
        if (n >= this.yval.length) {
            return false;
        }
        return (double)this.yval[n] < -12345.61 || (double)this.yval[n] > -12345.59;
    }

    int length() {
        return this.yval == null ? 0 : this.yval.length;
    }

    double yMin() {
        return this.yMin;
    }

    double yMax() {
        return this.yMax;
    }

    int minYear() {
        return this.minYear;
    }

    int maxYear() {
        return this.maxYear;
    }

    static void clearCache() {
        File file = null;
        try {
            String[] stringArray = cacheDir.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith(".")) continue;
                    file = new File(cacheDir, stringArray[i]);
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void readFromDB(DartImpl dartImpl, SelectionObject selectionObject, String string, String string2) {
        block33: {
            Object object;
            int n;
            int n2;
            File file;
            ResultSet resultSet;
            Statement statement;
            block32: {
                this.minYear = selectionObject.minYear();
                this.maxYear = selectionObject.maxYear();
                this.yMin = Double.MAX_VALUE;
                this.yMax = -1.7976931348623157E308;
                statement = null;
                resultSet = null;
                file = null;
                n2 = 366 * (1 + this.maxYear - this.minYear);
                this.yval = new float[n2];
                this.errorFlag = false;
                this.refusedFlag = false;
                for (n = 0; n < n2; ++n) {
                    this.yval[n] = -12345.6f;
                }
                if (cacheDir != null && cacheDir.exists() && (file = new File(cacheDir, selectionObject.cacheName())) != null && file.exists()) {
                    object = null;
                    ObjectInputStream objectInputStream = null;
                    try {
                        object = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream((InputStream)object);
                        for (n = 0; n < n2; ++n) {
                            this.yval[n] = objectInputStream.readFloat();
                        }
                        this.yMin = objectInputStream.readDouble();
                        this.yMax = objectInputStream.readDouble();
                        objectInputStream.close();
                        return;
                    }
                    catch (Exception exception) {
                        if (objectInputStream == null) break block32;
                        try {
                            objectInputStream.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                this.refusedFlag = !dartImpl.okToAccess();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.refusedFlag) {
                return;
            }
            object = selectionObject.query();
            try {
                dartImpl.getConnection();
                if (dartImpl.con == null) {
                    this.errorFlag = true;
                    return;
                }
                statement = dartImpl.con.createStatement();
                resultSet = statement.executeQuery((String)object);
                while (resultSet.next()) {
                    int n3 = resultSet.getInt(1);
                    int n4 = resultSet.getInt(2);
                    int n5 = resultSet.getInt(3);
                    String string3 = resultSet.getString(4);
                    if (string3 == null) continue;
                    int n6 = string3.length();
                    for (n = 0; n < n6 && string3.charAt(n) == ' '; ++n) {
                    }
                    if (n >= n6) continue;
                    try {
                        int n7 = this.getOffset(n3, n4, n5);
                        float f = Float.valueOf(string3).floatValue();
                        if (this.yValExists(n7)) {
                            int n8 = n7;
                            this.yval[n8] = this.yval[n8] + f;
                        } else {
                            this.yval[n7] = f;
                        }
                        this.yMin = Math.min(this.yMin, (double)this.yval[n7]);
                        this.yMax = Math.max(this.yMax, (double)this.yval[n7]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                this.errorFlag = true;
                dartImpl.errorStr = "Connection was lost during read";
            }
            if (!this.errorFlag) {
                try {
                    dartImpl.getConnection();
                    statement = dartImpl.con.createStatement();
                    String string4 = "Insert into jdart_log values ( 'now', '" + string2 + "', '" + string + "', '" + ((String)object).replace('\'', '%') + "' )";
                    statement.execute(string4);
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.errorFlag) {
                try {
                    if (file == null) break block33;
                    FileOutputStream fileOutputStream = null;
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        for (n = 0; n < n2; ++n) {
                            objectOutputStream.writeFloat(this.yval[n]);
                        }
                        objectOutputStream.writeDouble(this.yMin);
                        objectOutputStream.writeDouble(this.yMax);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {
                        if (objectOutputStream == null) break block33;
                        try {
                            objectOutputStream.close();
                            file.delete();
                        }
                        catch (Exception exception3) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    int getOffset(int n, int n2, int n3) {
        return 366 * (n - this.minYear) + DataContainer.getJD(n2, n3);
    }

    static int getJD(int n, int n2) {
        switch (n) {
            case 1: {
                return n2 - 1;
            }
            case 2: {
                return n2 + 30;
            }
            case 3: {
                return n2 + 59;
            }
            case 4: {
                return n2 + 90;
            }
            case 5: {
                return n2 + 120;
            }
            case 6: {
                return n2 + 151;
            }
            case 7: {
                return n2 + 181;
            }
            case 8: {
                return n2 + 212;
            }
            case 9: {
                return n2 + 243;
            }
            case 10: {
                return n2 + 273;
            }
            case 11: {
                return n2 + 304;
            }
            case 12: {
                return n2 + 334;
            }
        }
        return -1;
    }
}

