/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.DartUtils;
import DartPackage.GraphFrame;
import DartPackage.Positionable;
import DartPackage.SelectionObject;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataFilterSlider
extends JDialog
implements Positionable {
    protected GraphFrame myFrame;
    protected SelectionObject mySO;
    float absMin;
    float absMax;
    static Font AppFont = new Font("Dialog", 0, 12);
    String boxTitle = "Data Filtration Parameters Dialog";
    JCheckBox applySO = new JCheckBox("Apply to Object");
    JCheckBox applyAxis = new JCheckBox("Apply to Axis");
    JCheckBox applyGraph = new JCheckBox("Apply to Graph");
    int applyLevel;
    static int SOlevel = 0;
    static int Axislevel = 1;
    static int Graphlevel = 2;
    JCheckBox APlusBTCheckBox = new JCheckBox("Use A + B * Time");
    ButtonGroup applyGroup = new ButtonGroup();
    JTextField AbsMinTextField = new JTextField();
    JTextField AbsMaxTextField = new JTextField();
    JLabel AbsMinLabel = new JLabel();
    JLabel AbsMaxLabel = new JLabel();
    JLabel ASliderLabel = new JLabel();
    JLabel BSliderLabel = new JLabel();
    JLabel formulaLabel = new JLabel();
    JButton doneButton = new JButton();
    JTextField Afield = new JTextField();
    JTextField Bfield = new JTextField();
    JLabel Alabel = new JLabel();
    JLabel Blabel = new JLabel();
    JSlider aSlider = new JSlider();
    JSlider bSlider = new JSlider();
    JPanel mainPanel = new JPanel(null);
    float currAValue;
    float currBValue;
    String AsaveStr;
    String BsaveStr;
    FocusListener ABTextListener = new FocusAdapter(){

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == DataFilterSlider.this.Afield) {
                DataFilterSlider.this.AsaveStr = ((JTextField)focusEvent.getSource()).getText();
            }
            if (focusEvent.getSource() == DataFilterSlider.this.Bfield) {
                DataFilterSlider.this.BsaveStr = ((JTextField)focusEvent.getSource()).getText();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == DataFilterSlider.this.Afield && DataFilterSlider.this.AsaveStr.compareTo(DataFilterSlider.this.Afield.getText()) != 0) {
                DataFilterSlider.this.ABField_actionPerformed(new ActionEvent(focusEvent.getSource(), 0, ""));
            }
            if (focusEvent.getSource() == DataFilterSlider.this.Bfield && DataFilterSlider.this.BsaveStr.compareTo(DataFilterSlider.this.Bfield.getText()) != 0) {
                DataFilterSlider.this.ABField_actionPerformed(new ActionEvent(focusEvent.getSource(), 0, ""));
            }
            if (focusEvent.getSource() == DataFilterSlider.this.AbsMaxTextField) {
                DataFilterSlider.this.AbsMaxApply_actionPerformed(null);
            }
            if (focusEvent.getSource() == DataFilterSlider.this.AbsMinTextField) {
                DataFilterSlider.this.AbsMinApply_actionPerformed(null);
            }
        }
    };
    protected static int prefXPos = -1;
    protected static int prefYPos = -1;

    DataFilterSlider(JDialog jDialog, GraphFrame graphFrame, SelectionObject selectionObject) {
        super(jDialog);
        this.myFrame = graphFrame;
        this.mySO = selectionObject;
        this.absMin = selectionObject.absMin;
        this.absMax = selectionObject.absMax;
        this.AbsMinTextField.setText(Float.toString(this.absMin));
        this.AbsMaxTextField.setText(Float.toString(this.absMax));
        this.setResizable(false);
        this.setTitle("Edit Data Filtration Parameters");
        this.setSize(280, 342);
        DartUtils.positionDialog(this, this.myFrame);
        selectionObject.useAPlusBT = true;
        this.APlusBTCheckBox.setSelected(true);
        this.mainPanel.setSize(300, 340);
        this.getContentPane().add(this.mainPanel);
        this.aSlider.setMinimum(0);
        this.bSlider.setMinimum(0);
        if ((int)Math.rint(selectionObject.yMax() - selectionObject.yMin) < 5) {
            this.bSlider.setMaximum(5);
            this.bSlider.setMajorTickSpacing(1);
        } else {
            this.bSlider.setMaximum((int)Math.rint(selectionObject.yMax() - selectionObject.yMin));
            this.bSlider.setMajorTickSpacing((int)((selectionObject.yMax() - selectionObject.yMin) * 0.2));
        }
        if ((int)Math.rint(selectionObject.yMax() - selectionObject.yMin) < 5) {
            this.aSlider.setMaximum(5);
            this.aSlider.setMajorTickSpacing(1);
        } else {
            this.aSlider.setMaximum((int)Math.rint(selectionObject.yMax() - selectionObject.yMin));
            this.aSlider.setMajorTickSpacing((int)((selectionObject.yMax() - selectionObject.yMin) * 0.2));
        }
        this.bSlider.setOrientation(1);
        this.aSlider.setOrientation(1);
        this.aSlider.setValue(this.aSlider.getMaximum());
        this.bSlider.setValue(this.bSlider.getMaximum());
        if (selectionObject.aValue != Float.MAX_VALUE) {
            this.aSlider.setValue((int)selectionObject.aValue);
        } else {
            selectionObject.aValue = this.aSlider.getMaximum();
        }
        if (selectionObject.bValue != Float.MAX_VALUE) {
            this.bSlider.setValue((int)selectionObject.bValue);
        } else {
            selectionObject.bValue = this.bSlider.getMaximum();
        }
        this.aSlider.setSize(60, 200);
        this.bSlider.setSize(60, 200);
        this.aSlider.setLocation(5, 25);
        this.bSlider.setLocation(75, 25);
        this.aSlider.setPaintLabels(true);
        this.bSlider.setPaintLabels(true);
        this.bSlider.setPaintTicks(true);
        this.aSlider.setPaintTicks(true);
        this.aSlider.setMajorTickSpacing((int)(selectionObject.yMax() * 0.2));
        this.applySO.setSize(130, 25);
        this.applyAxis.setSize(130, 25);
        this.applyGraph.setSize(130, 25);
        this.applySO.setLocation(145, 110);
        this.applyAxis.setLocation(145, 135);
        this.applyGraph.setLocation(145, 160);
        this.APlusBTCheckBox.setLocation(10, 230);
        this.APlusBTCheckBox.setSize(125, 25);
        this.AbsMinTextField.setSize(75, 25);
        this.AbsMaxTextField.setSize(75, 25);
        this.AbsMinTextField.setLocation(150, 75);
        this.AbsMaxTextField.setLocation(150, 25);
        this.AbsMaxTextField.setFont(AppFont);
        this.AbsMinTextField.setFont(AppFont);
        this.APlusBTCheckBox.setFont(AppFont);
        this.applyGraph.setFont(AppFont);
        this.applyAxis.setFont(AppFont);
        this.applySO.setFont(AppFont);
        this.formulaLabel.setFont(AppFont);
        this.Alabel.setFont(AppFont);
        this.Blabel.setFont(AppFont);
        this.doneButton.setFont(AppFont);
        this.BSliderLabel.setFont(AppFont);
        this.ASliderLabel.setFont(AppFont);
        this.Afield.setFont(AppFont);
        this.Bfield.setFont(AppFont);
        this.AbsMinLabel.setFont(AppFont);
        this.AbsMaxLabel.setFont(AppFont);
        this.APlusBTCheckBox.setSelected(true);
        this.setFormulaText(selectionObject.aValue, selectionObject.bValue);
        this.currAValue = selectionObject.aValue;
        this.currBValue = selectionObject.bValue;
        this.AsaveStr = Float.toString(selectionObject.aValue);
        this.BsaveStr = Float.toString(selectionObject.bValue);
        this.applyGroup.add(this.applySO);
        this.applyGroup.add(this.applyAxis);
        this.applyGroup.add(this.applyGraph);
        this.AbsMinLabel.setText("Absolute Minimum:");
        this.AbsMaxLabel.setText("Absolute Maximum:");
        this.AbsMaxLabel.setLocation(150, 0);
        this.AbsMaxLabel.setSize(120, 25);
        this.AbsMinLabel.setLocation(150, 50);
        this.AbsMinLabel.setSize(120, 25);
        this.BSliderLabel.setText("B:");
        this.ASliderLabel.setText("A:");
        this.BSliderLabel.setSize(100, 25);
        this.ASliderLabel.setSize(100, 25);
        this.ASliderLabel.setLocation(20, 0);
        this.BSliderLabel.setLocation(70, 0);
        this.formulaLabel.setLocation(140, 200);
        this.formulaLabel.setSize(130, 40);
        this.formulaLabel.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(), "Filtering Equation"));
        this.Alabel.setLocation(10, 260);
        this.Blabel.setLocation(10, 280);
        this.Alabel.setSize(20, 20);
        this.Blabel.setSize(20, 20);
        this.Alabel.setText("A:");
        this.Blabel.setText("B:");
        this.Afield.setLocation(30, 260);
        this.Bfield.setLocation(30, 280);
        this.Afield.setSize(60, 20);
        this.Bfield.setSize(60, 20);
        this.doneButton.setSize(100, 25);
        this.doneButton.setLocation(160, 270);
        this.doneButton.setText("Done");
        this.mainPanel.add(this.aSlider);
        this.mainPanel.add(this.bSlider);
        this.mainPanel.add(this.applySO);
        this.mainPanel.add(this.applyAxis);
        this.mainPanel.add(this.applyGraph);
        this.mainPanel.add(this.APlusBTCheckBox);
        this.mainPanel.add(this.AbsMinTextField);
        this.mainPanel.add(this.AbsMaxTextField);
        this.mainPanel.add(this.AbsMaxLabel);
        this.mainPanel.add(this.AbsMinLabel);
        this.mainPanel.add(this.BSliderLabel);
        this.mainPanel.add(this.ASliderLabel);
        this.mainPanel.add(this.formulaLabel);
        this.mainPanel.add(this.Afield);
        this.mainPanel.add(this.Bfield);
        this.mainPanel.add(this.doneButton);
        this.mainPanel.add(this.Alabel);
        this.mainPanel.add(this.Blabel);
        this.mainPanel.add(this.doneButton);
        SymAction symAction = new SymAction();
        this.applySO.addActionListener(symAction);
        this.applyAxis.addActionListener(symAction);
        this.applyGraph.addActionListener(symAction);
        this.AbsMaxTextField.addActionListener(symAction);
        this.AbsMinTextField.addActionListener(symAction);
        this.Afield.addActionListener(symAction);
        this.Bfield.addActionListener(symAction);
        this.APlusBTCheckBox.addActionListener(symAction);
        this.doneButton.addActionListener(symAction);
        this.aSlider.addChangeListener(symAction);
        this.bSlider.addChangeListener(symAction);
        this.Afield.addFocusListener(this.ABTextListener);
        this.Bfield.addFocusListener(this.ABTextListener);
        this.AbsMinTextField.addFocusListener(this.ABTextListener);
        this.AbsMaxTextField.addFocusListener(this.ABTextListener);
        this.addWindowListener(new SymWindow());
        this.applySO.setSelected(true);
        this.applyLevel = SOlevel;
        this.setVisible(true);
    }

    public void ABField_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.Afield) {
            String string = this.Afield.getText();
            float f = -1.0f;
            try {
                f = (float)Double.parseDouble(string);
                System.out.println(f);
            }
            catch (NumberFormatException numberFormatException) {
                this.Afield.setText(this.AsaveStr);
                JOptionPane.showMessageDialog(this, "Only Positive Integers Accepted", "Incorrect Value Input", 1);
            }
            if (f >= 0.0f) {
                this.aSlider.setValue((int)f);
                this.currAValue = this.mySO.aValue = f;
                this.aSlider_actionPerformed(null);
            } else {
                JOptionPane.showMessageDialog(this, "Negative Values not Accepted", "Incorrect Value Input", 1);
            }
        } else if (actionEvent.getSource() == this.Bfield) {
            String string = this.Bfield.getText();
            float f = -1.0f;
            try {
                f = (float)Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.Bfield.setText(this.BsaveStr);
                JOptionPane.showMessageDialog(this, "Only Positive Integers Accepted", "Incorrect Value Input", 1);
            }
            if (f >= 0.0f) {
                this.bSlider.setValue((int)f);
                this.currBValue = this.mySO.bValue = f;
                this.bSlider_actionPerformed(null);
            } else {
                JOptionPane.showMessageDialog(this, "Negative Values not Accepted", "Incorrect Value Input", 1);
            }
        }
    }

    void doneButton_actionPerformed(ActionEvent actionEvent) {
        this.rememberLocation();
        this.dispose();
    }

    void applySO_actionPerformed(ActionEvent actionEvent) {
        this.applyLevel = SOlevel;
    }

    void applyAxis_actionPerformed(ActionEvent actionEvent) {
        if (this.applyLevel == SOlevel) {
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.soList(i).contains(this.mySO)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    SelectionObject selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.useAPlusBT = this.APlusBTCheckBox.isSelected();
                    selectionObject.aValue = this.currAValue;
                    selectionObject.bValue = this.currBValue;
                    selectionObject.setFilterData(true);
                    selectionObject.absMin = this.absMin;
                    selectionObject.absMax = this.absMax;
                }
                break;
            }
            this.myFrame.filtersUpdated();
        }
        this.applyLevel = Axislevel;
    }

    void applyGraph_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < 4; ++i) {
            ListIterator listIterator = this.myFrame.soList(i).listIterator();
            while (listIterator.hasNext()) {
                SelectionObject selectionObject = (SelectionObject)listIterator.next();
                selectionObject.useAPlusBT = this.APlusBTCheckBox.isSelected();
                selectionObject.aValue = this.currAValue;
                selectionObject.bValue = this.currBValue;
                selectionObject.setFilterData(true);
                selectionObject.absMin = this.absMin;
                selectionObject.absMax = this.absMax;
            }
        }
        this.myFrame.filtersUpdated();
        this.applyLevel = Graphlevel;
    }

    void APlusBTCheckBox_actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.APlusBTCheckBox.isSelected();
        if (this.applyAxis.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.soList(i).contains(this.mySO)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    SelectionObject selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.useAPlusBT = bl;
                }
                break;
            }
        } else if (this.applyGraph.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                SelectionObject selectionObject;
                if (this.myFrame.soList(i).size() <= 0 || (selectionObject = (SelectionObject)this.myFrame.soList(i).get(0)).axisType() != this.mySO.axisType()) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.aValue = this.aSlider.getValue();
                    selectionObject.bValue = this.bSlider.getValue();
                    selectionObject.useAPlusBT = bl;
                    selectionObject.setFilterData(true);
                }
            }
        }
        this.mySO.useAPlusBT = bl;
        this.formulaLabel.setEnabled(false);
        if (bl) {
            this.aSlider.setEnabled(true);
            this.bSlider.setEnabled(true);
            this.currAValue = this.aSlider.getValue();
            this.currBValue = this.bSlider.getValue();
            this.setFormulaText(this.currAValue, this.currBValue);
            this.formulaLabel.setEnabled(true);
        }
        this.Afield.setEnabled(this.APlusBTCheckBox.isSelected());
        this.Bfield.setEnabled(this.APlusBTCheckBox.isSelected());
        this.myFrame.filtersUpdated();
    }

    void aSlider_actionPerformed(ChangeEvent changeEvent) {
        SelectionObject selectionObject = null;
        this.Afield.setText(Float.toString(this.currAValue));
        this.Bfield.setText(Float.toString(this.currBValue));
        float f = this.aSlider.getValue();
        if (changeEvent == null) {
            f = this.mySO.aValue;
        }
        if (this.applySO.isSelected()) {
            this.mySO.aValue = f;
            this.mySO.useAPlusBT = true;
            this.mySO.setFilterData(true);
            this.currAValue = this.mySO.aValue;
            this.setFormulaText(this.currAValue, this.currBValue);
            this.myFrame.filtersUpdated();
        } else if (this.applyAxis.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.soList(i).contains(this.mySO)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.aValue = f;
                    selectionObject.useAPlusBT = true;
                    selectionObject.setFilterData(true);
                }
                break;
            }
            this.currAValue = selectionObject.aValue;
            this.setFormulaText(this.currAValue, this.currBValue);
            this.myFrame.filtersUpdated();
        } else {
            for (int i = 0; i < 4; ++i) {
                if (this.myFrame.soList(i).size() <= 0 || (selectionObject = (SelectionObject)this.myFrame.soList(i).get(0)).axisType() != this.mySO.axisType()) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.aValue = f;
                    selectionObject.useAPlusBT = true;
                    selectionObject.setFilterData(true);
                }
            }
            this.currAValue = selectionObject.aValue;
            this.setFormulaText(this.currAValue, this.currBValue);
            this.myFrame.filtersUpdated();
        }
        this.Afield.setText(Float.toString(this.currAValue));
        this.Bfield.setText(Float.toString(this.currBValue));
    }

    void bSlider_actionPerformed(ChangeEvent changeEvent) {
        SelectionObject selectionObject = null;
        float f = this.bSlider.getValue();
        if (changeEvent == null) {
            f = this.mySO.bValue;
        }
        if (this.applySO.isSelected()) {
            this.mySO.bValue = f;
            this.mySO.useAPlusBT = true;
            this.mySO.setFilterData(true);
            this.currBValue = this.mySO.bValue;
            this.setFormulaText(this.currAValue, this.currBValue);
            this.myFrame.filtersUpdated();
        } else if (this.applyAxis.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.soList(i).contains(this.mySO)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.bValue = f;
                    selectionObject.useAPlusBT = true;
                    selectionObject.setFilterData(true);
                }
                break;
            }
            this.currBValue = selectionObject.bValue;
            this.setFormulaText(this.currAValue, this.currBValue);
            this.myFrame.filtersUpdated();
        } else {
            for (int i = 0; i < 4; ++i) {
                if (this.myFrame.soList(i).size() <= 0 || (selectionObject = (SelectionObject)this.myFrame.soList(i).get(0)).axisType() != this.mySO.axisType()) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.bValue = f;
                    selectionObject.useAPlusBT = true;
                    selectionObject.setFilterData(true);
                }
            }
            this.currBValue = selectionObject.bValue;
            this.setFormulaText(this.currAValue, this.currBValue);
            this.myFrame.filtersUpdated();
        }
        this.Afield.setText(Float.toString(this.currAValue));
        this.Bfield.setText(Float.toString(this.currBValue));
    }

    void AbsMinApply_actionPerformed(ActionEvent actionEvent) {
        String string = this.AbsMinTextField.getText();
        try {
            this.absMin = Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Absolute Minimum value must be a number", this.boxTitle, 1);
            return;
        }
        if (this.absMin > this.absMax) {
            JOptionPane.showMessageDialog(this, "Absolute Maximum value must be less than Absolute Maximum value", this.boxTitle, 1);
            return;
        }
        if (this.applySO.isSelected()) {
            this.mySO.absMin = this.absMin;
            this.myFrame.filtersUpdated();
        } else if (this.applyAxis.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.soList(i).contains(this.mySO)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    SelectionObject selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.absMin = this.absMin;
                }
                break;
            }
            this.myFrame.filtersUpdated();
        } else if (this.applyGraph.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                SelectionObject selectionObject;
                if (this.myFrame.soList(i).size() <= 0 || (selectionObject = (SelectionObject)this.myFrame.soList(i).get(0)).axisType() != this.mySO.axisType()) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.absMin = this.absMin;
                }
            }
            this.myFrame.filtersUpdated();
        }
    }

    void AbsMaxApply_actionPerformed(ActionEvent actionEvent) {
        String string = this.AbsMaxTextField.getText();
        try {
            this.absMax = Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Absolute Maximum value must be a number", this.boxTitle, 1);
            return;
        }
        if (this.absMin > this.absMax) {
            JOptionPane.showMessageDialog(this, "Absolute Maximum value must be less than Absolute Maximum value", this.boxTitle, 1);
            return;
        }
        if (this.applySO.isSelected()) {
            this.mySO.absMax = this.absMax;
            this.myFrame.filtersUpdated();
        } else if (this.applyAxis.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.soList(i).contains(this.mySO)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    SelectionObject selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.absMax = this.absMax;
                }
                break;
            }
            this.myFrame.filtersUpdated();
        } else if (this.applyGraph.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                SelectionObject selectionObject;
                if (this.myFrame.soList(i).size() <= 0 || (selectionObject = (SelectionObject)this.myFrame.soList(i).get(0)).axisType() != this.mySO.axisType()) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator();
                while (listIterator.hasNext()) {
                    selectionObject = (SelectionObject)listIterator.next();
                    selectionObject.absMax = this.absMax;
                }
            }
            this.myFrame.filtersUpdated();
        }
    }

    void setFormulaText(float f, float f2) {
        this.formulaLabel.setText("Y = " + Float.toString(f) + " + " + Float.toString(f2) + "*T");
    }

    protected void rememberLocation() {
        Point point = this.getLocation();
        prefXPos = point.x;
        prefYPos = point.y;
    }

    public int getPrefX() {
        return prefXPos;
    }

    public int getPrefY() {
        return prefYPos;
    }

    public void setPrefPos(int n, int n2) {
        prefXPos = n;
        prefYPos = n2;
    }

    public void setPos(int n, int n2) {
        this.setLocation(n, n2);
    }

    public Rectangle getBoundsRect() {
        return this.getBounds();
    }

    void DataFilterSlider_windowClosing(WindowEvent windowEvent) {
        this.rememberLocation();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == DataFilterSlider.this) {
                DataFilterSlider.this.DataFilterSlider_windowClosing(windowEvent);
            }
        }
    }

    class SymAction
    implements ActionListener,
    ChangeListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == DataFilterSlider.this.APlusBTCheckBox) {
                DataFilterSlider.this.APlusBTCheckBox_actionPerformed(actionEvent);
            } else if (object == DataFilterSlider.this.Afield) {
                DataFilterSlider.this.ABField_actionPerformed(actionEvent);
            } else if (object == DataFilterSlider.this.Bfield) {
                DataFilterSlider.this.ABField_actionPerformed(actionEvent);
            } else if (object == DataFilterSlider.this.doneButton) {
                DataFilterSlider.this.doneButton_actionPerformed(actionEvent);
            } else if (object == DataFilterSlider.this.AbsMaxTextField) {
                DataFilterSlider.this.AbsMaxApply_actionPerformed(null);
            } else if (object == DataFilterSlider.this.AbsMinTextField) {
                DataFilterSlider.this.AbsMinApply_actionPerformed(null);
            } else if (object == DataFilterSlider.this.applySO) {
                DataFilterSlider.this.applySO_actionPerformed(actionEvent);
            } else if (object == DataFilterSlider.this.applyAxis) {
                DataFilterSlider.this.applyAxis_actionPerformed(actionEvent);
            } else if (object == DataFilterSlider.this.applyGraph) {
                DataFilterSlider.this.applyGraph_actionPerformed(actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == DataFilterSlider.this.aSlider) {
                DataFilterSlider.this.aSlider_actionPerformed(changeEvent);
            } else if (object == DataFilterSlider.this.bSlider) {
                DataFilterSlider.this.bSlider_actionPerformed(changeEvent);
            }
        }
    }
}

