/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.DartUtils;
import DartPackage.DataFilterSlider;
import DartPackage.FilterLayoutPopup;
import DartPackage.GasPercentSelectionObject;
import DartPackage.GraphDecoration;
import DartPackage.GraphFrame;
import DartPackage.Positionable;
import DartPackage.SOTransferable;
import DartPackage.SelectionObject;
import DartPackage.XAxisToolBar;
import DartPackage.YAxisToolBar;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FilterLayoutDialog
extends JDialog
implements Positionable,
DropTargetListener,
DragSourceListener,
DragGestureListener,
KeyListener {
    protected DataFlavor objFlavor = null;
    protected LinkedList copySoList;
    GraphFrame myFrame;
    mySelectionListener lsl;
    Object LastSelectedList;
    Font AppFont = new Font("DIALOG", 0, 12);
    static FilterLayoutPopup helpWnd = null;
    JPanel JPanel1 = new JPanel();
    JPanel JPanel2 = new JPanel(new GridLayout(1, 4));
    JScrollPane FirstAxisScroll = new JScrollPane();
    JScrollPane SecondAxisScroll = new JScrollPane();
    JScrollPane ThirdAxisScroll = new JScrollPane();
    JScrollPane FourthAxisScroll = new JScrollPane();
    JLabel DirectionLabel = new JLabel();
    JCheckBox ShowFarLeft = new JCheckBox();
    JCheckBox ShowLeft = new JCheckBox();
    JCheckBox ShowRight = new JCheckBox();
    JCheckBox ShowFarRight = new JCheckBox();
    JCheckBox[] ShowAxis;
    JButton axisHelp = new JButton();
    JButton doModify = new JButton();
    JButton doDataFilter = new JButton();
    JButton doneButton = new JButton();
    JLabel[] ListLabels = new JLabel[4];
    JLabel DeleteLabel = new JLabel();
    JLabel vsLabel1 = new JLabel();
    JLabel vsLabel2 = new JLabel();
    DataModel[] Models;
    JList[] Lists;
    protected static int prefXPos = -1;
    protected static int prefYPos = -1;

    FilterLayoutDialog(GraphFrame graphFrame) {
        super(graphFrame);
        int n;
        this.ShowAxis = new JCheckBox[4];
        this.ShowAxis[0] = this.ShowFarLeft;
        this.ShowAxis[1] = this.ShowLeft;
        this.ShowAxis[2] = this.ShowRight;
        this.ShowAxis[3] = this.ShowFarRight;
        this.setTitle("Data Modification and Filtration");
        this.myFrame = graphFrame;
        this.getContentPane().add(this.JPanel1);
        this.JPanel1.setSize(650, 275);
        this.setSize(650, 275);
        try {
            this.objFlavor = new DataFlavor(Class.forName("DartPackage.SOTransferable"), "SOTransferable");
        }
        catch (Exception exception) {
            System.out.println("Error making dataflavor" + exception);
            return;
        }
        iconCellRenderer iconCellRenderer2 = new iconCellRenderer();
        this.Models = new DataModel[4];
        this.Lists = new JList[4];
        this.lsl = new mySelectionListener(this);
        for (n = 0; n < 4; ++n) {
            this.Lists[n] = new JList();
            this.Lists[n].setFont(this.AppFont);
            this.Models[n] = new DataModel(this.myFrame.soList(n));
            this.Lists[n].setModel(this.Models[n]);
            new DropTarget(this.Lists[n], 3, this);
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.Lists[n], 3, this);
            this.Lists[n].addListSelectionListener(this.lsl);
            this.Lists[n].setCellRenderer(iconCellRenderer2);
            this.Lists[n].addKeyListener(this);
        }
        this.JPanel1.setLayout(null);
        this.setResizable(false);
        this.setAxisShowBoxes(this.myFrame);
        this.ShowFarLeft.setText("Show Far Left Axis");
        this.ShowLeft.setText("Show Left Axis");
        this.ShowRight.setText("Show Right Axis");
        this.ShowFarRight.setText("Show Far Right Axis");
        if (!this.myFrame.doXYPlot()) {
            this.vsLabel1.setVisible(false);
            this.vsLabel2.setVisible(false);
        }
        this.vsLabel1.setText("vs.");
        this.vsLabel2.setText("vs.");
        for (n = 0; n < 4; ++n) {
            this.ListLabels[n] = new JLabel();
            this.ListLabels[n].setText(this.myFrame.yToolBar(n).axisLabel());
        }
        this.vsLabel1.setLocation(130, 5);
        this.vsLabel2.setLocation(370, 5);
        this.ListLabels[0].setLocation(35, 5);
        this.ListLabels[1].setLocation(165, 5);
        this.ListLabels[2].setLocation(285, 5);
        this.ListLabels[3].setLocation(395, 5);
        this.ListLabels[0].setFont(this.AppFont);
        this.ListLabels[1].setFont(this.AppFont);
        this.ListLabels[2].setFont(this.AppFont);
        this.ListLabels[3].setFont(this.AppFont);
        this.DeleteLabel.setFont(this.AppFont);
        this.DirectionLabel.setFont(this.AppFont);
        this.vsLabel1.setFont(this.AppFont);
        this.vsLabel2.setFont(this.AppFont);
        this.vsLabel1.setSize(40, 25);
        this.vsLabel2.setSize(40, 25);
        for (n = 0; n < 4; ++n) {
            this.ListLabels[n].setSize(100, 25);
        }
        for (n = 0; n < 4; ++n) {
            this.JPanel1.add(this.ListLabels[n]);
        }
        this.JPanel1.add(this.vsLabel1);
        this.JPanel1.add(this.vsLabel2);
        this.ShowFarLeft.setFont(this.AppFont);
        this.ShowFarLeft.setBounds(505, 115, 135, 25);
        this.ShowLeft.setFont(this.AppFont);
        this.ShowLeft.setBounds(505, 135, 135, 25);
        this.ShowRight.setFont(this.AppFont);
        this.ShowRight.setBounds(505, 155, 135, 25);
        this.ShowFarRight.setFont(this.AppFont);
        this.ShowFarRight.setBounds(505, 175, 140, 25);
        this.JPanel1.add(this.ShowFarLeft);
        this.JPanel1.add(this.ShowLeft);
        this.JPanel1.add(this.ShowFarRight);
        this.JPanel1.add(this.ShowRight);
        this.axisHelp.setText("Editing Axes...");
        this.axisHelp.setBounds(515, 80, 110, 25);
        this.axisHelp.setFont(this.AppFont);
        this.JPanel1.add(this.axisHelp);
        this.doModify.setText("Customize...");
        this.doModify.setBounds(515, 15, 110, 25);
        this.doModify.setFont(this.AppFont);
        this.JPanel1.add(this.doModify);
        this.doDataFilter.setText("Data Filter...");
        this.doDataFilter.setFont(this.AppFont);
        this.doDataFilter.setBounds(515, 40, 110, 25);
        this.JPanel1.add(this.doDataFilter);
        this.doneButton.setLocation(515, 205);
        this.doneButton.setSize(110, 25);
        this.doneButton.setText("Done");
        this.doneButton.setFont(this.AppFont);
        this.JPanel1.add(this.doneButton);
        this.FirstAxisScroll.getViewport().add(this.Lists[0]);
        this.SecondAxisScroll.getViewport().add(this.Lists[1]);
        this.ThirdAxisScroll.getViewport().add(this.Lists[2]);
        this.FourthAxisScroll.getViewport().add(this.Lists[3]);
        this.JPanel2.add(this.FirstAxisScroll);
        this.JPanel2.add(this.SecondAxisScroll);
        this.JPanel2.add(this.ThirdAxisScroll);
        this.JPanel2.add(this.FourthAxisScroll);
        this.JPanel2.setLocation(12, 25);
        this.JPanel2.setSize(485, 205);
        this.JPanel1.add(this.JPanel2);
        this.setModal(true);
        SymAction symAction = new SymAction();
        this.ShowFarLeft.addActionListener(symAction);
        this.ShowLeft.addActionListener(symAction);
        this.ShowFarRight.addActionListener(symAction);
        this.ShowRight.addActionListener(symAction);
        this.doModify.addActionListener(symAction);
        this.axisHelp.addActionListener(symAction);
        this.doDataFilter.addActionListener(symAction);
        this.doneButton.addActionListener(symAction);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        DartUtils.positionDialog(this, this.myFrame);
        this.show();
    }

    void axisHelpButton_actionPerformed(ActionEvent actionEvent) {
        if (helpWnd == null) {
            helpWnd = new FilterLayoutPopup(this);
        } else {
            helpWnd.toFront();
        }
    }

    void doneButton_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < 4; ++i) {
            LinkedList linkedList = this.myFrame.soList(i);
            YAxisToolBar yAxisToolBar = this.myFrame.yToolBar(i);
            if (!linkedList.isEmpty()) {
                yAxisToolBar.AutoScaleButton_stateChanged(null);
                this.myFrame.yToolBar(i).setAxisLabel(this.myFrame.soListName(i, linkedList));
                continue;
            }
            this.myFrame.yToolBar(i).setAxisLabel("");
        }
        this.myFrame.yToolBar[0].setVisible(this.ShowFarLeft.isSelected());
        this.myFrame.yToolBar[1].setVisible(this.ShowLeft.isSelected());
        this.myFrame.yToolBar[2].setVisible(this.ShowRight.isSelected());
        this.myFrame.yToolBar[3].setVisible(this.ShowFarRight.isSelected());
        this.myFrame.setShowYAxis(0, this.ShowFarLeft.isSelected());
        this.myFrame.setShowYAxis(1, this.ShowLeft.isSelected());
        this.myFrame.setShowYAxis(3, this.ShowFarRight.isSelected());
        this.myFrame.setShowYAxis(2, this.ShowRight.isSelected());
        this.myFrame.XYPlotItem_actionPerformed(null);
        this.myFrame.updateTextView();
        this.myFrame.componentResized(null);
        this.myFrame.graphComponent.repaint(this.myFrame.graphComponent.getBounds(new Rectangle()));
        this.rememberLocation();
        this.dispose();
    }

    void setAxisShowBoxes(GraphFrame graphFrame) {
        this.ShowFarLeft.setSelected(this.myFrame.showYAxis(0));
        this.ShowLeft.setSelected(this.myFrame.showYAxis(1));
        this.ShowRight.setSelected(this.myFrame.showYAxis(2));
        this.ShowFarRight.setSelected(this.myFrame.showYAxis(3));
    }

    void doDataFilter_actionPerformed(ActionEvent actionEvent) {
        XAxisToolBar xAxisToolBar = this.myFrame.xToolBar();
        JList jList = (JList)this.LastSelectedList;
        int[] nArray = jList != null ? jList.getSelectedIndices() : new int[]{};
        if (jList == null || nArray.length < 1) {
            JOptionPane.showMessageDialog(this, "One or more objects must be selected from the axes", "Data Filter", 1);
            return;
        }
        DataModel dataModel = (DataModel)jList.getModel();
        SelectionObject selectionObject = (SelectionObject)dataModel.list.get(nArray[0]);
        if (selectionObject == null) {
            return;
        }
        new DataFilterSlider(this, this.myFrame, selectionObject);
    }

    void doModify_actionPerformed(ActionEvent actionEvent) {
        XAxisToolBar xAxisToolBar = this.myFrame.xToolBar();
        JList jList = (JList)this.LastSelectedList;
        int[] nArray = jList != null ? jList.getSelectedIndices() : new int[]{};
        if (jList == null || nArray.length < 1) {
            JOptionPane.showMessageDialog(this, "One or more objects must be selected from the axes", "Data Filter", 1);
            return;
        }
        DataModel dataModel = (DataModel)jList.getModel();
        SelectionObject selectionObject = (SelectionObject)dataModel.list.get(nArray[0]);
        if (selectionObject == null) {
            return;
        }
        if (!selectionObject.select(this.myFrame)) {
            return;
        }
        this.Lists[0].repaint();
        this.Lists[1].repaint();
        this.Lists[2].repaint();
        this.Lists[3].repaint();
        int n = xAxisToolBar.minYear();
        int n2 = xAxisToolBar.maxYear();
        this.myFrame.prodGraph();
        if (selectionObject.minYear != xAxisToolBar.minYear() || selectionObject.maxYear != xAxisToolBar.maxYear()) {
            xAxisToolBar.newXMinMaxValues();
            xAxisToolBar.setXMinMax(0, 100000000);
        }
        this.myFrame.ptcd.updateNames(this.myFrame);
    }

    protected void rememberLocation() {
        Point point = this.getLocation();
        prefXPos = point.x;
        prefYPos = point.y;
    }

    public int getPrefX() {
        return prefXPos;
    }

    public int getPrefY() {
        return prefYPos;
    }

    public void setPrefPos(int n, int n2) {
        prefXPos = n;
        prefYPos = n2;
    }

    public void setPos(int n, int n2) {
        this.setLocation(n, n2);
    }

    public Rectangle getBoundsRect() {
        return this.getBounds();
    }

    void FilterLayoutDialog_windowClosing(WindowEvent windowEvent) {
        this.rememberLocation();
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n = dragGestureEvent.getDragAction();
        JComponent jComponent = (JComponent)dragGestureEvent.getSourceAsDragGestureRecognizer().getComponent();
        Transferable transferable = this.createTransferable(jComponent, n);
        if (transferable == null) {
            return;
        }
        DragSource.getDefaultDragSource().startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, transferable, this);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable != null && dropTargetDropEvent.isDataFlavorSupported(this.objFlavor) && dropTargetDropEvent.isLocalTransfer()) {
            JComponent jComponent = (JComponent)((DropTarget)dropTargetDropEvent.getSource()).getComponent();
            int n = this.importData(jComponent, transferable);
            if (n == -1) {
                JOptionPane.showMessageDialog(this, "Selection Objects have incompatible units", "Data Management", 1);
                dropTargetDropEvent.rejectDrop();
                dropTargetDropEvent.dropComplete(false);
            } else {
                dropTargetDropEvent.dropComplete(true);
                int n2 = 0;
                for (n2 = 0; n2 < 4 && jComponent != this.Lists[n2]; ++n2) {
                }
                SelectionObject selectionObject = (SelectionObject)this.Models[n2].Get(0);
                YAxisToolBar yAxisToolBar = this.myFrame.yToolBar(n2);
                yAxisToolBar.setPrecision(selectionObject.defaultPrecision());
                yAxisToolBar.AutoScaleButton_stateChanged(null);
                String string = this.myFrame.soListName(n2, this.Models[n2].list);
                this.myFrame.yToolBar(n2).setAxisLabel(string);
                this.ListLabels[n2].setText(string);
                this.myFrame.updateTextView();
                this.myFrame.graphComponent.repaint();
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        int n = dragSourceDragEvent.getUserAction();
        Transferable transferable = dragSourceDragEvent.getDragSourceContext().getTransferable();
        try {
            SOTransferable sOTransferable = (SOTransferable)transferable.getTransferData(this.objFlavor);
        }
        catch (Exception exception) {
            System.out.println("Error importing SO:" + exception);
            return;
        }
        sOTransferable.action = n;
    }

    protected Transferable createTransferable(JComponent jComponent, int n) {
        JList jList = (JList)jComponent;
        int[] nArray = jList.getSelectedIndices();
        int n2 = -1;
        if (nArray.length < 1) {
            return null;
        }
        if (jList == this.Lists[0]) {
            n2 = 0;
        } else if (jList == this.Lists[1]) {
            n2 = 1;
        } else if (jList == this.Lists[2]) {
            n2 = 2;
        } else if (jList == this.Lists[3]) {
            n2 = 3;
        } else {
            return null;
        }
        SOTransferable sOTransferable = new SOTransferable(n, n2, nArray);
        return sOTransferable;
    }

    public int importData(JComponent jComponent, Transferable transferable) {
        int n;
        SOTransferable sOTransferable;
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(Class.forName("DartPackage.SOTransferable"), "SOTransferable");
        }
        catch (Exception exception) {
            System.out.println("Error making dataflavor" + exception);
        }
        try {
            sOTransferable = (SOTransferable)transferable.getTransferData(dataFlavor);
        }
        catch (Exception exception) {
            System.out.println("Error importing SO:" + exception);
            return -2;
        }
        int[] nArray = sOTransferable.itemNum;
        int n2 = sOTransferable.axisNum;
        Arrays.sort(nArray);
        boolean bl = 1 == sOTransferable.action;
        SelectionObject selectionObject = (SelectionObject)this.Models[n2].Get(nArray[0]);
        for (n = 0; n < 4; ++n) {
            if (jComponent != this.Lists[n]) continue;
            if (this.Models[n].list.isEmpty() || ((SelectionObject)this.Models[n].list.get(0)).axisType() == selectionObject.axisType()) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (this.Models[n].getSize() == 0) {
                        this.ShowAxis[n].setSelected(true);
                    }
                    this.Models[n].Add(this.Models[n2].Get(nArray[i]));
                }
                break;
            }
            return -1;
        }
        if (!bl) {
            this.Lists[n2].clearSelection();
            for (n = nArray.length - 1; n >= 0; --n) {
                this.Models[n2].Remove(nArray[n]);
            }
            if (this.Models[n2].getSize() == 0) {
                this.ShowAxis[n2].setSelected(false);
            }
        }
        return 1;
    }

    void apply_actionPerformed(ActionEvent actionEvent) {
        this.myFrame.yToolBar[0].setVisible(this.ShowFarLeft.isSelected());
        this.myFrame.yToolBar[1].setVisible(this.ShowLeft.isSelected());
        this.myFrame.yToolBar[2].setVisible(this.ShowRight.isSelected());
        this.myFrame.yToolBar[3].setVisible(this.ShowFarRight.isSelected());
        this.myFrame.setShowYAxis(0, this.ShowFarLeft.isSelected());
        this.myFrame.setShowYAxis(1, this.ShowLeft.isSelected());
        this.myFrame.setShowYAxis(3, this.ShowFarRight.isSelected());
        this.myFrame.setShowYAxis(2, this.ShowRight.isSelected());
        this.myFrame.XYPlotItem_actionPerformed(null);
        this.myFrame.updateTextView();
        this.myFrame.componentResized(null);
        this.myFrame.graphComponent.repaint(this.myFrame.graphComponent.getBounds(new Rectangle()));
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u007f') {
            JList jList = (JList)this.LastSelectedList;
            DataModel dataModel = (DataModel)jList.getModel();
            int[] nArray = jList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                dataModel.Remove(nArray[i]);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public class SOIcon
    implements Icon {
        SelectionObject so;

        SOIcon(SelectionObject selectionObject) {
            this.so = selectionObject;
        }

        void setSO(SelectionObject selectionObject) {
            this.so = selectionObject;
        }

        public int getIconHeight() {
            return 14;
        }

        public int getIconWidth() {
            return 14;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.so.color());
            graphics.drawLine(n, n2 + 7, n + 14, n2 + 7);
            GraphDecoration graphDecoration = this.so.decoration();
            if (graphDecoration != null) {
                graphDecoration.draw(graphics, n + 7, n2 + 7);
            }
        }
    }

    public class iconCellRenderer
    extends DefaultListCellRenderer {
        ImageIcon icon;
        SOIcon theIcon;

        iconCellRenderer() {
            this.theIcon = new SOIcon(new GasPercentSelectionObject());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            SelectionObject selectionObject = (SelectionObject)object;
            this.theIcon.setSO(selectionObject);
            jLabel.setIcon(this.theIcon);
            return jLabel;
        }
    }

    class mySelectionListener
    implements ListSelectionListener {
        FilterLayoutDialog fld;

        mySelectionListener(FilterLayoutDialog filterLayoutDialog2) {
            this.fld = filterLayoutDialog2;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.fld.LastSelectedList == null) {
                this.fld.LastSelectedList = listSelectionEvent.getSource();
            } else if (listSelectionEvent.getSource() != this.fld.LastSelectedList) {
                ((JList)this.fld.LastSelectedList).clearSelection();
                this.fld.LastSelectedList = listSelectionEvent.getSource();
            }
        }
    }

    public class DataModel
    extends AbstractListModel {
        LinkedList list;

        DataModel(LinkedList linkedList) {
            this.list = linkedList;
        }

        Object Get(int n) {
            return this.list.get(n);
        }

        void Add(Object object) {
            this.list.add(object);
            this.fireIntervalAdded(object, this.list.size() - 1, this.list.size());
        }

        Object Remove(int n) {
            Object e = this.list.remove(n);
            this.fireIntervalRemoved(e, n, n);
            return e;
        }

        public Object getElementAt(int n) {
            return this.list.get(n);
        }

        public int getSize() {
            return this.list.size();
        }

        boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == FilterLayoutDialog.this) {
                FilterLayoutDialog.this.FilterLayoutDialog_windowClosing(windowEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == FilterLayoutDialog.this.doModify) {
                FilterLayoutDialog.this.doModify_actionPerformed(actionEvent);
            } else if (object == FilterLayoutDialog.this.doDataFilter) {
                FilterLayoutDialog.this.doDataFilter_actionPerformed(actionEvent);
            } else if (object == FilterLayoutDialog.this.doneButton) {
                FilterLayoutDialog.this.doneButton_actionPerformed(actionEvent);
            } else if (object == FilterLayoutDialog.this.axisHelp) {
                FilterLayoutDialog.this.axisHelpButton_actionPerformed(actionEvent);
            } else if (object == FilterLayoutDialog.this.ShowFarRight || object == FilterLayoutDialog.this.ShowRight || object == FilterLayoutDialog.this.ShowLeft || object == FilterLayoutDialog.this.ShowFarLeft) {
                FilterLayoutDialog.this.apply_actionPerformed(actionEvent);
            }
        }
    }
}

