/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.GraphFrame;
import DartPackage.GraphViewFrame;
import DartPackage.PixelValueTransformer;
import DartPackage.SelectionObject;
import DartPackage.XAxisToolBar;
import DartPackage.YAxisToolBar;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

class GraphComponent
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected GraphFrame myFrame;
    protected GraphViewFrame myParent;
    protected YAxisToolBar[] yTB;
    protected XAxisToolBar xTB;
    protected LinkedList pointList = new LinkedList();
    protected GraphLegendFrame legendFrame;
    protected boolean[] swapped = new boolean[]{false, false};
    protected boolean lock = false;
    BufferedImage image_off;
    int frames = 0;
    Graphics graph;
    String xAxisLabel = "X Axis";
    String mainLabel = "Main Graph Label";
    BasicStroke bsFat = new BasicStroke(2.0f);
    Font normalFont;
    Font smallFont;
    Font italicFont;
    int vsWidth;
    int labelsHeight = 0;
    boolean mousePressedInLegend = false;
    boolean mousePressedInGraph = false;
    boolean dragCursor = false;
    private int dragX;
    private int dragY;
    protected int innerXSize;
    protected int innerYSize;
    protected int innerLeft;
    protected int innerTop;
    protected int outerTop;
    HashMap labelRects;
    protected boolean doXYPlot = false;
    protected PixelValueTransformer[] xyTrans = new PixelValueTransformer[4];

    public boolean getSwapped(int n) {
        return this.swapped[n];
    }

    public void setSwapped(int n, boolean bl) {
        this.swapped[n] = bl;
    }

    GraphComponent(GraphFrame graphFrame, GraphViewFrame graphViewFrame) {
        int n;
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(true);
        this.setFocusCycleRoot(true);
        this.requestFocus();
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.myFrame = graphFrame;
        this.myParent = graphViewFrame;
        this.yTB = new YAxisToolBar[4];
        for (n = 0; n < 4; ++n) {
            this.yTB[n] = this.myFrame.yToolBar(n);
        }
        this.xTB = this.myFrame.xToolBar();
        this.setMinimumSize(new Dimension(1, 1));
        this.setMaximumSize(new Dimension(10000, 10000));
        this.setPreferredSize(new Dimension(10000, 10000));
        if (this.myFrame == this.myParent) {
            for (n = 0; n < 4; ++n) {
                this.addMouseMotionListener(this.yTB[n]);
            }
            this.addMouseMotionListener(this.xTB);
        }
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.legendFrame = new GraphLegendFrame(this.myParent);
        this.labelRects = new HashMap();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.requestFocus();
        }
        if (this.withinGraph(mouseEvent)) {
            if (!this.doXYPlot() && !this.myFrame.doHistogram()) {
                double d = this.myFrame.xToolBar().valFromPixel(mouseEvent.getX());
                int n = (int)d;
                int n2 = n + 1;
                System.out.println("(" + n + ", " + n2 + ")");
                int n3 = this.myFrame.xToolBar().xPixel(n);
                int n4 = this.myFrame.xToolBar().xPixel(n2);
                double d2 = -1.0;
                SelectionObject selectionObject = null;
                for (int i = 0; i < 4; ++i) {
                    if (!this.myFrame.showYAxis(i)) continue;
                    ListIterator listIterator = this.myFrame.soList(i).listIterator(0);
                    while (listIterator.hasNext()) {
                        int n5;
                        SelectionObject selectionObject2 = (SelectionObject)listIterator.next();
                        boolean bl = false;
                        int n6 = n2;
                        int n7 = n3;
                        int n8 = n4;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        if (selectionObject2.accumulate()) {
                            double d5 = 0.0;
                            for (n5 = 1; n5 <= n - 1; ++n5) {
                                d5 += (double)selectionObject2.yVal(n5);
                            }
                            d3 = d5;
                            d4 = d3 + (double)selectionObject2.yVal(n5);
                            System.out.println(d3);
                        } else {
                            int n9;
                            for (n9 = n; n9 >= this.myFrame.xToolBar().minData() && !selectionObject2.yValExists(n9 - 1); --n9) {
                            }
                            while (n6 <= this.myFrame.xToolBar().maxData() && !selectionObject2.yValExists(n6 - 1)) {
                                ++n6;
                            }
                            if (n9 < this.myFrame.xToolBar().minData() || n6 > this.myFrame.xToolBar().maxData() || n9 < 0 || n6 >= selectionObject2.length()) {
                                bl = true;
                            } else {
                                d3 = selectionObject2.yVal(n9 - 1);
                                d4 = selectionObject2.yVal(n6 - 1);
                                if (n != n9) {
                                    n7 = this.myFrame.xToolBar().xPixel(n9);
                                }
                                if (n2 != n6) {
                                    n8 = this.myFrame.xToolBar().xPixel(n6);
                                }
                            }
                        }
                        if (bl) continue;
                        n5 = this.myFrame.yToolBar(i).yPixel(d3);
                        int n10 = this.myFrame.yToolBar(i).yPixel(d4);
                        double d6 = Line2D.ptSegDist(n7, n5, n8, n10, mouseEvent.getX(), mouseEvent.getY());
                        if (!(d2 < 0.0) && !(d6 < d2)) continue;
                        selectionObject = selectionObject2;
                        d2 = d6;
                    }
                }
                if (d2 < 13.0) {
                    this.clickSO(selectionObject, mouseEvent);
                }
            }
            return;
        }
        this.clickSO(this.withinLegend(mouseEvent), mouseEvent);
    }

    private void clickSO(SelectionObject selectionObject, MouseEvent mouseEvent) {
        if (selectionObject != null) {
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                selectionObject.setHighlight(!selectionObject.highlight());
                if (this.myFrame.doXYPlot() && selectionObject.buddy != null) {
                    selectionObject.buddy.setHighlight(selectionObject.highlight());
                }
                this.myFrame.prodGraph();
            } else {
                selectionObject.setFilterData(!selectionObject.filterData());
                this.myFrame.filtersUpdated();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private SelectionObject withinLegend(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && !this.myParent.detachLegend() || mouseEvent.getSource() == this.legendFrame.getLegend() && this.myParent.detachLegend()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.showYAxis(i)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator(0);
                while (listIterator.hasNext()) {
                    SelectionObject selectionObject = (SelectionObject)listIterator.next();
                    Rectangle rectangle = this.getLabelRect(selectionObject);
                    if (n < rectangle.x || n >= rectangle.x + rectangle.width || n2 < rectangle.y || n2 >= rectangle.y + rectangle.height) continue;
                    return selectionObject;
                }
            }
        }
        return null;
    }

    public boolean withinGraph(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        return n > this.innerLeft && n2 > this.innerTop + this.outerTop && n2 < this.innerTop + this.outerTop + this.innerYSize && n < this.innerLeft + this.innerXSize;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.mousePressedInGraph = this.withinGraph(mouseEvent);
            if (this.mousePressedInGraph) {
                this.mousePressedInLegend = false;
                this.dragX = mouseEvent.getX();
                this.dragY = mouseEvent.getY();
            } else {
                this.mousePressedInLegend = this.withinLegend(mouseEvent) != null;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.dragCursor) {
                this.myParent.setCursor(Cursor.getDefaultCursor());
                this.dragCursor = false;
            }
            if (!this.myParent.detachLegend() && this.mousePressedInLegend && this.withinLegend(mouseEvent) == null) {
                int n;
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, this);
                int n2 = point.x - this.legendFrame.getWidth() / 2;
                if (n2 < 0) {
                    n2 = 0;
                }
                if ((n = point.y - this.legendFrame.getHeight() / 2) < 0) {
                    n = 0;
                }
                this.legendFrame.setLocation(n2, n);
                this.myParent.setDetachLegend(true);
            }
            this.mousePressedInLegend = false;
            this.mousePressedInGraph = false;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.doXYPlot() && SwingUtilities.isLeftMouseButton(mouseEvent) && this.mousePressedInGraph) {
            int n;
            boolean bl = false;
            int n2 = this.myFrame.xToolBar().xMin();
            int n3 = this.myFrame.xToolBar().xMax();
            int n4 = n3 - n2;
            int n5 = (this.dragX - mouseEvent.getX()) * n4 / this.getWidth();
            int n6 = Math.abs(n5);
            if (this.xTB.daily && n6 >= 1 || this.xTB.weekly && n6 >= 7 || this.xTB.monthly && n6 >= 31 || this.xTB.yearly && n6 >= 366) {
                n = n2 + n5;
                int n7 = n3 + n5;
                if (n < this.myFrame.xToolBar().minData()) {
                    n = this.myFrame.xToolBar().minData();
                    n7 = n + n4;
                } else if (n7 > this.myFrame.xToolBar().maxData()) {
                    n7 = this.myFrame.xToolBar().maxData();
                    n = n7 - n4;
                }
                if (n != n2) {
                    this.myFrame.xToolBar().setXMinMax(n, n7);
                    bl = true;
                }
                this.dragX = mouseEvent.getX();
            }
            if (Math.abs(this.dragY - mouseEvent.getY()) > 0) {
                int n8;
                n = 0;
                double[] dArray = new double[4];
                double[] dArray2 = new double[4];
                for (n8 = 0; n8 < 4; ++n8) {
                    if (!this.myFrame.showYAxis(n8)) continue;
                    double d = this.myFrame.yToolBar(n8).yMin();
                    double d2 = this.myFrame.yToolBar(n8).yMax();
                    double d3 = d2 - d;
                    double d4 = (double)(mouseEvent.getY() - this.dragY) * d3 / (double)this.getHeight();
                    dArray[n8] = d + d4;
                    dArray2[n8] = d2 + d4;
                    if (!(this.myFrame.yToolBar(n8).minData() < d && dArray[n8] < d) && (!(this.myFrame.yToolBar(n8).maxData() > d2) || !(dArray2[n8] > d2))) continue;
                    n = 1;
                }
                if (n != 0) {
                    for (n8 = 0; n8 < 4; ++n8) {
                        if (!this.myFrame.showYAxis(n8)) continue;
                        this.myFrame.yToolBar(n8).setYMinMax(dArray[n8], dArray2[n8]);
                    }
                    this.dragY = mouseEvent.getY();
                    bl = true;
                }
            }
            if (bl && !this.dragCursor) {
                this.myParent.setCursor(Cursor.getPredefinedCursor(13));
                this.dragCursor = true;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        try {
            if (!this.myFrame.reCalculating) {
                if (this.image_off == null || this.image_off.getWidth() != this.getSize().width || this.image_off.getHeight() != this.getSize().height) {
                    this.image_off = new BufferedImage(this.getSize().width, this.getSize().height, 1);
                }
                Graphics2D graphics2D = this.image_off.createGraphics();
                graphics2D.setFont(new Font("Dialog", 0, 12));
                graphics.setFont(new Font("Dialog", 0, 12));
                if (this.doXYPlot()) {
                    this.paint_xy(graphics2D);
                } else {
                    this.paint_normal(graphics2D);
                }
                graphics.drawImage(this.image_off, 0, 0, this);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.myFrame.ptcd.deleteGraph(this.myFrame);
            this.myFrame.dispose();
            JOptionPane.showMessageDialog(this, "Out of Memory", "Graph not completed", 0);
        }
    }

    int yLabelWidthNeeded(int n, int n2, YAxisToolBar yAxisToolBar, PixelValueTransformer pixelValueTransformer, FontMetrics fontMetrics) {
        int n3 = 0;
        double d = pixelValueTransformer.viewMax();
        double d2 = pixelValueTransformer.viewMin();
        String string = yAxisToolBar.formatValue(d);
        n3 = Math.max(n3, fontMetrics.stringWidth(string));
        string = yAxisToolBar.formatValue(d2);
        n3 = Math.max(n3, fontMetrics.stringWidth(string));
        int n4 = n2 / (n * 3) - 1;
        if (n4 > 0) {
            int n5 = n2 / (n4 + 1);
            for (int i = 1; i <= n4; ++i) {
                double d3 = d2 + (d - d2) * (double)(i * n5) / (double)n2;
                string = yAxisToolBar.formatValue(d3);
                n3 = Math.max(n3, fontMetrics.stringWidth(string));
            }
        }
        return n3;
    }

    int yLabelWidthNeeded(int n, int n2, YAxisToolBar yAxisToolBar, FontMetrics fontMetrics) {
        return this.yLabelWidthNeeded(n, n2, yAxisToolBar, yAxisToolBar.trans(), fontMetrics);
    }

    void paint_normal(Graphics graphics) {
        Rectangle rectangle;
        block116: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            double d;
            String string;
            int n8;
            int n9;
            float f;
            int n10;
            int n11;
            SelectionObject selectionObject;
            YAxisToolBar[] yAxisToolBarArray;
            SelectionObject[] selectionObjectArray;
            int n12;
            int n13;
            int n14;
            int n15;
            FontMetrics fontMetrics;
            Graphics2D graphics2D;
            Stroke stroke;
            boolean bl;
            block115: {
                int n16;
                double d2;
                int n17;
                double d3;
                double d4;
                int n18;
                ListIterator listIterator;
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                boolean[] blArray = new boolean[4];
                bl = graphics instanceof Graphics2D;
                stroke = null;
                graphics2D = null;
                if (bl) {
                    graphics2D = (Graphics2D)graphics;
                }
                Rectangle rectangle2 = this.getVisibleRect();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics2D.setColor(Color.black);
                this.normalFont = graphics.getFont();
                this.italicFont = this.normalFont.deriveFont(2);
                rectangle = null;
                if (graphics instanceof PrintGraphics) {
                    System.out.println("Got pr gr");
                }
                if (this.lock) {
                    return;
                }
                if (this.myFrame.pf != null && this.myFrame.printing) {
                    int n19 = this.myFrame.pf.getOrientation();
                    PageFormat cfr_ignored_0 = this.myFrame.pf;
                    if (n19 == 0) {
                        System.out.println("Landscape");
                    }
                    PageFormat cfr_ignored_1 = this.myFrame.pf;
                    if (n19 == 1) {
                        System.out.println("Portrait" + n19);
                    }
                    this.lock = true;
                    rectangle2 = new Rectangle((int)this.myFrame.pf.getImageableX(), (int)this.myFrame.pf.getImageableY(), (int)this.myFrame.pf.getImageableWidth(), (int)this.myFrame.pf.getImageableHeight());
                    rectangle = graphics.getClipBounds();
                    rectangle = (Rectangle)rectangle2.clone();
                    ((Graphics2D)graphics).translate(this.myFrame.pf.getImageableX(), this.myFrame.pf.getImageableY());
                } else {
                    rectangle = graphics.getClipBounds();
                }
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                }
                fontMetrics = this.getFontMetrics(this.normalFont);
                FontMetrics fontMetrics2 = this.getFontMetrics(this.italicFont);
                int n20 = fontMetrics.getHeight();
                n15 = fontMetrics.charWidth('M');
                int n21 = n15 * 10;
                int n22 = fontMetrics.getAscent();
                for (n14 = 0; n14 < 4; ++n14) {
                    blArray[n14] = this.myFrame.showYAxis(n14);
                }
                n13 = fontMetrics.getHeight();
                this.innerTop = n13 * 2;
                if (blArray[0] && blArray[1] || blArray[2] && blArray[3]) {
                    this.innerTop += n13;
                }
                n12 = 0;
                for (n14 = 0; n14 < 4; ++n14) {
                    if (!blArray[n14]) continue;
                    n12 += this.myFrame.soList(n14).size();
                }
                selectionObjectArray = new SelectionObject[n12];
                yAxisToolBarArray = new YAxisToolBar[n12];
                int n23 = 0;
                int n24 = 0;
                n12 = 0;
                for (n14 = 0; n14 < 4; ++n14) {
                    if (!blArray[n14]) continue;
                    listIterator = this.myFrame.soList(n14).listIterator(0);
                    while (listIterator.hasNext()) {
                        selectionObjectArray[n12] = selectionObject = (SelectionObject)listIterator.next();
                        yAxisToolBarArray[n12++] = this.yTB[n14];
                        if (!this.myFrame.doXYPlot()) {
                            selectionObject.buddy = null;
                        }
                        selectionObject.applyDataFilter();
                    }
                }
                if (this.myParent.detachLegend()) {
                    this.innerYSize = rectangle2.height - (this.innerTop + n13 * 3);
                    this.labelsHeight = 0;
                } else {
                    this.updateLabelSizes(graphics);
                    for (n14 = 0; n14 < 4; ++n14) {
                        if (!blArray[n14]) continue;
                        ++n23;
                        n24 = 10 + fontMetrics.stringWidth("Axis " + n14 + ": ");
                        listIterator = this.myFrame.soList(n14).listIterator(0);
                        while (listIterator.hasNext()) {
                            selectionObject = (SelectionObject)listIterator.next();
                            n18 = this.getLabelRect((SelectionObject)selectionObject).width;
                            if (n24 + n18 > rectangle2.width - 20) {
                                n24 = 0;
                                ++n23;
                            }
                            n24 += n18;
                        }
                    }
                    this.labelsHeight = (--n23 + 1) * n13;
                }
                this.innerYSize = rectangle2.height - (this.innerTop + n13 * 2 + this.labelsHeight);
                this.innerLeft = 0;
                nArray[0] = 0;
                nArray[1] = 0;
                for (n14 = 0; n14 < 4; ++n14) {
                    nArray2[n14] = 0;
                }
                if (!blArray[0] && !blArray[1]) {
                    this.innerLeft = n21 / 4;
                }
                if (blArray[0]) {
                    nArray2[0] = this.yLabelWidthNeeded(n13, this.innerYSize, this.yTB[0], fontMetrics) + 4 * n15;
                    nArray[1] = this.innerLeft = nArray2[0];
                }
                if (blArray[1]) {
                    nArray2[1] = this.yLabelWidthNeeded(n13, this.innerYSize, this.yTB[1], fontMetrics) + 4 * n15;
                    this.innerLeft += nArray2[1];
                }
                nArray[3] = rectangle2.width;
                nArray[2] = rectangle2.width;
                if (!blArray[2] && !blArray[3]) {
                    nArray[2] = nArray[2] - n21 / 4;
                }
                if (blArray[3]) {
                    nArray2[3] = this.yLabelWidthNeeded(n13, this.innerYSize, this.yTB[3], fontMetrics) + 4 * n15;
                    nArray[3] = nArray[3] - nArray2[3];
                    nArray[2] = nArray[2] - nArray2[3];
                }
                if (blArray[2]) {
                    nArray2[2] = this.yLabelWidthNeeded(n13, this.innerYSize, this.yTB[2], fontMetrics) + 4 * n15;
                    nArray[2] = nArray[2] - nArray2[2];
                }
                this.innerXSize = nArray[2] - this.innerLeft;
                this.outerTop = 0;
                if (this.myFrame.pf != null) {
                    // empty if block
                }
                if (this.innerXSize <= 0 || this.innerYSize <= 0) {
                    graphics.drawString("Graph window is too small", 10, 20);
                    return;
                }
                this.lock = true;
                this.xTB.setPixelRange(this.innerLeft, this.innerLeft + this.innerXSize - 1);
                for (n14 = 0; n14 < 4; ++n14) {
                    this.yTB[n14].setPixelRange(this.innerTop, this.innerTop + this.innerYSize - 1);
                }
                this.lock = false;
                if (blArray[0] && blArray[1]) {
                    graphics.drawString(this.myFrame.yToolBar(0).axisLabel(), Math.max(10, nArray[0] + nArray2[0] - fontMetrics.stringWidth(this.myFrame.yToolBar(0).axisLabel()) * 3 / 4), this.outerTop + n13);
                    graphics.drawString(this.myFrame.yToolBar(1).axisLabel(), Math.max(10, nArray[1] + nArray2[1] - fontMetrics.stringWidth(this.myFrame.yToolBar(1).axisLabel()) * 3 / 4), this.outerTop + n13 * 2);
                } else if (blArray[0]) {
                    graphics.drawString(this.myFrame.yToolBar(0).axisLabel(), Math.max(10, nArray[0] + nArray2[0] - fontMetrics.stringWidth(this.myFrame.yToolBar(0).axisLabel())), this.outerTop + n13);
                } else if (blArray[1]) {
                    graphics.drawString(this.myFrame.yToolBar(1).axisLabel(), Math.max(10, nArray[1] + nArray2[1] - fontMetrics.stringWidth(this.myFrame.yToolBar(1).axisLabel())), this.outerTop + n13);
                }
                if (blArray[2] && blArray[3]) {
                    graphics.drawString(this.myFrame.yToolBar(2).axisLabel(), Math.min(nArray[2], rectangle2.width - 10 - fontMetrics.stringWidth(this.myFrame.yToolBar(2).axisLabel())), this.outerTop + n13 * 2);
                    graphics.drawString(this.myFrame.yToolBar(3).axisLabel(), Math.min(nArray[3], rectangle2.width - 10 - fontMetrics.stringWidth(this.myFrame.yToolBar(3).axisLabel())), this.outerTop + n13);
                } else if (blArray[2]) {
                    graphics.drawString(this.myFrame.yToolBar(2).axisLabel(), Math.min(nArray[2], rectangle2.width - 10 - fontMetrics.stringWidth(this.myFrame.yToolBar(2).axisLabel())), this.outerTop + n13);
                } else if (blArray[3]) {
                    graphics.drawString(this.myFrame.yToolBar(3).axisLabel(), Math.min(nArray[3], rectangle2.width - 10 - fontMetrics.stringWidth(this.myFrame.yToolBar(3).axisLabel())), this.outerTop + n13);
                }
                graphics.drawString(this.mainLabel, (rectangle2.width - fontMetrics.stringWidth(this.mainLabel)) / 2, this.outerTop + n22);
                graphics.drawString(this.xAxisLabel, (rectangle2.width - fontMetrics.stringWidth(this.xAxisLabel)) / 2, this.outerTop + n22 + n13);
                n11 = this.innerTop + this.innerYSize;
                int n25 = this.innerLeft + this.innerXSize;
                n10 = this.innerYSize / (n13 * 3) - 1;
                f = 1.0f;
                n9 = 1;
                if (n10 > 0) {
                    f = this.innerYSize / (n10 + 1);
                }
                for (n14 = 0; n14 < 2; ++n14) {
                    if (!blArray[n14]) continue;
                    n11 = this.innerTop + this.innerYSize;
                    n25 = this.innerLeft + this.innerXSize;
                    n9 = 1;
                    d4 = this.yTB[n14].yMax();
                    d3 = this.yTB[n14].yMin();
                    n8 = nArray[n14] + nArray2[n14];
                    graphics.drawLine(n8, this.innerTop, n8, n11);
                    graphics.drawLine(n8, this.innerTop, n8 - n15, this.innerTop);
                    string = this.yTB[n14].formatValue(d4);
                    graphics.drawString(string, n8 - (fontMetrics.stringWidth(string) + n15), this.innerTop + n13 / 2);
                    graphics.drawLine(n8, n11, n8 - n15, n11);
                    string = this.yTB[n14].formatValue(d3);
                    graphics.drawString(string, n8 - (fontMetrics.stringWidth(string) + n15), n11 + n13 / 2);
                    d = 0.0;
                    n17 = n10;
                    if (n10 <= 0) continue;
                    d2 = this.yTB[n14].yMax() - this.yTB[n14].yMin();
                    if (this.yTB[n14].trans.rounded()) {
                        f = -((float)this.yTB[n14].trans().divisionPixelSize());
                        n17 = this.yTB[n14].trans().numberOfDividers();
                        for (n16 = 1; n16 <= n17; ++n16) {
                            n9 = (int)Math.rint((float)n11 - (float)n16 * f);
                            graphics.drawLine(n8 - n15, n9, n8, n9);
                            d = d3 + (d4 - d3) / (double)(n17 + 1) * (double)n16;
                            string = this.yTB[n14].formatValue(d);
                            graphics.drawString(string, n8 - (fontMetrics.stringWidth(string) + n15), n9 + n13 / 2);
                        }
                        continue;
                    }
                    f = this.innerYSize / (n10 + 1);
                    for (n16 = 1; n16 <= n10; ++n16) {
                        n9 = (int)((float)n11 - (float)n16 * f);
                        graphics.drawLine(n8 - n15, n9, n8, n9);
                        d = d3 + (d4 - d3) * (double)((float)n16 * f) / (double)this.innerYSize;
                        string = this.yTB[n14].formatValue(d);
                        graphics.drawString(string, n8 - (fontMetrics.stringWidth(string) + n15), n9 + n13 / 2);
                    }
                }
                for (n14 = 2; n14 < 4; ++n14) {
                    if (!blArray[n14]) continue;
                    n17 = n10;
                    d4 = this.yTB[n14].yMax();
                    d3 = this.yTB[n14].yMin();
                    n8 = nArray[n14];
                    graphics.drawLine(n8, this.innerTop, n8, this.innerTop + this.innerYSize);
                    graphics.drawLine(n8, this.innerTop, n8 + n15, this.innerTop);
                    string = this.yTB[n14].formatValue(d4);
                    graphics.drawString(string, n8 + n15, this.innerTop + n13 / 2);
                    graphics.drawLine(n8, n11, n8 + n15, n11);
                    string = this.yTB[n14].formatValue(d3);
                    graphics.drawString(string, n8 + n15, n11 + n13 / 2);
                    if (n10 <= 0) continue;
                    d2 = this.yTB[n14].yMax() - this.yTB[n14].yMin();
                    if (this.yTB[n14].trans.rounded()) {
                        f = -((float)this.yTB[n14].trans().divisionPixelSize());
                        n17 = this.yTB[n14].trans().numberOfDividers();
                        for (n16 = 1; n16 <= n17; ++n16) {
                            n9 = (int)Math.rint((float)n11 - (float)n16 * f);
                            graphics.drawLine(n8, n9, n8 + n15, n9);
                            d = d3 + (d4 - d3) / (double)(n17 + 1) * (double)n16;
                            string = this.yTB[n14].formatValue(d);
                            graphics.drawString(string, n8 + n15, n9 + n13 / 2);
                        }
                        continue;
                    }
                    f = this.innerYSize / (n10 + 1);
                    for (n16 = 1; n16 <= n10; ++n16) {
                        n9 = (int)((float)n11 - (float)n16 * f);
                        graphics.drawLine(n8, n9, n8 + n15, n9);
                        d = d3 + (d4 - d3) * (double)((float)n16 * f) / (double)this.innerYSize;
                        string = this.yTB[n14].formatValue(d);
                        graphics.drawString(string, n8 + n15, n9 + n13 / 2);
                    }
                }
                if (this.myFrame.showGrid()) {
                    graphics.drawLine(this.innerLeft, this.innerTop, n25, this.innerTop);
                    for (n14 = 1; n14 <= n10; ++n14) {
                        n9 = (int)Math.rint((float)n11 - (float)n14 * f);
                        graphics.drawLine(this.innerLeft, n9, n25, n9);
                    }
                }
                n9 = n11 + n13 + n22;
                n8 = 10;
                int[] nArray3 = new int[4];
                LinkedList<String> linkedList = new LinkedList<String>();
                LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
                for (n7 = 0; n7 < 4; ++n7) {
                    if (!blArray[n7]) continue;
                    linkedList.add(this.yTB[n7].SideLabel.getText() + " Axis :");
                    nArray3[n7] = this.myFrame.soList(n7).size();
                    linkedList2.add(new Integer(n7));
                }
                if (!this.myParent.detachLegend()) {
                    n7 = 1;
                    for (n14 = 0; n14 < n12; ++n14) {
                        graphics.setColor(Color.black);
                        --n7;
                        do {
                            if (n7 != 0) continue;
                            n6 = (Integer)linkedList2.remove(0);
                            n7 = nArray3[n6];
                            n8 = 10;
                            graphics.setFont(this.normalFont);
                            graphics.drawString((String)linkedList.get(0), n8, n9 += n13);
                            graphics.drawLine(n8, n9 + 2, fontMetrics.stringWidth((String)linkedList.get(0)) + 3, n9 + 2);
                            n8 = n8 + fontMetrics.stringWidth((String)linkedList.remove(0)) + 5;
                        } while (n7 <= 0 && !linkedList2.isEmpty());
                        selectionObject = selectionObjectArray[n14];
                        Rectangle rectangle3 = this.getLabelRect(selectionObject);
                        n18 = rectangle3.width;
                        if (n8 + n18 > rectangle2.width - 10) {
                            n8 = 10;
                        }
                        if (n8 == 10) {
                            n9 += n13;
                        }
                        this.paintLabel(selectionObject, graphics, n8, n9);
                        rectangle3.x = n8;
                        rectangle3.y = n9 - n13;
                        n8 += n18;
                    }
                    while (!linkedList2.isEmpty()) {
                        n6 = (Integer)linkedList2.remove(0);
                        n7 = nArray3[n6];
                        n8 = 10;
                        graphics.setFont(this.normalFont);
                        graphics.drawString((String)linkedList.get(0), n8, n9 += n13);
                        graphics.drawLine(n8, n9 + 2, fontMetrics.stringWidth((String)linkedList.get(0)) + 3, n9 + 2);
                        n8 = n8 + fontMetrics.stringWidth((String)linkedList.remove(0)) + 5;
                    }
                }
                graphics.setFont(this.normalFont);
                graphics.drawLine(this.innerLeft, n11, n25, n11);
                n7 = this.xTB.xMin();
                n6 = this.xTB.xMax();
                graphics.drawLine(this.innerLeft, n11, this.innerLeft, n11 + n13 / 2);
                string = this.xTB.xDate(n7, true);
                graphics.drawString(string, this.innerLeft - fontMetrics.stringWidth(string) / 2, n11 + 3 * n13 / 2);
                int n26 = this.innerLeft + fontMetrics.stringWidth(string) / 2;
                graphics.drawLine(n25, n11, n25, n11 + n13 / 2);
                string = this.xTB.xDate(n6, true);
                int n27 = n25 - fontMetrics.stringWidth(string) / 2 - 10;
                graphics.drawString(string, n27, n11 + 3 * n13 / 2);
                n5 = this.xTB.xMin();
                n4 = this.xTB.xMax();
                n3 = this.xTB.minYear();
                if (!this.myFrame.doHistogram()) break block115;
                SelectionObject[] selectionObjectArray2 = null;
                if (this.myFrame.histOverlap()) {
                    selectionObjectArray2 = new SelectionObject[n12];
                }
                int n28 = -1;
                int n29 = -1;
                int n30 = -1;
                boolean bl2 = this.myFrame.histWeekly();
                boolean bl3 = this.myFrame.histMonthly();
                boolean bl4 = this.myFrame.histYearly();
                boolean bl5 = this.myFrame.showColor();
                boolean bl6 = this.myFrame.histSideBySide();
                int n31 = n3 + (n5 - 1) / 366;
                int n32 = this.xTB.getMonth(1 + (n5 - 1) % 366);
                int n33 = this.xTB.getWeek(1 + (n5 - 1) % 366, n31);
                if (this.myFrame.pf != null && this.myFrame.printing) {
                    graphics.setClip(new Rectangle(this.innerLeft, this.innerTop - 1, this.innerXSize + 1, this.innerYSize + 1));
                    System.out.println("disabling clip");
                } else {
                    graphics.setClip(rectangle.intersection(new Rectangle(this.innerLeft, this.innerTop - 1, this.innerXSize + 1, this.innerYSize + 1)));
                }
                for (n14 = 0; n14 < n12; ++n14) {
                    selectionObject = selectionObjectArray[n14];
                    selectionObject.sum = 0.0;
                    selectionObject.indOff = this.xTB.overplot() ? 1 : 1 + (selectionObject.minYear() - n3) * 366;
                }
                int n34 = n5;
                boolean bl7 = false;
                boolean bl8 = true;
                while (!bl7) {
                    int n35;
                    if (bl8) {
                        n29 = this.xTB.xPixel(n34);
                        n28 = n34;
                        for (n14 = 0; n14 < n12; ++n14) {
                            selectionObject = selectionObjectArray[n14];
                            if (!selectionObject.accumulate()) {
                                selectionObject.sum = 0.0;
                            }
                            selectionObject.ndays = 0;
                        }
                        bl8 = false;
                    }
                    for (n14 = 0; n14 < n12; ++n14) {
                        selectionObject = selectionObjectArray[n14];
                        n35 = n34 - selectionObject.indOff;
                        if (n35 < 0 || n35 >= selectionObject.length() || !selectionObject.yValExists(n35)) continue;
                        selectionObject.sum += (double)selectionObject.yVal(n35);
                        ++selectionObject.ndays;
                    }
                    if (n34 == n4 || bl4 && n34 % 366 == 0 || bl3 && 1 + (n34 - 1) % 366 == this.xTB.monthEnds(n32) || bl2 && 1 + (n34 - 1) % 366 == this.xTB.weekEnds(n33, n31)) {
                        int n36;
                        int n37;
                        boolean bl9;
                        n30 = this.xTB.xPixel(n34);
                        if (bl6) {
                            int n38 = n29;
                            for (n14 = 0; n14 < n12; ++n14) {
                                selectionObject = selectionObjectArray[n14];
                                int n39 = n38;
                                n38 = n29 + (int)Math.round((double)(n14 + 1) * (double)(n30 - n29) / (double)n12);
                                if (selectionObject.ndays <= 0) continue;
                                if (selectionObject.histAverage() && !selectionObject.accumulate()) {
                                    selectionObject.sum /= (double)selectionObject.ndays;
                                }
                                if (selectionObject.sum < yAxisToolBarArray[n14].yMin()) continue;
                                n9 = yAxisToolBarArray[n14].yPixel(selectionObject.sum);
                                if (bl5) {
                                    graphics.setColor(selectionObject.color());
                                }
                                boolean bl10 = bl9 = bl && selectionObject.highlight();
                                if (bl9) {
                                    stroke = graphics2D.getStroke();
                                    graphics2D.setStroke(this.bsFat);
                                }
                                graphics.drawRect(n39, n9, n38 - n39, n11 - n9);
                                if (selectionObject.decoration() != null && this.myFrame.showDecoration()) {
                                    selectionObject.decoration().draw(graphics, (n39 + n38) / 2, n9);
                                }
                                n9 = Math.max(n9, 0);
                                for (n35 = n39 + 3; n35 <= n38 - 3; n35 += bl9 ? 6 : 3) {
                                    this.drawVertDashedLine(n35, n9, n11, graphics, bl9);
                                }
                                if (!bl9) continue;
                                graphics2D.setStroke(stroke);
                            }
                        } else {
                            int n40 = 0;
                            for (n14 = 0; n14 < n12; ++n14) {
                                selectionObject = selectionObjectArray[n14];
                                if (selectionObject.ndays <= 0) continue;
                                if (selectionObject.histAverage() && !selectionObject.accumulate()) {
                                    selectionObject.sum /= (double)selectionObject.ndays;
                                }
                                selectionObject.yPixel = selectionObject.sum < yAxisToolBarArray[n14].yMin() ? n11 : yAxisToolBarArray[n14].yPixel(selectionObject.sum);
                                for (int i = n40 - 1; i >= 0 && selectionObjectArray2[i].yPixel > selectionObject.yPixel; --i) {
                                    selectionObjectArray2[i + 1] = selectionObjectArray2[i];
                                }
                                selectionObjectArray2[i + 1] = selectionObject;
                                ++n40;
                            }
                            for (n14 = 0; n14 < n40; ++n14) {
                                selectionObject = selectionObjectArray2[n14];
                                int n41 = selectionObject.yPixel;
                                if (n41 < n11) {
                                    int n42 = n14 == n40 - 1 ? n11 : selectionObjectArray2[n14 + 1].yPixel;
                                    if (bl5) {
                                        graphics.setColor(selectionObject.color());
                                    }
                                    boolean bl11 = bl9 = bl && selectionObject.highlight();
                                    if (bl9) {
                                        stroke = graphics2D.getStroke();
                                        graphics2D.setStroke(this.bsFat);
                                    }
                                    graphics.drawRect(n29, n41, n30 - n29, n42 - n41);
                                    if (selectionObject.decoration() != null && this.myFrame.showDecoration()) {
                                        selectionObject.decoration().draw(graphics, (n29 + n30) / 2, n41);
                                    }
                                    n41 = Math.max(n41, 0);
                                    n42 = Math.max(n42, 0);
                                    for (n35 = n29 + 3; n35 <= n30 - 3; n35 += bl9 ? 6 : 3) {
                                        this.drawVertDashedLine(n35, n41, n42, graphics, bl9);
                                    }
                                    if (!bl9) continue;
                                    graphics2D.setStroke(stroke);
                                    continue;
                                }
                                break;
                            }
                        }
                        if ((n37 = (n30 + n29) / 2) - (n36 = fontMetrics.stringWidth(string = this.xTB.xDate((n28 + n34) / 2, true))) / 2 >= n26 + 4 * n15 && n37 + n36 / 2 <= n27 - 4 * n15) {
                            if (bl5) {
                                graphics.setColor(Color.black);
                            }
                            graphics.drawLine(n37, n11, n37, n11 + n13 / 2);
                            graphics.drawString(string, n37 - n36 / 2, n11 + 3 * n13 / 2);
                            n26 = n37 + n36 / 2;
                        }
                        bl8 = true;
                        if (bl2) {
                            ++n33;
                        }
                        if (bl3) {
                            ++n32;
                        }
                    }
                    if (bl2 && n33 == 53) {
                        while (n34 % 366 != 0) {
                            ++n34;
                        }
                    }
                    if (++n34 > n4) {
                        bl7 = true;
                        continue;
                    }
                    if (n34 % 366 != 1) continue;
                    ++n31;
                    n32 = 1;
                    n33 = 1;
                    bl8 = true;
                }
                break block116;
            }
            n10 = this.innerXSize / (n15 * 10) - 1;
            if (n10 > 0) {
                f = this.innerXSize / (n10 + 1);
                for (n14 = 1; n14 <= n10; ++n14) {
                    n8 = (int)((float)this.innerLeft + (float)n14 * f);
                    graphics.drawLine(n8, n11, n8, n11 + n13 / 2);
                    d = (double)n7 + (double)(n6 - n7) * (double)((float)n14 * f) / (double)this.innerXSize;
                    string = this.xTB.xDate(d, true);
                    graphics.drawString(string, n8 - fontMetrics.stringWidth(string) / 2, n11 + 3 * n13 / 2);
                    if (!this.myFrame.showGrid()) continue;
                    graphics.drawLine(n8, n11, n8, this.innerTop);
                }
            }
            if (this.myFrame.pf != null && this.myFrame.printing) {
                graphics.setClip(new Rectangle(this.innerLeft, this.innerTop - 1, this.innerXSize + 1, this.innerYSize + 1));
                System.out.println("disabling clip");
            } else {
                graphics.setClip(rectangle.intersection(new Rectangle(this.innerLeft, this.innerTop - 1, this.innerXSize + 1, this.innerYSize + 1)));
            }
            int n43 = this.xTB.xPixel(n5);
            for (n2 = 0; n2 < n12; ++n2) {
                selectionObject = selectionObjectArray[n2];
                selectionObject.sum = 0.0;
                selectionObject.indOff = this.xTB.overplot() ? 0 : (selectionObject.minYear() - n3) * 366;
                selectionObject.lastDec = -100000;
                selectionObject.dataMissing = false;
                n = n5 - 1 - selectionObject.indOff;
                if (n < 0 || n >= selectionObject.length()) continue;
                selectionObject.prevX = this.xTB.xPixel(n5);
                if (selectionObject.yValExists(n)) {
                    selectionObject.prevY = yAxisToolBarArray[n2].yPixel(selectionObject.yVal(n));
                    selectionObject.prevXYExists = true;
                    selectionObject.dataMissing = false;
                    selectionObject.sum = selectionObject.yVal(n);
                } else {
                    selectionObject.dataMissing = true;
                    selectionObject.prevXYExists = false;
                    selectionObject.sum = 0.0;
                    selectionObject.prevY = yAxisToolBarArray[n2].yPixel(0.0);
                }
                if (!selectionObject.accumulate()) continue;
                selectionObject.dataMissing = false;
                selectionObject.prevXYExists = true;
            }
            for (n14 = n5 + 1; n14 <= n4; ++n14) {
                n8 = this.xTB.xPixel(n14);
                n = n14 - 1;
                for (n2 = 0; n2 < n12; ++n2) {
                    block119: {
                        YAxisToolBar yAxisToolBar;
                        block117: {
                            block118: {
                                int n44 = (n2 + n14) % n12;
                                selectionObject = selectionObjectArray[n44];
                                yAxisToolBar = yAxisToolBarArray[n44];
                                if (n < selectionObject.indOff || selectionObject.length() + selectionObject.indOff <= n) continue;
                                if (n == selectionObject.indOff) {
                                    selectionObject.prevX = n8;
                                    if (selectionObject.yValExists(0)) {
                                        selectionObject.prevXYExists = true;
                                        selectionObject.dataMissing = false;
                                        selectionObject.prevY = yAxisToolBar.yPixel(selectionObject.yVal(0));
                                    } else {
                                        selectionObject.dataMissing = true;
                                        selectionObject.prevXYExists = false;
                                    }
                                    if (!selectionObject.accumulate()) continue;
                                    if (selectionObject.prevXYExists) {
                                        selectionObject.sum = selectionObject.yVal(0);
                                    } else {
                                        selectionObject.sum = 0.0;
                                        selectionObject.prevY = n11;
                                        selectionObject.dataMissing = false;
                                        selectionObject.prevXYExists = true;
                                    }
                                }
                                if (!selectionObject.yValExists(n - selectionObject.indOff)) break block117;
                                if (!selectionObject.accumulate()) break block118;
                                selectionObject.sum += (double)selectionObject.yVal(n - selectionObject.indOff);
                                n9 = yAxisToolBar.yPixel(selectionObject.sum);
                                break block119;
                            }
                            n9 = yAxisToolBar.yPixel(selectionObject.yVal(n - selectionObject.indOff));
                            if (selectionObject.prevXYExists) break block119;
                            selectionObject.dataMissing = false;
                            break block119;
                        }
                        if (selectionObject.accumulate()) {
                            n9 = yAxisToolBar.yPixel(selectionObject.sum);
                        } else {
                            if (!selectionObject.prevXYExists) continue;
                            selectionObject.dataMissing = true;
                            continue;
                        }
                    }
                    if (selectionObject.prevXYExists) {
                        boolean bl12;
                        if (this.myFrame.showColor()) {
                            graphics.setColor(selectionObject.color());
                        }
                        boolean bl13 = bl12 = bl && selectionObject.highlight();
                        if (bl12) {
                            stroke = graphics2D.getStroke();
                            graphics2D.setStroke(this.bsFat);
                        }
                        if (selectionObject.dataMissing) {
                            this.drawDashedLine(selectionObject.prevX, selectionObject.prevY, n8, n9, graphics, bl12);
                        } else {
                            graphics.drawLine(selectionObject.prevX, selectionObject.prevY, n8, n9);
                        }
                        selectionObject.dataMissing = false;
                        if (selectionObject.decoration() != null && n8 >= selectionObject.lastDec + 20 && this.myFrame.showDecoration()) {
                            selectionObject.decoration().draw(graphics, n8, n9);
                            selectionObject.lastDec = n8;
                        }
                        if (bl12) {
                            graphics2D.setStroke(stroke);
                        }
                    }
                    selectionObject.prevX = n8;
                    selectionObject.prevY = n9;
                    selectionObject.prevXYExists = true;
                }
                n43 = n8;
            }
        }
        graphics.setClip(rectangle);
    }

    void repaintYourself() {
        if (this.lock) {
            return;
        }
        this.repaint();
        this.legendFrame.repaintYourself();
    }

    public void update(Graphics graphics) {
        this.repaintYourself();
    }

    public Rectangle getLabelRect(SelectionObject selectionObject) {
        Rectangle rectangle = (Rectangle)this.labelRects.get(selectionObject);
        if (rectangle != null) {
            return rectangle;
        }
        rectangle = new Rectangle();
        this.labelRects.put(selectionObject, rectangle);
        return rectangle;
    }

    public void updateLabelSizes(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.normalFont = graphics.getFont();
        this.italicFont = this.normalFont.deriveFont(2);
        FontMetrics fontMetrics = this.getFontMetrics(this.normalFont);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.italicFont);
        int n = fontMetrics.getHeight();
        if (this.doXYPlot()) {
            this.vsWidth = fontMetrics.stringWidth(" vs ");
            for (int i = 0; i < 4; i += 2) {
                if (!this.myFrame.showYAxis(i) || !this.myFrame.showYAxis(i + 1)) continue;
                boolean bl = false;
                ListIterator listIterator = this.myFrame.soList(i).listIterator(0);
                ListIterator listIterator2 = this.myFrame.soList(i + 1).listIterator(0);
                while (listIterator2.hasNext() && listIterator.hasNext()) {
                    SelectionObject selectionObject = (SelectionObject)listIterator2.next();
                    SelectionObject selectionObject2 = (SelectionObject)listIterator.next();
                    int n2 = 20 + this.vsWidth;
                    int n3 = selectionObject.filterData() ? fontMetrics2.stringWidth(selectionObject.abbrevNameStr()) : fontMetrics.stringWidth(selectionObject.abbrevNameStr());
                    n2 += n3;
                    n2 = selectionObject2.filterData() ? (n2 += fontMetrics2.stringWidth(selectionObject2.abbrevNameStr())) : (n2 += fontMetrics.stringWidth(selectionObject2.abbrevNameStr()));
                    this.getLabelRect(selectionObject).setSize(n3 + 20, n);
                    this.getLabelRect(selectionObject2).setSize(n2 - (n3 + 20), n);
                    selectionObject.buddy = selectionObject2;
                    selectionObject2.buddy = selectionObject;
                }
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                if (!this.myFrame.showYAxis(i)) continue;
                ListIterator listIterator = this.myFrame.soList(i).listIterator(0);
                while (listIterator.hasNext()) {
                    SelectionObject selectionObject = (SelectionObject)listIterator.next();
                    int n4 = selectionObject.filterData() ? 60 + fontMetrics2.stringWidth(selectionObject.abbrevNameStr()) : 60 + fontMetrics.stringWidth(selectionObject.abbrevNameStr());
                    this.getLabelRect(selectionObject).setSize(n4, n);
                }
            }
        }
    }

    void paintLabel(SelectionObject selectionObject, Graphics graphics, int n, int n2) {
        Stroke stroke = null;
        Rectangle rectangle = this.getLabelRect(selectionObject);
        int n3 = rectangle.height;
        Graphics2D graphics2D = null;
        boolean bl = graphics instanceof Graphics2D;
        graphics2D = (Graphics2D)graphics;
        if (this.doXYPlot()) {
            SelectionObject selectionObject2 = selectionObject;
            SelectionObject selectionObject3 = selectionObject.buddy;
            Rectangle rectangle2 = this.getLabelRect(selectionObject3);
            if (this.myFrame.showColor()) {
                graphics.setColor(selectionObject2.color());
            }
            if (selectionObject2.highlight()) {
                graphics.fillOval(n + 7, n2 - n3 / 2 - 3, 7, 7);
            } else {
                graphics.fillOval(n + 8, n2 - n3 / 2 - 2, 5, 5);
            }
            if (selectionObject2.decoration() != null && this.myFrame.showDecoration()) {
                selectionObject2.decoration().draw(graphics, n + 10, n2 - n3 / 2);
            }
            graphics.setColor(Color.black);
            if (selectionObject3.filterData()) {
                graphics.setFont(this.italicFont);
                graphics.drawString(selectionObject3.abbrevNameStr(), n + 20, n2);
                graphics.setFont(this.normalFont);
            } else {
                graphics.setFont(this.normalFont);
                graphics.drawString(selectionObject3.abbrevNameStr(), n + 20, n2);
            }
            graphics.drawString(" vs ", n + rectangle2.width, n2);
            if (selectionObject2.filterData()) {
                graphics.setFont(this.italicFont);
            } else {
                graphics.setFont(this.normalFont);
            }
            graphics.drawString(selectionObject2.abbrevNameStr(), n + this.vsWidth + rectangle2.width, n2);
            rectangle2.setLocation(n, n2 - n3);
            rectangle.setLocation(n + rectangle2.width, n2 - n3);
        } else {
            boolean bl2;
            if (this.myFrame.showColor()) {
                graphics.setColor(selectionObject.color());
            }
            boolean bl3 = bl2 = bl && selectionObject.highlight();
            if (bl2) {
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.bsFat);
            }
            if (selectionObject.emptySet) {
                graphics.setColor(Color.black);
                graphics.drawString("N/A-", n + 20, n2);
                graphics.setColor(selectionObject.color());
            } else {
                graphics.drawLine(n, n2 - n3 / 2 + 3, n + 50, n2 - n3 / 2 + 3);
                if (selectionObject.decoration() != null && this.myFrame.showDecoration()) {
                    selectionObject.decoration().draw(graphics, n + 25, n2 - n3 / 2 + 3);
                }
            }
            if (bl2) {
                graphics2D.setStroke(stroke);
            }
            graphics.setColor(Color.black);
            if (selectionObject.filterData()) {
                graphics.setFont(this.italicFont);
            } else {
                graphics.setFont(this.normalFont);
            }
            graphics.drawString(selectionObject.abbrevNameStr(), n + 50, n2);
            rectangle.setLocation(n, n2 - n3);
        }
    }

    boolean doXYPlot() {
        return this.doXYPlot;
    }

    void setDoXYPlot(boolean bl) {
        this.doXYPlot = bl;
    }

    void paint_xy(Graphics graphics) {
        double d;
        int n;
        double d2;
        int n2;
        double d3;
        int n3;
        double d4;
        String string;
        int n4;
        double d5;
        double d6;
        int n5;
        SelectionObject selectionObject;
        SelectionObject selectionObject2;
        ListIterator listIterator;
        ListIterator listIterator2;
        int n6;
        boolean[] blArray = new boolean[4];
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (int i = 0; i < 4; i += 2) {
            if (this.swapped[i / 2]) {
                nArray2[i] = i + 1;
                nArray2[i + 1] = i;
                continue;
            }
            nArray2[i] = i;
            nArray2[i + 1] = i + 1;
        }
        LinkedList[] linkedListArray = new LinkedList[4];
        for (int i = 0; i < 4; ++i) {
            linkedListArray[i] = this.myFrame.soList(nArray2[i]);
        }
        PixelValueTransformer[] pixelValueTransformerArray = new PixelValueTransformer[4];
        for (int i = 0; i < 4; ++i) {
            pixelValueTransformerArray[i] = this.xyTrans[nArray2[i]];
        }
        YAxisToolBar[] yAxisToolBarArray = new YAxisToolBar[4];
        for (int i = 0; i < 4; ++i) {
            yAxisToolBarArray[i] = this.yTB[nArray2[i]];
        }
        YAxisToolBar[] yAxisToolBarArray2 = new YAxisToolBar[4];
        for (int i = 0; i < 4; ++i) {
            yAxisToolBarArray2[i] = this.myFrame.yToolBar(nArray2[i]);
        }
        Rectangle rectangle = this.getVisibleRect();
        boolean bl = graphics instanceof Graphics2D;
        Graphics2D graphics2D = null;
        if (bl) {
            graphics2D = (Graphics2D)graphics;
        }
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(Color.black);
        if (this.myFrame.pf != null) {
            rectangle.setLocation(0, 0);
            rectangle.setSize((int)this.myFrame.pf.getImageableWidth(), (int)this.myFrame.pf.getImageableHeight());
            int n7 = (int)((this.myFrame.pf.getHeight() - this.myFrame.pf.getImageableHeight()) / 2.0);
            int n8 = (int)((this.myFrame.pf.getWidth() - this.myFrame.pf.getImageableWidth()) / 2.0);
            graphics = graphics.create(n8, n7, (int)this.myFrame.pf.getImageableWidth(), (int)this.myFrame.pf.getImageableHeight());
        }
        this.normalFont = graphics.getFont();
        this.italicFont = this.normalFont.deriveFont(2);
        FontMetrics fontMetrics = this.getFontMetrics(this.normalFont);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.italicFont);
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            rectangle2 = new Rectangle(rectangle);
        }
        int n9 = fontMetrics.getHeight();
        int n10 = fontMetrics.charWidth('M');
        int n11 = fontMetrics.getAscent();
        int n12 = n10 * 10;
        boolean bl2 = false;
        for (n6 = 0; n6 < 4; ++n6) {
            blArray[n6] = this.myFrame.showYAxis(nArray2[n6]);
            bl2 |= blArray[n6];
        }
        if (!bl2) {
            return;
        }
        int n13 = fontMetrics.getHeight();
        this.innerTop = 2 * n13;
        if (blArray[2]) {
            this.innerTop += 3 * n13 / 2;
        }
        this.updateLabelSizes(graphics);
        int n14 = 0;
        for (n6 = 0; n6 < 4; n6 += 2) {
            if (!blArray[n6]) continue;
            n14 += Math.min(linkedListArray[n6].size(), linkedListArray[n6 + 1].size());
        }
        int n15 = this.xTB.xMin();
        int n16 = this.xTB.xMax();
        int n17 = this.xTB.minYear();
        SelectionObject[] selectionObjectArray = new SelectionObject[n14 * 2];
        YAxisToolBar[] yAxisToolBarArray3 = new YAxisToolBar[n14 * 2];
        PixelValueTransformer[] pixelValueTransformerArray2 = new PixelValueTransformer[n14 * 2];
        int n18 = 0;
        int n19 = 0;
        n14 = 0;
        boolean bl3 = this.xTB.overplot();
        for (n6 = 0; n6 < 4; n6 += 2) {
            if (!blArray[n6]) continue;
            if (pixelValueTransformerArray[n6] == null) {
                pixelValueTransformerArray[n6] = new PixelValueTransformer(true);
            }
            yAxisToolBarArray[n6].scalePixelValueTransformer(pixelValueTransformerArray[n6]);
            if (pixelValueTransformerArray[n6 + 1] == null) {
                pixelValueTransformerArray[n6 + 1] = new PixelValueTransformer(true);
            }
            yAxisToolBarArray[n6 + 1].scalePixelValueTransformer(pixelValueTransformerArray[n6 + 1]);
            listIterator2 = linkedListArray[n6].listIterator(0);
            listIterator = linkedListArray[n6 + 1].listIterator(0);
            while (listIterator2.hasNext() && listIterator.hasNext()) {
                selectionObject2 = (SelectionObject)listIterator2.next();
                selectionObject2.sum = 0.0;
                selectionObjectArray[n14] = selectionObject2;
                pixelValueTransformerArray2[n14] = pixelValueTransformerArray[n6];
                yAxisToolBarArray3[n14++] = yAxisToolBarArray[n6];
                selectionObject2.applyDataFilter();
                selectionObject2.indOff = bl3 ? 1 : (selectionObject2.minYear() - n17) * 366;
                selectionObject = (SelectionObject)listIterator.next();
                selectionObject.sum = 0.0;
                selectionObjectArray[n14] = selectionObject;
                pixelValueTransformerArray2[n14] = pixelValueTransformerArray[n6 + 1];
                yAxisToolBarArray3[n14++] = yAxisToolBarArray[n6 + 1];
                selectionObject.applyDataFilter();
                selectionObject.indOff = bl3 ? 1 : (selectionObject.minYear() - n17) * 366;
                selectionObject.buddy = selectionObject2;
                selectionObject2.buddy = selectionObject;
            }
        }
        if (!this.myParent.detachLegend()) {
            block9: for (n6 = 0; n6 < 4; n6 += 2) {
                if (!blArray[n6]) continue;
                listIterator2 = linkedListArray[n6].listIterator(0);
                listIterator = linkedListArray[n6 + 1].listIterator(0);
                while (listIterator2.hasNext() && listIterator.hasNext()) {
                    selectionObject2 = (SelectionObject)listIterator2.next();
                    selectionObject = (SelectionObject)listIterator.next();
                    if (selectionObject == null) continue block9;
                    n5 = this.getLabelRect((SelectionObject)selectionObject).width + this.getLabelRect((SelectionObject)selectionObject2).width;
                    if (n19 + n5 > rectangle.width - 20) {
                        n19 = 0;
                        ++n18;
                    }
                    n19 += n5;
                }
            }
            this.labelsHeight = n13 * (n18 + 1);
        } else {
            this.labelsHeight = 0;
        }
        this.innerYSize = rectangle.height - (this.innerTop + n13 * 3 + this.labelsHeight);
        this.innerLeft = 0;
        for (n6 = 0; n6 < 4; ++n6) {
            nArray[n6] = 0;
        }
        if (!blArray[0]) {
            this.innerLeft = n12 / 4;
        } else {
            nArray[0] = this.yLabelWidthNeeded(n13, this.innerYSize, yAxisToolBarArray[0], pixelValueTransformerArray[0], fontMetrics) + 3 * n10;
            this.innerLeft = nArray[0];
        }
        this.innerXSize = rectangle.width - this.innerLeft;
        if (!blArray[2]) {
            this.innerXSize -= n12 / 4;
        } else {
            nArray[2] = this.yLabelWidthNeeded(n13, this.innerYSize, yAxisToolBarArray[2], pixelValueTransformerArray[2], fontMetrics) + 3 * n10;
            this.innerXSize -= nArray[2];
        }
        this.outerTop = 0;
        if (this.myFrame.pf != null) {
            this.innerYSize -= 2 * n13;
            this.innerTop += n13;
            this.outerTop = n13;
        }
        if (this.innerXSize <= 0 || this.innerYSize <= 0) {
            graphics.drawString("Graph window is too small", 10, 20);
            return;
        }
        this.lock = true;
        for (n6 = 0; n6 < 4; n6 += 2) {
            if (!blArray[n6]) continue;
            pixelValueTransformerArray[n6].setPixelRange(this.innerTop, this.innerTop + this.innerYSize - 1);
            pixelValueTransformerArray[n6 + 1].setPixelRange(this.innerLeft + this.innerXSize - 1, this.innerLeft);
        }
        this.lock = false;
        if (blArray[0]) {
            graphics.drawString(yAxisToolBarArray2[0].axisLabel(), Math.max(10, nArray[0] - fontMetrics.stringWidth(yAxisToolBarArray2[0].axisLabel())), this.outerTop + n13 + n11);
        }
        if (blArray[2]) {
            graphics.drawString(yAxisToolBarArray2[2].axisLabel(), Math.min(this.innerLeft + this.innerXSize, rectangle.width - 10 - fontMetrics.stringWidth(yAxisToolBarArray2[2].axisLabel())), this.outerTop + n13 + n11);
        }
        if (blArray[3]) {
            graphics.drawString(yAxisToolBarArray2[3].axisLabel(), this.innerLeft + (this.innerXSize - fontMetrics.stringWidth(yAxisToolBarArray2[3].axisLabel())) / 2, this.outerTop + n11 + n13);
        }
        int n20 = this.innerTop + this.innerYSize;
        int n21 = this.innerLeft + this.innerXSize;
        int n22 = this.innerYSize / (n13 * 3) - 1;
        double d7 = 1.0;
        int n23 = 1;
        if (n22 > 0) {
            d7 = (double)this.innerYSize / (double)(n22 + 1);
        }
        if (blArray[0]) {
            d6 = pixelValueTransformerArray[0].viewMax();
            d5 = pixelValueTransformerArray[0].viewMin();
            n4 = nArray[0];
            graphics.drawLine(n4, this.innerTop, n4, n20);
            graphics.drawLine(n4, this.innerTop, n4 - n10, this.innerTop);
            string = yAxisToolBarArray[0].formatValue(d6);
            graphics.drawString(string, n4 - (fontMetrics.stringWidth(string) + n10), this.innerTop + n13 / 2);
            graphics.drawLine(n4, n20, n4 - n10, n20);
            string = yAxisToolBarArray[0].formatValue(d5);
            graphics.drawString(string, n4 - (fontMetrics.stringWidth(string) + n10), n20 + n13 / 2);
            d4 = 0.0;
            n3 = n22;
            if (n22 > 0) {
                d3 = pixelValueTransformerArray[0].viewMax() - pixelValueTransformerArray[0].viewMin();
                if (pixelValueTransformerArray[0].rounding() && d3 > 50.0) {
                    d7 = -((float)pixelValueTransformerArray[0].divisionPixelSize());
                    n3 = pixelValueTransformerArray[0].numberOfDividers();
                    for (n2 = 1; n2 <= n3; ++n2) {
                        n23 = (int)Math.rint((double)n20 - (double)n2 * d7);
                        graphics.drawLine(n4 - n10, n23, n4, n23);
                        d4 = d5 + (d6 - d5) / (double)(n3 + 1) * (double)n2;
                        string = yAxisToolBarArray[0].formatValue(d4);
                        graphics.drawString(string, n4 - (fontMetrics.stringWidth(string) + n10), n23 + n13 / 2);
                    }
                } else {
                    d7 = (double)this.innerYSize / (double)(n22 + 1);
                    for (n2 = 1; n2 <= n22; ++n2) {
                        n23 = (int)((double)n20 - (double)n2 * d7);
                        graphics.drawLine(n4 - n10, n23, n4, n23);
                        d4 = d5 + (d6 - d5) * ((double)n2 * d7) / (double)this.innerYSize;
                        string = yAxisToolBarArray[0].formatValue(d4);
                        graphics.drawString(string, n4 - (fontMetrics.stringWidth(string) + n10), n23 + n13 / 2);
                    }
                }
            }
        }
        if (blArray[2]) {
            d6 = pixelValueTransformerArray[2].viewMax();
            d5 = pixelValueTransformerArray[2].viewMin();
            n4 = this.innerLeft + this.innerXSize;
            graphics.drawLine(n4, this.innerTop, n4, this.innerTop + this.innerYSize);
            graphics.drawLine(n4, this.innerTop, n4 + n10, this.innerTop);
            string = yAxisToolBarArray[2].formatValue(d6);
            graphics.drawString(string, n4 + n10, this.innerTop + n13 / 2);
            graphics.drawLine(n4, n20, n4 + n10, n20);
            string = yAxisToolBarArray[2].formatValue(d5);
            graphics.drawString(string, n4 + n10, n20 + n13 / 2);
            n3 = n22;
            if (n22 > 0) {
                d3 = pixelValueTransformerArray[2].viewMax() - pixelValueTransformerArray[2].viewMin();
                if (pixelValueTransformerArray[2].rounding() && d3 > 50.0) {
                    d7 = -((float)pixelValueTransformerArray[2].divisionPixelSize());
                    n3 = pixelValueTransformerArray[2].numberOfDividers();
                    for (n2 = 1; n2 <= n3; ++n2) {
                        n23 = (int)Math.rint((double)n20 - (double)n2 * d7);
                        graphics.drawLine(n4, n23, n4 + n10, n23);
                        d4 = d5 + (d6 - d5) / (double)(n3 + 1) * (double)n2;
                        string = yAxisToolBarArray[2].formatValue(d4);
                        graphics.drawString(string, n4 + n10, n23 + n13 / 2);
                    }
                } else {
                    d7 = (double)this.innerYSize / (double)(n22 + 1);
                    for (n2 = 1; n2 <= n22; ++n2) {
                        n23 = (int)((double)n20 - (double)n2 * d7);
                        graphics.drawLine(n4, n23, n4 + n10, n23);
                        d4 = d5 + (d6 - d5) * ((double)n2 * d7) / (double)this.innerYSize;
                        string = yAxisToolBarArray[2].formatValue(d4);
                        graphics.drawString(string, n4 + n10, n23 + n13 / 2);
                    }
                }
            }
        }
        if (this.myFrame.showGrid()) {
            for (n6 = 1; n6 <= n22; ++n6) {
                n23 = (int)Math.rint((double)n20 - (double)n6 * d7);
                graphics.drawLine(this.innerLeft, n23, n21, n23);
            }
        }
        if (blArray[1]) {
            graphics.drawLine(this.innerLeft, n20, n21, n20);
            double d8 = pixelValueTransformerArray[1].viewMin();
            d2 = pixelValueTransformerArray[1].viewMax();
            graphics.drawString(yAxisToolBarArray2[1].axisLabel(), this.innerLeft + (this.innerXSize - fontMetrics.stringWidth(yAxisToolBarArray2[1].axisLabel())) / 2, n20 + 5 * n13 / 2);
            graphics.drawLine(this.innerLeft, n20, this.innerLeft, n20 + n13 / 2);
            string = yAxisToolBarArray[1].formatValue(d8);
            graphics.drawString(string, this.innerLeft - fontMetrics.stringWidth(string) / 2, n20 + 3 * n13 / 2);
            graphics.drawLine(n21, n20, n21, n20 + n13 / 2);
            string = yAxisToolBarArray[1].formatValue(d2);
            graphics.drawString(string, n21 - fontMetrics.stringWidth(string) / 2, n20 + 3 * n13 / 2);
            n = n22 = this.innerXSize / (n10 * 10) - 1;
            if (n22 > 0) {
                d = pixelValueTransformerArray[1].viewMax() - pixelValueTransformerArray[1].viewMin();
                if (pixelValueTransformerArray[1].rounding() && d > 50.0) {
                    d7 = (float)pixelValueTransformerArray[1].divisionPixelSize();
                    n = pixelValueTransformerArray[1].numberOfDividers();
                    for (n6 = 1; n6 <= n; ++n6) {
                        n4 = (int)Math.rint((double)this.innerLeft + (double)n6 * d7);
                        graphics.drawLine(n4, n20, n4, n20 + n13 / 2);
                        d4 = d8 + (d2 - d8) / (double)(n + 1) * (double)n6;
                        string = yAxisToolBarArray[1].formatValue(d4);
                        graphics.drawString(string, n4 - fontMetrics.stringWidth(string) / 2, n20 + 3 * n13 / 2);
                    }
                } else {
                    d7 = this.innerXSize / (n22 + 1);
                    for (n6 = 1; n6 <= n22; ++n6) {
                        n4 = (int)((double)this.innerLeft + (double)n6 * d7);
                        graphics.drawLine(n4, n20, n4, n20 + n13 / 2);
                        d4 = d8 + (d2 - d8) * ((double)n6 * d7) / (double)this.innerXSize;
                        string = yAxisToolBarArray[1].formatValue(d4);
                        graphics.drawString(string, n4 - fontMetrics.stringWidth(string) / 2, n20 + 3 * n13 / 2);
                    }
                }
            }
        }
        if (blArray[3]) {
            graphics.drawLine(this.innerLeft, this.innerTop, n21, this.innerTop);
            double d9 = pixelValueTransformerArray[3].viewMin();
            d2 = pixelValueTransformerArray[3].viewMax();
            graphics.drawLine(this.innerLeft, this.innerTop, this.innerLeft, this.innerTop - n13 / 2);
            string = yAxisToolBarArray[3].formatValue(d9);
            graphics.drawString(string, this.innerLeft - fontMetrics.stringWidth(string) / 2, this.innerTop - n13 / 2);
            graphics.drawLine(n21, this.innerTop, n21, this.innerTop - n13 / 2);
            string = yAxisToolBarArray[3].formatValue(d2);
            graphics.drawString(string, n21 - fontMetrics.stringWidth(string) / 2, this.innerTop - n13 / 2);
            n = n22 = this.innerXSize / (n10 * 10) - 1;
            if (n22 > 0) {
                d = pixelValueTransformerArray[3].viewMax() - pixelValueTransformerArray[3].viewMin();
                if (pixelValueTransformerArray[3].rounding() && d > 50.0) {
                    d7 = (float)pixelValueTransformerArray[3].divisionPixelSize();
                    n = pixelValueTransformerArray[3].numberOfDividers();
                    for (n6 = 1; n6 <= n; ++n6) {
                        n4 = (int)Math.rint((double)this.innerLeft + (double)n6 * d7);
                        graphics.drawLine(n4, this.innerTop, n4, this.innerTop - n13 / 2);
                        d4 = d9 + (d2 - d9) / (double)(n + 1) * (double)n6;
                        string = yAxisToolBarArray[3].formatValue(d4);
                        graphics.drawString(string, n4 - fontMetrics.stringWidth(string) / 2, this.innerTop - n13 / 2);
                    }
                } else {
                    d7 = this.innerXSize / (n22 + 1);
                    for (n6 = 1; n6 <= n22; ++n6) {
                        n4 = (int)Math.rint((double)this.innerLeft + (double)n6 * d7);
                        graphics.drawLine(n4, this.innerTop, n4, this.innerTop - n13 / 2);
                        d4 = d9 + (d2 - d9) * ((double)n6 * d7) / (double)this.innerXSize;
                        string = yAxisToolBarArray[3].formatValue(d4);
                        graphics.drawString(string, n4 - fontMetrics.stringWidth(string) / 2, this.innerTop - n13 / 2);
                    }
                }
            }
        }
        if (this.myFrame.showGrid()) {
            for (n6 = 1; n6 <= n22; ++n6) {
                n4 = (int)Math.rint((double)this.innerLeft + (double)n6 * d7);
                graphics.drawLine(n4, n20, n4, this.innerTop);
            }
        }
        if (!this.myParent.detachLegend()) {
            n23 = n20 + 5 * n13 / 2;
            n4 = 10;
            boolean bl4 = false;
            for (n6 = 0; n6 < n14; n6 += 2) {
                selectionObject2 = selectionObjectArray[n6];
                selectionObject = selectionObjectArray[n6 + 1];
                n5 = this.getLabelRect((SelectionObject)selectionObject).width + this.getLabelRect((SelectionObject)selectionObject2).width;
                if (n4 + n5 > rectangle.width - 10) {
                    n4 = 10;
                }
                if (n4 == 10) {
                    n23 += n13;
                }
                this.paintLabel(selectionObject2, graphics, n4, n23);
                n4 += n5;
            }
        }
        graphics.setFont(this.normalFont);
        if (this.myFrame.pf != null && this.myFrame.printing) {
            graphics.setClip(new Rectangle(this.innerLeft, this.innerTop - 1, this.innerXSize + 1, this.innerYSize + 1));
            System.out.println("disabling clip");
        } else {
            graphics.setClip(rectangle2.intersection(new Rectangle(this.innerLeft, this.innerTop - 1, this.innerXSize + 1, this.innerYSize + 1)));
        }
        boolean bl5 = true;
        n6 = 0;
        while (bl5) {
            bl5 = false;
            for (n = 0; n < n14; n += 2) {
                int n24 = (n + n6 * 2) % n14;
                selectionObject2 = selectionObjectArray[n24];
                selectionObject = selectionObjectArray[n24 + 1];
                YAxisToolBar yAxisToolBar = yAxisToolBarArray3[n24];
                YAxisToolBar yAxisToolBar2 = yAxisToolBarArray3[n24 + 1];
                PixelValueTransformer pixelValueTransformer = pixelValueTransformerArray2[n24];
                PixelValueTransformer pixelValueTransformer2 = pixelValueTransformerArray2[n24 + 1];
                if (selectionObject.length() <= n6 || selectionObject2.length() <= n6) continue;
                bl5 = true;
                int n25 = n6 + selectionObject2.indOff;
                if (n25 < n15 || n25 > n16 || (n25 = n6 + selectionObject.indOff) < n15 || n25 > n16) continue;
                boolean bl6 = selectionObject.yValExists(n6);
                if (selectionObject.accumulate()) {
                    if (bl6) {
                        selectionObject.sum += (double)selectionObject.yVal(n6);
                    }
                    bl6 = true;
                } else {
                    selectionObject.sum = selectionObject.yVal(n6);
                }
                boolean bl7 = selectionObject2.yValExists(n6);
                if (selectionObject2.accumulate()) {
                    if (bl7) {
                        selectionObject2.sum += (double)selectionObject2.yVal(n6);
                    }
                    bl7 = true;
                } else {
                    selectionObject2.sum = selectionObject2.yVal(n6);
                }
                if (!bl6 || !bl7) continue;
                n23 = pixelValueTransformer.pixel(selectionObject2.sum);
                n4 = pixelValueTransformer2.pixel(selectionObject.sum);
                if (this.myFrame.LinearRegression.getState() && selectionObject2.sum <= pixelValueTransformer.viewMax() && selectionObject.sum < pixelValueTransformer2.viewMax()) {
                    this.pointList.addLast(new Point2D.Double(selectionObject.sum, selectionObject2.sum));
                }
                if (this.myFrame.showColor()) {
                    graphics.setColor(selectionObject2.color());
                }
                if (selectionObject2.highlight()) {
                    graphics.fillOval(n4 - 3, n23 - 3, 7, 7);
                } else {
                    graphics.fillOval(n4 - 2, n23 - 2, 5, 5);
                }
                if (selectionObject2.decoration() == null || !this.myFrame.showDecoration()) continue;
                selectionObject2.decoration().draw(graphics, n4, n23);
            }
            ++n6;
        }
        String[] stringArray = new String[]{"    ", "    "};
        if (this.myFrame.LinearRegression.getState()) {
            stringArray = this.doRegression(graphics, pixelValueTransformerArray);
        }
        graphics.setClip(rectangle2);
        graphics.setColor(Color.black);
        graphics.drawString(this.mainLabel, (rectangle.width - fontMetrics.stringWidth(this.mainLabel)) / 2, this.outerTop + n11);
        if (this.myFrame.LinearRegression.getState()) {
            int n26 = rectangle.width - fontMetrics.stringWidth(this.myFrame.regressionLabel + stringArray[0] + "2" + stringArray[1]) - 10;
            graphics.drawString(this.myFrame.regressionLabel + stringArray[0], n26, this.outerTop + n11);
            graphics.drawString("2", n26 += fontMetrics.stringWidth(this.myFrame.regressionLabel + stringArray[0]), this.outerTop + n11 - 3);
            graphics.drawString(stringArray[1], n26 += fontMetrics.stringWidth("2"), this.outerTop + n11);
        }
    }

    void getLimits(SelectionObject selectionObject, double[] dArray) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = this.xTB.minYear();
        int n2 = this.xTB.maxYear();
        boolean bl = selectionObject.histAverage();
        int n3 = -1;
        boolean bl2 = !this.myFrame.doHistogram();
        boolean bl3 = this.myFrame.histWeekly() && !bl2;
        boolean bl4 = this.myFrame.histMonthly() && !bl2;
        boolean bl5 = this.myFrame.histYearly() && !bl2;
        int n4 = this.xTB.xMin();
        int n5 = this.xTB.xMax();
        int n6 = n + (n4 - 1) / 366;
        int n7 = this.xTB.getMonth(1 + (n4 - 1) % 366);
        int n8 = this.xTB.getWeek(1 + (n4 - 1) % 366, n6);
        selectionObject.sum = 0.0;
        selectionObject.indOff = this.xTB.overplot() ? 1 : 1 + (selectionObject.minYear() - n) * 366;
        int n9 = n4;
        boolean bl6 = false;
        boolean bl7 = true;
        while (!bl6) {
            int n10;
            if (bl7) {
                n3 = n9;
                if (!selectionObject.accumulate()) {
                    selectionObject.sum = 0.0;
                }
                selectionObject.ndays = 0;
                bl7 = false;
            }
            if ((n10 = n9 - selectionObject.indOff) >= 0 && n10 < selectionObject.length() && selectionObject.yValExists(n10)) {
                selectionObject.sum += (double)selectionObject.yVal(n10);
                ++selectionObject.ndays;
            }
            if (n9 == n5 || bl5 && n9 % 366 == 0 || bl4 && 1 + (n9 - 1) % 366 == this.xTB.monthEnds(n7) || bl3 && 1 + (n9 - 1) % 366 == this.xTB.weekEnds(n8, n6) || bl2) {
                if (selectionObject.ndays > 0 && selectionObject.histAverage() && !selectionObject.accumulate()) {
                    selectionObject.sum /= (double)selectionObject.ndays;
                }
                if (selectionObject.ndays > 0 || selectionObject.accumulate()) {
                    d = Math.min(d, selectionObject.sum);
                    d2 = Math.max(d2, selectionObject.sum);
                }
                bl7 = true;
                if (bl3) {
                    ++n8;
                }
                if (bl4) {
                    ++n7;
                }
            }
            if (bl3 && n8 == 53) {
                while (n9 % 366 != 0) {
                    ++n9;
                }
            }
            if (++n9 > n5) {
                bl6 = true;
                continue;
            }
            if (n9 % 366 != 1) continue;
            ++n6;
            n7 = 1;
            n8 = 1;
            bl7 = true;
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    String[] doRegression(Graphics graphics, PixelValueTransformer[] pixelValueTransformerArray) {
        int n;
        int n2 = this.pointList.size();
        if (n2 <= 1) {
            String[] stringArray = new String[]{"     ", "    "};
            return stringArray;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        while (this.pointList.size() > 0) {
            Point2D.Double double_ = (Point2D.Double)this.pointList.removeFirst();
            d7 += double_.getX();
            d5 += double_.getX() * double_.getX();
            d6 += double_.getY() * double_.getY();
            d8 += double_.getY();
            d9 += double_.getX() * double_.getY();
        }
        d = d9 - d7 * d8 / (double)n2;
        d2 = d5 - d7 * d7 / (double)n2;
        d3 = d6 - d8 * d8 / (double)n2;
        double d10 = d / d2;
        double d11 = d8 / (double)n2 - d10 * d7 / (double)n2;
        d4 = d * d / (d2 * d3);
        int n3 = pixelValueTransformerArray[1].pixel(pixelValueTransformerArray[1].viewMax());
        if (n3 > (n = pixelValueTransformerArray[0].pixel(pixelValueTransformerArray[0].viewMax()))) {
            n = pixelValueTransformerArray[0].pixel(d10 * pixelValueTransformerArray[1].viewMax() + d11);
        } else {
            n3 = pixelValueTransformerArray[1].pixel((pixelValueTransformerArray[0].viewMax() - d11) / d10);
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(this.myFrame.regressionPrecision);
        String string = numberFormat.format(d10);
        String string2 = numberFormat.format(d11);
        String string3 = numberFormat.format(d4);
        Color color = graphics.getColor();
        graphics.setColor(new Color(204, 0, 204));
        graphics.drawLine(pixelValueTransformerArray[1].pixel(0.0), pixelValueTransformerArray[0].pixel((int)d11), n3, n);
        graphics.setColor(color);
        String[] stringArray = new String[]{"Y = " + string + "X" + " + " + string2 + "  R", ": " + string3};
        return stringArray;
    }

    void drawDashedLine(int n, int n2, int n3, int n4, Graphics graphics, boolean bl) {
        double d;
        double d2;
        double d3;
        int n5 = 6;
        int n6 = 3;
        if (bl) {
            n5 = 12;
            n6 = 6;
        }
        if ((d3 = Math.sqrt((d2 = (double)(n3 - n)) * d2 + (d = (double)(n4 - n2)) * d)) <= (double)n6) {
            graphics.drawLine(n, n2, n3, n4);
        } else {
            int n7;
            int n8;
            double d4;
            d2 /= d3;
            d /= d3;
            double d5 = 0.0;
            for (d4 = d3; d4 >= (double)n5; d4 -= (double)n5) {
                n8 = (int)Math.round((double)n + d2 * d5);
                n7 = (int)Math.round((double)n2 + d * d5);
                int n9 = (int)Math.round((double)n + d2 * (d5 + (double)n6));
                int n10 = (int)Math.round((double)n2 + d * (d5 + (double)n6));
                graphics.drawLine(n8, n7, n9, n10);
                d5 += (double)n5;
            }
            if (d4 > 0.0) {
                n8 = (int)Math.round((double)n + d2 * d5);
                n7 = (int)Math.round((double)n2 + d * d5);
                graphics.drawLine(n8, n7, n3, n4);
            }
        }
    }

    void drawVertDashedLine(int n, int n2, int n3, Graphics graphics, boolean bl) {
        int n4;
        int n5 = 6;
        int n6 = 3;
        if (bl) {
            n5 = 12;
            n6 = 6;
        }
        if (n2 > n3) {
            n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if ((n4 = n3 - n2) <= n6) {
            graphics.drawLine(n, n2, n, n3);
        } else {
            int n7;
            int n8;
            int n9 = 0;
            for (n8 = n4; n8 >= n5; n8 -= n5) {
                n7 = n2 + n9;
                int n10 = n2 + n9 + n6;
                graphics.drawLine(n, n7, n, n10);
                n9 += n5;
            }
            if (n8 > 0) {
                n7 = n2 + n9;
                graphics.drawLine(n, n7, n, n3);
            }
        }
    }

    protected class GraphLegendFrame
    extends JDialog
    implements WindowListener {
        protected GraphLegend legend;
        protected JMenuBar mb;
        protected JMenu EditMenu;
        protected JMenuItem CopyItem;

        public GraphLegendFrame(Frame frame) {
            super(frame, "Legend");
            this.mb = new JMenuBar();
            this.EditMenu = new JMenu("Edit");
            this.CopyItem = new JMenuItem("Copy");
            this.addWindowListener(this);
            this.legend = new GraphLegend(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBackground(Color.white);
            JScrollPane jScrollPane = new JScrollPane(this.legend);
            jScrollPane.getViewport().setBackground(Color.white);
            jPanel.add((Component)jScrollPane, "Center");
            this.setContentPane(jPanel);
            LegendAction legendAction = new LegendAction();
            this.setJMenuBar(this.mb);
            this.mb.add(this.EditMenu);
            this.CopyItem.setActionCommand("Copy");
            this.EditMenu.add(this.CopyItem);
            this.CopyItem.addActionListener(legendAction);
            this.CopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            Object object = new Object();
            InputMap inputMap = GraphComponent.this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), object);
            inputMap = this.legend.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), object);
            ActionMap actionMap = this.legend.getActionMap();
            actionMap.put(object, legendAction);
            actionMap = this.legend.getActionMap();
            actionMap.put(object, legendAction);
            this.pack();
        }

        public void CopyItem_actionPerformed(ActionEvent actionEvent) {
            GraphComponent.this.myFrame.copyComponent(this.legend);
        }

        public void repaintYourself() {
            this.setVisible(GraphComponent.this.myParent.detachLegend());
            if (this.isVisible()) {
                this.legend.repaintYourself();
            }
        }

        public GraphLegend getLegend() {
            return this.legend;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (this == windowEvent.getSource()) {
                GraphComponent.this.myParent.setDetachLegend(false);
                this.hide();
            }
        }

        protected class GraphLegend
        extends JComponent
        implements Scrollable,
        MouseListener {
            protected GraphLegendFrame frame;
            protected int width;
            protected int height;
            protected int lineHeight;
            protected int maxWidth = 100;
            protected boolean lock = false;

            public GraphLegend(GraphLegendFrame graphLegendFrame2) {
                this.frame = graphLegendFrame2;
                this.addMouseListener(this);
            }

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.width, this.height);
            }

            public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
                if (n == 1) {
                    return this.lineHeight * 3;
                }
                return this.maxWidth * 3;
            }

            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                if (n == 1) {
                    return this.lineHeight;
                }
                return this.maxWidth;
            }

            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            public void update(Graphics graphics) {
                this.repaintYourself();
            }

            public void repaintYourself() {
                if (this.lock) {
                    return;
                }
                this.repaint();
            }

            public void paintComponent(Graphics graphics) {
                int n;
                Object object;
                ListIterator listIterator;
                int n2;
                int n3;
                boolean bl = graphics instanceof Graphics2D;
                Object var3_3 = null;
                Graphics2D graphics2D = null;
                if (bl) {
                    graphics2D = (Graphics2D)graphics;
                }
                int n4 = 0;
                int n5 = 0;
                if (this.lock) {
                    return;
                }
                this.lock = true;
                GraphComponent.this.normalFont = graphics.getFont();
                GraphComponent.this.italicFont = GraphComponent.this.normalFont.deriveFont(2);
                FontMetrics fontMetrics = this.getFontMetrics(GraphComponent.this.normalFont);
                FontMetrics fontMetrics2 = this.getFontMetrics(GraphComponent.this.italicFont);
                this.lineHeight = fontMetrics.getHeight();
                GraphComponent.this.updateLabelSizes(graphics);
                if (GraphComponent.this.doXYPlot()) {
                    for (n3 = 0; n3 < 4; n3 += 2) {
                        if (!GraphComponent.this.myFrame.showYAxis(n3) || !GraphComponent.this.myFrame.showYAxis(n3 + 1)) continue;
                        n2 = 0;
                        listIterator = GraphComponent.this.myFrame.soList(n3).listIterator(0);
                        object = GraphComponent.this.myFrame.soList(n3 + 1).listIterator(0);
                        while (listIterator.hasNext() && object.hasNext()) {
                            SelectionObject selectionObject = (SelectionObject)listIterator.next();
                            SelectionObject selectionObject2 = (SelectionObject)object.next();
                            n = GraphComponent.this.getLabelRect((SelectionObject)selectionObject2).width + GraphComponent.this.getLabelRect((SelectionObject)selectionObject).width;
                            if (n > this.maxWidth) {
                                this.maxWidth = n;
                            }
                            ++n2;
                        }
                        if (n2 > n5) {
                            n5 = n2;
                        }
                        ++n4;
                    }
                } else {
                    for (n3 = 0; n3 < 4; ++n3) {
                        if (!GraphComponent.this.myFrame.showYAxis(n3)) continue;
                        n2 = 0;
                        listIterator = GraphComponent.this.myFrame.soList(n3).listIterator(0);
                        while (listIterator.hasNext()) {
                            object = (SelectionObject)listIterator.next();
                            n = GraphComponent.this.getLabelRect((SelectionObject)object).width;
                            if (n > this.maxWidth) {
                                this.maxWidth = n;
                            }
                            ++n2;
                        }
                        if (n2 > n5) {
                            n5 = n2;
                        }
                        ++n4;
                    }
                }
                n3 = n4 * this.maxWidth;
                n2 = (n5 + 1) * this.lineHeight;
                if (n3 != this.width || n2 != this.height) {
                    this.setPreferredSize(new Dimension(n3, n2));
                    this.width = n3;
                    this.height = n2;
                    this.revalidate();
                    this.frame.pack();
                }
                int n6 = 0;
                Rectangle rectangle = this.getBounds();
                graphics.setColor(Color.white);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(Color.black);
                if (GraphComponent.this.doXYPlot()) {
                    boolean bl2 = false;
                    int n7 = fontMetrics.stringWidth(" vs ");
                    for (int i = 0; i < 4; i += 2) {
                        if (!GraphComponent.this.myFrame.showYAxis(i) || !GraphComponent.this.myFrame.showYAxis(i + 1)) continue;
                        int n8 = this.lineHeight;
                        String string = GraphComponent.this.yTB[i].SideLabel.getText() + " vs. " + GraphComponent.this.yTB[i + 1].SideLabel.getText();
                        int n9 = fontMetrics.stringWidth(string);
                        graphics.setFont(GraphComponent.this.normalFont);
                        graphics.drawString(string, n6 + (this.maxWidth - n9) / 2, n8);
                        graphics.drawLine(n6 + (this.maxWidth - n9) / 2, n8 + 2, n6 + (this.maxWidth - n9) / 2 + n9 + 3, n8 + 2);
                        n8 += this.lineHeight;
                        ListIterator listIterator2 = GraphComponent.this.myFrame.soList(i).listIterator(0);
                        ListIterator listIterator3 = GraphComponent.this.myFrame.soList(i + 1).listIterator(0);
                        while (listIterator2.hasNext() && listIterator3.hasNext()) {
                            SelectionObject selectionObject = (SelectionObject)listIterator2.next();
                            SelectionObject selectionObject3 = (SelectionObject)listIterator3.next();
                            GraphComponent.this.paintLabel(selectionObject, graphics, n6, n8);
                            n8 += this.lineHeight;
                        }
                        graphics.setFont(GraphComponent.this.normalFont);
                        n6 += this.maxWidth;
                    }
                } else {
                    boolean bl3 = true;
                    for (int i = 0; i < 4; ++i) {
                        if (!GraphComponent.this.myFrame.showYAxis(i)) continue;
                        int n10 = this.lineHeight;
                        String string = GraphComponent.this.yTB[i].SideLabel.getText() + " Axis";
                        int n11 = fontMetrics.stringWidth(string);
                        graphics.setFont(GraphComponent.this.normalFont);
                        graphics.drawString(string, n6 + (this.maxWidth - n11) / 2, n10);
                        graphics.drawLine(n6 + (this.maxWidth - n11) / 2, n10 + 2, n6 + (this.maxWidth - n11) / 2 + n11 + 3, n10 + 2);
                        n10 += this.lineHeight;
                        ListIterator listIterator4 = GraphComponent.this.myFrame.soList(i).listIterator(0);
                        while (listIterator4.hasNext()) {
                            SelectionObject selectionObject = (SelectionObject)listIterator4.next();
                            GraphComponent.this.paintLabel(selectionObject, graphics, n6, n10);
                            n10 += this.lineHeight;
                        }
                        n6 += this.maxWidth;
                    }
                    graphics.setColor(Color.black);
                }
                this.lock = false;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                GraphComponent.this.myParent.graphComponent().mouseClicked(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Rectangle rectangle;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && GraphComponent.this.myParent.detachLegend() && (mouseEvent.getX() < 0 || mouseEvent.getX() > this.getWidth() || mouseEvent.getY() < 0 || mouseEvent.getY() > this.getHeight()) && (rectangle = SwingUtilities.convertRectangle(GraphComponent.this.myParent, new Rectangle(0, 0, GraphComponent.this.myParent.getWidth(), GraphComponent.this.myParent.getHeight()), this)).contains(mouseEvent.getPoint())) {
                    GraphComponent.this.myParent.setDetachLegend(false);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }
        }

        class LegendAction
        extends AbstractAction {
            LegendAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == GraphLegendFrame.this.CopyItem || object == GraphLegendFrame.this.legend) {
                    GraphLegendFrame.this.CopyItem_actionPerformed(actionEvent);
                }
            }
        }
    }
}

