/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.AboutBox;
import DartPackage.DartInterface;
import DartPackage.DartObservable;
import DartPackage.DartUtils;
import DartPackage.FilterLayoutDialog;
import DartPackage.GraphComponent;
import DartPackage.GraphDecoration;
import DartPackage.GraphLabelDialog;
import DartPackage.GraphListModel;
import DartPackage.GraphViewFrame;
import DartPackage.HelpFrame;
import DartPackage.SelectionObject;
import DartPackage.SelectionParams;
import DartPackage.SingleExtFileFilter;
import DartPackage.ThreeColumnDialog;
import DartPackage.XAxisToolBar;
import DartPackage.YAxisToolBar;
import DartPackage.undoAction;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.text.Collator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class GraphFrame
extends GraphViewFrame
implements ComponentListener,
Printable,
Pageable {
    protected XYPlotFrame xyPlotFrame;
    protected XAxisToolBar xToolBar;
    protected YAxisToolBar[] yToolBar;
    protected UndoManager undoMgr = new UndoManager();
    boolean Accum = false;
    PageFormat pf;
    protected GraphComponent graphComponent = null;
    protected int regressionPrecision = 3;
    protected String regressionLabel = "";
    boolean reCalculating = false;
    String graphName;
    protected JFileChooser saveFileDialog = null;
    protected JFileChooser openFileDialog = null;
    protected JFileChooser saveDataFileDialog = null;
    protected LinkedList[] soList;
    protected boolean[] showYAxis;
    protected DartInterface dartInter;
    DartObservable favObOb;
    protected int minYr = 2001;
    protected int maxYr = 2001;
    static LinkedList allGraphFrames = new LinkedList();
    static int nextUniqueId = 1;
    int uniqueId;
    transient String hostAddr = "unknown";
    transient String hostName = "unknown";
    protected ThreeColumnDialog ptcd;
    protected ThreeColumnDialog[] tcdArr;
    protected SelectionParams currSelection;
    JScrollPane ScrollPane = new JScrollPane();
    JTable TextTable = new JTable();
    JMenuBar JMenuBar1 = new JMenuBar();
    JMenu FileMenu = new JMenu();
    JMenu GraphMenu = new JMenu();
    JMenuItem PrintItem = new JMenuItem();
    JMenuItem OpenItem = new JMenuItem();
    JMenuItem SaveAsItem = new JMenuItem();
    JMenuItem SaveDataAsItem = new JMenuItem();
    JMenuItem CloseItem = new JMenuItem();
    JCheckBoxMenuItem HistAverage = new JCheckBoxMenuItem();
    JCheckBoxMenuItem HistSum = new JCheckBoxMenuItem();
    JMenu ViewMenu = new JMenu();
    JMenu ViewOptionsMenu = new JMenu();
    JCheckBoxMenuItem GridItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem ColorItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem DecorationItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem ViewAsTextItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem DetachLegendItem = new JCheckBoxMenuItem();
    JMenu TextViewMenu = new JMenu();
    JCheckBoxMenuItem NoDataSpaceItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem NoDataNAItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem OverPlotItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem XYPlotItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem HistogramItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem JulianDateView = new JCheckBoxMenuItem();
    JCheckBoxMenuItem StandardDateView = new JCheckBoxMenuItem();
    JMenu HistogramOptionsMenu = new JMenu();
    JCheckBoxMenuItem HistWeeklyItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem HistMonthlyItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem HistYearlyItem = new JCheckBoxMenuItem();
    JSeparator JSeparator1 = new JSeparator();
    JCheckBoxMenuItem HistSideBySideItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem HistOverlapItem = new JCheckBoxMenuItem();
    JMenu EditMenu = new JMenu();
    JMenuItem EditLabelsItem = new JMenuItem();
    JMenuItem EditSelectionsItem = new JMenuItem();
    JMenuItem SelectAllItem = new JMenuItem();
    JMenuItem CopyItem = new JMenuItem();
    JMenu HelpMenu = new JMenu();
    JMenuItem AboutItem = new JMenuItem();
    JMenuItem UndoItem = new JMenuItem();
    JMenuItem RedoItem = new JMenuItem();
    JMenuItem HelpItem = new JMenuItem();
    JMenuItem saveAsImage = new JMenuItem();
    JMenuItem DataFilter = new JMenuItem();
    JMenuItem DataLayout = new JMenuItem();
    JCheckBoxMenuItem Accumulate = new JCheckBoxMenuItem();
    JCheckBoxMenuItem LinearRegression = new JCheckBoxMenuItem();
    ImageIcon jdLogo;
    ImageIcon jdXYLogo;
    DefaultTableModel tableModel = new DefaultTableModel(){

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };
    ButtonGroup TimeGroup = new ButtonGroup();
    ButtonGroup SpaceGroup = new ButtonGroup();
    ButtonGroup DataGroup = new ButtonGroup();
    ButtonGroup DateGroup = new ButtonGroup();
    ButtonGroup HistGroup = new ButtonGroup();
    public boolean printing = false;
    protected static final int FILE_VERSION = 2;
    static final int COLUMN_WIDTH = 12;
    private StringBuffer privBuf = new StringBuffer();
    protected boolean firstXYPlot = true;

    public void delete() {
        if (this.xyPlotFrame != null) {
            this.xyPlotFrame.dispose();
        }
    }

    public String toString() {
        return this.graphName;
    }

    XAxisToolBar xToolBar() {
        return this.xToolBar;
    }

    YAxisToolBar yToolBar(int n) {
        return this.yToolBar[n];
    }

    GraphComponent graphComponent() {
        return this.graphComponent;
    }

    LinkedList soList(int n) {
        return this.soList[n];
    }

    String soListName(int n, LinkedList linkedList) {
        return "y" + (n + 1) + " (" + SelectionObject.unitsShortStr(((SelectionObject)linkedList.getFirst()).axisType()) + ")";
    }

    void setSOList(int n, LinkedList linkedList) {
        this.soList[n] = linkedList;
        if (linkedList.size() <= 0) {
            return;
        }
        SelectionObject selectionObject = (SelectionObject)linkedList.getFirst();
        this.yToolBar[n].setAxisLabel(this.soListName(n, linkedList));
        this.yToolBar[n].setPrecision(selectionObject.defaultPrecision());
    }

    boolean showYAxis(int n) {
        return this.showYAxis[n];
    }

    void setShowYAxis(int n, boolean bl) {
        this.showYAxis[n] = bl;
    }

    void setOverplot(boolean bl) {
        this.OverPlotItem.setSelected(bl);
        this.xToolBar.setOverplot(bl);
    }

    void setHistogram(boolean bl) {
        this.HistogramItem.setSelected(bl);
    }

    void setMainLabel(String string) {
        String string2;
        this.graphComponent.mainLabel = string2 = string + " #" + String.valueOf(this.uniqueId);
        this.setTitle(string2);
    }

    void setXYPlot(boolean bl) {
        this.XYPlotItem.setSelected(bl);
        this.XYPlotItem_actionPerformed(null);
        this.xToolBar.XYButton.setSelected(bl);
    }

    boolean doXYPlot() {
        return this.XYPlotItem.isSelected();
    }

    boolean doHistogram() {
        return this.HistogramItem.isSelected();
    }

    boolean histWeekly() {
        return this.HistWeeklyItem.isSelected();
    }

    boolean histMonthly() {
        return this.HistMonthlyItem.isSelected();
    }

    boolean histYearly() {
        return this.HistYearlyItem.isSelected();
    }

    boolean histSideBySide() {
        return this.HistSideBySideItem.isSelected();
    }

    boolean histOverlap() {
        return this.HistOverlapItem.isSelected();
    }

    void updateYourself() {
        this.readAllData();
    }

    DartInterface dartInter() {
        return this.dartInter;
    }

    int minYr() {
        return this.minYr;
    }

    int maxYr() {
        return this.maxYr;
    }

    String hostAddr() {
        return this.hostAddr;
    }

    String hostName() {
        return this.hostName;
    }

    public SelectionParams getSelectionParams() {
        return this.currSelection;
    }

    public void setSelectionParams(SelectionParams selectionParams) {
        this.currSelection = selectionParams;
    }

    public GraphFrame(DartInterface dartInterface, DartObservable dartObservable, ThreeColumnDialog[] threeColumnDialogArray, ThreeColumnDialog threeColumnDialog, SelectionParams selectionParams) {
        this.dartInter = dartInterface;
        this.favObOb = dartObservable;
        this.ptcd = threeColumnDialog;
        this.tcdArr = threeColumnDialogArray;
        this.currSelection = selectionParams;
        URL uRL = this.getClass().getResource("jdLogo.png");
        this.jdLogo = new ImageIcon(uRL);
        if (this.jdLogo != null) {
            this.setIconImage(this.jdLogo.getImage());
        }
        this.undoMgr.setLimit(15);
        this.setJMenuBar(this.JMenuBar1);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(null);
        this.getContentPane().setFont(new Font("Dialog", 0, 12));
        this.setSize(730, 500);
        this.setVisible(false);
        this.ScrollPane.setOpaque(true);
        this.JMenuBar1.setFont(new Font("Dialog", 0, 12));
        this.FileMenu.setText("File");
        this.FileMenu.setActionCommand("File");
        this.FileMenu.setFont(new Font("Dialog", 0, 12));
        this.GraphMenu.setText("Graph");
        this.GraphMenu.setFont(new Font("Dialog", 0, 12));
        this.JMenuBar1.add(this.FileMenu);
        this.PrintItem.setText("Print...");
        this.PrintItem.setActionCommand("Print...");
        this.PrintItem.setFont(new Font("Dialog", 0, 12));
        this.PrintItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.OpenItem.setText("Open...");
        this.OpenItem.setActionCommand("Open...");
        this.OpenItem.setFont(new Font("Dialog", 0, 12));
        this.OpenItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.FileMenu.add(this.OpenItem);
        this.SaveAsItem.setText("Save As...");
        this.SaveAsItem.setActionCommand("Save Configuration...");
        this.SaveAsItem.setFont(new Font("Dialog", 0, 12));
        this.SaveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.FileMenu.add(this.SaveAsItem);
        this.SaveDataAsItem.setText("Save Data As...");
        this.SaveDataAsItem.setActionCommand("Save Data As...");
        this.SaveDataAsItem.setFont(new Font("Dialog", 0, 12));
        this.FileMenu.add(this.SaveDataAsItem);
        this.saveAsImage.setText("Save Image As...");
        this.saveAsImage.setFont(new Font("Dialog", 0, 12));
        this.FileMenu.add(this.saveAsImage);
        this.CloseItem.setText("Close");
        this.CloseItem.setActionCommand("Close");
        this.CloseItem.setFont(new Font("Dialog", 0, 12));
        this.CloseItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.FileMenu.add(this.PrintItem);
        this.FileMenu.add(this.CloseItem);
        this.ViewMenu.setText("View");
        this.ViewMenu.setActionCommand("View");
        this.ViewMenu.setFont(new Font("Dialog", 0, 12));
        this.JMenuBar1.add(this.EditMenu);
        this.JMenuBar1.add(this.ViewMenu);
        this.UndoItem.setEnabled(false);
        this.EditMenu.add(this.UndoItem);
        this.EditMenu.add(this.RedoItem);
        this.EditMenu.add(new JSeparator());
        this.EditMenu.add(this.CopyItem);
        this.EditMenu.add(this.SelectAllItem);
        this.EditMenu.add(new JSeparator());
        this.UndoItem.setText("Undo");
        this.UndoItem.setFont(new Font("Dialog", 0, 12));
        this.UndoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.RedoItem.setText("Redo");
        this.RedoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.RedoItem.setFont(new Font("Dialog", 0, 12));
        this.ViewOptionsMenu.setText("View Options");
        this.ViewOptionsMenu.setActionCommand("View Options");
        this.ViewOptionsMenu.setFont(new Font("Dialog", 0, 12));
        this.ViewMenu.add(this.ViewOptionsMenu);
        this.GridItem.setText("Grid");
        this.GridItem.setActionCommand("Grid");
        this.GridItem.setFont(new Font("Dialog", 0, 12));
        this.ViewOptionsMenu.add(this.GridItem);
        this.ColorItem.setSelected(true);
        this.ColorItem.setText("Color");
        this.ColorItem.setActionCommand("Color");
        this.ColorItem.setFont(new Font("Dialog", 0, 12));
        this.ViewOptionsMenu.add(this.ColorItem);
        this.DecorationItem.setSelected(true);
        this.DecorationItem.setText("Decoration");
        this.DecorationItem.setActionCommand("Decoration");
        this.DecorationItem.setFont(new Font("Dialog", 0, 12));
        this.ViewOptionsMenu.add(this.DecorationItem);
        this.ViewAsTextItem.setText("View As Text");
        this.ViewAsTextItem.setActionCommand("View As Text");
        this.ViewAsTextItem.setFont(new Font("Dialog", 0, 12));
        this.ViewMenu.add(this.ViewAsTextItem);
        this.TextViewMenu.setText("Text View Options");
        this.TextViewMenu.setActionCommand("jmenu");
        this.TextViewMenu.setFont(new Font("Dialog", 0, 12));
        this.ViewMenu.add(this.TextViewMenu);
        this.DetachLegendItem.setText("Detach Legend");
        this.DetachLegendItem.setActionCommand("Detach Legend");
        this.DetachLegendItem.setFont(new Font("Dialog", 0, 12));
        this.ViewMenu.add(this.DetachLegendItem);
        this.Accumulate.setText("Cumulative");
        this.Accumulate.setFont(new Font("Dialog", 0, 12));
        this.GraphMenu.add(this.Accumulate);
        this.LinearRegression.setFont(new Font("Dialog", 0, 12));
        this.LinearRegression.setText("Linear Regression");
        this.GraphMenu.add(this.LinearRegression);
        this.NoDataSpaceItem.setText("Missing Data: Space");
        this.NoDataSpaceItem.setActionCommand("Missing Data: Space");
        this.NoDataSpaceItem.setFont(new Font("Dialog", 0, 12));
        this.TextViewMenu.add(this.NoDataSpaceItem);
        this.NoDataNAItem.setText("Missing Data: NA");
        this.NoDataNAItem.setActionCommand("Missing Data: NA");
        this.NoDataNAItem.setFont(new Font("Dialog", 0, 12));
        this.TextViewMenu.add(this.NoDataNAItem);
        this.NoDataNAItem.setState(true);
        this.TextViewMenu.add(new JSeparator(0));
        this.JulianDateView.setText("Julian Dates");
        this.JulianDateView.setFont(new Font("Dialog", 0, 12));
        this.TextViewMenu.add(this.JulianDateView);
        this.StandardDateView.setText("Standard Dates");
        this.StandardDateView.setFont(new Font("Dialog", 0, 12));
        this.TextViewMenu.add(this.StandardDateView);
        this.JulianDateView.setState(true);
        this.OverPlotItem.setText("Over Plot Years");
        this.OverPlotItem.setActionCommand("OverPlot");
        this.OverPlotItem.setFont(new Font("Dialog", 0, 12));
        this.RedoItem.setEnabled(false);
        this.GraphMenu.add(this.OverPlotItem);
        this.XYPlotItem.setText("XY Plot");
        this.XYPlotItem.setActionCommand("XY Plot");
        this.XYPlotItem.setFont(new Font("Dialog", 0, 12));
        this.GraphMenu.add(this.XYPlotItem);
        this.HistogramItem.setText("Histogram");
        this.HistogramItem.setActionCommand("Histogram");
        this.HistogramItem.setFont(new Font("Dialog", 0, 12));
        this.GraphMenu.add(this.HistogramItem);
        this.HistogramOptionsMenu.setText("Hist. Options");
        this.HistogramOptionsMenu.setActionCommand("Hist. Options");
        this.HistogramOptionsMenu.setFont(new Font("Dialog", 0, 12));
        this.GraphMenu.add(this.HistogramOptionsMenu);
        this.DataFilter.setText("Data Management...");
        this.DataFilter.setFont(new Font("Dialog", 0, 12));
        this.GraphMenu.add(new JSeparator());
        this.GraphMenu.add(this.DataFilter);
        this.HistWeeklyItem.setSelected(true);
        this.HistWeeklyItem.setText("Weekly");
        this.HistWeeklyItem.setActionCommand("Weekly");
        this.HistWeeklyItem.setFont(new Font("Dialog", 0, 12));
        this.HistogramOptionsMenu.add(this.HistWeeklyItem);
        this.HistMonthlyItem.setText("Monthly");
        this.HistMonthlyItem.setActionCommand("Monthly");
        this.HistMonthlyItem.setFont(new Font("Dialog", 0, 12));
        this.HistogramOptionsMenu.add(this.HistMonthlyItem);
        this.HistYearlyItem.setText("Yearly");
        this.HistYearlyItem.setActionCommand("Yearly");
        this.HistYearlyItem.setFont(new Font("Dialog", 0, 12));
        this.HistogramOptionsMenu.add(this.HistYearlyItem);
        this.HistogramOptionsMenu.add(this.JSeparator1);
        this.HistSideBySideItem.setSelected(true);
        this.HistSideBySideItem.setText("Side by Side");
        this.HistSideBySideItem.setActionCommand("Side by Side");
        this.HistSideBySideItem.setFont(new Font("Dialog", 0, 12));
        this.HistogramOptionsMenu.add(this.HistSideBySideItem);
        this.HistOverlapItem.setText("Overlap");
        this.HistOverlapItem.setActionCommand("Overlap");
        this.HistOverlapItem.setFont(new Font("Dialog", 0, 12));
        this.HistogramOptionsMenu.add(this.HistOverlapItem);
        this.HistogramOptionsMenu.add(new JSeparator());
        this.HistAverage.setText("Average");
        this.HistAverage.setFont(new Font("Dialog", 0, 12));
        this.HistSum.setFont(new Font("Dialog", 0, 12));
        this.HistSum.setText("Sum");
        this.HistogramOptionsMenu.add(this.HistSum);
        this.HistogramOptionsMenu.add(this.HistAverage);
        this.EditMenu.setText("Edit");
        this.EditMenu.setActionCommand("Edit");
        this.EditMenu.setFont(new Font("Dialog", 0, 12));
        this.EditLabelsItem.setText("Labels...");
        this.EditLabelsItem.setActionCommand("Labels...");
        this.EditLabelsItem.setFont(new Font("Dialog", 0, 12));
        this.EditMenu.add(this.EditLabelsItem);
        this.EditSelectionsItem.setText("Data Layout...");
        this.EditSelectionsItem.setActionCommand("jmenuItem");
        this.EditSelectionsItem.setFont(new Font("Dialog", 0, 12));
        this.SelectAllItem.setText("Select All");
        this.SelectAllItem.setActionCommand("Select All");
        this.SelectAllItem.setFont(new Font("Dialog", 0, 12));
        this.SelectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.CopyItem.setText("Copy");
        this.CopyItem.setActionCommand("Copy");
        this.CopyItem.setFont(new Font("Dialog", 0, 12));
        this.CopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.JMenuBar1.add(this.GraphMenu);
        this.HelpMenu.setText("Help");
        this.HelpMenu.setActionCommand("Help");
        this.HelpMenu.setFont(new Font("Dialog", 0, 12));
        this.JMenuBar1.add(this.HelpMenu);
        this.HelpItem.setText("Help Contents...");
        this.HelpItem.setActionCommand("Help Contents...");
        this.HelpItem.setFont(new Font("Dialog", 0, 12));
        this.HelpMenu.add(this.HelpItem);
        this.AboutItem.setText("About...");
        this.AboutItem.setActionCommand("About...");
        this.AboutItem.setFont(new Font("Dialog", 0, 12));
        this.HelpMenu.add(this.AboutItem);
        this.getContentPane().add(this.ScrollPane);
        this.ScrollPane.setBounds(0, 0, 20, 40);
        this.TextTable.setColumnSelectionAllowed(true);
        this.TextTable.setRowSelectionAllowed(false);
        this.TextTable.setDragEnabled(false);
        this.ScrollPane.getViewport().add(this.TextTable);
        this.TextTable.setModel(this.tableModel);
        this.TextTable.setFont(new Font("MonoSpaced", 0, 12));
        this.TextTable.setBounds(2, 2, 17, 37);
        this.TextTable.getTableHeader().setReorderingAllowed(false);
        this.SelectAllItem.setEnabled(false);
        SymAction symAction = new SymAction();
        this.PrintItem.addActionListener(symAction);
        this.CloseItem.addActionListener(symAction);
        this.GridItem.addActionListener(symAction);
        this.DetachLegendItem.addActionListener(symAction);
        this.ColorItem.addActionListener(symAction);
        this.DecorationItem.addActionListener(symAction);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        this.SaveAsItem.addActionListener(symAction);
        this.OpenItem.addActionListener(symAction);
        this.EditLabelsItem.addActionListener(symAction);
        this.OverPlotItem.addActionListener(symAction);
        this.ViewAsTextItem.addActionListener(symAction);
        this.SelectAllItem.addActionListener(symAction);
        this.CopyItem.addActionListener(symAction);
        this.XYPlotItem.addActionListener(symAction);
        this.EditSelectionsItem.addActionListener(symAction);
        this.SaveDataAsItem.addActionListener(symAction);
        this.HistogramItem.addActionListener(symAction);
        this.HistWeeklyItem.addActionListener(symAction);
        this.HistMonthlyItem.addActionListener(symAction);
        this.HistYearlyItem.addActionListener(symAction);
        this.HistSideBySideItem.addActionListener(symAction);
        this.HistOverlapItem.addActionListener(symAction);
        this.AboutItem.addActionListener(symAction);
        this.HelpItem.addActionListener(symAction);
        this.NoDataSpaceItem.addActionListener(symAction);
        this.NoDataNAItem.addActionListener(symAction);
        this.Accumulate.addActionListener(symAction);
        this.LinearRegression.addActionListener(symAction);
        this.JulianDateView.addActionListener(symAction);
        this.StandardDateView.addActionListener(symAction);
        this.UndoItem.addActionListener(symAction);
        this.RedoItem.addActionListener(symAction);
        this.saveAsImage.addActionListener(symAction);
        this.DataFilter.addActionListener(symAction);
        this.HistSum.addActionListener(symAction);
        this.HistAverage.addActionListener(symAction);
        this.soList = new LinkedList[4];
        for (int i = 0; i < 4; ++i) {
            this.soList[i] = new LinkedList();
        }
        this.TimeGroup.add(this.HistWeeklyItem);
        this.TimeGroup.add(this.HistMonthlyItem);
        this.TimeGroup.add(this.HistYearlyItem);
        this.SpaceGroup.add(this.HistSideBySideItem);
        this.SpaceGroup.add(this.HistOverlapItem);
        this.DataGroup.add(this.NoDataSpaceItem);
        this.DataGroup.add(this.NoDataNAItem);
        this.DateGroup.add(this.JulianDateView);
        this.DateGroup.add(this.StandardDateView);
        this.HistGroup.add(this.HistSum);
        this.HistGroup.add(this.HistAverage);
        this.showYAxis = new boolean[4];
        this.showYAxis[0] = false;
        this.showYAxis[1] = true;
        this.showYAxis[2] = true;
        this.showYAxis[3] = false;
        this.yToolBar = new YAxisToolBar[4];
        this.yToolBar[0] = new YAxisToolBar(this);
        this.getContentPane().add(this.yToolBar[0]);
        this.yToolBar[0].setVisible(this.showYAxis[0]);
        this.yToolBar[1] = new YAxisToolBar(this);
        this.getContentPane().add(this.yToolBar[1]);
        this.yToolBar[1].setVisible(this.showYAxis[1]);
        this.yToolBar[2] = new YAxisToolBar(this);
        this.getContentPane().add(this.yToolBar[2]);
        this.yToolBar[2].setVisible(this.showYAxis[2]);
        this.yToolBar[3] = new YAxisToolBar(this);
        this.getContentPane().add(this.yToolBar[3]);
        this.yToolBar[3].setVisible(this.showYAxis[3]);
        this.xToolBar = new XAxisToolBar(this);
        this.getContentPane().add(this.xToolBar);
        this.updateRanges();
        this.graphComponent = new GraphComponent(this, this);
        RepaintManager repaintManager = RepaintManager.currentManager(this.graphComponent);
        repaintManager.setDoubleBufferingEnabled(false);
        this.getContentPane().add(this.graphComponent);
        Object object = new Object();
        InputMap inputMap = this.TextTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(67, 2), object);
        inputMap = this.graphComponent.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(67, 2), object);
        ActionMap actionMap = this.TextTable.getActionMap();
        actionMap.put(object, symAction);
        actionMap = this.graphComponent.getActionMap();
        actionMap.put(object, symAction);
        this.getContentPane().addComponentListener(this);
        this.graphComponent.xAxisLabel = "X - Days";
        DartUtils.centerWindow(this, null);
        SelectionObject.configure();
        allGraphFrames.addLast(this);
        this.uniqueId = nextUniqueId++;
        this.setMainLabel("DART Graph Window");
        try {
            this.hostAddr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            this.hostAddr = "error";
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.hostName = "error";
        }
        this.show();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension;
        Dimension dimension2 = this.getContentPane().getSize();
        int n = 0;
        if (this.xToolBar != null) {
            this.xToolBar.setVisible(true);
            dimension = this.xToolBar.getPreferredSize();
            this.xToolBar.setBounds(0, n, dimension2.width, dimension.height);
            n += dimension.height;
        }
        if (this.ViewAsTextItem.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                if (this.yToolBar[i] == null) continue;
                this.yToolBar[i].setVisible(false);
            }
            if (this.graphComponent != null) {
                this.graphComponent.setVisible(false);
            }
            this.ScrollPane.setVisible(true);
            this.ScrollPane.setBounds(0, n, dimension2.width, dimension2.height - n);
            this.TextTable.revalidate();
            this.TextTable.repaint();
            this.xToolBar.revalidate();
            this.xToolBar.repaint();
            return;
        }
        this.ScrollPane.setVisible(false);
        for (int i = 0; i < 4; ++i) {
            if (this.yToolBar[i] == null) continue;
            if (this.showYAxis[i]) {
                this.yToolBar[i].setVisible(true);
                dimension = this.yToolBar[i].getPreferredSize();
                this.yToolBar[i].setBounds(0, n, dimension2.width, dimension.height);
                n += dimension.height;
                continue;
            }
            this.yToolBar[i].setVisible(false);
        }
        this.xToolBar.revalidate();
        this.xToolBar.repaint();
        if (this.graphComponent != null) {
            this.graphComponent.setVisible(true);
            this.graphComponent.setBounds(0, n, dimension2.width, Math.max(1, dimension2.height - n));
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    void prodGraph() {
        if (this.graphComponent != null) {
            this.graphComponent.repaintYourself();
        }
        if (this.xyPlotFrame != null && this.doXYPlot()) {
            this.xyPlotFrame.prodGraph();
        }
        this.updateTextView();
    }

    void HistSum_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < 4; ++i) {
            for (SelectionObject selectionObject : this.soList[i]) {
                selectionObject.setHistAverage(false);
            }
        }
    }

    void HistAverage_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < 4; ++i) {
            for (SelectionObject selectionObject : this.soList[i]) {
                selectionObject.setHistAverage(true);
            }
        }
    }

    void updateRanges() {
        this.minYr = Integer.MAX_VALUE;
        this.maxYr = Integer.MIN_VALUE;
        double[] dArray = new double[2];
        for (int i = 0; i < 4; ++i) {
            double d = Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            ListIterator listIterator = this.soList[i].listIterator(0);
            while (listIterator.hasNext()) {
                SelectionObject selectionObject = (SelectionObject)listIterator.next();
                selectionObject.applyDataFilter();
                if (this.HistogramItem.isSelected() || selectionObject.accumulate()) {
                    this.graphComponent.getLimits(selectionObject, dArray);
                    d = Math.min(d, dArray[0]);
                    d2 = Math.max(d2, dArray[1]);
                } else {
                    d = Math.min(d, selectionObject.yMin());
                    d2 = Math.max(d2, selectionObject.yMax());
                }
                this.minYr = Math.min(this.minYr, selectionObject.minYear());
                this.maxYr = Math.max(this.maxYr, selectionObject.maxYear());
            }
            if (d > d2) {
                d = 0.0;
                d2 = 0.0;
            }
            this.yToolBar[i].setDataRange(d, d2);
        }
        if (this.minYr > this.maxYr) {
            this.minYr = 2001;
            this.maxYr = 2001;
        }
        this.xToolBar.setDataRange(this.minYr, this.maxYr);
        this.prodGraph();
    }

    void UndoItem_actionPerformed(ActionEvent actionEvent) {
        if (this.undoMgr.canUndo()) {
            this.undoMgr.undo();
            this.RedoItem.setEnabled(true);
        }
        if (!this.undoMgr.canUndo()) {
            this.UndoItem.setEnabled(false);
        }
    }

    void RedoItem_actionPerformed(ActionEvent actionEvent) {
        if (this.undoMgr.canRedo()) {
            this.undoMgr.redo();
            this.UndoItem.setEnabled(true);
        }
        if (!this.undoMgr.canRedo()) {
            this.RedoItem.setEnabled(false);
        }
    }

    void DataFilter_actionPerformed(ActionEvent actionEvent) {
        this.firstXYPlot = false;
        new FilterLayoutDialog(this);
    }

    void Accumulate_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("accumulation", this, null));
        }
        this.Accum = !this.Accum;
        for (int i = 0; i < this.soList.length; ++i) {
            ListIterator listIterator = this.soList[i].listIterator(0);
            while (listIterator.hasNext()) {
                SelectionObject selectionObject = (SelectionObject)listIterator.next();
                selectionObject.setAccumulate(this.Accum && selectionObject.mayAccumulate());
            }
        }
        this.updateRanges();
        this.graphComponent.paintImmediately(this.graphComponent.getVisibleRect());
    }

    public void HelpItem_actionPerformed(ActionEvent actionEvent) {
        if (!HelpFrame.open) {
            HelpFrame helpFrame = new HelpFrame();
        } else {
            HelpFrame.instance.toFront();
            HelpFrame.instance.setState(0);
            HelpFrame.instance.setVisible(true);
        }
    }

    void LinearRegression_actionPerformed(ActionEvent actionEvent) {
        this.prodGraph();
    }

    void JulianDateView_actionPerformed(ActionEvent actionEvent) {
        this.updateTextView();
    }

    void StandardDateView_actionPerformed(ActionEvent actionEvent) {
        this.updateTextView();
    }

    void PrintItem_actionPerformed(ActionEvent actionEvent) {
        class PrintThread
        extends Thread {
            PrinterJob pj;
            GraphFrame grfr;

            PrintThread(PrinterJob printerJob, GraphFrame graphFrame2) {
                this.pj = printerJob;
                this.grfr = graphFrame2;
            }

            public void run() {
                boolean bl = this.pj.printDialog();
                this.grfr.printResult(bl, this.pj);
            }
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.pf = printerJob.defaultPage();
        if (this.ViewAsTextItem.isSelected()) {
            printerJob.setPageable(this);
            PrintThread printThread = new PrintThread(printerJob, this);
            printThread.start();
        } else {
            this.pf.setOrientation(0);
            printerJob.setPrintable(this, this.pf);
            printerJob.setPageable(this);
            PrintThread printThread = new PrintThread(printerJob, this);
            printThread.start();
        }
    }

    public void printResult(boolean bl, PrinterJob printerJob) {
        if (bl) {
            try {
                printerJob.print();
                this.graphComponent.lock = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.ViewAsTextItem.isSelected()) {
            boolean bl = false;
            int n2 = this.TextTable.getRowCount() + 1;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.black);
            int n3 = graphics2D.getFontMetrics().getHeight();
            int n4 = graphics2D.getFontMetrics().getDescent();
            double d = pageFormat.getImageableHeight() - (double)n3;
            double d2 = pageFormat.getImageableWidth();
            double d3 = this.TextTable.getColumnModel().getTotalColumnWidth();
            double d4 = 1.0;
            if (d3 >= d2) {
                d4 = d2 / d3;
            }
            double d5 = (double)this.TextTable.getTableHeader().getHeight() * d4;
            double d6 = d3 * d4;
            double d7 = (double)this.TextTable.getRowHeight() * d4;
            int n5 = (int)((d - d5) / d7);
            double d8 = d7 * (double)n5;
            int n6 = (int)Math.ceil((double)this.TextTable.getRowCount() / (double)n5);
            if (n >= n6) {
                return 1;
            }
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics2D.drawString("Page: " + (n + 1), (int)d2 / 2 - 35, (int)(d + (double)n3 - (double)n4));
            graphics2D.translate(0.0, d5);
            graphics2D.translate(5.0, (double)(-n) * d8);
            if (n + 1 == n6) {
                int n7 = n5 * n;
                int n8 = this.TextTable.getRowCount() - n7;
                graphics2D.setClip(-5, (int)(d8 * (double)n), (int)Math.ceil(d6) + 5, (int)Math.ceil(d7 * (double)n8));
            } else {
                graphics2D.setClip(0, (int)(d8 * (double)n), (int)Math.ceil(d6) + 5, (int)Math.ceil(d8));
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(1, 0, 1, (int)d8);
            }
            graphics2D.scale(d4, d4);
            this.TextTable.paint(graphics2D);
            graphics2D.scale(1.0 / d4, 1.0 / d4);
            graphics2D.translate(0.0, (double)n * d8);
            graphics2D.translate(0.0, -d5);
            graphics2D.setClip(0, 0, (int)Math.ceil(d6), (int)Math.ceil(d5));
            graphics2D.scale(d4, d4);
            this.TextTable.getTableHeader().paint(graphics2D);
        } else {
            int n9 = pageFormat.getOrientation();
            if (n9 == 0) {
                // empty if block
            }
            if (n9 == 1) {
                System.out.println("Portrait" + n9);
            }
            System.out.println(n);
            if (n > 0) {
                graphics.dispose();
                return 1;
            }
            this.printing = true;
            this.graphComponent.paint(graphics);
            this.printing = false;
            graphics.dispose();
        }
        return 0;
    }

    int paintText(Graphics graphics, int n) {
        return 0;
    }

    void GridItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("viewGrid", this, null));
        }
        this.prodGraph();
    }

    void DetachLegendItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("detachLegend", this, null));
        }
        this.prodGraph();
    }

    void setDetachLegend(boolean bl) {
        if (this.detachLegend() != bl) {
            this.DetachLegendItem.doClick();
        }
    }

    boolean detachLegend() {
        return this.DetachLegendItem.isSelected();
    }

    boolean showGrid() {
        return this.GridItem.isSelected();
    }

    void ColorItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("viewColor", this, null));
        }
        this.prodGraph();
    }

    boolean showColor() {
        return this.ColorItem.isSelected();
    }

    void DecorationItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("viewDecoration", this, null));
        }
        this.prodGraph();
    }

    boolean showDecoration() {
        return this.DecorationItem.isSelected();
    }

    protected void refreshSelf() {
        this.updateRanges();
    }

    void GraphFrame_windowClosing(WindowEvent windowEvent) {
        if (this.ptcd != null) {
            this.ptcd.deleteFromList(this);
        }
        allGraphFrames.remove(this);
    }

    void CloseItem_actionPerformed(ActionEvent actionEvent) {
        if (this.ptcd != null) {
            this.ptcd.deleteFromList(this);
        }
        allGraphFrames.remove(this);
        this.dispose();
    }

    void SaveAsItem_actionPerformed(ActionEvent actionEvent) {
        block9: {
            int n;
            if (this.saveFileDialog == null) {
                try {
                    this.saveFileDialog = new JFileChooser();
                    this.saveFileDialog.addChoosableFileFilter(this.saveFileDialog.getAcceptAllFileFilter());
                    SingleExtFileFilter singleExtFileFilter = new SingleExtFileFilter("gcf", "Graph Config Files (*.gcf)");
                    this.saveFileDialog.addChoosableFileFilter(singleExtFileFilter);
                    this.saveFileDialog.setDialogTitle("Save Graph Config As");
                    this.saveFileDialog.setFileFilter(singleExtFileFilter);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Perhaps you could adjust browser security", "File i/o failure", 1);
                    return;
                }
            }
            if ((n = this.saveFileDialog.showSaveDialog(this)) == 0) {
                String string = DartUtils.getProperPathname(this.saveFileDialog);
                FileOutputStream fileOutputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string);
                    objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeInt(2);
                    objectOutputStream.writeObject(this.graphComponent.xAxisLabel);
                    objectOutputStream.writeObject(this.graphComponent.mainLabel);
                    for (int i = 0; i < 4; ++i) {
                        objectOutputStream.writeObject(this.yToolBar(i).axisLabel());
                        objectOutputStream.writeObject(this.soList[i]);
                        this.yToolBar[i].writeObject(objectOutputStream);
                        objectOutputStream.writeBoolean(this.showYAxis[i]);
                    }
                    this.xToolBar.writeObject(objectOutputStream);
                    objectOutputStream.writeBoolean(this.GridItem.isSelected());
                    objectOutputStream.writeBoolean(this.ColorItem.isSelected());
                    objectOutputStream.writeBoolean(this.DecorationItem.isSelected());
                    objectOutputStream.writeBoolean(this.OverPlotItem.isSelected());
                    objectOutputStream.writeBoolean(this.ViewAsTextItem.isSelected());
                    objectOutputStream.writeBoolean(this.NoDataSpaceItem.isSelected());
                    objectOutputStream.writeBoolean(this.NoDataNAItem.isSelected());
                    objectOutputStream.writeBoolean(false);
                    objectOutputStream.writeBoolean(this.XYPlotItem.isSelected());
                    objectOutputStream.writeBoolean(this.HistogramItem.isSelected());
                    objectOutputStream.writeBoolean(this.HistWeeklyItem.isSelected());
                    objectOutputStream.writeBoolean(this.HistMonthlyItem.isSelected());
                    objectOutputStream.writeBoolean(this.HistYearlyItem.isSelected());
                    objectOutputStream.writeBoolean(this.HistSideBySideItem.isSelected());
                    objectOutputStream.writeBoolean(this.HistOverlapItem.isSelected());
                    objectOutputStream.writeObject(this.currSelection);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    this.favObOb.setAndNotify(this);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, string, "File save failed", 0);
                    if (objectOutputStream == null) break block9;
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void SaveDataAsItem_actionPerformed(ActionEvent actionEvent) {
        block13: {
            int n;
            if (this.saveDataFileDialog == null) {
                try {
                    this.saveDataFileDialog = new JFileChooser();
                    this.saveDataFileDialog.addChoosableFileFilter(this.saveDataFileDialog.getAcceptAllFileFilter());
                    SingleExtFileFilter singleExtFileFilter = new SingleExtFileFilter("txt", "Graph Data Files (*.txt)");
                    this.saveDataFileDialog.addChoosableFileFilter(singleExtFileFilter);
                    this.saveDataFileDialog.setDialogTitle("Save Graph Data As");
                    this.saveDataFileDialog.setFileFilter(singleExtFileFilter);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Perhaps you could adjust browser security", "File i/o failure", 1);
                    return;
                }
            }
            if ((n = this.saveDataFileDialog.showSaveDialog(this)) == 0) {
                String string = DartUtils.getProperPathname(this.saveDataFileDialog);
                FileOutputStream fileOutputStream = null;
                PrintStream printStream = null;
                try {
                    int n2;
                    int n3;
                    fileOutputStream = new FileOutputStream(string);
                    printStream = new PrintStream(fileOutputStream);
                    this.updateTextView();
                    int n4 = 0;
                    for (n3 = 0; n3 < 4; ++n3) {
                        if (!this.showYAxis[n3]) continue;
                        n4 += this.soList[n3].size();
                    }
                    n3 = 1;
                    if (this.JulianDateView.isSelected()) {
                        ++n3;
                    }
                    boolean[] blArray = new boolean[n4 += n3];
                    for (int i = 0; i < blArray.length; ++i) {
                        blArray[i] = true;
                    }
                    String string2 = this.getDataString(blArray);
                    int n5 = string2.length();
                    int n6 = 0;
                    String string3 = "";
                    for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
                        string3 = string3 + this.tableModel.getColumnName(i) + "\t";
                    }
                    printStream.println(string3);
                    while (n6 < n5 && (n2 = string2.indexOf(10, n6)) >= 0) {
                        printStream.println(string2.substring(n6, n2));
                        n6 = n2 + 1;
                    }
                    printStream.flush();
                    printStream.close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, string, "File save failed", 0);
                    if (printStream == null) break block13;
                    try {
                        printStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void OpenItem_actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object;
        if (this.openFileDialog == null) {
            try {
                this.openFileDialog = new JFileChooser();
                this.openFileDialog.addChoosableFileFilter(this.openFileDialog.getAcceptAllFileFilter());
                SingleExtFileFilter singleExtFileFilter = new SingleExtFileFilter("gcf", "Graph Config Files (*.gcf)");
                this.openFileDialog.addChoosableFileFilter(singleExtFileFilter);
                this.openFileDialog.setDialogTitle("Open Graph Config");
                object = new File(System.getProperty("user.dir"));
                this.openFileDialog.setCurrentDirectory((File)object);
                this.openFileDialog.setFileFilter(singleExtFileFilter);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Perhaps you could adjust browser security", "File i/o failure", 1);
                return;
            }
        }
        if ((n = this.openFileDialog.showOpenDialog(this)) == 0) {
            object = DartUtils.getProperPathname(this.openFileDialog);
            this.readSelfFrom((String)object, this.tcdArr, false);
        }
    }

    public void readSelfFrom(String string, ThreeColumnDialog[] threeColumnDialogArray, boolean bl) {
        block14: {
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                objectInputStream = new ObjectInputStream(fileInputStream);
                int n = objectInputStream.readInt();
                if (n != 2) {
                    JOptionPane.showMessageDialog(this, "Incompatible File Version: " + n, "File version incompatible", 1);
                    objectInputStream.close();
                    return;
                }
                this.graphComponent.xAxisLabel = (String)objectInputStream.readObject();
                this.graphComponent.mainLabel = (String)objectInputStream.readObject();
                this.setTitle(this.graphComponent.mainLabel);
                for (int i = 0; i < 4; ++i) {
                    this.yToolBar[i].setAxisLabel((String)objectInputStream.readObject());
                    this.soList[i] = (LinkedList)objectInputStream.readObject();
                    this.yToolBar[i].readObject(objectInputStream);
                    this.showYAxis[i] = objectInputStream.readBoolean();
                }
                this.xToolBar.readObject(objectInputStream);
                int n2 = this.xToolBar.xMin();
                int n3 = this.xToolBar.xMax();
                this.GridItem.setSelected(objectInputStream.readBoolean());
                this.ColorItem.setSelected(objectInputStream.readBoolean());
                this.DecorationItem.setSelected(objectInputStream.readBoolean());
                this.OverPlotItem.setSelected(objectInputStream.readBoolean());
                this.ViewAsTextItem.setSelected(objectInputStream.readBoolean());
                this.NoDataSpaceItem.setSelected(objectInputStream.readBoolean());
                this.NoDataNAItem.setSelected(objectInputStream.readBoolean());
                objectInputStream.readBoolean();
                this.setXYPlot(objectInputStream.readBoolean());
                this.firstXYPlot = false;
                this.HistogramItem.setSelected(objectInputStream.readBoolean());
                this.HistWeeklyItem.setSelected(objectInputStream.readBoolean());
                this.HistMonthlyItem.setSelected(objectInputStream.readBoolean());
                this.HistYearlyItem.setSelected(objectInputStream.readBoolean());
                this.HistSideBySideItem.setSelected(objectInputStream.readBoolean());
                this.HistOverlapItem.setSelected(objectInputStream.readBoolean());
                this.currSelection = (SelectionParams)objectInputStream.readObject();
                if (!bl) {
                    if (this.ptcd != threeColumnDialogArray[this.currSelection.graphType]) {
                        this.ptcd.deleteGraph(this);
                        this.ptcd = threeColumnDialogArray[this.currSelection.graphType];
                        this.ptcd.addGraph(this);
                    }
                } else {
                    this.ptcd = threeColumnDialogArray[this.currSelection.graphType];
                    this.ptcd.addGraph(this);
                }
                this.readAllData();
                this.xToolBar.setXMinMax(n2, n3);
                this.xToolBar.setOverplot(this.OverPlotItem.isSelected());
                this.updateTextView();
                this.XYPlotItem_actionPerformed(null);
                if (this.ptcd.Graphs.getSelectedValue() == this) {
                    this.ptcd.UpdateListSelections(this.currSelection);
                }
                this.ptcd.updateNames(this);
                objectInputStream.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, string + "  " + iOException, "File read failed", 0);
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                JOptionPane.showMessageDialog(this, string + "  " + classNotFoundException, "Object not created from file", 0);
                if (objectInputStream == null) break block14;
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void filtersUpdated() {
        this.updateRanges();
        this.updateTextView();
    }

    void readAllData() {
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        block0: for (int i = 0; i < 4; ++i) {
            ListIterator listIterator = this.soList[i].listIterator(0);
            while (listIterator.hasNext()) {
                SelectionObject selectionObject = (SelectionObject)listIterator.next();
                selectionObject.readFromServer(this);
                if (selectionObject.getDC() != null) continue;
                break block0;
            }
        }
        this.updateRanges();
        this.setCursor(cursor);
    }

    void EditLabelsItem_actionPerformed(ActionEvent actionEvent) {
        GraphLabelDialog graphLabelDialog = new GraphLabelDialog(this, this.graphComponent, this.XYPlotItem.isSelected());
        if (graphLabelDialog.succeeded()) {
            this.setTitle(this.graphComponent.mainLabel);
            if (this.xyPlotFrame != null) {
                this.xyPlotFrame.updateTitle();
            }
            this.prodGraph();
        }
    }

    void OverPlotItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("overplot", this, null));
        }
        class MyRunnable
        implements Runnable {
            GraphFrame grfr;

            MyRunnable(GraphFrame graphFrame2) {
                this.grfr = graphFrame2;
            }

            public void run() {
                this.grfr.graphComponent.lock = true;
                this.grfr.OverPlotItem_thread();
                this.grfr.graphComponent.lock = false;
                this.grfr.prodGraph();
            }
        }
        MyRunnable myRunnable = new MyRunnable(this);
        new Thread(myRunnable).start();
    }

    void OverPlotItem_thread() {
        Object object;
        Object object2;
        LinkedList<Object> linkedList;
        ListIterator listIterator;
        int n;
        this.xToolBar.setOverplot(this.OverPlotItem.isSelected());
        int n2 = 15;
        int n3 = GraphDecoration.decorationList().size();
        int n4 = 0;
        int n5 = 0;
        Color[] colorArray = new Color[]{Color.black, Color.blue, Color.green, Color.red, Color.gray, Color.magenta, Color.cyan, new Color(255, 102, 51), new Color(102, 51, 0), new Color(0, 102, 51), new Color(153, 0, 51), new Color(255, 204, 51), new Color(0, 0, 153), new Color(102, 0, 153), new Color(51, 153, 153)};
        this.reCalculating = true;
        if (this.OverPlotItem.isSelected()) {
            for (n = 0; n < 4; ++n) {
                listIterator = this.soList[n].listIterator(0);
                linkedList = new LinkedList();
                while (listIterator.hasNext()) {
                    String string;
                    object2 = (SelectionObject)listIterator.next();
                    while (((SelectionObject)object2).minYear() < ((SelectionObject)object2).maxYear()) {
                        object = ((SelectionObject)object2).copy();
                        ((SelectionObject)object).setMinYear(((SelectionObject)object2).maxYear());
                        ((SelectionObject)object).setMaxYear(((SelectionObject)object2).maxYear());
                        ((SelectionObject)object).setColor(colorArray[n4]);
                        if (n5 == 0) {
                            ((SelectionObject)object).setDecoration(null);
                        } else {
                            ((SelectionObject)object).setDecoration((GraphDecoration)GraphDecoration.decorationList().get(n5 - 1));
                        }
                        if (++n4 >= n2) {
                            n4 = 0;
                            if (++n5 > n3) {
                                n5 = 0;
                            }
                        }
                        string = ((SelectionObject)object).nameStr();
                        string = string.split(",")[0];
                        String string2 = ((SelectionObject)object).abbrevNameStr();
                        string2 = string2.split(",")[0];
                        ((SelectionObject)object).setNameStr(string);
                        ((SelectionObject)object).setAbbrevNameStr(string2);
                        string2 = SelectionObject.defaultAbbrevName((SelectionObject)object, ((SelectionObject)object).getFeature(), ((SelectionObject)object).minYear(), ((SelectionObject)object).maxYear(), ((SelectionObject)object).accumulate());
                        string = SelectionObject.defaultName((SelectionObject)object, ((SelectionObject)object).getFeature(), ((SelectionObject)object).minYear(), ((SelectionObject)object).maxYear(), ((SelectionObject)object).accumulate());
                        ((SelectionObject)object).setNameStr(string);
                        ((SelectionObject)object).setAbbrevNameStr(string2);
                        linkedList.add(object);
                        ((SelectionObject)object2).setMaxYear(((SelectionObject)object2).maxYear() - 1);
                    }
                    ((SelectionObject)object2).setColor(colorArray[n4]);
                    if (n5 == 0) {
                        ((SelectionObject)object2).setDecoration(null);
                    } else {
                        ((SelectionObject)object2).setDecoration((GraphDecoration)GraphDecoration.decorationList().get(n5 - 1));
                    }
                    if (++n4 >= n2) {
                        n4 = 0;
                        if (++n5 > n3) {
                            n5 = 0;
                        }
                    }
                    object = ((SelectionObject)object2).nameStr();
                    object = ((String)object).split(",")[0];
                    string = ((SelectionObject)object2).abbrevNameStr();
                    string = string.split(",")[0];
                    ((SelectionObject)object2).setNameStr((String)object);
                    ((SelectionObject)object2).setAbbrevNameStr(string);
                    string = SelectionObject.defaultAbbrevName((SelectionObject)object2, ((SelectionObject)object2).getFeature(), ((SelectionObject)object2).minYear(), ((SelectionObject)object2).maxYear(), ((SelectionObject)object2).accumulate());
                    object = SelectionObject.defaultName((SelectionObject)object2, ((SelectionObject)object2).getFeature(), ((SelectionObject)object2).minYear(), ((SelectionObject)object2).maxYear(), ((SelectionObject)object2).accumulate());
                    ((SelectionObject)object2).setNameStr((String)object);
                    ((SelectionObject)object2).setAbbrevNameStr(string);
                    linkedList.add(object2);
                }
                this.soList[n] = linkedList;
            }
        } else {
            for (n = 0; n < 4; ++n) {
                linkedList = new LinkedList<Object>();
                object2 = null;
                object = null;
                while (!this.soList[n].isEmpty()) {
                    object2 = (SelectionObject)this.soList[n].removeFirst();
                    listIterator = this.soList[n].listIterator(0);
                    int n6 = this.soList[n].size();
                    int n7 = 0;
                    while (n7 < n6) {
                        object = (SelectionObject)this.soList[n].get(n7);
                        if (((SelectionObject)object2).getFeature() == ((SelectionObject)object).getFeature() && ((SelectionObject)object2).typeString() == ((SelectionObject)object).typeString() && (((SelectionObject)object2).minYear - 1 == ((SelectionObject)object).maxYear() || ((SelectionObject)object2).maxYear + 1 == ((SelectionObject)object).minYear())) {
                            if (((SelectionObject)object2).maxYear + 1 == ((SelectionObject)object).minYear()) {
                                ((SelectionObject)object2).setMaxYear(((SelectionObject)object2).maxYear() + 1);
                            } else {
                                ((SelectionObject)object2).setMinYear(((SelectionObject)object2).minYear() - 1);
                            }
                            this.soList[n].remove(object);
                            --n6;
                            continue;
                        }
                        ++n7;
                    }
                    if (object2 == null) continue;
                    String string = ((SelectionObject)object2).nameStr();
                    string = string.split(",")[0];
                    String string3 = ((SelectionObject)object2).abbrevNameStr();
                    string3 = string3.split(",")[0];
                    ((SelectionObject)object2).setNameStr(string);
                    ((SelectionObject)object2).setAbbrevNameStr(string3);
                    string3 = SelectionObject.defaultAbbrevName((SelectionObject)object2, ((SelectionObject)object2).getFeature(), ((SelectionObject)object2).minYear(), ((SelectionObject)object2).maxYear(), ((SelectionObject)object2).accumulate());
                    string = SelectionObject.defaultName((SelectionObject)object2, ((SelectionObject)object2).getFeature(), ((SelectionObject)object2).minYear(), ((SelectionObject)object2).maxYear(), ((SelectionObject)object2).accumulate());
                    ((SelectionObject)object2).setNameStr(string);
                    ((SelectionObject)object2).setAbbrevNameStr(string3);
                    ((SelectionObject)object2).setColor(colorArray[n4]);
                    if (n5 == 0) {
                        ((SelectionObject)object2).setDecoration(null);
                    } else {
                        ((SelectionObject)object2).setDecoration((GraphDecoration)GraphDecoration.decorationList().get(n5 - 1));
                    }
                    if (++n4 >= n2) {
                        n4 = 0;
                        if (++n5 > n3) {
                            n5 = 0;
                        }
                    }
                    linkedList.add(object2);
                    object2 = null;
                }
                this.soList[n] = linkedList;
            }
        }
        this.updateYourself();
        this.updateRanges();
        this.xToolBar().setXMinMax(0, 100000000);
        if (this.ViewAsTextItem.isSelected()) {
            this.updateTextView();
        }
        this.reCalculating = false;
        String string = "#" + Integer.toString(this.uniqueId) + " ";
        object2 = "";
        for (int i = 0; i < 4; ++i) {
            object = this.soList(i);
            if (i > 0) {
                object2 = " /  ";
            }
            if (object == null) continue;
            for (int j = 0; j < ((LinkedList)object).size(); ++j) {
                if (j > 0) {
                    object2 = " & ";
                }
                object2 = (String)object2 + ((SelectionObject)((LinkedList)object).get(j)).nameStr();
                string = string + (String)object2;
                object2 = "";
            }
        }
        this.graphName = string;
        GraphListModel graphListModel = (GraphListModel)this.ptcd.Graphs.getModel();
        graphListModel.changedElement(this);
        this.ptcd.GraphsPane.repaint();
    }

    void ViewAsTextItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("viewAsText", this, null));
        }
        this.XYPlotItem.setEnabled(!this.ViewAsTextItem.isSelected());
        this.SelectAllItem.setEnabled(this.ViewAsTextItem.isSelected());
        this.TextTable.grabFocus();
        this.updateTextView();
        this.componentResized(null);
        JTableHeader jTableHeader = this.TextTable.getTableHeader();
        ColumnHeaderListener columnHeaderListener = new ColumnHeaderListener();
        jTableHeader.addMouseMotionListener(columnHeaderListener);
        jTableHeader.addMouseListener(columnHeaderListener);
    }

    String justifyText(String string, boolean bl) {
        this.privBuf.setLength(0);
        int n = string.length();
        if (bl) {
            if (n > 23) {
                this.privBuf.append(string.substring(0, 23));
            } else if (n < 12) {
                this.privBuf.append(string);
                this.privBuf.append("\t");
            } else {
                this.privBuf.append(string);
            }
            this.privBuf.append("\t");
        } else {
            if (n > 11) {
                this.privBuf.append(string.substring(0, 11));
            } else {
                this.privBuf.append(string);
            }
            this.privBuf.append("\t");
        }
        return this.privBuf.toString();
    }

    String justifyText(double d, boolean bl) {
        return this.justifyText(Double.toString(d), bl);
    }

    String justifyText(float f, boolean bl) {
        return this.justifyText(Float.toString(f), bl);
    }

    void updateTextView() {
        if (this.TextTable != null) {
            Vector vector = this.getDataVect();
            Vector vector2 = (Vector)vector.remove(0);
            Vector vector3 = (Vector)vector.remove(0);
            this.TextTable.setVisible(false);
            this.tableModel.setDataVector(vector3, vector2);
            if (!this.ViewAsTextItem.isSelected()) {
                return;
            }
            this.TextTable.setVisible(true);
        }
    }

    Vector getDataVect() {
        SelectionObject selectionObject;
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!this.HistogramItem.isSelected()) {
            bl = true;
        } else if (this.HistWeeklyItem.isSelected()) {
            bl2 = true;
        } else if (this.HistMonthlyItem.isSelected()) {
            bl3 = true;
        } else {
            bl4 = true;
        }
        bl5 = this.OverPlotItem.isSelected();
        for (n = 0; n < 4; ++n) {
            if (!this.showYAxis[n]) continue;
            n2 += this.soList[n].size();
        }
        SelectionObject[] selectionObjectArray = new SelectionObject[n2];
        YAxisToolBar[] yAxisToolBarArray = new YAxisToolBar[n2];
        StringBuffer stringBuffer = new StringBuffer(50000);
        int n3 = this.xToolBar.minYear();
        n2 = 0;
        int n4 = this.xToolBar.xMax();
        for (n = 0; n < 4; ++n) {
            if (!this.showYAxis[n]) continue;
            ListIterator listIterator = this.soList[n].listIterator(0);
            while (listIterator.hasNext()) {
                selectionObject = (SelectionObject)listIterator.next();
                yAxisToolBarArray[n2] = this.yToolBar[n];
                selectionObjectArray[n2++] = selectionObject;
                selectionObject.applyDataFilter();
                selectionObject.indOff = bl5 ? 1 : 1 + (selectionObject.minYear() - n3) * 366;
                selectionObject.sum = 0.0;
            }
        }
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        if (this.JulianDateView.isSelected()) {
            vector2.add("Year");
        }
        vector2.add("Date");
        for (n = 0; n < n2; ++n) {
            vector2.add(selectionObjectArray[n].abbrevNameStr());
        }
        vector.add(vector2);
        Vector vector3 = new Vector();
        Vector<String> vector4 = new Vector<String>();
        int n5 = this.xToolBar.xMin();
        int n6 = (n5 - 1) / 366 + n3;
        int n7 = this.xToolBar.getWeek(1 + (n5 - 1) % 366, n6);
        int n8 = this.xToolBar.getMonth(1 + (n5 - 1) % 366);
        boolean bl6 = false;
        boolean bl7 = true;
        while (!bl6) {
            if (bl7) {
                int n9 = n5;
                for (n = 0; n < n2; ++n) {
                    selectionObject = selectionObjectArray[n];
                    if (!selectionObject.accumulate()) {
                        selectionObject.sum = 0.0;
                    }
                    selectionObject.ndays = 0;
                }
                bl7 = false;
            }
            for (n = 0; n < n2; ++n) {
                selectionObject = selectionObjectArray[n];
                int n10 = n5 - selectionObject.indOff;
                if (n10 < 0 || n10 >= selectionObject.length() || !selectionObject.yValExists(n10)) continue;
                selectionObject.sum += (double)selectionObject.yVal(n10);
                ++selectionObject.ndays;
            }
            if (bl || n5 == n4 || bl4 && n5 % 366 == 0 || bl3 && 1 + (n5 - 1) % 366 == this.xToolBar.monthEnds(n8) || bl2 && 1 + (n5 - 1) % 366 == this.xToolBar.weekEnds(n7, n6)) {
                if (this.JulianDateView.isSelected()) {
                    vector4.add(this.justifyText(Integer.toString(n6), false));
                }
                vector4.add(this.justifyText(this.xToolBar.xDate(n5, true), false));
                for (int i = 0; i < n2; ++i) {
                    selectionObject = selectionObjectArray[i];
                    if (selectionObject.ndays > 0) {
                        if (selectionObject.histAverage() && !selectionObject.accumulate()) {
                            selectionObject.sum /= (double)selectionObject.ndays;
                        }
                        vector4.add(this.justifyText(yAxisToolBarArray[i].formatValue(selectionObject.sum), false));
                        continue;
                    }
                    if (this.NoDataSpaceItem.isSelected()) {
                        vector4.add(this.justifyText(" ", false));
                        continue;
                    }
                    vector4.add(this.justifyText("NA", false));
                }
                vector3.add(vector4);
                vector4 = new Vector();
                bl7 = true;
                if (bl2) {
                    ++n7;
                }
                if (bl3) {
                    ++n8;
                }
            }
            if (bl2 && n7 == 53) {
                while (n5 % 366 != 0) {
                    ++n5;
                }
            }
            if (++n5 > n4) {
                bl6 = true;
                continue;
            }
            if (n5 % 366 != 1) continue;
            ++n6;
            n8 = 1;
            n7 = 1;
            bl7 = true;
        }
        vector.add(vector3);
        return vector;
    }

    String getDataString(boolean[] blArray) {
        SelectionObject selectionObject;
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!this.HistogramItem.isSelected()) {
            bl = true;
        } else if (this.HistWeeklyItem.isSelected()) {
            bl2 = true;
        } else if (this.HistMonthlyItem.isSelected()) {
            bl3 = true;
        } else {
            bl4 = true;
        }
        bl5 = this.OverPlotItem.isSelected();
        for (n = 0; n < 4; ++n) {
            if (!this.showYAxis[n]) continue;
            n2 += this.soList[n].size();
        }
        SelectionObject[] selectionObjectArray = new SelectionObject[n2];
        YAxisToolBar[] yAxisToolBarArray = new YAxisToolBar[n2];
        StringBuffer stringBuffer = new StringBuffer(50000);
        int n3 = this.xToolBar.minYear();
        n2 = 0;
        int n4 = this.xToolBar.xMax();
        for (n = 0; n < 4; ++n) {
            if (!this.showYAxis[n]) continue;
            ListIterator listIterator = this.soList[n].listIterator(0);
            while (listIterator.hasNext()) {
                selectionObject = (SelectionObject)listIterator.next();
                yAxisToolBarArray[n2] = this.yToolBar[n];
                selectionObjectArray[n2++] = selectionObject;
                selectionObject.applyDataFilter();
                selectionObject.indOff = bl5 ? 1 : 1 + (selectionObject.minYear() - n3) * 366;
                selectionObject.sum = 0.0;
            }
        }
        int n5 = 2;
        if (!this.JulianDateView.isSelected()) {
            --n5;
        }
        int n6 = this.xToolBar.xMin();
        int n7 = (n6 - 1) / 366 + n3;
        int n8 = this.xToolBar.getWeek(1 + (n6 - 1) % 366, n7);
        int n9 = this.xToolBar.getMonth(1 + (n6 - 1) % 366);
        boolean bl6 = false;
        boolean bl7 = true;
        while (!bl6) {
            if (bl7) {
                int n10 = n6;
                for (n = 0; n < n2; ++n) {
                    selectionObject = selectionObjectArray[n];
                    if (!selectionObject.accumulate()) {
                        selectionObject.sum = 0.0;
                    }
                    selectionObject.ndays = 0;
                }
                bl7 = false;
            }
            for (n = 0; n < n2; ++n) {
                selectionObject = selectionObjectArray[n];
                int n11 = n6 - selectionObject.indOff;
                if (n11 < 0 || n11 >= selectionObject.length() || !selectionObject.yValExists(n11)) continue;
                selectionObject.sum += (double)selectionObject.yVal(n11);
                ++selectionObject.ndays;
            }
            if (bl || n6 == n4 || bl4 && n6 % 366 == 0 || bl3 && 1 + (n6 - 1) % 366 == this.xToolBar.monthEnds(n9) || bl2 && 1 + (n6 - 1) % 366 == this.xToolBar.weekEnds(n8, n7)) {
                if (this.JulianDateView.isSelected()) {
                    System.out.println("Adding year and day");
                    stringBuffer.append(this.justifyText(Integer.toString(n7), false));
                    int n12 = n6 % 367;
                    stringBuffer.append(this.justifyText(Integer.toString(n12), false));
                } else {
                    System.out.println("Adding standard dates");
                    stringBuffer.append(this.justifyText(this.xToolBar.xDate(n6, true), false));
                }
                for (int i = 0; i < n2; ++i) {
                    selectionObject = selectionObjectArray[i];
                    if (selectionObject.ndays > 0) {
                        if (selectionObject.histAverage() && !selectionObject.accumulate()) {
                            selectionObject.sum /= (double)selectionObject.ndays;
                        }
                        if (!blArray[i + n5]) continue;
                        stringBuffer.append(this.justifyText(yAxisToolBarArray[i].formatValue(selectionObject.sum), false));
                        continue;
                    }
                    if (!blArray[i + n5]) continue;
                    if (this.NoDataSpaceItem.isSelected()) {
                        stringBuffer.append(this.justifyText(" ", false));
                        continue;
                    }
                    stringBuffer.append(this.justifyText("NA", false));
                }
                stringBuffer.append("\n");
                bl7 = true;
                if (bl2) {
                    ++n8;
                }
                if (bl3) {
                    ++n9;
                }
            }
            if (bl2 && n8 == 53) {
                while (n6 % 366 != 0) {
                    ++n6;
                }
            }
            if (++n6 > n4) {
                bl6 = true;
                continue;
            }
            if (n6 % 366 != 1) continue;
            ++n7;
            n9 = 1;
            n8 = 1;
            bl7 = true;
        }
        return stringBuffer.toString();
    }

    void SelectAllItem_actionPerformed(ActionEvent actionEvent) {
        if (this.ViewAsTextItem.isSelected()) {
            this.TextTable.selectAll();
        }
    }

    public void copyComponent(JComponent jComponent) {
        CopyThread copyThread = new CopyThread(jComponent);
        copyThread.start();
    }

    void CopyItem_actionPerformed(ActionEvent actionEvent) {
        if (this.ViewAsTextItem.isSelected()) {
            int n;
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String string = "";
            int[] nArray = this.TextTable.getSelectedColumns();
            int n2 = 1;
            if (this.JulianDateView.isSelected()) {
                string = string + "Year\t";
                ++n2;
            }
            string = string + "Date\t";
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == 0 || nArray[n] == 1 && this.JulianDateView.isSelected()) continue;
                string = string + this.tableModel.getColumnName(nArray[n]) + "\t";
            }
            string = string + "\n";
            if (nArray.length < 1) {
                return;
            }
            n = 0;
            for (int i = 0; i < 4; ++i) {
                if (!this.showYAxis[i]) continue;
                n += this.soList[i].size();
            }
            boolean[] blArray = new boolean[n += n2];
            for (int i = 0; i < nArray.length; ++i) {
                blArray[nArray[i]] = true;
            }
            string = string + this.getDataString(blArray);
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        } else {
            this.copyComponent(this.graphComponent);
        }
    }

    void saveAsImage(ActionEvent actionEvent) {
        final SingleExtFileFilter singleExtFileFilter = new SingleExtFileFilter("jpg", "JPEG Image (*.jpg)");
        SingleExtFileFilter singleExtFileFilter2 = new SingleExtFileFilter("png", "PNG Image (*.png)");
        if (this.saveFileDialog == null) {
            try {
                this.saveFileDialog = new JFileChooser();
                this.saveFileDialog.addChoosableFileFilter(singleExtFileFilter);
                this.saveFileDialog.addChoosableFileFilter(singleExtFileFilter2);
                this.saveFileDialog.setDialogTitle("Save Graph Image As");
                this.saveFileDialog.setFileFilter(singleExtFileFilter);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Perhaps you could adjust browser security", "File i/o failure", 1);
                return;
            }
        }
        boolean bl = this.ViewAsTextItem.isSelected();
        this.ViewAsTextItem.setSelected(false);
        this.updateTextView();
        int n = this.saveFileDialog.showSaveDialog(this);
        if (n == 0) {
            String string = DartUtils.getProperPathname(this.saveFileDialog);
            final FileFilter fileFilter = this.saveFileDialog.getFileFilter();
            final File file = new File(string);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ImgThread
            extends Thread {
                boolean isViewingText;
                GraphFrame grfr;

                ImgThread(boolean bl, GraphFrame graphFrame2) {
                    this.isViewingText = bl;
                    this.grfr = graphFrame2;
                }

                @Override
                public void run() {
                    BufferedImage bufferedImage = (BufferedImage)GraphFrame.this.graphComponent.createImage(GraphFrame.this.graphComponent.getWidth(), GraphFrame.this.graphComponent.getHeight());
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    GraphFrame.this.graphComponent.paint(graphics2D);
                    try {
                        if (fileFilter == singleExtFileFilter) {
                            ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
                        } else {
                            ImageIO.write((RenderedImage)bufferedImage, "png", file);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.isViewingText) {
                        this.grfr.ViewAsTextItem.setSelected(true);
                    }
                    this.grfr.updateTextView();
                }
            }
            ImgThread imgThread = new ImgThread(bl, this);
            imgThread.start();
        }
        this.saveFileDialog = null;
    }

    void XYPlotItem_actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        if (actionEvent != null) {
            this.addEdit(new undoAction("xy-toggle", this, null));
        }
        if (this.XYPlotItem.isSelected() && this.firstXYPlot && this.firstXYPlot) {
            ListIterator listIterator;
            Object object;
            LinkedList[] linkedListArray;
            n2 = 0;
            int n3 = 0;
            TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
            for (n = 0; n < 4; ++n) {
                if (!this.showYAxis[n]) continue;
                ++n2;
                linkedListArray = this.soList(n).listIterator(0);
                while (linkedListArray.hasNext()) {
                    treeSet.add(((SelectionObject)linkedListArray.next()).typeString());
                    ++n3;
                }
            }
            int n4 = treeSet.size();
            if (n3 < n4 || n3 % 2 != 0 || n4 == 1 && n3 <= 1) {
                JOptionPane.showMessageDialog(this, "XY plots must have an even number of selections and at least as many selections as parameters.", "XY Plot Error", 1);
                this.XYPlotItem.setSelected(false);
                this.xToolBar.XYButton.setSelected(false);
                return;
            }
            if (n4 == 1 && n3 <= 4) {
                object = new LinkedList[4];
                int n5 = 0;
                for (n = 0; n < 4; ++n) {
                    object[n] = new LinkedList();
                }
                for (n = 0; n < 4; ++n) {
                    listIterator = this.soList[n].listIterator();
                    while (listIterator.hasNext()) {
                        ((LinkedList)object[n5]).add(listIterator.next());
                        this.showYAxis[n5] = true;
                        ++n5;
                    }
                }
                for (n = 0; n < 4; ++n) {
                    this.setSOList(n, (LinkedList)object[n]);
                }
            } else if (n2 < n4) {
                object = new TreeMap();
                linkedListArray = new LinkedList[4];
                for (n = 0; n < 4; ++n) {
                    if (n < n4) {
                        ((TreeMap)object).put(treeSet.first(), new Integer(n));
                        treeSet.remove(treeSet.first());
                        this.showYAxis[n] = true;
                    }
                    linkedListArray[n] = new LinkedList();
                }
                for (n = 0; n < 4; ++n) {
                    listIterator = this.soList[n].listIterator();
                    while (listIterator.hasNext()) {
                        SelectionObject selectionObject = (SelectionObject)listIterator.next();
                        linkedListArray[(Integer)((TreeMap)object).get(selectionObject.typeString())].add(selectionObject);
                    }
                }
                for (n = 0; n < 4; ++n) {
                    this.setSOList(n, linkedListArray[n]);
                }
            }
            this.firstXYPlot = false;
        }
        if (this.XYPlotItem.isSelected()) {
            if (this.showYAxis[0] != this.showYAxis[1] || this.showYAxis[2] != this.showYAxis[3]) {
                JOptionPane.showMessageDialog(this, "XY plots must have at least one pair of axes (left/bottom and/or right/top).", "XY Plot Error", 1);
                this.XYPlotItem.setSelected(false);
                this.xToolBar.XYButton.setSelected(false);
                return;
            }
            this.HistogramItem.setEnabled(false);
            this.HistogramOptionsMenu.setEnabled(false);
            if (this.xyPlotFrame == null) {
                this.xyPlotFrame = new XYPlotFrame(this);
            }
            this.xyPlotFrame.setVisible(true);
            this.ViewAsTextItem.setEnabled(false);
            this.yToolBar[1].setListenToY(false);
            this.yToolBar[3].setListenToY(false);
            this.xToolBar.setDaily();
            this.xToolBar.XYButton.setSelected(true);
            for (n = 0; n < 4; ++n) {
                if (!this.showYAxis[n]) continue;
                this.showYAxis[n ^ 1] = true;
                n2 = 0;
                if (n % 2 == 0) {
                    n2 = 1;
                }
                this.yToolBar[n].enableXYSwap(true, n2 != 0);
            }
        } else {
            this.HistogramItem.setEnabled(true);
            this.HistogramOptionsMenu.setEnabled(true);
            if (this.xyPlotFrame != null) {
                this.xyPlotFrame.setVisible(false);
            }
            this.xToolBar.XYButton.setSelected(false);
            this.ViewAsTextItem.setEnabled(true);
            this.yToolBar[1].setListenToY(true);
            this.yToolBar[3].setListenToY(true);
            this.HistogramItem_actionPerformed(null);
            for (n = 0; n < 4; ++n) {
                if (!this.showYAxis[n]) continue;
                n2 = 0;
                if (n % 2 == 0) {
                    n2 = 1;
                }
                this.yToolBar[n].enableXYSwap(false, n2 != 0);
            }
        }
        this.componentResized(null);
    }

    void updateNames() {
        this.ptcd.updateNames(this);
    }

    void HistogramItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("histogram", this, null));
        }
        if (this.HistogramItem.isSelected()) {
            this.XYPlotItem.setEnabled(false);
            this.xToolBar.XYButton.setEnabled(false);
        } else {
            this.XYPlotItem.setEnabled(true);
            this.xToolBar.XYButton.setEnabled(true);
        }
        if (this.HistogramItem.isSelected()) {
            if (this.HistWeeklyItem.isSelected()) {
                this.xToolBar.setWeekly();
            }
            if (this.HistMonthlyItem.isSelected()) {
                this.xToolBar.setMonthly();
            }
            if (this.HistYearlyItem.isSelected()) {
                this.xToolBar.setYearly();
            }
            this.updateRanges();
        } else {
            this.xToolBar.setDaily();
            if (actionEvent != null) {
                this.updateRanges();
            }
        }
        this.updateTextView();
    }

    void HistWeeklyItem_actionPerformed(ActionEvent actionEvent) {
        if (this.HistogramItem.isSelected()) {
            this.xToolBar.setWeekly();
            this.updateRanges();
            this.updateTextView();
        }
    }

    void HistMonthlyItem_actionPerformed(ActionEvent actionEvent) {
        if (this.HistogramItem.isSelected()) {
            this.xToolBar.setMonthly();
            this.updateRanges();
            this.updateTextView();
        }
    }

    void HistYearlyItem_actionPerformed(ActionEvent actionEvent) {
        if (this.HistogramItem.isSelected()) {
            this.xToolBar.setYearly();
            this.updateRanges();
            this.updateTextView();
        }
    }

    void HistSideBySideItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("sidebyside", this, null));
        }
        this.prodGraph();
    }

    void HistOverlapItem_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.addEdit(new undoAction("overlap", this, null));
        }
        this.prodGraph();
    }

    void AboutItem_actionPerformed(ActionEvent actionEvent) {
        DartUtils.centerWindow(new AboutBox(), this);
    }

    void NoDataSpaceItem_actionPerformed(ActionEvent actionEvent) {
        this.prodGraph();
    }

    void NoDataNAItem_actionPerformed(ActionEvent actionEvent) {
        this.prodGraph();
    }

    void SwapXYPlot(YAxisToolBar yAxisToolBar) {
        int n = yAxisToolBar == this.yToolBar[0] ? 0 : 1;
        this.xyPlotFrame.xyPlotComponent.setSwapped(n, !this.xyPlotFrame.xyPlotComponent.getSwapped(n));
        this.xyPlotFrame.xyPlotComponent.repaint();
    }

    public void addEdit(UndoableEdit undoableEdit) {
        if (!this.UndoItem.isEnabled()) {
            this.UndoItem.setEnabled(true);
        }
        if (this.RedoItem.isEnabled()) {
            this.RedoItem.setEnabled(false);
        }
        this.undoMgr.addEdit(undoableEdit);
    }

    public int getNumberOfPages() {
        if (!this.ViewAsTextItem.isSelected()) {
            return 1;
        }
        PageFormat pageFormat = this.getPageFormat(0);
        PageFormat pageFormat2 = this.getPageFormat(0);
        Font font = new Font("Dialog", 0, 12);
        LineMetrics lineMetrics = font.getLineMetrics("1234567890", new FontRenderContext(new AffineTransform(), false, false));
        double d = lineMetrics.getHeight();
        double d2 = pageFormat.getImageableHeight() - d;
        double d3 = pageFormat2.getImageableWidth();
        double d4 = this.TextTable.getColumnModel().getTotalColumnWidth();
        double d5 = 1.0;
        if (d4 >= d3) {
            d5 = d3 / d4;
        }
        double d6 = (double)this.TextTable.getTableHeader().getHeight() * d5;
        double d7 = (double)(this.TextTable.getRowHeight() + this.TextTable.getRowMargin()) * d5;
        int n = (int)((d2 - d6) / d7);
        double d8 = d7 * (double)n;
        int n2 = (int)Math.ceil((double)this.TextTable.getRowCount() / (double)n);
        return n2;
    }

    public PageFormat getPageFormat(int n) {
        if (this.ViewAsTextItem.isSelected()) {
            return PrinterJob.getPrinterJob().defaultPage();
        }
        return this.pf;
    }

    public Printable getPrintable(int n) {
        return this;
    }

    private class CopyThread
    extends Thread {
        private JComponent comp;

        public CopyThread(JComponent jComponent) {
            this.comp = jComponent;
        }

        public void run() {
            final BufferedImage bufferedImage = (BufferedImage)this.comp.createImage(this.comp.getWidth(), this.comp.getHeight());
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.comp.paint(graphics2D);
            Transferable transferable = new Transferable(){

                public DataFlavor[] getTransferDataFlavors() {
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
                    return dataFlavorArray;
                }

                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return DataFlavor.imageFlavor.equals(dataFlavor);
                }

                public Object getTransferData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
                    if (!this.isDataFlavorSupported(dataFlavor)) {
                        throw new UnsupportedFlavorException(dataFlavor);
                    }
                    return bufferedImage;
                }
            };
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
        }
    }

    public class ColumnHeaderListener
    extends MouseInputAdapter {
        protected int startingColumn;

        public void mousePressed(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = mouseEvent;
            JTable jTable = ((JTableHeader)mouseEvent2.getSource()).getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent2.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (n == -1) {
                return;
            }
            Rectangle rectangle = jTable.getTableHeader().getHeaderRect(n);
            if (n == 0) {
                rectangle.width -= 3;
            } else {
                rectangle.grow(-3, 0);
            }
            if (!rectangle.contains(mouseEvent2.getX(), mouseEvent2.getY())) {
                int n3 = n;
                if (mouseEvent2.getX() < rectangle.x) {
                    --n3;
                }
            } else {
                this.startingColumn = n;
                boolean bl = jTable.isColumnSelected(n);
                jTable.clearSelection();
                jTable.addColumnSelectionInterval(this.startingColumn, n);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = mouseEvent;
            JTable jTable = ((JTableHeader)mouseEvent2.getSource()).getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent2.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (n == -1) {
                return;
            }
            Rectangle rectangle = jTable.getTableHeader().getHeaderRect(n);
            if (n == 0) {
                rectangle.width -= 3;
            } else {
                rectangle.grow(-3, 0);
            }
            if (!rectangle.contains(mouseEvent2.getX(), rectangle.y + 1)) {
                int n3 = n;
                if (mouseEvent2.getX() < rectangle.x) {
                    --n3;
                }
            } else {
                jTable.clearSelection();
                jTable.addColumnSelectionInterval(this.startingColumn, n);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == GraphFrame.this) {
                GraphFrame.this.GraphFrame_windowClosing(windowEvent);
            }
        }
    }

    class SymAction
    extends AbstractAction {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == GraphFrame.this.PrintItem) {
                GraphFrame.this.PrintItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.CloseItem) {
                GraphFrame.this.CloseItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.GridItem) {
                GraphFrame.this.GridItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.DetachLegendItem) {
                GraphFrame.this.DetachLegendItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.ColorItem) {
                GraphFrame.this.ColorItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.DecorationItem) {
                GraphFrame.this.DecorationItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.SaveAsItem) {
                GraphFrame.this.SaveAsItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.OpenItem) {
                GraphFrame.this.OpenItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.EditLabelsItem) {
                GraphFrame.this.EditLabelsItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.OverPlotItem) {
                GraphFrame.this.OverPlotItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.ViewAsTextItem) {
                GraphFrame.this.ViewAsTextItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.SelectAllItem) {
                GraphFrame.this.SelectAllItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.CopyItem) {
                GraphFrame.this.CopyItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.XYPlotItem) {
                GraphFrame.this.XYPlotItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.SaveDataAsItem) {
                GraphFrame.this.SaveDataAsItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistogramItem) {
                GraphFrame.this.HistogramItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistWeeklyItem) {
                GraphFrame.this.HistWeeklyItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistMonthlyItem) {
                GraphFrame.this.HistMonthlyItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistYearlyItem) {
                GraphFrame.this.HistYearlyItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistSideBySideItem) {
                GraphFrame.this.HistSideBySideItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistOverlapItem) {
                GraphFrame.this.HistOverlapItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.AboutItem) {
                GraphFrame.this.AboutItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.NoDataSpaceItem) {
                GraphFrame.this.NoDataSpaceItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.NoDataNAItem) {
                GraphFrame.this.NoDataNAItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HelpItem) {
                GraphFrame.this.HelpItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.TextTable) {
                GraphFrame.this.CopyItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.graphComponent) {
                GraphFrame.this.CopyItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.Accumulate) {
                GraphFrame.this.Accumulate_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.LinearRegression) {
                GraphFrame.this.LinearRegression_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.StandardDateView) {
                GraphFrame.this.StandardDateView_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.JulianDateView) {
                GraphFrame.this.JulianDateView_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.DataFilter) {
                GraphFrame.this.DataFilter_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistAverage) {
                GraphFrame.this.HistAverage_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.HistSum) {
                GraphFrame.this.HistSum_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.UndoItem) {
                GraphFrame.this.UndoItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.RedoItem) {
                GraphFrame.this.RedoItem_actionPerformed(actionEvent);
            } else if (object == GraphFrame.this.saveAsImage) {
                GraphFrame.this.saveAsImage(actionEvent);
            }
        }
    }

    protected class XYPlotFrame
    extends GraphViewFrame
    implements WindowListener {
        boolean detachLegend;
        protected GraphFrame graphFrame;
        protected GraphComponent xyPlotComponent;
        protected JMenuBar mb = new JMenuBar();
        protected JMenu EditMenu = new JMenu("Edit");
        protected JMenuItem CopyItem = new JMenuItem("Copy");

        public XYPlotFrame(GraphFrame graphFrame2) {
            this.graphFrame = graphFrame2;
            this.addWindowListener(this);
            this.xyPlotComponent = new GraphComponent(graphFrame2, this);
            this.updateTitle();
            this.xyPlotComponent.setDoXYPlot(true);
            this.getContentPane().add(this.xyPlotComponent);
            this.pack();
            XYPlotAction xYPlotAction = new XYPlotAction();
            this.setJMenuBar(this.mb);
            this.mb.add(this.EditMenu);
            this.CopyItem.setActionCommand("Copy");
            this.EditMenu.add(this.CopyItem);
            this.CopyItem.addActionListener(xYPlotAction);
            this.CopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            Object object = new Object();
            InputMap inputMap = this.xyPlotComponent.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), object);
            ActionMap actionMap = this.xyPlotComponent.getActionMap();
            actionMap.put(object, xYPlotAction);
            actionMap = this.xyPlotComponent.getActionMap();
            actionMap.put(object, xYPlotAction);
            URL uRL = this.getClass().getResource("jdXYLogo.png");
            GraphFrame.this.jdXYLogo = new ImageIcon(uRL);
            if (GraphFrame.this.jdXYLogo != null) {
                this.setIconImage(GraphFrame.this.jdXYLogo.getImage());
            }
            this.setSize(graphFrame2.getSize());
            this.setVisible(true);
        }

        public void CopyItem_actionPerformed(ActionEvent actionEvent) {
            this.graphFrame.copyComponent(this.xyPlotComponent);
        }

        public void updateTitle() {
            this.xyPlotComponent.mainLabel = this.graphFrame.graphComponent.mainLabel;
            this.setTitle("(XY Plot) " + this.graphFrame.getTitle());
        }

        public GraphComponent graphComponent() {
            return this.xyPlotComponent;
        }

        public void setDetachLegend(boolean bl) {
            if (bl != this.detachLegend) {
                this.detachLegend = bl;
                this.graphFrame.prodGraph();
            }
        }

        public boolean detachLegend() {
            return this.detachLegend;
        }

        public void prodGraph() {
            if (this.xyPlotComponent != null) {
                this.xyPlotComponent.repaintYourself();
            }
        }

        public GraphComponent xyPlotComponent() {
            return this.xyPlotComponent;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (this == windowEvent.getSource()) {
                this.graphFrame.setXYPlot(false);
                this.hide();
            }
        }

        class XYPlotAction
        extends AbstractAction {
            XYPlotAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == XYPlotFrame.this.CopyItem || object == XYPlotFrame.this.xyPlotComponent) {
                    XYPlotFrame.this.CopyItem_actionPerformed(actionEvent);
                }
            }
        }
    }
}

