/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HelpFrame
extends JFrame {
    public static HelpFrame instance = null;
    public static boolean open = false;
    public static final String helpLocation = "http://www.cbr.washington.edu/dart/javadart/Help/";
    JPanel helpPanel = null;
    DefaultMutableTreeNode Help;
    final DefaultTreeModel HelpModel;
    final JTree HelpTree;
    JSplitPane splitPane = new JSplitPane();
    JEditorPane editorPane = new JEditorPane();
    tsl selectionListener = new tsl();
    JScrollPane htmlPane = new JScrollPane();
    Enumeration modelEnum;
    private SymWindow wListener = new SymWindow();

    public HelpFrame() {
        super("javaDART  -  Help");
        this.setSize(820, 575);
        instance = this;
        open = true;
        this.setVisible(false);
        this.addWindowListener(this.wListener);
        this.editorPane.setEditable(false);
        this.htmlPane.getViewport().add(this.editorPane);
        this.editorPane.addHyperlinkListener(new Hyperactive());
        Object var2_1 = null;
        this.ApltHelpTree();
        this.HelpModel = new DefaultTreeModel(this.Help);
        this.HelpTree = new JTree(this.HelpModel);
        this.HelpTree.getSelectionModel().setSelectionMode(1);
        this.HelpTree.setPreferredSize(new Dimension(200, 500));
        this.editorPane.setPreferredSize(new Dimension(400, 500));
        this.splitPane.setLeftComponent(this.HelpTree);
        this.splitPane.setRightComponent(this.htmlPane);
        this.getContentPane().add(this.splitPane);
        this.splitPane.resetToPreferredSizes();
        this.HelpTree.addTreeSelectionListener(this.selectionListener);
        this.HelpTree.setSelectionInterval(0, 0);
        this.setVisible(true);
    }

    protected void ApltHelpTree() {
        InputStream inputStream = this.getClass().getResourceAsStream("helpList.txt");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            this.Help = new DefaultMutableTreeNode(string.substring(0, string.length() - 1).trim());
            this.recurseTree(bufferedReader, this.Help);
        }
        catch (Exception exception) {
            System.out.println("Exception reading help contents");
        }
    }

    protected void recurseTree(BufferedReader bufferedReader, DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            String string = bufferedReader.readLine();
            while (bufferedReader.ready() && string != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                if ((string = string.trim()).startsWith("/")) {
                    return;
                }
                if (string.endsWith("/")) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(string.substring(0, string.length() - 1).trim());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    this.recurseTree(bufferedReader, defaultMutableTreeNode2);
                } else {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(string.split("\\p{Punct}ht")[0].trim());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.out.println("Error in recurse tree" + exception);
        }
    }

    DefaultMutableTreeNode recurseDir(File file) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(file.getName());
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file + "/" + stringArray[i]);
            if (file2.isDirectory()) {
                defaultMutableTreeNode.add(this.recurseDir(file2));
                continue;
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(file2.getName()));
        }
        return defaultMutableTreeNode;
    }

    void HelpFrame_windowClosing(WindowEvent windowEvent) {
        open = false;
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                try {
                    URL uRL = hyperlinkEvent.getURL();
                    String string = uRL.getFile();
                    String[] stringArray = string.split("/");
                    string = stringArray[stringArray.length - 1];
                    string = string.substring(0, string.length() - 5);
                    TreePath treePath = null;
                    HelpFrame.this.modelEnum = HelpFrame.this.Help.breadthFirstEnumeration();
                    while (HelpFrame.this.modelEnum.hasMoreElements()) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)HelpFrame.this.modelEnum.nextElement();
                        if (!((String)defaultMutableTreeNode.getUserObject()).equals(string)) continue;
                        treePath = new TreePath(defaultMutableTreeNode.getPath());
                    }
                    if (treePath == null) {
                        System.out.println("Help system error");
                    } else {
                        HelpFrame.this.HelpTree.setSelectionPath(treePath);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            HelpFrame.this.HelpFrame_windowClosing(windowEvent);
        }
    }

    public class tsl
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!treeSelectionEvent.isAddedPath()) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
            URL uRL = this.getClass().getResource("helpList.txt");
            String string = HelpFrame.helpLocation + defaultMutableTreeNode.toString() + ".html";
            String string2 = string.replaceAll(" ", "%20");
            try {
                uRL = new URL(string2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            try {
                HelpFrame.this.editorPane.setPage(uRL);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }
}

