/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

public class PixelValueTransformer {
    protected double a = 0.0;
    protected double b = 0.0;
    protected int pixelStart;
    protected int pixelEnd;
    protected double minData;
    protected double maxData;
    protected boolean rounding;
    protected double viewMin;
    protected double viewMax;
    private double unroundedViewMin = 0.0;
    private double unroundedViewMax = 0.0;
    protected boolean rounded = false;
    private int spanExp;
    private int spanIndex;
    private static int[] spans = new int[]{5, 6, 8, 10, 15, 20, 25, 30, 40};
    private static int[] dividers = new int[]{4, 5, 3, 3, 5, 3, 4, 5, 3};

    public int pixelStart() {
        return this.pixelStart;
    }

    public int pixelEnd() {
        return this.pixelEnd;
    }

    public PixelValueTransformer(boolean bl) {
        this.rounding = bl;
    }

    boolean rounding() {
        return this.rounding;
    }

    void setRounding(boolean bl) {
        this.rounding = bl;
    }

    public double a() {
        return this.a;
    }

    public double b() {
        return this.b;
    }

    double minData() {
        return this.minData;
    }

    double maxData() {
        return this.maxData;
    }

    void zoomIn() {
        double d = (this.viewMax - this.viewMin) / 4.0;
        this.setViewMinMax(this.viewMin + d, this.viewMax - d);
    }

    void zoomOut() {
        double d = (this.viewMax - this.viewMin) / 4.0;
        this.setViewMinMax(this.viewMin - d, this.viewMax + d);
    }

    double viewMin() {
        return this.viewMin;
    }

    double viewMax() {
        return this.viewMax;
    }

    void setViewMinMax(double d, double d2) {
        this.viewMin = d;
        this.viewMax = d2;
        this.newViewMinMaxValues();
        this.updateAB();
    }

    protected void newViewMinMaxValues() {
        if (this.rounding) {
            this.doRounding();
        }
    }

    boolean setDataRange(double d, double d2) {
        if (this.minData != d || this.maxData != d2) {
            this.minData = d;
            this.maxData = d2;
            return true;
        }
        return false;
    }

    boolean setPixelRange(int n, int n2) {
        if (this.pixelStart != n || this.pixelEnd != n2) {
            this.pixelStart = n;
            this.pixelEnd = n2;
            this.updateAB();
            return true;
        }
        return false;
    }

    int pixel(double d) {
        return (int)(this.a + this.b * d);
    }

    double valueFromPixel(int n) {
        return ((double)n - this.a) / this.b;
    }

    protected void updateAB() {
        this.a = 0.0;
        this.b = 0.0;
        if (this.viewMin != this.viewMax && this.pixelStart != this.pixelEnd) {
            this.b = (double)(this.pixelStart - this.pixelEnd) / (this.viewMax - this.viewMin);
            this.a = (double)this.pixelStart - this.b * this.viewMax;
        }
        this.rounded = false;
    }

    boolean rounded() {
        return this.rounded;
    }

    public void unround() {
        this.viewMin = this.unroundedViewMin;
        this.viewMax = this.unroundedViewMax;
        this.updateAB();
    }

    public void round() {
        this.unroundedViewMin = this.viewMin;
        this.unroundedViewMax = this.viewMax;
        this.doRounding();
        this.updateAB();
        this.rounded = true;
    }

    protected void doRounding() {
        if (Math.round(this.viewMin) != 0L) {
            int n = (int)Math.floor(Math.log(this.viewMin) / Math.log(10.0));
            this.viewMin = (long)((int)(this.viewMin / Math.exp(Math.log(10.0) * (double)n))) * Math.round(Math.exp(Math.log(10.0) * (double)n));
        }
        double d = this.viewMax - this.viewMin;
        this.spanExp = (int)Math.ceil(Math.log(d / 4.0) / Math.log(10.0)) - 1;
        this.spanIndex = 0;
        double d2 = d / Math.exp(Math.log(10.0) * (double)this.spanExp);
        this.spanIndex = 0;
        while (this.spanIndex < spans.length && d2 > (double)spans[this.spanIndex]) {
            ++this.spanIndex;
        }
        if (d2 <= (double)spans[this.spanIndex]) {
            this.viewMax = this.viewMin + (double)spans[this.spanIndex] * Math.exp(Math.log(10.0) * (double)this.spanExp);
        }
    }

    public double divisionSize() {
        return (double)spans[this.spanIndex] * Math.exp(Math.log(10.0) * (double)this.spanExp) / (double)(dividers[this.spanIndex] + 1);
    }

    public double divisionPixelSize() {
        return this.b * (double)spans[this.spanIndex] * Math.exp(Math.log(10.0) * (double)this.spanExp) / (double)(dividers[this.spanIndex] + 1);
    }

    public int numberOfDividers() {
        return dividers[this.spanIndex];
    }
}

