/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.DartUtils;
import DartPackage.DataConDialog;
import DartPackage.DataContainer;
import DartPackage.GraphDecoration;
import DartPackage.GraphFrame;
import java.awt.Color;
import java.awt.Cursor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JOptionPane;

abstract class SelectionObject
implements Serializable {
    protected int minYear;
    protected int maxYear;
    boolean emptySet = false;
    protected transient double yMin;
    protected transient double yMax;
    String table;
    String column;
    String ftype = null;
    String run = null;
    protected String nameStr;
    protected String abbrevNameStr;
    protected Color color = Color.black;
    protected GraphDecoration decoration = null;
    transient int prevX;
    transient int prevY;
    transient int lastDec;
    transient int indOff;
    transient boolean prevXYExists;
    transient boolean dataMissing;
    transient int ndays;
    transient int yPixel;
    transient double sum;
    transient SelectionObject buddy;
    protected String feature = "";
    static HashMap featureToNameDam = null;
    static HashMap nameToFeatureDam = null;
    static HashMap featureToNameProj = null;
    static HashMap nameToFeatureProj = null;
    static HashMap featureToNameSmolt = null;
    static HashMap nameToFeatureSmolt = null;
    static HashMap featureSmoltAndDam = null;
    static String[] projArr = new String[]{"ALF-Albeni Falls Forebay [1961]", "ANQW-Anatone WA (Snake) [1999]", "BON-Bonneville Forebay [1949]", "CCIW-Cascade Island (Columbia) [2004]", "CIBW-Boundary (US/Canada) [1997]", "CHJ-Chief Joseph Forebay [1960]", "CHQW-Chief Joseph Tailrace [1997]", "CWMW-Camas/Washougal [1995]", "DWR-Dworshak Tailrace [1973]", "GCL-Grand Coulee Forebay [1960]", "GCGW-Grand Coulee Downstream [1997]", "HGH-Hungry Horse [1960]", "HGHM-Hungry Horse Tailrace [1998]", "IHR-Ice Harbor Forebay [1961]", "IDSW-Ice Harbor Tailrace [1995]", "JDA-John Day Forebay [1968]", "JHAW-John Day Tailrace [1995]", "KLAW-Kalama [1996-1998]", "LEWI-Lewiston ID (Clearwater) [1997]", "LIB-Libby Forebay [1975]", "LGS-Little Goose Forebay [1970]", "LGSW-Little Goose Tailrace [1995]", "LWG-Lower Granite Forebay [1975]", "LGNW-Lower Granite Tailrace [1995]", "LMN-Lower Monumental Forebay [1969]", "LMNW-Lower Monumental Tailrace [1995]", "MCN-McNary Forebay (WA) [1956]", "MCQO-McNary Forebay (OR) [1996]", "MCPW-McNary Tailrace [1995]", "PAQW-Pasco WA (Columbia) [2000]", "PEKI-Peck ID (Clearwater) [1997]", "PRD-Priest Rapids Forebay [1961]", "PRXW-Priest Rapids Downstream [1995]", "RIS-Rock Island Forebay [1964]", "RIGW-Rock Island Tailrace [1997]", "RRH-Rocky Reach Forebay [1962]", "RRDW-Rocky Reach Tailrace [1997]", "SKAW-Skamania WA (Columbia) [1995-2002]", "TDA-The Dalles Forebay [1960]", "TDDO-The Dalles Tailrace [1997]", "WAN-Wanapum Forebay [1966]", "WANW-Wanapum (Downstream) [1995]", "WRNO-Warrendale OR (Columbia) [1996]", "WEL-Wells Forebay [1967]", "WELW-Wells Tailrace [1998]"};
    static String[] damArr = new String[]{"BON-Bonneville [1938]", "IHR-Ice Harbor [1962]", "JDA-John Day [1969]", "LGS-Little Goose [1970]", "LMN-Lower Monumental [1969]", "LWG-Lower Granite [1975]", "MCN-McNary [1956]", "PRD-Priest Rapids [1962]", "PRO-Prosser [1983]", "RIS-Rock Island [1977]", "RRH-Rocky Reach [1977]", "ROZ-Roza [1940]", "TDA-The Dalles [1960]", "TUM-Tumwater [1999]", "WEL-Wells [1977]", "ZOS-Zosel [2006]"};
    static String[] smoltArr = new String[]{"BON-Bonneville [1986]", "GRN-Grande Ronde R Trap [1994]", "IMN-Imnaha R Trap [1994]", "JDA-John Day [1985]", "LEW-Lewiston Trap (Snake R) [1985]", "LGS-Little Goose [1985]", "LMN-Lower Monumental [1985]", "LWG-Lower Granite [1985]", "MCN-McNary [1985]", "RIS-Rock Island [1985]", "WTB-Whitebird Trap (Salmon R) [1985]"};
    protected boolean histAverage;
    protected transient DataContainer myDC = null;
    boolean filterData = true;
    float absMin = -3.4028235E38f;
    float absMax = Float.MAX_VALUE;
    float aValue = Float.MAX_VALUE;
    float bValue = Float.MAX_VALUE;
    boolean useAPlusBT = false;
    boolean accumulate = false;
    protected boolean highlight;
    protected transient boolean[] valEx = null;
    protected transient float[] val = null;
    static final String[] YAXIS_UNITS_SHORT = new String[]{"", "%", "Fract", "\ufffdC", "KCFS", "Ft", "KAF", "Quant", "Mi/Day", "J", "mmHg", "Se.Ft"};
    static final int YAXIS_PERCENT = 1;
    static final String YAXIS_PERCENT_STR = "Percent";
    static final int YAXIS_FRACTION = 2;
    static final String YAXIS_FRACTION_STR = "Fraction";
    static final int YAXIS_TEMP = 3;
    static final String YAXIS_TEMP_STR = "Degrees C";
    static final int YAXIS_KCFS = 4;
    static final String YAXIS_KCFS_STR = "KCFS";
    static final int YAXIS_FEET = 5;
    static final String YAXIS_FEET_STR = "Feet";
    static final int YAXIS_KAFT = 6;
    static final String YAXIS_KAFT_STR = "KAF";
    static final int YAXIS_NUMBER = 7;
    static final String YAXIS_NUMBER_STR = "Quantity";
    static final int YAXIS_MI_DAY = 8;
    static final String YAXIS_MI_DAY_STR = "Miles/Day";
    static final int YAXIS_JOULES = 9;
    static final String YAXIS_JOULES_STR = "Joules";
    static final int YAXIS_PRESSURE = 10;
    static final String YAXIS_PRESSURE_STR = "mmHg";
    static final int YAXIS_TURB = 11;
    static final String YAXIS_TURB_STR = "Secchi ft.";
    protected static final int FILE_VERSION = 1;

    SelectionObject() {
        SelectionObject.configure();
        this.buddy = null;
    }

    int minYear() {
        return this.minYear;
    }

    int maxYear() {
        return this.maxYear;
    }

    void setMinYear(int n) {
        this.minYear = n;
    }

    void setMaxYear(int n) {
        this.maxYear = n;
    }

    double yMin() {
        return this.yMin;
    }

    double yMax() {
        return this.yMax;
    }

    abstract String typeString();

    abstract int axisType();

    abstract int defaultPrecision();

    String nameStr() {
        return this.nameStr;
    }

    void setNameStr(String string) {
        this.nameStr = string;
    }

    String abbrevNameStr() {
        return this.abbrevNameStr;
    }

    void setAbbrevNameStr(String string) {
        this.abbrevNameStr = string;
    }

    Color color() {
        return this.color;
    }

    void setColor(Color color) {
        this.color = color;
    }

    GraphDecoration decoration() {
        return this.decoration;
    }

    void setDecoration(GraphDecoration graphDecoration) {
        this.decoration = graphDecoration;
    }

    void resetTempGraphics() {
        this.prevX = 0;
        this.prevY = 0;
        this.lastDec = 0;
        this.indOff = 0;
        this.ndays = 0;
        this.yPixel = 0;
    }

    String getFeature() {
        return this.feature;
    }

    void setFeature(String string) {
        this.feature = string;
    }

    String getFeatureName() {
        if (this.validAtProj()) {
            return (String)featureToNameProj.get(this.feature);
        }
        if (this.validAtDam()) {
            return (String)featureToNameDam.get(this.feature);
        }
        if (this.validAtSmolt()) {
            return (String)featureToNameSmolt.get(this.feature);
        }
        return "Error";
    }

    void setFeatureName(String string) {
        String string2;
        this.feature = SelectionObject.featureFromName(string);
        if (!this.validAtSmolt() && (string2 = (String)featureSmoltAndDam.get(this.feature)) != null) {
            this.feature = string2;
        }
    }

    static String featureFromName(String string) {
        String string2 = null;
        string2 = (String)nameToFeatureDam.get(string);
        if (string2 == null || string2.length() == 0) {
            string2 = (String)nameToFeatureProj.get(string);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = (String)nameToFeatureSmolt.get(string);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "Nowhere";
        }
        return string2;
    }

    static void fillHashesDam(String string, String string2) {
        featureToNameDam.put(string, string2);
        nameToFeatureDam.put(string2, string);
    }

    static void fillHashesProj(String string, String string2) {
        featureToNameProj.put(string, string2);
        nameToFeatureProj.put(string2, string);
    }

    static void fillHashesSmolt(String string, String string2) {
        featureToNameSmolt.put(string, string2);
        nameToFeatureSmolt.put(string2, string);
    }

    static void configure() {
        if (featureToNameProj != null) {
            return;
        }
        featureToNameProj = new HashMap(100);
        nameToFeatureProj = new HashMap(100);
        SelectionObject.fillHashesProj("ALF", projArr[0]);
        SelectionObject.fillHashesProj("ANQW", projArr[1]);
        SelectionObject.fillHashesProj("BON", projArr[2]);
        SelectionObject.fillHashesProj("CCIW", projArr[3]);
        SelectionObject.fillHashesProj("CIBW", projArr[4]);
        SelectionObject.fillHashesProj("CHJ", projArr[5]);
        SelectionObject.fillHashesProj("CHQW", projArr[6]);
        SelectionObject.fillHashesProj("CWMW", projArr[7]);
        SelectionObject.fillHashesProj("DWR", projArr[8]);
        SelectionObject.fillHashesProj("GCL", projArr[9]);
        SelectionObject.fillHashesProj("GCGW", projArr[10]);
        SelectionObject.fillHashesProj("HGH", projArr[11]);
        SelectionObject.fillHashesProj("HGHM", projArr[12]);
        SelectionObject.fillHashesProj("IHR", projArr[13]);
        SelectionObject.fillHashesProj("IDSW", projArr[14]);
        SelectionObject.fillHashesProj("JDA", projArr[15]);
        SelectionObject.fillHashesProj("JHAW", projArr[16]);
        SelectionObject.fillHashesProj("KLAW", projArr[17]);
        SelectionObject.fillHashesProj("LEWI", projArr[18]);
        SelectionObject.fillHashesProj("LIB", projArr[19]);
        SelectionObject.fillHashesProj("LGS", projArr[20]);
        SelectionObject.fillHashesProj("LGSW", projArr[21]);
        SelectionObject.fillHashesProj("LWG", projArr[22]);
        SelectionObject.fillHashesProj("LGNW", projArr[23]);
        SelectionObject.fillHashesProj("LMN", projArr[24]);
        SelectionObject.fillHashesProj("LMNW", projArr[25]);
        SelectionObject.fillHashesProj("MCN", projArr[26]);
        SelectionObject.fillHashesProj("MCQO", projArr[27]);
        SelectionObject.fillHashesProj("MCPW", projArr[28]);
        SelectionObject.fillHashesProj("PAQW", projArr[29]);
        SelectionObject.fillHashesProj("PECK", projArr[30]);
        SelectionObject.fillHashesProj("PRD", projArr[31]);
        SelectionObject.fillHashesProj("PRXW", projArr[32]);
        SelectionObject.fillHashesProj("RIS", projArr[33]);
        SelectionObject.fillHashesProj("RIGW", projArr[34]);
        SelectionObject.fillHashesProj("RRH", projArr[35]);
        SelectionObject.fillHashesProj("RRDW", projArr[36]);
        SelectionObject.fillHashesProj("SKAW", projArr[37]);
        SelectionObject.fillHashesProj("TDA", projArr[38]);
        SelectionObject.fillHashesProj("TDDO", projArr[39]);
        SelectionObject.fillHashesProj("WAN", projArr[40]);
        SelectionObject.fillHashesProj("WANW", projArr[41]);
        SelectionObject.fillHashesProj("WRNO", projArr[42]);
        SelectionObject.fillHashesProj("WEL", projArr[43]);
        SelectionObject.fillHashesProj("WELW", projArr[44]);
        SelectionObject.fillHashesProj("", "");
        featureToNameDam = new HashMap(100);
        nameToFeatureDam = new HashMap(100);
        SelectionObject.fillHashesDam("BON", damArr[0]);
        SelectionObject.fillHashesDam("IHR", damArr[1]);
        SelectionObject.fillHashesDam("JDA", damArr[2]);
        SelectionObject.fillHashesDam("LGS", damArr[3]);
        SelectionObject.fillHashesDam("LMN", damArr[4]);
        SelectionObject.fillHashesDam("LWG", damArr[5]);
        SelectionObject.fillHashesDam("MCN", damArr[6]);
        SelectionObject.fillHashesDam("PRD", damArr[7]);
        SelectionObject.fillHashesDam("PRO", damArr[8]);
        SelectionObject.fillHashesDam("RIS", damArr[9]);
        SelectionObject.fillHashesDam("RRH", damArr[10]);
        SelectionObject.fillHashesDam("ROZ", damArr[11]);
        SelectionObject.fillHashesDam("TDA", damArr[12]);
        SelectionObject.fillHashesDam("TUM", damArr[13]);
        SelectionObject.fillHashesDam("WEL", damArr[14]);
        SelectionObject.fillHashesDam("ZOS", damArr[15]);
        SelectionObject.fillHashesDam("", "");
        featureToNameSmolt = new HashMap(100);
        nameToFeatureSmolt = new HashMap(100);
        SelectionObject.fillHashesSmolt("bo1", smoltArr[0]);
        SelectionObject.fillHashesSmolt("grn", smoltArr[1]);
        SelectionObject.fillHashesSmolt("imn", smoltArr[2]);
        SelectionObject.fillHashesSmolt("jda", smoltArr[3]);
        SelectionObject.fillHashesSmolt("lew", smoltArr[4]);
        SelectionObject.fillHashesSmolt("lgs", smoltArr[5]);
        SelectionObject.fillHashesSmolt("lmn", smoltArr[6]);
        SelectionObject.fillHashesSmolt("lgr", smoltArr[7]);
        SelectionObject.fillHashesSmolt("mcn", smoltArr[8]);
        SelectionObject.fillHashesSmolt("ris", smoltArr[9]);
        SelectionObject.fillHashesSmolt("wtb", smoltArr[10]);
        SelectionObject.fillHashesSmolt("", "");
        featureSmoltAndDam = new HashMap(100);
        featureSmoltAndDam.put("bo1", "BON");
        featureSmoltAndDam.put("jda", "JDA");
        featureSmoltAndDam.put("lgs", "LGS");
        featureSmoltAndDam.put("lmn", "LMN");
        featureSmoltAndDam.put("lgr", "LWG");
        featureSmoltAndDam.put("mcn", "MCN");
        featureSmoltAndDam.put("ris", "RIS");
    }

    abstract boolean validAtDam();

    abstract boolean validAtProj();

    abstract boolean validAtSmolt();

    abstract boolean mayAccumulate();

    boolean histAverage() {
        return this.histAverage;
    }

    void setHistAverage(boolean bl) {
        this.histAverage = bl;
    }

    DataContainer getDC() {
        return this.myDC;
    }

    void setDC(DataContainer dataContainer) {
        this.myDC = dataContainer;
    }

    boolean filterData() {
        return this.filterData;
    }

    void setFilterData(boolean bl) {
        this.filterData = bl;
    }

    boolean accumulate() {
        return this.accumulate;
    }

    void setAccumulate(boolean bl) {
        this.accumulate = bl;
    }

    boolean highlight() {
        return this.highlight;
    }

    void setHighlight(boolean bl) {
        this.highlight = bl;
    }

    boolean yValExists(int n) {
        if (n >= this.valEx.length) {
            return false;
        }
        return this.valEx[n];
    }

    float yVal(int n) {
        return this.val[n];
    }

    int length() {
        return this.val.length;
    }

    void extrema(int n, int n2, double[] dArray) {
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        boolean bl = true;
        int n4 = (1 + this.maxYear - this.minYear) * 366;
        if (n != 0 || n2 != n4) {
            bl = false;
        }
        if (this.valEx == null || bl && this.valEx.length != n2) {
            this.valEx = new boolean[n4];
            this.val = new float[n4];
        }
        if (this.myDC == null) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            return;
        }
        for (int i = n; i < n2; ++i) {
            if (!this.myDC.yValExists(i)) continue;
            this.val[i] = this.myDC.yVal(i);
            this.valEx[i] = false;
            if (this.filterData && (this.val[i] > this.absMax || this.val[i] < this.absMin || this.useAPlusBT && n3 >= 0 && Math.abs(this.val[i] - this.val[n3]) >= this.aValue + this.bValue * (float)(i - n3))) continue;
            n3 = i;
            d = Math.min(d, (double)this.val[i]);
            d2 = Math.max(d2, (double)this.val[i]);
            this.valEx[i] = true;
        }
        if (d > d2) {
            d = 0.0;
            d2 = 0.0;
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    void applyDataFilter() {
        double[] dArray = new double[2];
        this.extrema(0, (1 + this.maxYear - this.minYear) * 366, dArray);
        this.yMin = dArray[0];
        this.yMax = dArray[1];
    }

    static String unitsShortStr(int n) {
        if (n >= 0 && n < YAXIS_UNITS_SHORT.length) {
            return YAXIS_UNITS_SHORT[n];
        }
        return "";
    }

    static String unitsStr(int n) {
        switch (n) {
            case 1: {
                return YAXIS_PERCENT_STR;
            }
            case 2: {
                return YAXIS_FRACTION_STR;
            }
            case 3: {
                return YAXIS_TEMP_STR;
            }
            case 4: {
                return YAXIS_KCFS_STR;
            }
            case 5: {
                return YAXIS_FEET_STR;
            }
            case 6: {
                return YAXIS_KAFT_STR;
            }
            case 7: {
                return YAXIS_NUMBER_STR;
            }
            case 8: {
                return YAXIS_MI_DAY_STR;
            }
            case 9: {
                return YAXIS_JOULES_STR;
            }
            case 10: {
                return YAXIS_PRESSURE_STR;
            }
            case 11: {
                return YAXIS_TURB_STR;
            }
        }
        return "Illegal value";
    }

    static String defaultName(SelectionObject selectionObject, String string, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(selectionObject.nameStr());
        stringBuffer.append(", ");
        stringBuffer.append(string);
        stringBuffer.append(", ");
        String string2 = Integer.toString(n);
        String string3 = Integer.toString(n2);
        stringBuffer.append(string2);
        if (n != n2) {
            int n3 = n / 10 == n2 / 10 ? 1 : (n / 100 == n2 / 100 ? 2 : (n / 1000 == n2 / 1000 ? 3 : 4));
            n3 = Math.max(n3, string3.length());
            string3 = "-" + string3.substring(string3.length() - n3);
            stringBuffer.append(string3);
        }
        if (bl) {
            stringBuffer.append(", accum.");
        }
        return stringBuffer.toString();
    }

    static String defaultAbbrevName(SelectionObject selectionObject, String string, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(selectionObject.abbrevNameStr());
        stringBuffer.append(",");
        stringBuffer.append(string);
        stringBuffer.append(",");
        String string2 = Integer.toString(n);
        String string3 = Integer.toString(n2);
        stringBuffer.append(string2.substring(string2.length() - 2));
        if (n != n2) {
            int n3 = n / 10 == n2 / 10 ? 1 : 2;
            string3 = "-" + string3.substring(string3.length() - n3);
            stringBuffer.append(string3);
        }
        if (bl) {
            stringBuffer.append(",cum");
        }
        return stringBuffer.toString();
    }

    void readFromServer(GraphFrame graphFrame) {
        Cursor cursor = graphFrame.getCursor();
        graphFrame.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = true;
        this.myDC = null;
        try {
            this.myDC = graphFrame.dartInter().getDC(this, graphFrame.hostName(), graphFrame.hostAddr());
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("myDC null in So's ReadFrom server in exception" + exception);
        }
        graphFrame.setCursor(cursor);
        if (this.myDC.refusedFlag()) {
            DartUtils.showAccessRefusedBox(graphFrame);
            this.myDC = null;
        } else if (!bl || this.myDC.errorFlag()) {
            try {
                DartUtils.showConnectionErrorBox(graphFrame, graphFrame.dartInter().getStr());
            }
            catch (Exception exception) {
                DartUtils.showConnectionErrorBox(graphFrame, exception.getMessage());
            }
            this.myDC = null;
        }
    }

    String query() {
        StringBuffer stringBuffer = new StringBuffer(150);
        if (this.ftype == null) {
            stringBuffer.append("SELECT ");
            if (!this.mayAccumulate()) {
                stringBuffer.append("DISTINCT ");
            }
            stringBuffer.append("YEAR, MO, DA, ");
            stringBuffer.append(this.column);
            stringBuffer.append(" FROM ");
            stringBuffer.append(this.table);
            stringBuffer.append(" WHERE YEAR>=");
            stringBuffer.append(this.minYear);
            stringBuffer.append(" AND YEAR<=");
            stringBuffer.append(this.maxYear);
            stringBuffer.append(" AND PROJ='");
            stringBuffer.append(this.feature);
            stringBuffer.append("'");
        } else {
            stringBuffer.append("SELECT YEAR, MO, DA, ");
            stringBuffer.append(this.feature);
            stringBuffer.append(" FROM ");
            stringBuffer.append(this.table);
            stringBuffer.append(" WHERE ");
            if (this.ftype.length() > 0) {
                stringBuffer.append("FTYPE='");
                stringBuffer.append(this.ftype);
                stringBuffer.append("' AND ");
            }
            if (this.run != null && this.run.length() > 0) {
                stringBuffer.append(" RUN='");
                stringBuffer.append(this.run);
                stringBuffer.append("' AND ");
            }
            stringBuffer.append(" YEAR>=");
            stringBuffer.append(this.minYear);
            stringBuffer.append(" AND YEAR<=");
            stringBuffer.append(this.maxYear);
        }
        return stringBuffer.toString();
    }

    String cacheName() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.table);
        stringBuffer.append(".");
        if (this.ftype == null) {
            stringBuffer.append(this.column);
            stringBuffer.append(".");
        } else {
            if (this.ftype.length() > 0) {
                stringBuffer.append(this.ftype);
                stringBuffer.append(".");
            }
            if (this.run != null && this.run.length() > 0) {
                stringBuffer.append(this.run);
                stringBuffer.append(".");
            }
        }
        stringBuffer.append(this.feature);
        stringBuffer.append(".");
        stringBuffer.append(this.minYear);
        stringBuffer.append(".");
        stringBuffer.append(this.maxYear);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.abbrevNameStr;
    }

    boolean select(GraphFrame graphFrame) {
        DataConDialog dataConDialog = new DataConDialog(graphFrame, this);
        if (dataConDialog.succeeded()) {
            if (dataConDialog.changedData()) {
                this.readFromServer(graphFrame);
            }
            return true;
        }
        return false;
    }

    SelectionObject copy() {
        Class<?> clazz = this.getClass();
        SelectionObject selectionObject = null;
        try {
            selectionObject = (SelectionObject)clazz.newInstance();
            selectionObject.minYear = this.minYear;
            selectionObject.maxYear = this.maxYear;
            selectionObject.nameStr = this.nameStr;
            selectionObject.abbrevNameStr = this.abbrevNameStr;
            selectionObject.color = this.color;
            selectionObject.decoration = this.decoration;
            selectionObject.feature = this.feature;
            selectionObject.filterData = this.filterData;
            selectionObject.absMin = this.absMin;
            selectionObject.absMax = this.absMax;
            selectionObject.aValue = this.aValue;
            selectionObject.bValue = this.bValue;
            selectionObject.useAPlusBT = this.useAPlusBT;
            selectionObject.accumulate = this.accumulate;
            selectionObject.highlight = this.highlight;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return selectionObject;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeInt(this.minYear);
        objectOutputStream.writeInt(this.maxYear);
        objectOutputStream.writeObject(this.table);
        objectOutputStream.writeObject(this.column);
        objectOutputStream.writeObject(this.ftype);
        objectOutputStream.writeObject(this.run);
        objectOutputStream.writeObject(this.nameStr);
        objectOutputStream.writeObject(this.abbrevNameStr);
        objectOutputStream.writeObject(this.color);
        objectOutputStream.writeObject(this.decoration);
        objectOutputStream.writeObject(this.feature);
        objectOutputStream.writeBoolean(this.histAverage);
        objectOutputStream.writeBoolean(this.filterData);
        objectOutputStream.writeFloat(this.absMin);
        objectOutputStream.writeFloat(this.absMax);
        objectOutputStream.writeFloat(this.aValue);
        objectOutputStream.writeFloat(this.bValue);
        objectOutputStream.writeBoolean(this.useAPlusBT);
        objectOutputStream.writeBoolean(this.accumulate);
        objectOutputStream.writeBoolean(this.highlight);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n > 1) {
            JOptionPane.showMessageDialog(null, "Perhaps you reinstall javaDART", "File version incompatible", 1);
            throw new IOException();
        }
        this.minYear = objectInputStream.readInt();
        this.maxYear = objectInputStream.readInt();
        this.table = (String)objectInputStream.readObject();
        this.column = (String)objectInputStream.readObject();
        this.ftype = (String)objectInputStream.readObject();
        this.run = (String)objectInputStream.readObject();
        this.nameStr = (String)objectInputStream.readObject();
        this.abbrevNameStr = (String)objectInputStream.readObject();
        this.color = (Color)objectInputStream.readObject();
        this.decoration = (GraphDecoration)objectInputStream.readObject();
        this.feature = (String)objectInputStream.readObject();
        this.histAverage = objectInputStream.readBoolean();
        this.filterData = objectInputStream.readBoolean();
        this.absMin = objectInputStream.readFloat();
        this.absMax = objectInputStream.readFloat();
        this.aValue = objectInputStream.readFloat();
        this.bValue = objectInputStream.readFloat();
        this.useAPlusBT = objectInputStream.readBoolean();
        this.accumulate = objectInputStream.readBoolean();
        this.highlight = objectInputStream.readBoolean();
    }
}

