/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.BaroPressureSOFactory;
import DartPackage.DartInterface;
import DartPackage.DartObservable;
import DartPackage.GraphDecoration;
import DartPackage.GraphFrame;
import DartPackage.GraphListModel;
import DartPackage.ParamListSelection;
import DartPackage.ParameterCellRenderer;
import DartPackage.RiverEnvDialog;
import DartPackage.SelectionObject;
import DartPackage.SelectionObjectFactory;
import DartPackage.SelectionParams;
import DartPackage.StringListModel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ThreeColumnDialog
extends JPanel
implements MouseListener {
    protected DartInterface dartInter;
    protected LinkedList GraphsList = new LinkedList();
    protected DartObservable favOb;
    protected LinkedList soFactories;
    protected int firstYear;
    protected int lastYear;
    protected String[] myFeatures;
    protected String myTitle;
    protected Font AppFont = new Font("Dialog", 0, 12);
    ThreeColumnDialog[] tcdArr;
    JPanel JPanel1 = new JPanel();
    JLabel MainLabel = new JLabel();
    JScrollPane ParameterScrollPane = new JScrollPane();
    JList ParameterList = new JList();
    JList EnvironmentList = new JList();
    JScrollPane YearsScrollPane = new JScrollPane();
    JList YearsList = new JList();
    JScrollPane ProjectsScrollPane = new JScrollPane();
    JList ProjectsList = new JList();
    JCheckBox OverplotCheckBox = new JCheckBox();
    JButton CreateGraphButton = new JButton();
    JButton DoneButton = new JButton();
    JLabel ParameterLabel = new JLabel();
    JLabel YearsLabel = new JLabel();
    JLabel ProjectsLabel = new JLabel();
    JList Graphs = new JList();
    JButton UpdateGraph = new JButton();
    JScrollPane GraphsPane = new JScrollPane();
    JButton CloseGraph = new JButton();
    JLabel GraphListLabel = new JLabel();
    StringListModel stringListModel1 = new StringListModel();
    StringListModel stringListModel2 = new StringListModel();
    StringListModel stringListModel3 = new StringListModel();
    StringListModel stringListModel4 = new StringListModel();
    GraphListModel graphList1 = new GraphListModel();
    ParameterCellRenderer myCellRenderer = new ParameterCellRenderer();
    ParamListSelection pListSelection;

    abstract boolean useThisSOF(SelectionObjectFactory var1);

    public ThreeColumnDialog(DartInterface dartInterface, DartObservable dartObservable, String string, String[] stringArray, ThreeColumnDialog[] threeColumnDialogArray, int n, int n2) {
        this.firstYear = n;
        this.lastYear = n2;
        this.dartInter = dartInterface;
        this.favOb = dartObservable;
        this.tcdArr = threeColumnDialogArray;
        this.myFeatures = stringArray;
        this.myTitle = string;
        this.setLayout(null);
        this.JPanel1.setLayout(null);
        this.setSize(560, 405);
        this.setVisible(false);
        this.add(this.JPanel1);
        this.ParameterList.setFont(this.AppFont);
        this.EnvironmentList.setFont(this.AppFont);
        this.YearsList.setFont(this.AppFont);
        this.ProjectsList.setFont(this.AppFont);
        this.CloseGraph.setFont(this.AppFont);
        this.GraphListLabel.setFont(this.AppFont);
        this.CreateGraphButton.setFont(this.AppFont);
        this.DoneButton.setFont(this.AppFont);
        this.ParameterLabel.setFont(this.AppFont);
        this.YearsLabel.setFont(this.AppFont);
        this.ProjectsLabel.setFont(this.AppFont);
        this.Graphs.setFont(this.AppFont);
        this.UpdateGraph.setFont(this.AppFont);
        this.JPanel1.setBounds(0, 0, 558, 405);
        this.ParameterScrollPane.setOpaque(true);
        this.JPanel1.add(this.ParameterScrollPane);
        this.ParameterScrollPane.setBounds(12, 30, 168, 216);
        this.ParameterList.setBounds(0, 0, 165, 213);
        this.ParameterScrollPane.getViewport().add(this.ParameterList);
        this.YearsScrollPane.setOpaque(true);
        this.JPanel1.add(this.YearsScrollPane);
        this.YearsScrollPane.setBounds(200, 30, 68, 216);
        this.YearsScrollPane.getViewport().add(this.YearsList);
        this.YearsList.setBounds(0, 0, 65, 213);
        this.ProjectsScrollPane.setOpaque(true);
        this.JPanel1.add(this.ProjectsScrollPane);
        this.ProjectsScrollPane.setBounds(293, 30, 245, 216);
        this.ProjectsScrollPane.getViewport().add(this.ProjectsList);
        this.ProjectsList.setBounds(0, 0, 333, 213);
        this.ParameterLabel.setHorizontalAlignment(0);
        this.ParameterLabel.setText("Parameters");
        this.JPanel1.add(this.ParameterLabel);
        this.ParameterLabel.setForeground(Color.black);
        this.ParameterLabel.setBounds(12, 6, 168, 24);
        this.YearsLabel.setHorizontalAlignment(0);
        this.YearsLabel.setText("Years");
        this.JPanel1.add(this.YearsLabel);
        this.YearsLabel.setForeground(Color.black);
        this.YearsLabel.setBounds(204, 6, 66, 20);
        this.GraphListLabel.setText("Open Graphs");
        this.ProjectsLabel.setHorizontalAlignment(0);
        this.ProjectsLabel.setText("Projects and Locations");
        this.JPanel1.add(this.ProjectsLabel);
        this.ProjectsLabel.setForeground(Color.black);
        this.ProjectsLabel.setBounds(238, 6, 334, 23);
        this.UpdateGraph.setText("Update");
        this.UpdateGraph.setFont(new Font("Dialog", 0, 12));
        this.UpdateGraph.setBounds(432, 325, 108, 24);
        this.UpdateGraph.setToolTipText("Update the Selected Graph");
        this.JPanel1.add(this.UpdateGraph);
        JPanel jPanel = new JPanel(null);
        LineBorder lineBorder = new LineBorder(Color.black);
        String string2 = string + " Graphs";
        TitledBorder titledBorder = new TitledBorder(LineBorder.createBlackLineBorder(), string2);
        titledBorder.setTitleFont(this.AppFont);
        jPanel.setBorder(titledBorder);
        jPanel.setBounds(12, 250, 410, 150);
        this.GraphsPane.setBounds(5, 17, 400, 128);
        jPanel.add(this.GraphsPane);
        this.JPanel1.add(jPanel);
        this.Graphs.setSelectionMode(0);
        this.Graphs.addMouseListener(this);
        this.GraphsPane.getViewport().add(this.Graphs);
        this.GraphsPane.setOpaque(true);
        this.JPanel1.add(this.CloseGraph);
        this.CloseGraph.setText("Delete");
        this.CloseGraph.setBounds(432, 355, 108, 24);
        this.CreateGraphButton.setText("Create");
        this.CreateGraphButton.setToolTipText("Create a New Graph from Selections");
        this.CreateGraphButton.setActionCommand("Create Graph");
        this.JPanel1.add(this.CreateGraphButton);
        this.CreateGraphButton.setBounds(432, 295, 108, 24);
        SymAction symAction = new SymAction();
        this.CreateGraphButton.addActionListener(symAction);
        this.UpdateGraph.addActionListener(symAction);
        this.CloseGraph.addActionListener(symAction);
        this.ParameterList.setModel(this.stringListModel1);
        this.EnvironmentList.setModel(this.stringListModel4);
        this.YearsList.setModel(this.stringListModel2);
        this.ProjectsList.setModel(this.stringListModel3);
        this.Graphs.setModel(this.graphList1);
        this.ParameterList.setCellRenderer(this.myCellRenderer);
        this.Graphs.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ThreeColumnDialog.this.ListSelectionChanged(listSelectionEvent);
            }
        });
        this.MainLabel.setText("DART " + string);
        if (stringArray.length > 0) {
            this.fillDialog();
            if (!(this instanceof RiverEnvDialog)) {
                this.ParameterList.setSelectionModel(this.pListSelection);
            }
        } else {
            this.CreateGraphButton.setEnabled(false);
            this.DoneButton.setEnabled(false);
            this.UpdateGraph.setEnabled(false);
            this.CloseGraph.setEnabled(false);
        }
        this.setVisible(true);
    }

    void fillDialog() {
        StringListModel stringListModel = (StringListModel)this.ParameterList.getModel();
        SelectionObjectFactory.configure();
        ListIterator listIterator = SelectionObjectFactory.factoryList.listIterator(0);
        this.soFactories = new LinkedList();
        while (listIterator.hasNext()) {
            SelectionObjectFactory selectionObjectFactory = (SelectionObjectFactory)listIterator.next();
            if (!this.useThisSOF(selectionObjectFactory)) continue;
            if (selectionObjectFactory instanceof BaroPressureSOFactory && !(this instanceof RiverEnvDialog)) {
                JToolBar.Separator separator = new JToolBar.Separator(new Dimension(90, 20));
                separator.setOrientation(0);
                stringListModel.addElement(separator);
                this.pListSelection = new ParamListSelection(this.soFactories.size());
                this.soFactories.addLast(new BaroPressureSOFactory());
            }
            stringListModel.addElement(selectionObjectFactory.nameStr());
            this.soFactories.addLast(selectionObjectFactory);
        }
        stringListModel = (StringListModel)this.YearsList.getModel();
        for (int i = this.lastYear; i >= this.firstYear; --i) {
            stringListModel.addElement(Integer.toString(i));
        }
        stringListModel = (StringListModel)this.ProjectsList.getModel();
        for (int i = 0; i < this.myFeatures.length; ++i) {
            stringListModel.addElement(this.myFeatures[i]);
        }
    }

    void UpdateListSelections(SelectionParams selectionParams) {
        this.ParameterList.setSelectedIndices(selectionParams.param);
        this.ProjectsList.setSelectedIndices(selectionParams.proj);
        this.YearsList.setSelectedIndices(selectionParams.years);
    }

    void ListSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (this.Graphs.getSelectedIndex() >= 0) {
            GraphFrame graphFrame = (GraphFrame)this.Graphs.getSelectedValue();
            SelectionParams selectionParams = graphFrame.getSelectionParams();
            if (graphFrame.ptcd.getClass().isInstance(this)) {
                this.UpdateListSelections(selectionParams);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() >= 2 && (n = this.Graphs.locationToIndex(mouseEvent.getPoint())) >= 0 && this.Graphs.getCellBounds(n, n).contains(mouseEvent.getPoint()) && this.Graphs.getSelectedIndex() == n && this.Graphs.getSelectedValue() != null) {
            GraphFrame graphFrame = (GraphFrame)this.Graphs.getSelectedValue();
            graphFrame.setState(0);
            graphFrame.requestFocus();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void deleteGraph(GraphFrame graphFrame) {
        GraphListModel graphListModel = (GraphListModel)this.Graphs.getModel();
        graphListModel.deleteElement(graphFrame);
        this.Graphs.repaint();
    }

    void addGraph(GraphFrame graphFrame) {
        GraphListModel graphListModel = (GraphListModel)this.Graphs.getModel();
        graphListModel.addElement(graphFrame);
        this.Graphs.repaint();
    }

    void updateNames(GraphFrame graphFrame) {
        String string = "#" + Integer.toString(graphFrame.uniqueId) + " ";
        GraphListModel graphListModel = (GraphListModel)this.Graphs.getModel();
        String string2 = "";
        for (int i = 0; i < 4; ++i) {
            LinkedList linkedList = graphFrame.soList(i);
            if (i > 0) {
                string2 = " /  ";
            }
            if (linkedList == null) continue;
            for (int j = 0; j < linkedList.size(); ++j) {
                if (j > 0) {
                    string2 = string2 + " & ";
                }
                string2 = string2 + ((SelectionObject)linkedList.get(j)).nameStr();
                string = string + string2;
                string2 = "";
            }
        }
        graphFrame.graphName = string;
        graphListModel.changedElement(graphFrame);
        this.Graphs.repaint();
    }

    void CloseGraph_actionPerformed(ActionEvent actionEvent) {
        if (this.Graphs.getSelectedIndex() >= 0) {
            GraphFrame graphFrame = (GraphFrame)this.Graphs.getSelectedValue();
            this.deleteFromList(graphFrame);
            graphFrame.dispose();
        }
    }

    void UpdateGraph_actionPerformed(ActionEvent actionEvent) {
        if (this.Graphs.getSelectedIndex() >= 0 && this.Graphs.getSelectedValue() != null) {
            GraphFrame graphFrame = (GraphFrame)this.Graphs.getSelectedValue();
            class MyRunnable
            implements Runnable {
                ThreeColumnDialog tcd;
                GraphFrame grfr;

                MyRunnable(ThreeColumnDialog threeColumnDialog2, GraphFrame graphFrame) {
                    this.tcd = threeColumnDialog2;
                    this.grfr = graphFrame;
                }

                public void run() {
                    Cursor cursor = ThreeColumnDialog.this.getCursor();
                    ThreeColumnDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    this.tcd.ChangeGraphButton_actionPerformed(null, this.grfr);
                    this.grfr.undoMgr.discardAllEdits();
                    ThreeColumnDialog.this.setCursor(cursor);
                }
            }
            MyRunnable myRunnable = new MyRunnable(this, graphFrame);
            new Thread(myRunnable).start();
        }
    }

    void CreateGraphButton_actionPerformed(ActionEvent actionEvent) {
        this.ChangeGraphButton_actionPerformed(actionEvent, null);
    }

    void ChangeGraphButton_actionPerformed(ActionEvent actionEvent, GraphFrame graphFrame) {
        GraphFrame graphFrame2;
        int n;
        String string = this.myTitle + " Dialog";
        ListSelectionModel listSelectionModel = this.ParameterList.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "You must select at least one parameter", string, 1);
            return;
        }
        ListSelectionModel listSelectionModel2 = this.YearsList.getSelectionModel();
        if (listSelectionModel2.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "You must select at least one year", string, 1);
            return;
        }
        ListSelectionModel listSelectionModel3 = this.ProjectsList.getSelectionModel();
        if (listSelectionModel3.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this, "You must select at least one project", string, 1);
            return;
        }
        LinkedList[] linkedListArray = new LinkedList[4];
        int n2 = 15;
        int n3 = GraphDecoration.decorationList().size();
        int n4 = 0;
        int n5 = 0;
        Color[] colorArray = new Color[]{Color.black, Color.blue, Color.green, Color.red, Color.gray, Color.magenta, Color.cyan, new Color(255, 102, 51), new Color(102, 51, 0), new Color(0, 102, 51), new Color(153, 0, 51), new Color(255, 204, 51), new Color(0, 0, 153), new Color(102, 0, 153), new Color(51, 153, 153)};
        boolean bl = false;
        boolean bl2 = false;
        if (graphFrame != null) {
            bl = graphFrame.OverPlotItem.isSelected();
            bl2 = graphFrame.Accum;
        }
        StringListModel stringListModel = (StringListModel)this.ParameterList.getModel();
        StringListModel stringListModel2 = (StringListModel)this.YearsList.getModel();
        StringListModel stringListModel3 = (StringListModel)this.ProjectsList.getModel();
        for (n = 0; n < 4; ++n) {
            linkedListArray[n] = new LinkedList();
        }
        for (int i = 0; i < stringListModel.getSize(); ++i) {
            SelectionObject selectionObject;
            int n6;
            int n7 = i;
            if (!listSelectionModel.isSelectedIndex(n7)) continue;
            SelectionObjectFactory selectionObjectFactory = (SelectionObjectFactory)this.soFactories.get(n7);
            for (n6 = 0; n6 < 4 && linkedListArray[n6].size() >= 1 && (selectionObject = (SelectionObject)linkedListArray[n6].getFirst()).axisType() != selectionObjectFactory.axisType(); ++n6) {
            }
            if (n6 > 3) {
                JOptionPane.showMessageDialog(this, "Too many parameters with conflicting units", string, 1);
                return;
            }
            int n8 = this.firstYear;
            int n9 = stringListModel2.getSize() - 1;
            while (n9 >= 0) {
                if (listSelectionModel2.isSelectedIndex(n9)) {
                    int n10 = n8;
                    if (!bl) {
                        while (listSelectionModel2.isSelectedIndex(n9 - 1)) {
                            --n9;
                            ++n10;
                        }
                    }
                    for (int j = 0; j < stringListModel3.getSize(); ++j) {
                        if (!listSelectionModel3.isSelectedIndex(j)) continue;
                        selectionObject = selectionObjectFactory.makeSO();
                        selectionObject.setMinYear(n8);
                        selectionObject.setMaxYear(n10);
                        selectionObject.setColor(colorArray[n4]);
                        if (n5 == 0) {
                            selectionObject.setDecoration(null);
                        } else {
                            selectionObject.setDecoration((GraphDecoration)GraphDecoration.decorationList().get(n5 - 1));
                        }
                        if (++n4 >= n2) {
                            n4 = 0;
                            if (++n5 > n3) {
                                n5 = 0;
                            }
                        }
                        selectionObject.setFeatureName((String)stringListModel3.elementAt(j));
                        String string2 = selectionObject.getFeatureName();
                        String string3 = selectionObject.getFeature();
                        if (bl2 && selectionObject.mayAccumulate()) {
                            selectionObject.setAccumulate(true);
                        }
                        selectionObject.setAbbrevNameStr(SelectionObject.defaultAbbrevName(selectionObject, string3, n8, n10, bl2));
                        selectionObject.setNameStr(SelectionObject.defaultName(selectionObject, string3, n8, n10, bl2));
                        linkedListArray[n6].addLast(selectionObject);
                    }
                    n8 = n10;
                }
                --n9;
                ++n8;
            }
        }
        int[] nArray = this.ParameterList.getSelectedIndices();
        int[] nArray2 = this.ProjectsList.getSelectedIndices();
        int[] nArray3 = this.YearsList.getSelectedIndices();
        int n11 = -1;
        if (this.myTitle.startsWith("River")) {
            n11 = 0;
        } else if (this.myTitle.startsWith("Adult")) {
            n11 = 1;
        } else if (this.myTitle.startsWith("Juvenile")) {
            n11 = 2;
        }
        SelectionParams selectionParams = new SelectionParams(nArray3, nArray2, nArray, n11);
        if (graphFrame == null) {
            graphFrame2 = new GraphFrame(this.dartInter, this.favOb, this.tcdArr, this, selectionParams);
        } else {
            graphFrame2 = graphFrame;
            graphFrame2.setSelectionParams(selectionParams);
            graphFrame2.LinearRegression.setSelected(false);
            graphFrame2.xToolBar.RegressionButton.setSelected(false);
        }
        graphFrame2.graphComponent.lock = true;
        for (n = 0; n < 4; ++n) {
            graphFrame2.setSOList(n, linkedListArray[n]);
            graphFrame2.setShowYAxis(n, linkedListArray[n].size() > 0);
        }
        graphFrame2.setOverplot(bl);
        graphFrame2.setMainLabel(this.MainLabel.getText());
        graphFrame2.updateYourself();
        graphFrame2.xToolBar().setXMinMax(0, 100000000);
        String string4 = "#" + Integer.toString(graphFrame2.uniqueId) + " ";
        GraphListModel graphListModel = (GraphListModel)this.Graphs.getModel();
        String string5 = "";
        for (int i = 0; i < 4; ++i) {
            LinkedList linkedList = graphFrame2.soList(i);
            if (i > 0) {
                string5 = " /  ";
            }
            if (linkedList == null) continue;
            for (int j = 0; j < linkedList.size(); ++j) {
                if (j > 0) {
                    string5 = " & ";
                }
                string5 = string5 + ((SelectionObject)linkedList.get(j)).nameStr();
                string4 = string4 + string5;
                string5 = "";
            }
        }
        graphFrame2.graphName = string4;
        if (graphFrame == null) {
            graphListModel.addElement(graphFrame2);
        } else {
            graphFrame2.graphComponent.lock = false;
            graphFrame.prodGraph();
        }
        this.Graphs.setSelectedValue(graphFrame2, true);
        this.setEmptyDataSets(graphFrame2.soList);
        graphFrame2.graphComponent.lock = false;
    }

    protected void setEmptyDataSets(LinkedList[] linkedListArray) {
        for (int i = 0; i < 4; ++i) {
            LinkedList linkedList = linkedListArray[i];
            ListIterator listIterator = linkedList.listIterator(0);
            while (listIterator.hasNext()) {
                int n;
                SelectionObject selectionObject = (SelectionObject)listIterator.next();
                for (n = 0; n < selectionObject.length() && !selectionObject.yValExists(n); ++n) {
                }
                if (n != selectionObject.length()) continue;
                selectionObject.emptySet = true;
            }
        }
    }

    void deleteFromList(GraphFrame graphFrame) {
        GraphListModel graphListModel = (GraphListModel)this.Graphs.getModel();
        graphFrame.delete();
        graphListModel.deleteElement(graphFrame);
        this.GraphsPane.repaint();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ThreeColumnDialog.this.CreateGraphButton) {
                ThreeColumnDialog.this.CreateGraphButton_actionPerformed(actionEvent);
            } else if (object == ThreeColumnDialog.this.UpdateGraph) {
                ThreeColumnDialog.this.UpdateGraph_actionPerformed(actionEvent);
            } else if (object == ThreeColumnDialog.this.CloseGraph) {
                ThreeColumnDialog.this.CloseGraph_actionPerformed(actionEvent);
            }
        }
    }
}

