/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.GraphFrame;
import DartPackage.undoAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

class XAxisToolBar
extends JToolBar
implements MouseMotionListener {
    protected boolean overplot = false;
    protected double a;
    protected double b;
    protected boolean daily = true;
    protected boolean weekly = false;
    protected boolean monthly = false;
    protected boolean yearly = false;
    protected int minYear;
    protected int maxYear;
    protected int minData;
    protected int maxData;
    protected int leftPixel;
    protected int rightPixel;
    protected int xMin;
    protected int xMax;
    private transient boolean lock;
    protected GraphFrame myFrame;
    JLabel XMinLabel = new JLabel();
    JTextField XMinTextField = new JTextField();
    JLabel XMaxLabel = new JLabel();
    JTextField XMaxTextField = new JTextField();
    JLabel XMouseLabel = new JLabel();
    JButton ZoomInButton = new JButton();
    JButton ZoomOutButton = new JButton();
    JToggleButton RegressionButton = new JToggleButton();
    JScrollBar ScrollBar = new JScrollBar();
    JLabel ArrowLabel = new JLabel();
    ImageIcon ZoomInIcon;
    ImageIcon ZoomOutIcon;
    ImageIcon HorizArrow;
    JToolBar.Separator ts = new JToolBar.Separator();
    JToggleButton XYButton = new JToggleButton();
    transient int firstYear;
    transient int lastYear;
    transient int firstMonth;
    transient int lastMonth;
    transient int firstWeek;
    transient int lastWeek;
    protected FocusListener focusXMinListener = new FocusAdapter(){
        String saveStr;

        public void focusGained(FocusEvent focusEvent) {
            this.saveStr = XAxisToolBar.this.XMinTextField.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.saveStr.compareTo(XAxisToolBar.this.XMinTextField.getText()) != 0) {
                XAxisToolBar.this.XMinTextField_actionPerformed(null);
            }
        }
    };
    protected FocusListener focusXMaxListener = new FocusAdapter(){
        String saveStr;

        public void focusGained(FocusEvent focusEvent) {
            this.saveStr = XAxisToolBar.this.XMaxTextField.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.saveStr.compareTo(XAxisToolBar.this.XMaxTextField.getText()) != 0) {
                XAxisToolBar.this.XMaxTextField_actionPerformed(null);
            }
        }
    };
    protected static final int FILE_VERSION = 1;

    void setOverplot(boolean bl) {
        this.overplot = bl;
    }

    boolean overplot() {
        return this.overplot;
    }

    protected void clearMode() {
        this.daily = false;
        this.weekly = false;
        this.monthly = false;
        this.yearly = false;
    }

    void setDaily() {
        this.clearMode();
        this.daily = true;
        this.newXMinMaxValues();
    }

    void setWeekly() {
        this.clearMode();
        this.weekly = true;
        this.newXMinMaxValues();
    }

    void setMonthly() {
        this.clearMode();
        this.monthly = true;
        this.newXMinMaxValues();
    }

    void setYearly() {
        this.clearMode();
        this.yearly = true;
        this.newXMinMaxValues();
    }

    int minYear() {
        return this.minYear;
    }

    int maxYear() {
        return this.maxYear;
    }

    int minData() {
        return this.minData;
    }

    int maxData() {
        return this.maxData;
    }

    void setDataRange(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.overplot) {
            n6 = 0;
            n5 = 0;
            n4 = 1;
            n3 = 366;
        } else {
            n6 = n;
            n5 = n2;
            n4 = 1;
            n3 = (1 + n5 - n6) * 366;
        }
        if (n6 != this.minYear || n5 != this.maxYear || n4 != this.minData || n3 != this.maxData) {
            this.minYear = n6;
            this.maxYear = n5;
            this.minData = n4;
            this.maxData = n3;
            this.newXMinMaxValues();
        }
    }

    void setPixelRange(int n, int n2) {
        if (this.leftPixel != n || this.rightPixel != n2) {
            this.leftPixel = n;
            this.rightPixel = n2;
            this.updateAB();
        }
    }

    int xMin() {
        return this.xMin;
    }

    int xMax() {
        return this.xMax;
    }

    void setXMinMax(int n, int n2) {
        this.xMin = n;
        this.xMax = n2;
        this.newXMinMaxValues();
    }

    XAxisToolBar(GraphFrame graphFrame) {
        this.setFloatable(false);
        this.lock = false;
        this.myFrame = graphFrame;
        this.ZoomInIcon = new ImageIcon(this.getClass().getResource("zoomin.gif"));
        this.ZoomOutIcon = new ImageIcon(this.getClass().getResource("zoomout.gif"));
        this.HorizArrow = new ImageIcon(this.getClass().getResource("horizarrow.gif"));
        this.setSize(0, 0);
        this.XMinLabel.setHorizontalAlignment(0);
        this.XMinLabel.setText("XMin: ");
        this.XMinLabel.setHorizontalAlignment(4);
        this.add(this.XMinLabel);
        this.XMinLabel.setForeground(Color.black);
        this.XMinLabel.setFont(new Font("Dialog", 0, 12));
        this.XMinLabel.setBounds(20, 0, 46, 25);
        this.XMinLabel.setPreferredSize(new Dimension(42, 20));
        this.XMinTextField.setColumns(8);
        this.add(this.XMinTextField);
        this.XMinTextField.setBounds(48, 0, 82, 20);
        this.XMinTextField.setPreferredSize(new Dimension(92, 20));
        this.XMinTextField.setMinimumSize(new Dimension(92, 20));
        this.XMinTextField.setMaximumSize(new Dimension(92, 20));
        this.XMaxLabel.setHorizontalAlignment(0);
        this.XMaxLabel.setText("XMax: ");
        this.add(this.XMaxLabel);
        this.XMaxLabel.setForeground(Color.black);
        this.XMaxLabel.setFont(new Font("Dialog", 0, 12));
        this.XMaxLabel.setHorizontalAlignment(4);
        this.XMaxLabel.setBounds(132, 0, 48, 25);
        this.XMaxLabel.setPreferredSize(new Dimension(42, 20));
        this.XMaxTextField.setColumns(8);
        this.XMaxTextField.setPreferredSize(new Dimension(92, 20));
        this.XMaxTextField.setMinimumSize(new Dimension(92, 20));
        this.XMaxTextField.setMaximumSize(new Dimension(92, 20));
        this.XMaxTextField.setBounds(180, 0, 83, 20);
        this.add(this.XMaxTextField);
        this.add(new JLabel("  "));
        this.add(this.XMouseLabel);
        this.XMouseLabel.setForeground(Color.black);
        this.XMouseLabel.setFont(new Font("Dialog", 0, 12));
        this.XMouseLabel.setBounds(255, 0, 100, 24);
        this.XMouseLabel.setPreferredSize(new Dimension(100, 25));
        this.XMouseLabel.setMinimumSize(new Dimension(100, 25));
        this.XYButton.setText("XY Plot");
        this.XYButton.setFont(new Font("Dialog", 0, 10));
        this.XYButton.setToolTipText("XY Scatter Plot");
        this.XYButton.setBounds(300, 0, 40, 25);
        this.XYButton.setPreferredSize(new Dimension(50, 25));
        this.add(this.XYButton);
        this.ScrollBar.setLocation(0, 330);
        this.ScrollBar.setMinimumSize(new Dimension(117, 25));
        this.ScrollBar.setMaximumSize(new Dimension(117, 25));
        this.ScrollBar.setPreferredSize(new Dimension(117, 25));
        this.add(this.ts);
        this.ZoomInButton.setFont(new Font("Dialog", 0, 12));
        this.ZoomInButton.setMinimumSize(new Dimension(25, 25));
        this.ZoomInButton.setMaximumSize(new Dimension(25, 25));
        this.ZoomInButton.setPreferredSize(new Dimension(25, 25));
        this.add(this.ZoomInButton);
        this.ZoomOutButton.setFont(new Font("Dialog", 0, 12));
        this.ZoomOutButton.setMinimumSize(new Dimension(25, 25));
        this.ZoomOutButton.setMaximumSize(new Dimension(25, 25));
        this.ZoomOutButton.setPreferredSize(new Dimension(25, 25));
        this.add(this.ZoomOutButton);
        this.ArrowLabel.setMinimumSize(new Dimension(23, 10));
        this.ArrowLabel.setMaximumSize(new Dimension(23, 10));
        this.ArrowLabel.setPreferredSize(new Dimension(23, 10));
        this.ArrowLabel.setIcon(this.HorizArrow);
        this.add(this.ArrowLabel);
        this.ScrollBar.setOrientation(0);
        this.ScrollBar.setToolTipText("X-Axis Scroll");
        this.ScrollBar.setMinimumSize(new Dimension(100, 17));
        this.ScrollBar.setMaximumSize(new Dimension(100, 17));
        this.ScrollBar.setPreferredSize(new Dimension(100, 17));
        this.add(this.ScrollBar);
        this.ZoomInButton.setIcon(this.ZoomInIcon);
        this.ZoomOutButton.setIcon(this.ZoomOutIcon);
        this.ZoomInButton.setToolTipText("Zoom In");
        this.ZoomOutButton.setToolTipText("Zoom Out");
        SymAction symAction = new SymAction();
        this.XMinTextField.addActionListener(symAction);
        this.XMaxTextField.addActionListener(symAction);
        this.ZoomInButton.addActionListener(symAction);
        this.ZoomOutButton.addActionListener(symAction);
        SymAdjustment symAdjustment = new SymAdjustment();
        this.ScrollBar.addAdjustmentListener(symAdjustment);
        this.RegressionButton.addActionListener(symAction);
        this.XYButton.addActionListener(symAction);
        this.ts.setPreferredSize(new Dimension(8, 25));
        this.ts.setOrientation(1);
        this.XMinTextField.addFocusListener(this.focusXMinListener);
        this.XMaxTextField.addFocusListener(this.focusXMaxListener);
        this.setMinimumSize(new Dimension(730, 25));
        this.setMaximumSize(new Dimension(730, 25));
        this.setPreferredSize(new Dimension(730, 25));
    }

    int xPixel(double d) {
        return (int)(this.a + this.b * d);
    }

    protected void updateAB() {
        this.a = 0.0;
        this.b = 0.0;
        if (this.xMin != this.xMax && this.leftPixel != this.rightPixel) {
            this.b = (double)(this.leftPixel - this.rightPixel) / (double)(this.xMin - this.xMax);
            this.a = (double)this.leftPixel - this.b * (double)this.xMin;
        }
        this.XMouseLabel.setText("");
        this.prodGraph();
    }

    protected void prodGraph() {
        this.myFrame.updateRanges();
    }

    protected void newXMinMaxValues() {
        if (this.xMin > this.xMax - 1) {
            this.xMin = this.xMax - 1;
        }
        if (this.xMin > this.maxData - 1 && this.xMax >= this.maxData) {
            this.xMax = this.maxData;
            this.xMin = this.xMax - 1;
        }
        if (this.xMin < this.minData && this.xMax < this.minData + 1) {
            this.xMin = this.minData;
            this.xMax = this.xMin + 1;
        }
        if (this.xMin < this.minData) {
            this.xMin = this.minData;
        }
        if (this.xMax > this.maxData) {
            this.xMax = this.maxData;
        }
        if (!this.daily) {
            this.xMin = this.roundToFirst(this.xMin);
            this.xMax = this.roundToLast(this.xMax);
        }
        this.XMinTextField.setText(this.xDate(this.xMin, true));
        this.XMaxTextField.setText(this.xDate(this.xMax, true));
        this.lock = true;
        this.firstYear = 1 + (this.xMin - 1) / 366;
        this.lastYear = 1 + (this.xMax - 1) / 366;
        if (this.daily) {
            this.ScrollBar.setValues(this.xMin, this.xMax - this.xMin, this.minData, this.maxData);
            this.ScrollBar.setBlockIncrement(1 + this.xMax - this.xMin);
        } else if (this.weekly) {
            this.firstWeek = this.getWeek(1 + (this.xMin - 1) % 366, this.minYear + this.firstYear - 1) + 53 * (this.firstYear - 1);
            this.lastWeek = this.getWeek(1 + (this.xMax - 1) % 366, this.minYear + this.lastYear - 1) + 53 * (this.lastYear - 1);
            this.ScrollBar.setValues(this.firstWeek, this.lastWeek - this.firstWeek, 1, (1 + this.maxYear - this.minYear) * 53);
            this.ScrollBar.setBlockIncrement(1 + this.lastWeek - this.firstWeek);
        } else if (this.monthly) {
            this.firstMonth = this.getMonth(1 + (this.xMin - 1) % 366) + 12 * (this.firstYear - 1);
            this.lastMonth = this.getMonth(1 + (this.xMax - 1) % 366) + 12 * (this.lastYear - 1);
            this.ScrollBar.setValues(this.firstMonth, this.lastMonth - this.firstMonth, 1, (1 + this.maxYear - this.minYear) * 12);
            this.ScrollBar.setBlockIncrement(1 + this.lastMonth - this.firstMonth);
        } else if (this.yearly) {
            this.ScrollBar.setValues(this.firstYear, this.lastYear - this.firstYear, 1, 1 + this.maxYear - this.minYear);
            this.ScrollBar.setBlockIncrement(1 + this.lastYear - this.firstYear);
        }
        this.ScrollBar.setUnitIncrement(1);
        this.lock = false;
        this.updateAB();
    }

    void ScrollBar_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.lock) {
            if (this.daily) {
                int n = this.xMax - this.xMin;
                this.xMin = this.ScrollBar.getValue();
                this.xMax = this.xMin + n;
            } else if (this.weekly) {
                int n = this.lastWeek - this.firstWeek;
                int n2 = this.ScrollBar.getValue();
                int n3 = (n2 - 1) / 53;
                n2 = 1 + (n2 - 1) % 53;
                this.xMin = n3 * 366 + this.weekBegins(n2, n3 + this.minYear);
                n2 = this.ScrollBar.getValue() + n;
                n3 = (n2 - 1) / 53;
                n2 = 1 + (n2 - 1) % 53;
                this.xMax = n3 * 366 + this.weekEnds(n2, n3 + this.minYear);
            } else if (this.monthly) {
                int n = this.lastMonth - this.firstMonth;
                int n4 = this.ScrollBar.getValue();
                int n5 = (n4 - 1) / 12;
                n4 = 1 + (n4 - 1) % 12;
                this.xMin = n5 * 366 + this.monthBegins(n4);
                n4 = this.ScrollBar.getValue() + n;
                n5 = (n4 - 1) / 12;
                n4 = 1 + (n4 - 1) % 12;
                this.xMax = n5 * 366 + this.monthEnds(n4);
            } else {
                int n = this.lastYear - this.firstYear;
                int n6 = this.ScrollBar.getValue();
                this.xMin = 1 + (n6 - 1) * 366;
                n6 = this.ScrollBar.getValue() + n;
                this.xMax = 366 * n6;
            }
            this.newXMinMaxValues();
        }
    }

    int roundToFirst(int n) {
        if (!this.daily) {
            int n2 = this.minYear + (n - 1) / 366;
            int n3 = 1 + (n - 1) % 366;
            if (this.weekly) {
                int n4 = this.getWeek(n3, n2);
                n = this.weekBegins(n4, n2) + (n2 - this.minYear) * 366;
            } else if (this.monthly) {
                int n5 = this.getMonth(n3);
                n = this.monthBegins(n5) + (n2 - this.minYear) * 366;
            } else if (this.yearly) {
                n = 1 + (n2 - this.minYear) * 366;
            }
        }
        return n;
    }

    int roundToLast(int n) {
        if (!this.daily) {
            int n2 = this.minYear + (n - 1) / 366;
            int n3 = 1 + (n - 1) % 366;
            if (this.weekly) {
                int n4 = this.getWeek(n3, n2);
                n = this.weekEnds(n4, n2) + (n2 - this.minYear) * 366;
            } else if (this.monthly) {
                int n5 = this.getMonth(n3);
                n = this.monthEnds(n5) + (n2 - this.minYear) * 366;
            } else if (this.yearly) {
                n = 366 + (n2 - this.minYear) * 366;
            }
        }
        return n;
    }

    public double valFromPixel(int n) {
        n = Math.max(n, this.leftPixel);
        n = Math.min(n, this.rightPixel);
        return ((double)n - this.a) / this.b;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.b != 0.0 && !this.myFrame.doXYPlot()) {
            int n = (int)Math.round(this.valFromPixel(mouseEvent.getX()));
            if (this.myFrame.JulianDateView.isSelected()) {
                this.XMouseLabel.setText(Integer.toString((n - 1) % 366 + 1));
            } else {
                this.XMouseLabel.setText(this.xDate(n, false));
            }
        } else {
            this.XMouseLabel.setText("");
        }
    }

    boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    int getWeek(int n, int n2) {
        if (!this.isLeapYear(n2) && n > 59) {
            --n;
        }
        return 1 + (n - 1) / 7;
    }

    int weekBegins(int n, int n2) {
        int n3 = 1 + (n - 1) * 7;
        if (!this.isLeapYear(n2) && n3 > 59) {
            ++n3;
        }
        return n3;
    }

    int weekEnds(int n, int n2) {
        return this.weekBegins(n + 1, n2) - 1;
    }

    int getMonth(int n) {
        int n2 = 0;
        n2 = n < 32 ? 1 : (n < 61 ? 2 : (n < 92 ? 3 : (n < 122 ? 4 : (n < 153 ? 5 : (n < 183 ? 6 : (n < 214 ? 7 : (n < 245 ? 8 : (n < 275 ? 9 : (n < 306 ? 10 : (n < 336 ? 11 : 12))))))))));
        return n2;
    }

    int monthBegins(int n) {
        if (n == 1) {
            return 1;
        }
        return this.monthEnds(n - 1) + 1;
    }

    int monthEnds(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 31;
                break;
            }
            case 2: {
                n2 = 60;
                break;
            }
            case 3: {
                n2 = 91;
                break;
            }
            case 4: {
                n2 = 121;
                break;
            }
            case 5: {
                n2 = 152;
                break;
            }
            case 6: {
                n2 = 182;
                break;
            }
            case 7: {
                n2 = 213;
                break;
            }
            case 8: {
                n2 = 244;
                break;
            }
            case 9: {
                n2 = 274;
                break;
            }
            case 10: {
                n2 = 305;
                break;
            }
            case 11: {
                n2 = 335;
                break;
            }
            case 12: {
                n2 = 366;
            }
        }
        return n2;
    }

    String xDate(double d, boolean bl) {
        String string;
        String string2;
        int n;
        int n2;
        int n3 = 0;
        int n4 = (int)Math.round(d);
        n4 = Math.max(n4, this.minData);
        n4 = Math.min(n4, this.maxData);
        if (!this.overplot) {
            n3 = this.minYear + --n4 / 366;
            n4 %= 366;
            ++n4;
        }
        if (n4 < 32) {
            n2 = 1;
            n = n4;
            string2 = "Jan ";
        } else if (n4 < 61) {
            n2 = 2;
            n = n4 - 31;
            string2 = "Feb ";
        } else if (n4 < 92) {
            n2 = 3;
            n = n4 - 60;
            string2 = "March ";
        } else if (n4 < 122) {
            n2 = 4;
            n = n4 - 91;
            string2 = "April ";
        } else if (n4 < 153) {
            n2 = 5;
            n = n4 - 121;
            string2 = "May ";
        } else if (n4 < 183) {
            n2 = 6;
            n = n4 - 152;
            string2 = "June ";
        } else if (n4 < 214) {
            n2 = 7;
            n = n4 - 182;
            string2 = "July ";
        } else if (n4 < 245) {
            n2 = 8;
            n = n4 - 213;
            string2 = "Aug ";
        } else if (n4 < 275) {
            n2 = 9;
            n = n4 - 244;
            string2 = "Sept ";
        } else if (n4 < 306) {
            n2 = 10;
            n = n4 - 274;
            string2 = "Oct ";
        } else if (n4 < 336) {
            n2 = 11;
            n = n4 - 305;
            string2 = "Nov ";
        } else {
            n2 = 12;
            n = n4 - 335;
            string2 = "Dec ";
        }
        if (this.daily) {
            if (this.overplot) {
                string = bl ? (this.myFrame.JulianDateView.isSelected() && this.myFrame.ViewAsTextItem.isSelected() ? Integer.toString(n4) : Integer.toString(n2) + "/" + Integer.toString(n)) : string2 + Integer.toString(n);
            } else {
                String string3 = Integer.toString(n3);
                string = bl ? (this.myFrame.JulianDateView.isSelected() && this.myFrame.ViewAsTextItem.isSelected() ? Integer.toString(n4) : Integer.toString(n2) + "/" + Integer.toString(n) + "/" + string3) : string2 + Integer.toString(n) + ", " + string3;
            }
        } else if (this.weekly) {
            String string4 = Integer.toString(this.getWeek(n4, n3));
            if (this.overplot) {
                string = bl ? string4 : "Week " + string4;
            } else {
                String string5 = Integer.toString(n3);
                string = bl ? string4 + "/" + string5.substring(string5.length() - 2) : "Week " + string4 + ", " + string5;
            }
        } else if (this.monthly) {
            if (this.overplot) {
                string = bl ? Integer.toString(n2) : string2;
            } else {
                String string6 = Integer.toString(n3);
                string = bl ? Integer.toString(n2) + "/" + string6.substring(string6.length() - 2) : string2 + string6;
            }
        } else {
            string = Integer.toString(n3);
        }
        return string;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    protected int getJulian(int n, int n2) {
        int n3 = -1;
        if ((n == 4 || n == 6 || n == 9 || n == 11) && n2 > 30) {
            n2 = 30;
        }
        if (n == 2 && n2 > 29) {
            n2 = 29;
        }
        if (n2 > 0) {
            switch (n) {
                case 1: {
                    if (n2 > 31) break;
                    n3 = n2;
                    break;
                }
                case 2: {
                    if (n2 > 29) break;
                    n3 = n2 + 31;
                    break;
                }
                case 3: {
                    if (n2 > 31) break;
                    n3 = n2 + 60;
                    break;
                }
                case 4: {
                    if (n2 > 30) break;
                    n3 = n2 + 91;
                    break;
                }
                case 5: {
                    if (n2 > 31) break;
                    n3 = n2 + 121;
                    break;
                }
                case 6: {
                    if (n2 > 30) break;
                    n3 = n2 + 152;
                    break;
                }
                case 7: {
                    if (n2 > 31) break;
                    n3 = n2 + 182;
                    break;
                }
                case 8: {
                    if (n2 > 31) break;
                    n3 = n2 + 213;
                    break;
                }
                case 9: {
                    if (n2 > 30) break;
                    n3 = n2 + 244;
                    break;
                }
                case 10: {
                    if (n2 > 31) break;
                    n3 = n2 + 274;
                    break;
                }
                case 11: {
                    if (n2 > 30) break;
                    n3 = n2 + 305;
                    break;
                }
                case 12: {
                    if (n2 > 31) break;
                    n3 = n2 + 335;
                }
            }
        }
        return n3;
    }

    protected int interpretText(JTextField jTextField) {
        String string = jTextField.getText();
        int n = -1;
        int n2 = string.indexOf(47);
        if (n2 >= 0) {
            n = string.indexOf(47, n2 + 1);
        }
        int n3 = this.minYear + (this.xMin - 1) / 366;
        try {
            if (n2 < 0 && n < 0) {
                int n4 = Integer.parseInt(string.trim());
                if (this.weekly) {
                    return 3 + this.weekBegins(n4, n3) + (n3 - this.minYear) * 366;
                }
                if (this.monthly) {
                    return 15 + this.monthBegins(n4) + (n3 - this.minYear) * 366;
                }
                if (this.yearly) {
                    if (n4 < 100) {
                        return 1 + (n4 + 100 * (this.minYear / 100) - this.minYear) * 366;
                    }
                    return 1 + (n4 - this.minYear) * 366;
                }
                return n4;
            }
            if (n2 >= 0 && n < 0) {
                int n5 = Integer.parseInt(string.substring(0, n2).trim());
                int n6 = Integer.parseInt(string.substring(n2 + 1).trim());
                if (this.daily) {
                    int n7 = this.getJulian(n5, n6);
                    if (n7 >= 0) {
                        return n7 + (n3 - this.minYear) * 366;
                    }
                } else {
                    if (this.weekly) {
                        n3 = n6 < 100 ? n6 + 100 * (this.minYear / 100) : n6;
                        return 3 + this.weekBegins(n5, n3) + (n3 - this.minYear) * 366;
                    }
                    if (this.monthly) {
                        n3 = n6 < 100 ? n6 + 100 * (this.minYear / 100) : n6;
                        return 15 + this.monthBegins(n5) + (n3 - this.minYear) * 366;
                    }
                }
            } else if (n2 >= 0 && n >= 0) {
                int n8 = Integer.parseInt(string.substring(0, n2).trim());
                int n9 = Integer.parseInt(string.substring(n2 + 1, n).trim());
                n3 = Integer.parseInt(string.substring(n + 1).trim());
                int n10 = this.getJulian(n8, n9);
                if (n3 < 100) {
                    n3 = n3 >= this.minYear % 100 ? (n3 += 100 * (this.minYear / 100)) : (n3 += 100 * (this.maxYear / 100));
                }
                if (n10 >= 0) {
                    return n10 + 366 * (n3 - this.minYear);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.daily) {
            JOptionPane.showMessageDialog(this, "Allowed date formats: one number, or MM/DD, or MM/DD/YY, or MM/DD/YYYY", "X Axis Tool Bar", 1);
        } else if (this.weekly) {
            JOptionPane.showMessageDialog(this, "Allowed date formats: one number, or WW, or WW/YY, or WW/YYYY", "X Axis Tool Bar", 1);
        } else if (this.monthly) {
            JOptionPane.showMessageDialog(this, "Allowed date formats: one number, or MM, or MM/YY, or MM/YYYY", "X Axis Tool Bar", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Allowed date formats: YY, or YYYY", "X Axis Tool Bar", 1);
        }
        return -1;
    }

    void XYButton_actionPerformed(ActionEvent actionEvent) {
        this.myFrame.XYPlotItem.setState(this.XYButton.isSelected());
        this.myFrame.XYPlotItem_actionPerformed(actionEvent);
    }

    void XMinTextField_actionPerformed(ActionEvent actionEvent) {
        int n = this.interpretText(this.XMinTextField);
        if (n >= 0) {
            this.xMin = n;
            this.newXMinMaxValues();
        }
    }

    void XMaxTextField_actionPerformed(ActionEvent actionEvent) {
        int n = this.interpretText(this.XMaxTextField);
        if (n >= 0) {
            this.xMax = n;
            this.newXMinMaxValues();
        }
    }

    void ZoomInButton_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.myFrame.addEdit(new undoAction("zoomin", this.myFrame, this));
        }
        double d = (double)(this.xMax - this.xMin) / 4.0;
        this.xMin = (int)((double)this.xMin + d);
        this.xMax = (int)((double)this.xMax - d);
        this.newXMinMaxValues();
    }

    void ZoomOutButton_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.myFrame.addEdit(new undoAction("zoomout", this.myFrame, this));
        }
        double d = (double)(this.xMax - this.xMin) / 2.0;
        this.xMin = (int)((double)this.xMin - d);
        this.xMax = (int)((double)this.xMax + d);
        this.newXMinMaxValues();
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeInt(this.xMin);
        objectOutputStream.writeInt(this.xMax);
        objectOutputStream.writeBoolean(this.overplot);
        objectOutputStream.writeBoolean(this.daily);
        objectOutputStream.writeBoolean(this.weekly);
        objectOutputStream.writeBoolean(this.monthly);
        objectOutputStream.writeBoolean(this.yearly);
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n > 1) {
            JOptionPane.showMessageDialog(this, "Perhaps you reinstall javaDART", "File version incompatible", 1);
            throw new IOException();
        }
        this.xMin = objectInputStream.readInt();
        this.xMax = objectInputStream.readInt();
        this.overplot = objectInputStream.readBoolean();
        this.daily = objectInputStream.readBoolean();
        this.weekly = objectInputStream.readBoolean();
        this.monthly = objectInputStream.readBoolean();
        this.yearly = objectInputStream.readBoolean();
    }

    class SymAdjustment
    implements AdjustmentListener {
        SymAdjustment() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            if (object == XAxisToolBar.this.ScrollBar) {
                XAxisToolBar.this.ScrollBar_adjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == XAxisToolBar.this.XMinTextField) {
                XAxisToolBar.this.XMinTextField_actionPerformed(actionEvent);
            } else if (object == XAxisToolBar.this.XMaxTextField) {
                XAxisToolBar.this.XMaxTextField_actionPerformed(actionEvent);
            } else if (object == XAxisToolBar.this.ZoomInButton) {
                XAxisToolBar.this.ZoomInButton_actionPerformed(actionEvent);
            } else if (object == XAxisToolBar.this.ZoomOutButton) {
                XAxisToolBar.this.ZoomOutButton_actionPerformed(actionEvent);
            } else if (object == XAxisToolBar.this.XYButton) {
                XAxisToolBar.this.XYButton_actionPerformed(actionEvent);
            }
        }
    }
}

