/*
 * Decompiled with CFR 0.152.
 */
package DartPackage;

import DartPackage.GraphFrame;
import DartPackage.PixelValueTransformer;
import DartPackage.SelectionObject;
import DartPackage.undoAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;

class YAxisToolBar
extends JToolBar
implements MouseMotionListener {
    protected GraphFrame myFrame;
    protected PixelValueTransformer trans = new PixelValueTransformer(false);
    protected String axisLabel = "";
    protected int precision = 0;
    protected NumberFormat nFormat = NumberFormat.getInstance();
    JComponent myComponent;
    protected JButton SwapXYButton = new JButton();
    JLabel SideLabel = new JLabel();
    JLabel YMinLabel = new JLabel();
    JTextField YMinTextField = new JTextField();
    JLabel YMaxLabel = new JLabel();
    JTextField YMaxTextField = new JTextField();
    JLabel YMouseLabel = new JLabel();
    JButton AutoScaleButton = new JButton();
    JButton UpButton = new JButton();
    JButton DownButton = new JButton();
    JButton RoundButton = new JButton();
    ImageIcon UpArrowIcon;
    ImageIcon DownArrowIcon;
    ImageIcon VertArrow;
    JLabel ArrowLabel = new JLabel();
    protected boolean listenToY = true;
    protected FocusListener focusYMinListener = new FocusAdapter(){
        String saveStr;

        public void focusGained(FocusEvent focusEvent) {
            this.saveStr = YAxisToolBar.this.YMinTextField.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.saveStr.compareTo(YAxisToolBar.this.YMinTextField.getText()) != 0) {
                YAxisToolBar.this.YMinTextField_actionPerformed(null);
            }
        }
    };
    protected FocusListener focusYMaxListener = new FocusAdapter(){
        String saveStr;

        public void focusGained(FocusEvent focusEvent) {
            this.saveStr = YAxisToolBar.this.YMaxTextField.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.saveStr.compareTo(YAxisToolBar.this.YMaxTextField.getText()) != 0) {
                YAxisToolBar.this.YMaxTextField_actionPerformed(null);
            }
        }
    };
    int intervalX1;
    int intervalX2;
    double intervalMinData;
    double intervalMaxData;
    protected static final int FILE_VERSION = 1;

    PixelValueTransformer trans() {
        return this.trans;
    }

    String axisLabel() {
        return this.axisLabel;
    }

    void setAxisLabel(String string) {
        String string2 = null;
        for (int i = 0; i < 4; ++i) {
            LinkedList linkedList;
            if (this.myFrame.yToolBar(i) != this || (linkedList = this.myFrame.soList[i]).isEmpty()) continue;
            string2 = SelectionObject.unitsShortStr(((SelectionObject)linkedList.getFirst()).axisType());
        }
        this.axisLabel = string;
        if (string2 == null || string.toUpperCase().indexOf(string2.toUpperCase()) != -1) {
            this.SideLabel.setText(string);
        } else {
            this.SideLabel.setText(string + " (" + string2 + ")");
        }
    }

    double minData() {
        return this.trans.minData();
    }

    double maxData() {
        return this.trans.maxData();
    }

    private int topPixel() {
        return this.trans.pixelStart();
    }

    private int bottomPixel() {
        return this.trans.pixelEnd();
    }

    public double yMin() {
        return this.trans.viewMin();
    }

    public double yMax() {
        return this.trans.viewMax();
    }

    int yPixel(double d) {
        return this.trans.pixel(d);
    }

    void setDataRange(double d, double d2) {
        if (this.trans.setDataRange(d, d2) && !this.AutoScaleButton.isSelected()) {
            this.setYMinMax(this.minData(), this.maxData());
        }
    }

    void setPixelRange(int n, int n2) {
        if (this.trans.setPixelRange(n, n2)) {
            this.updateTrans();
        }
    }

    void setYMinMax(double d, double d2) {
        this.trans.setViewMinMax(d, d2);
        this.updateTrans();
    }

    void setPrecision(int n) {
        this.precision = Math.max(0, Math.min(10, n));
        this.nFormat.setMaximumFractionDigits(n);
    }

    int precision() {
        return this.precision;
    }

    String formatValue(double d) {
        if (this.precision > 0 || Math.abs(d) >= 9.223372036854776E18) {
            return this.nFormat.format(d);
        }
        return this.nFormat.format(Math.round(d));
    }

    YAxisToolBar(GraphFrame graphFrame) {
        this.myFrame = graphFrame;
        this.setLayout(new BoxLayout(this, 0));
        this.UpArrowIcon = new ImageIcon(this.getClass().getResource("zoomin.gif"));
        this.DownArrowIcon = new ImageIcon(this.getClass().getResource("zoomout.gif"));
        this.VertArrow = new ImageIcon(this.getClass().getResource("vertarrow.gif"));
        this.setMargin(new Insets(2, 10, 2, 2));
        this.SideLabel.setText("?");
        this.add(this.SideLabel);
        this.SideLabel.setForeground(Color.black);
        this.SideLabel.setFont(new Font("Dialog", 0, 12));
        this.SideLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.SideLabel.setPreferredSize(new Dimension(96, 15));
        this.SideLabel.setMinimumSize(new Dimension(96, 15));
        this.SideLabel.setMaximumSize(new Dimension(96, 15));
        this.YMinLabel.setText("YMin: ");
        this.add(this.YMinLabel);
        this.YMinLabel.setForeground(Color.black);
        this.YMinLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.YMinLabel.setFont(new Font("Dialog", 0, 12));
        this.YMinLabel.setPreferredSize(new Dimension(39, 15));
        this.YMinTextField.setColumns(10);
        this.add(this.YMinTextField);
        this.YMinTextField.setPreferredSize(new Dimension(110, 19));
        this.YMaxLabel.setText("YMax: ");
        this.add(this.YMaxLabel);
        this.YMaxLabel.setForeground(Color.black);
        this.YMaxLabel.setFont(new Font("Dialog", 0, 12));
        this.YMaxLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.YMinLabel.setPreferredSize(new Dimension(39, 15));
        this.YMaxTextField.setColumns(10);
        this.add(this.YMaxTextField);
        this.YMaxTextField.setPreferredSize(new Dimension(110, 19));
        this.YMaxTextField.setMaximumSize(new Dimension(110, 19));
        this.YMinTextField.setMaximumSize(new Dimension(110, 19));
        this.YMaxTextField.setMinimumSize(new Dimension(75, 19));
        this.YMinTextField.setMinimumSize(new Dimension(75, 19));
        this.add(this.YMouseLabel);
        this.YMouseLabel.setOpaque(true);
        this.YMouseLabel.setForeground(Color.black);
        this.YMouseLabel.setFont(new Font("Dialog", 0, 12));
        this.YMouseLabel.setPreferredSize(new Dimension(75, 15));
        this.YMouseLabel.setMinimumSize(new Dimension(75, 15));
        this.YMouseLabel.setMaximumSize(new Dimension(75, 15));
        this.AutoScaleButton.setToolTipText("Auto Scale Axis");
        this.AutoScaleButton.setText("AutoScale");
        this.AutoScaleButton.setFont(new Font("Dialog", 0, 10));
        this.AutoScaleButton.setMargin(new Insets(5, 0, 5, 0));
        this.add(this.AutoScaleButton);
        this.RoundButton.setText("Round");
        this.RoundButton.setMargin(new Insets(5, 0, 5, 0));
        this.RoundButton.setActionCommand("Rnd");
        this.RoundButton.setToolTipText("Round Axis Bounds");
        this.add(this.RoundButton);
        this.RoundButton.setFont(new Font("Dialog", 0, 10));
        this.RoundButton.setPreferredSize(new Dimension(38, 25));
        this.addSeparator();
        this.AutoScaleButton.setPreferredSize(new Dimension(40, 25));
        this.ArrowLabel.setPreferredSize(new Dimension(36, 25));
        this.ArrowLabel.setMinimumSize(new Dimension(36, 25));
        this.ArrowLabel.setIcon(this.VertArrow);
        this.add(this.ArrowLabel);
        this.add(this.UpButton);
        this.UpButton.setFont(new Font("Dialog", 0, 12));
        this.UpButton.setPreferredSize(new Dimension(25, 25));
        this.UpButton.setToolTipText("Axis Zoom In");
        this.add(this.DownButton);
        this.DownButton.setFont(new Font("Dialog", 0, 12));
        this.DownButton.setPreferredSize(new Dimension(25, 25));
        this.DownButton.setToolTipText("Axis Zoom Out");
        this.addSeparator();
        this.setFloatable(false);
        this.setOrientation(0);
        this.DownButton.setIcon(this.DownArrowIcon);
        this.UpButton.setIcon(this.UpArrowIcon);
        this.SwapXYButton.setMargin(new Insets(0, 0, 0, 0));
        this.SwapXYButton.setToolTipText("Swap XY Axes");
        this.SwapXYButton.setHorizontalTextPosition(0);
        this.SwapXYButton.setText("Swap");
        this.SwapXYButton.setPreferredSize(new Dimension(30, 25));
        this.SwapXYButton.setMinimumSize(new Dimension(30, 25));
        this.SwapXYButton.setMaximumSize(new Dimension(30, 25));
        this.SwapXYButton.setSize(30, 25);
        this.SwapXYButton.setFont(new Font("Dialog", 0, 9));
        this.add(this.SwapXYButton);
        if (!this.myFrame.doXYPlot()) {
            this.SwapXYButton.setEnabled(false);
        }
        SymAction symAction = new SymAction();
        this.UpButton.addActionListener(symAction);
        this.SwapXYButton.addActionListener(symAction);
        this.DownButton.addActionListener(symAction);
        this.YMinTextField.addActionListener(symAction);
        this.YMaxTextField.addActionListener(symAction);
        this.AutoScaleButton.addActionListener(symAction);
        this.RoundButton.addActionListener(symAction);
        this.YMinTextField.addFocusListener(this.focusYMinListener);
        this.YMaxTextField.addFocusListener(this.focusYMaxListener);
        this.setOpaque(true);
        this.nFormat.setGroupingUsed(false);
        this.setMinimumSize(new Dimension(690, 26));
        this.setMaximumSize(new Dimension(690, 26));
        this.setPreferredSize(new Dimension(690, 26));
    }

    protected void updateTrans() {
        this.YMouseLabel.setText("");
        this.YMinTextField.setText(this.formatValue(this.yMin()));
        this.YMaxTextField.setText(this.formatValue(this.yMax()));
        this.prodGraph();
    }

    void enableXYSwap(boolean bl, boolean bl2) {
        this.SwapXYButton.setEnabled(bl);
        this.SwapXYButton.setVisible(bl2);
    }

    protected void prodGraph() {
        this.myFrame.prodGraph();
    }

    void setListenToY(boolean bl) {
        this.listenToY = bl;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.trans.b() != 0.0) {
            int n = this.listenToY ? mouseEvent.getY() : mouseEvent.getX();
            if (this.topPixel() > this.bottomPixel()) {
                n = Math.min(n, this.topPixel());
                n = Math.max(n, this.bottomPixel());
            } else {
                n = Math.max(n, this.topPixel());
                n = Math.min(n, this.bottomPixel());
            }
            this.YMouseLabel.setText(this.formatValue(this.trans.valueFromPixel(n)));
        } else {
            this.YMouseLabel.setText("");
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    void SwapXYButton_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.myFrame.addEdit(new undoAction("swapxy", this.myFrame, this));
        }
        this.myFrame.SwapXYPlot(this);
    }

    void UpButton_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.myFrame.addEdit(new undoAction("zoomin", this.myFrame, this));
        }
        this.trans.zoomIn();
        this.updateTrans();
    }

    void DownButton_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.myFrame.addEdit(new undoAction("zoomout", this.myFrame, this));
        }
        this.trans.zoomOut();
        this.updateTrans();
    }

    void YMinTextField_actionPerformed(ActionEvent actionEvent) {
        this.AutoScaleButton.setSelected(true);
        try {
            this.setYMinMax(Double.valueOf(this.YMinTextField.getText()), this.yMax());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void YMaxTextField_actionPerformed(ActionEvent actionEvent) {
        this.AutoScaleButton.setSelected(true);
        try {
            this.setYMinMax(this.yMin(), Double.valueOf(this.YMaxTextField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void calculateIntervalExtrema() {
        int n;
        int n2 = this.myFrame.xToolBar.xMin();
        int n3 = this.myFrame.xToolBar.xMax();
        if (this.intervalX1 == n2 && this.intervalX2 == n3) {
            return;
        }
        this.intervalX1 = n2;
        this.intervalX2 = n3;
        for (n = 0; n < 4 && this.myFrame.yToolBar(n) != this; ++n) {
        }
        double[] dArray = new double[2];
        ListIterator listIterator = this.myFrame.soList(n).listIterator(0);
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        while (listIterator.hasNext()) {
            SelectionObject selectionObject = (SelectionObject)listIterator.next();
            selectionObject.extrema(n2, n3, dArray);
            if (this.myFrame.HistogramItem.isSelected() || selectionObject.accumulate()) {
                this.myFrame.graphComponent.getLimits(selectionObject, dArray);
                d = Math.min(d, dArray[0]);
                d2 = Math.max(d2, dArray[1]);
                continue;
            }
            d = Math.min(d, dArray[0]);
            d2 = Math.max(d2, dArray[1]);
        }
        if (d > d2) {
            d = 0.0;
            d2 = 0.0;
        }
        this.intervalMinData = d;
        this.intervalMaxData = d2;
    }

    void scalePixelValueTransformer(PixelValueTransformer pixelValueTransformer) {
        this.calculateIntervalExtrema();
        pixelValueTransformer.setViewMinMax(this.intervalMinData, this.intervalMaxData);
    }

    void AutoScaleButton_stateChanged(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.myFrame.addEdit(new undoAction("fix", this.myFrame, this));
        }
        this.scalePixelValueTransformer(this.trans);
        this.updateTrans();
    }

    void unround() {
        this.trans.unround();
        this.updateTrans();
    }

    void round() {
        this.trans.round();
        this.updateTrans();
    }

    void RoundButton_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.myFrame.addEdit(new undoAction("round", this.myFrame, this));
        }
        this.round();
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeDouble(this.yMin());
        objectOutputStream.writeDouble(this.yMax());
        objectOutputStream.writeBoolean(this.AutoScaleButton.isSelected());
        objectOutputStream.writeBoolean(this.listenToY);
        objectOutputStream.writeInt(this.precision);
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n > 1) {
            JOptionPane.showMessageDialog(this, "Perhaps you reinstall javaDART", "File version incompatible", 1);
            throw new IOException();
        }
        this.setYMinMax(objectInputStream.readDouble(), objectInputStream.readDouble());
        this.AutoScaleButton.setSelected(objectInputStream.readBoolean());
        this.listenToY = objectInputStream.readBoolean();
        this.precision = objectInputStream.readInt();
        this.nFormat.setMaximumFractionDigits(this.precision);
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == YAxisToolBar.this.UpButton) {
                YAxisToolBar.this.UpButton_actionPerformed(actionEvent);
            } else if (object == YAxisToolBar.this.DownButton) {
                YAxisToolBar.this.DownButton_actionPerformed(actionEvent);
            } else if (object == YAxisToolBar.this.YMinTextField) {
                YAxisToolBar.this.YMinTextField_actionPerformed(actionEvent);
            } else if (object == YAxisToolBar.this.YMaxTextField) {
                YAxisToolBar.this.YMaxTextField_actionPerformed(actionEvent);
            } else if (object == YAxisToolBar.this.SwapXYButton) {
                YAxisToolBar.this.SwapXYButton_actionPerformed(actionEvent);
            } else if (object == YAxisToolBar.this.AutoScaleButton) {
                YAxisToolBar.this.AutoScaleButton_stateChanged(actionEvent);
            } else if (object == YAxisToolBar.this.RoundButton) {
                YAxisToolBar.this.RoundButton_actionPerformed(actionEvent);
            }
        }
    }
}

