/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.dam;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.dam.TlConst;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.TraceLog;
import com.ingres.gcf.util.Tracing;
import java.net.InetAddress;
import java.net.Socket;

class MsgIo
implements GcfErr,
TlConst,
MsgConst {
    public static final String DAM_ML_TRACE_ID = "msg";
    protected Socket socket = null;
    protected CharSet char_set = null;
    protected byte msg_proto_lvl = 1;
    protected byte tl_proto_lvl = 1;
    protected String title = null;
    protected Tracing trace;
    private int conn_id = connections++;
    private static int connections = 0;

    protected MsgIo(String string, TraceLog traceLog) throws SqlEx {
        this.trace = new Tracing(traceLog, DAM_ML_TRACE_ID);
        this.title = "MsgIo[" + this.conn_id + "]";
        if (this.trace.enabled(2)) {
            this.trace.write(this.title + ": opening network connection");
        }
        try {
            String string2 = this.getHost(string);
            int n = this.getPort(string);
            InetAddress inetAddress = InetAddress.getByName(string2);
            if (this.trace.enabled(3)) {
                this.trace.write(this.title + ": " + string + " -> " + inetAddress + "," + n);
            }
            this.socket = new Socket(inetAddress, n);
        }
        catch (SqlEx sqlEx) {
            throw sqlEx;
        }
        catch (Exception exception) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": connection error - " + exception.getMessage());
            }
            throw SqlEx.get(GcfErr.ERR_GC4001_CONNECT_ERR, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.socket != null) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.title + ": closing network connection");
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected void disconnect() {
        this.close();
    }

    public void abort() {
        this.close();
    }

    public boolean isClosed() {
        return this.socket == null;
    }

    public boolean isLocal() {
        return this.socket == null ? false : this.socket.getInetAddress().equals(this.socket.getLocalAddress());
    }

    public int connID() {
        return this.conn_id;
    }

    public String getRemoteHost() {
        String string;
        try {
            string = this.socket.getInetAddress().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getLocalHost() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getLocalAddr() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public byte setProtocolLevel(byte by) {
        byte by2 = this.msg_proto_lvl;
        this.msg_proto_lvl = by;
        return by2;
    }

    public CharSet getCharSet() {
        return this.char_set;
    }

    private String getHost(String string) {
        int n = string.indexOf(58);
        return n < 0 ? string : string.substring(0, n);
    }

    private int getPort(String string) throws SqlEx {
        int n = string.indexOf(58);
        if (n < 0 || string.length() <= ++n) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": port number missing '" + string + "'");
            }
            throw SqlEx.get(GcfErr.ERR_GC4000_BAD_URL);
        }
        String string2 = string.substring(n);
        int n2 = this.translatePortID(string2);
        if (n2 < 0) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.title + ": invalid port '" + string2 + "'");
            }
            throw SqlEx.get(GcfErr.ERR_GC4000_BAD_URL);
        }
        return n2;
    }

    private int translatePortID(String string) {
        int n;
        if (string.length() == 2 || string.length() == 3) {
            char c;
            char c2 = string.charAt(0);
            char c3 = string.charAt(1);
            char c4 = c = string.length() == 3 ? (char)string.charAt(2) : (char)'0';
            if (Character.isLetter(c2) && Character.isLetterOrDigit(c3) && Character.isDigit(c)) {
                c2 = Character.toUpperCase(c2);
                c3 = Character.toUpperCase(c3);
                return 0x4000 | (c2 & 0x1F) << 9 | (c3 & 0x3F) << 3 | c & 7;
            }
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }
}

