/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConn;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.DrvPrep;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Random;

class DrvConn
implements DrvConst,
MsgConst,
DbmsConst,
GcfErr {
    public MsgConn msg = null;
    public JdbcConn jdbc = null;
    public DrvTrace trace = null;
    public DbCaps dbCaps = null;
    public DbInfo dbInfo = null;
    public String driverName = "Ingres JDBC Driver";
    public String protocol = "?";
    public String host = null;
    public String database = null;
    public byte msg_protocol_level = 1;
    public byte db_protocol_level = 1;
    public byte[] session_mask = new byte[8];
    public boolean is_dtmc = false;
    public boolean is_ingres = true;
    public boolean use_gmt_tz = true;
    public boolean ingres_tz = false;
    public boolean ucs2_supported = false;
    public boolean select_loops = false;
    public int cursor_mode = 0;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public int max_char_len = 2000;
    public int max_vchr_len = 2000;
    public int max_byte_len = 2000;
    public int max_vbyt_len = 2000;
    public int max_nchr_len = 1000;
    public int max_nvch_len = 1000;
    private Hashtable prepStmts = new Hashtable();
    private int tran_id = 0;
    private int obj_id = 0;
    private String tr_id = "Conn";

    public DrvConn(String string, Config config, DrvTrace drvTrace, boolean bl) throws SqlEx {
        this.host = string;
        this.trace = drvTrace;
        CharSet charSet = null;
        String string2 = config.get("char_encode");
        if (string2 != null && string2.length() > 0) {
            try {
                charSet = new CharSet(string2);
            }
            catch (Exception exception) {
                if (drvTrace.enabled(1)) {
                    drvTrace.write(this.tr_id + ": invalid character encoding '" + string2 + "'");
                }
                throw SqlEx.get(GcfErr.ERR_GC4009_BAD_CHARSET);
            }
        }
        new Random(System.currentTimeMillis()).nextBytes(this.session_mask);
        this.connect(charSet, bl);
    }

    private void connect(CharSet charSet, boolean bl) throws SqlEx {
        int n;
        byte[][] byArrayArray = new byte[1][];
        boolean bl2 = false;
        int n2 = 3;
        n2 += 2 + this.session_mask.length;
        if (bl) {
            n2 += 2;
        }
        byArrayArray[0] = new byte[n2];
        n2 = 0;
        byArrayArray[0][n2++] = 1;
        byArrayArray[0][n2++] = 1;
        byArrayArray[0][n2++] = 4;
        byArrayArray[0][n2++] = 3;
        byArrayArray[0][n2++] = (byte)this.session_mask.length;
        for (n = 0; n < this.session_mask.length; ++n) {
            byArrayArray[0][n2++] = this.session_mask[n];
        }
        if (bl) {
            byArrayArray[0][n2++] = 2;
            byArrayArray[0][n2++] = 0;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": Connecting to server: " + this.host);
        }
        this.msg = new MsgConn(this.host, byArrayArray, charSet, this.trace.getTraceLog());
        this.tr_id = this.tr_id + "[" + this.msg.connID() + "]";
        try {
            n = 0;
            block8: while (n < byArrayArray[0].length - 1) {
                byte by = byArrayArray[0][n++];
                byte by2 = byArrayArray[0][n++];
                switch (by) {
                    case 1: {
                        if (by2 != 1 || n >= byArrayArray[0].length) {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid PROTO param length: " + by2 + "," + (byArrayArray[0].length - n));
                            }
                            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                        }
                        this.msg_protocol_level = byArrayArray[0][n++];
                        this.msg.setProtocolLevel(this.msg_protocol_level);
                        continue block8;
                    }
                    case 2: {
                        if (by2 != 0) {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid DTMC param length: " + by2);
                            }
                            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                        }
                        this.is_dtmc = true;
                        continue block8;
                    }
                    case 3: {
                        if (by2 != this.session_mask.length) {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid mask param length: " + by2);
                            }
                            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                        }
                        int n3 = 0;
                        while (n3 < this.session_mask.length) {
                            int n4 = n3++;
                            this.session_mask[n4] = (byte)(this.session_mask[n4] ^ byArrayArray[0][n]);
                            ++n;
                        }
                        bl2 = true;
                        continue block8;
                    }
                }
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Invalid param ID: " + by);
                }
                throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
            }
            if (this.msg_protocol_level < 1 || this.msg_protocol_level > 4) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Invalid MSG protocol: " + this.msg_protocol_level);
                }
                throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
            }
            if (!bl2) {
                this.session_mask = null;
            }
            if (this.is_dtmc) {
                if (!bl) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": DTM connection not requested!");
                    }
                    throw SqlEx.get(GcfErr.ERR_GC4001_CONNECT_ERR);
                }
                if (this.msg_protocol_level < 2) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": 2PC not supported");
                    }
                    throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
                }
                this.autoCommit = false;
            } else if (bl) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": Could not establish DTM connection!");
                }
                throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
            }
        }
        catch (SqlEx sqlEx) {
            this.msg.close();
            throw sqlEx;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": connected to server");
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": messaging protocol initialized:");
                this.trace.write("    MSG protocol: " + this.msg_protocol_level);
                if (this.is_dtmc) {
                    this.trace.write("    DTM Connection");
                }
                if (this.session_mask != null) {
                    this.trace.write("    Session mask: " + this.session_mask.length + " bytes");
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (!this.msg.isClosed()) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": Disconnecting from server ");
            }
            this.msg.close();
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ": disconnected from server");
            }
        }
    }

    public synchronized void endXact() {
        if (this.trace.enabled(4)) {
            this.trace.write(this.tr_id + ": end of transaction");
        }
        ++this.tran_id;
        this.obj_id = 0;
        this.clearPrepStmts();
    }

    public int getXactID() {
        return this.tran_id;
    }

    public synchronized String getUniqueID(String string) {
        return new String(string + Integer.toHexString(this.tran_id) + "_" + Integer.toHexString(this.obj_id++));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrvPrep getPrepStmt(String string) throws SqlEx {
        DrvPrep drvPrep;
        Hashtable hashtable = this.prepStmts;
        synchronized (hashtable) {
            drvPrep = (DrvPrep)this.prepStmts.get(string);
            if (drvPrep == null) {
                drvPrep = new DrvPrep(this, string);
                this.prepStmts.put(string, drvPrep);
            }
        }
        return drvPrep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPrepStmts() {
        Hashtable hashtable = this.prepStmts;
        synchronized (hashtable) {
            this.prepStmts.clear();
        }
    }

    public void loadDbCaps() throws SqlEx {
        this.dbInfo = new DbInfo(this);
        this.dbCaps = new DbCaps(this);
        this.dbCaps.loadDbCaps();
        String string = this.dbCaps.getDbCap(this.msg_protocol_level < 3 ? "JDBC_CONNECT_LEVEL" : "DBMS_CONNECT_LEVEL");
        if (string != null) {
            try {
                this.db_protocol_level = Byte.parseByte(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("DBMS_TYPE")) != null) {
            this.is_ingres = string.equalsIgnoreCase("INGRES");
        }
        if ((string = this.dbCaps.getDbCap("OPEN_SQL_DATES")) != null) {
            this.use_gmt_tz = false;
        }
        if ((string = this.dbCaps.getDbCap("NATIONAL_CHARACTER_SET")) != null && string.length() >= 1) {
            boolean bl = this.ucs2_supported = string.charAt(0) == 'Y' || string.charAt(0) == 'y';
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_CHAR_COLUMN_LEN")) != null) {
            try {
                this.max_char_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_VCHR_COLUMN_LEN")) != null) {
            try {
                this.max_vchr_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_BYTE_COLUMN_LEN")) != null) {
            try {
                this.max_byte_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_VBYT_COLUMN_LEN")) != null) {
            try {
                this.max_vbyt_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = this.dbCaps.getDbCap("SQL_MAX_NCHAR_COLUMN_LEN")) == null) {
            this.max_nchr_len = this.max_char_len / 2;
        } else {
            try {
                this.max_nchr_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = this.dbCaps.getDbCap("SQL_MAX_NVCHR_COLUMN_LEN");
        if (string == null) {
            this.max_nvch_len = this.max_vchr_len / 2;
        } else {
            try {
                this.max_nvch_len = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class DbInfo
    extends DrvObj
    implements DrvConst,
    MsgConst {
        private JdbcRSMD rsmd = null;
        private String request_result;

        public DbInfo(DrvConn drvConn) {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-DbInfo[" + this.msg.connID() + "]";
            this.tr_id = "DbInfo[" + this.msg.connID() + "]";
        }

        public String getDbmsInfo(String string) throws SqlEx {
            String string2 = this.conn.msg_protocol_level >= 2 ? this.requestDbInfo(string) : this.selectDbInfo(string);
            return string2;
        }

        private String selectDbInfo(String string) throws SqlEx {
            String string2 = null;
            try {
                ResultSet resultSet;
                JdbcStmt jdbcStmt = new JdbcStmt(this.conn, 1003, 0, 2);
                String string3 = "select dbmsinfo('" + string + "')";
                if (!this.conn.is_ingres) {
                    string3 = string3 + " from iidbconstants";
                }
                if ((resultSet = jdbcStmt.executeQuery(string3)).next()) {
                    string2 = resultSet.getString(1);
                }
                resultSet.close();
                jdbcStmt.close();
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": error retrieving dbmsinfo()");
                }
                throw (SqlEx)sQLException;
            }
            return string2;
        }

        private String requestDbInfo(String string) throws SqlEx {
            String string2;
            this.msg.lock();
            this.request_result = null;
            try {
                this.msg.begin((byte)10);
                this.msg.write((short)3);
                this.msg.write((short)3);
                this.msg.write(string);
                this.msg.done(true);
                this.readResults();
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": error requesting dbmsinfo()");
                }
                throw sqlEx;
            }
            finally {
                String string3 = this.request_result;
                this.msg.unlock();
            }
            return string2;
        }

        protected JdbcRSMD readDesc() throws SqlEx {
            if (this.rsmd == null) {
                this.rsmd = JdbcRSMD.load(this.conn);
            } else {
                this.rsmd.reload(this.conn);
            }
            return this.rsmd;
        }

        protected boolean readData() throws SqlEx {
            if (this.msg.moreData()) {
                this.msg.readByte();
                this.request_result = this.msg.readString();
            }
            return false;
        }
    }

    static class DbCaps
    extends DrvObj {
        private JdbcRSMD rsmd = null;
        private Hashtable caps = new Hashtable();

        public DbCaps(DrvConn drvConn) throws SqlEx {
            super(drvConn);
            this.title = this.trace.getTraceName() + "-DbCaps[" + this.msg.connID() + "]";
            this.tr_id = "DbCap[" + this.msg.connID() + "]";
        }

        public String getDbCap(String string) {
            return (String)this.caps.get(string);
        }

        public void loadDbCaps() throws SqlEx {
            this.msg.lock();
            try {
                this.msg.begin((byte)10);
                this.msg.write((short)1);
                this.msg.done(true);
                this.readResults();
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.log(this.title + ": error loading DBMS capabilities");
                }
                throw sqlEx;
            }
            finally {
                this.msg.unlock();
            }
        }

        protected JdbcRSMD readDesc() throws SqlEx {
            if (this.rsmd == null) {
                this.rsmd = JdbcRSMD.load(this.conn);
            } else {
                this.rsmd.reload(this.conn);
            }
            return this.rsmd;
        }

        protected boolean readData() throws SqlEx {
            while (this.msg.moreData()) {
                this.msg.readByte();
                String string = this.msg.readString();
                this.msg.readByte();
                String string2 = this.msg.readString();
                if (this.trace.enabled(4)) {
                    this.trace.write(this.tr_id + ": '" + string + "' = '" + string2 + "'");
                }
                this.caps.put(string, string2);
            }
            return false;
        }
    }
}

