/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConn;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlWarn;
import java.sql.SQLException;
import java.sql.SQLWarning;

class DrvObj
implements DrvConst,
MsgConst,
GcfErr {
    protected DrvConn conn = null;
    protected MsgConn msg = null;
    protected DrvTrace trace = null;
    protected String title = null;
    protected String tr_id = null;
    protected int inst_id = 0;
    protected int rslt_flags = 0;
    protected boolean rslt_rowcount = false;
    protected boolean rslt_prefetch = false;
    protected boolean rslt_stmt_id = false;
    protected boolean rslt_proc_val = false;
    protected boolean rslt_tblkey = false;
    protected boolean rslt_objkey = false;
    protected long rslt_val_stmt = 0L;
    protected int rslt_val_rows = 0;
    protected int rslt_val_fetch = 0;
    protected int rslt_val_proc = 0;
    protected byte[] rslt_val_tblkey = null;
    protected byte[] rslt_val_objkey = null;
    protected SQLWarning warnings = null;
    private static int inst_count = 0;

    protected DrvObj(DrvConn drvConn) {
        this.conn = drvConn;
        this.msg = drvConn.msg;
        this.trace = drvConn.trace;
        this.inst_id = inst_count++;
        this.title = this.trace.getTraceName() + "[" + this.inst_id + "]";
        this.tr_id = "Jdbc[" + this.inst_id + "]";
    }

    public String toString() {
        return this.title;
    }

    protected boolean timeValuesInGMT() {
        return this.conn.use_gmt_tz || this.conn.ingres_tz;
    }

    protected boolean timeLiteralsInGMT() {
        return this.conn.use_gmt_tz && !this.conn.ingres_tz;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getWarnings()");
        }
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".clearWarnings()");
        }
        this.warnings = null;
    }

    protected void setWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    protected void clearResults() {
        this.warnings = null;
        this.rslt_flags = 0;
        this.rslt_rowcount = false;
        this.rslt_val_rows = 0;
        this.rslt_prefetch = false;
        this.rslt_val_fetch = 0;
        this.rslt_stmt_id = false;
        this.rslt_val_stmt = 0L;
        this.rslt_proc_val = false;
        this.rslt_val_proc = 0;
        this.rslt_tblkey = false;
        this.rslt_objkey = false;
    }

    protected JdbcRSMD readResults() throws SqlEx {
        JdbcRSMD jdbcRSMD;
        SqlEx sqlEx;
        block14: {
            sqlEx = null;
            jdbcRSMD = null;
            try {
                do {
                    byte by = this.msg.receive();
                    switch (by) {
                        case 6: {
                            jdbcRSMD = this.readDesc();
                            break;
                        }
                        case 7: {
                            if (!this.readData()) break;
                            break block14;
                        }
                        case 8: {
                            SqlEx sqlEx2 = this.readError();
                            if (sqlEx == null) {
                                sqlEx = sqlEx2;
                                break;
                            }
                            if (sqlEx2 == null) break;
                            sqlEx.setNextException(sqlEx2);
                            break;
                        }
                        case 9: {
                            if (!this.readResult()) break;
                            break block14;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid message ID " + by);
                            }
                            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    if (!this.msg.moreData()) continue;
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": end-of-message not reached");
                    }
                    throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                } while (this.msg.moreMessages());
            }
            catch (SqlEx sqlEx3) {
                if (sqlEx == null) {
                    sqlEx = sqlEx3;
                }
                sqlEx.setNextException(sqlEx3);
            }
        }
        if (sqlEx != null) {
            throw sqlEx;
        }
        return jdbcRSMD;
    }

    protected JdbcRSMD readDesc() throws SqlEx {
        if (this.trace.enabled(1)) {
            this.trace.write(this.tr_id + ": unexpected result set");
        }
        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
    }

    protected boolean readData() throws SqlEx {
        if (this.trace.enabled(1)) {
            this.trace.write(this.tr_id + ": unexpected result data.");
        }
        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
    }

    protected SqlEx readError() throws SqlEx {
        SqlEx sqlEx = null;
        int n = this.msg.readInt();
        String string = this.msg.readString(5);
        byte by = this.msg.readByte();
        String string2 = this.msg.readString();
        if (by == 2) {
            sqlEx = new SqlEx(string2, string, n);
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": Received error '" + string + "' 0x" + Integer.toHexString(n) + " -- " + string2);
            }
        } else {
            if (this.trace.enabled(by == 0 ? 3 : 1)) {
                this.trace.write(this.tr_id + ": Received " + (by == 0 ? "message" : "warning") + " '" + string + "' 0x" + Integer.toHexString(n) + " -- " + string2);
            }
            this.setWarning(new SqlWarn(string2, string, n));
        }
        return sqlEx;
    }

    protected boolean readResult() throws SqlEx {
        block32: while (this.msg.moreData()) {
            short s = this.msg.readShort();
            short s2 = this.msg.readShort();
            switch (s) {
                case 1: {
                    switch (s2) {
                        case 1: {
                            this.rslt_val_rows = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            this.rslt_val_rows = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            this.rslt_val_rows = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid row count length: " + s2);
                            }
                            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_rowcount = true;
                    continue block32;
                }
                case 2: {
                    if (s2 > 0) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid XACT param length: " + s2);
                        }
                        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_flags |= 1;
                    this.conn.endXact();
                    continue block32;
                }
                case 3: {
                    if (s2 != 8) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid stmt ID length: " + s2);
                        }
                        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_val_stmt = (long)this.msg.readInt() << 32 | (long)this.msg.readInt() & 0xFFFFFFFFFFFFFFFFL;
                    this.rslt_stmt_id = true;
                    continue block32;
                }
                case 4: {
                    switch (s2) {
                        case 1: {
                            this.rslt_val_fetch = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            this.rslt_val_fetch = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            this.rslt_val_fetch = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid fetch limit length: " + s2);
                            }
                            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_prefetch = true;
                    continue block32;
                }
                case 5: {
                    if (s2 != 0) {
                        this.trace.write(this.tr_id + ": Invalid EOD length: " + s2);
                        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_flags |= 4;
                    continue block32;
                }
                case 6: {
                    switch (s2) {
                        case 1: {
                            this.setProcResult(this.msg.readByte());
                            continue block32;
                        }
                        case 2: {
                            this.setProcResult(this.msg.readShort());
                            continue block32;
                        }
                        case 4: {
                            this.setProcResult(this.msg.readInt());
                            continue block32;
                        }
                    }
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": Invalid proc result length: " + s2);
                    }
                    throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                }
                case 7: {
                    if (s2 != 0) {
                        this.trace.write(this.tr_id + ": Invalid READ_ONLY length: " + s2);
                        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                    }
                    this.rslt_flags |= 2;
                    continue block32;
                }
                case 8: {
                    if (s2 != 8) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid table key length: " + s2);
                        }
                        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.rslt_val_tblkey == null) {
                        this.rslt_val_tblkey = new byte[s2];
                    }
                    this.msg.readBytes(this.rslt_val_tblkey, 0, s2);
                    this.rslt_tblkey = true;
                    continue block32;
                }
                case 9: {
                    if (s2 != 16) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": Invalid object key length: " + s2);
                        }
                        throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                    }
                    if (this.rslt_val_objkey == null) {
                        this.rslt_val_objkey = new byte[s2];
                    }
                    this.msg.readBytes(this.rslt_val_objkey, 0, s2);
                    this.rslt_objkey = true;
                    continue block32;
                }
                case 10: {
                    int n;
                    switch (s2) {
                        case 1: {
                            n = this.msg.readByte();
                            break;
                        }
                        case 2: {
                            n = this.msg.readShort();
                            break;
                        }
                        case 4: {
                            n = this.msg.readInt();
                            break;
                        }
                        default: {
                            if (this.trace.enabled(1)) {
                                this.trace.write(this.tr_id + ": Invalid result flags length: " + s2);
                            }
                            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                        }
                    }
                    this.rslt_flags |= n;
                    if ((n & 1) == 0) continue block32;
                    this.conn.endXact();
                    continue block32;
                }
            }
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": Invalid result param ID " + s);
            }
            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
        }
        return false;
    }

    protected void setProcResult(int n) throws SqlEx {
        this.rslt_val_proc = n;
        this.rslt_proc_val = true;
    }
}

