/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.SqlParse;
import com.ingres.gcf.util.SqlEx;

class DrvPrep
extends DrvObj {
    private static final String stmt_prefix = "JDBC_STMT_";
    private JdbcRSMD rsmd = null;
    private String stmt_name = null;
    private String table_name = null;
    private int qry_concur = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrvPrep(DrvConn drvConn, String string) throws SqlEx {
        super(drvConn);
        this.title = this.trace.getTraceName() + "-DrvPrep[" + this.inst_id + "]";
        this.tr_id = "DrvPrep[" + this.inst_id + "]";
        try {
            SqlParse sqlParse = new SqlParse(string, this.timeLiteralsInGMT());
            string = sqlParse.parseSQL(true);
            this.qry_concur = sqlParse.getConcurrency();
            this.table_name = sqlParse.getTableName();
            this.stmt_name = drvConn.getUniqueID(stmt_prefix);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": error parsing statement text");
            }
            throw sqlEx;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": preparing statement '" + string + "'");
        }
        this.msg.lock();
        try {
            this.msg.begin((byte)4);
            this.msg.write((short)3);
            this.msg.write((short)3);
            this.msg.write(this.stmt_name);
            this.msg.write((short)1);
            this.msg.write(string);
            this.msg.done(true);
            this.rsmd = this.readResults();
        }
        finally {
            this.msg.unlock();
        }
    }

    public JdbcRSMD getMetaData() {
        return this.rsmd;
    }

    public String getStmtName() {
        return this.stmt_name;
    }

    public String getTableName() {
        return this.table_name;
    }

    public int getConcurrency() {
        return this.qry_concur;
    }

    protected JdbcRSMD readDesc() throws SqlEx {
        return JdbcRSMD.load(this.conn);
    }
}

