/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

class JdbcCPVirt
implements Connection,
GcfErr {
    protected DrvTrace trace = null;
    protected String title = null;
    protected String tr_id = "CPVirt";
    protected int inst_id = 0;
    private Connection conn = null;
    private PooledConnection pool = null;
    private ConnectionEventListener listener = null;
    private static int inst_count = 0;

    public JdbcCPVirt(Connection connection, PooledConnection pooledConnection, ConnectionEventListener connectionEventListener, DrvTrace drvTrace) {
        this.conn = connection;
        this.pool = pooledConnection;
        this.listener = connectionEventListener;
        this.trace = drvTrace;
        this.inst_id = inst_count++;
        this.title = drvTrace.getTraceName() + "-CPVConnection[" + this.inst_id + "]";
        this.tr_id = this.tr_id + "[" + this.inst_id + "]";
    }

    public String toString() {
        return this.title;
    }

    public boolean isClosed() throws SQLException {
        return this.conn != null ? this.conn.isClosed() : true;
    }

    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        if (this.conn != null) {
            this.closeEvent();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn != null ? this.conn.getWarnings() : null;
    }

    public void clearWarnings() throws SQLException {
        if (this.conn != null) {
            this.conn.clearWarnings();
        }
    }

    public Statement createStatement() throws SQLException {
        Statement statement;
        this.checkConn(".createStatement()");
        try {
            statement = this.conn.createStatement();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return statement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        Statement statement;
        this.checkConn(".createStatement()");
        try {
            statement = this.conn.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return statement;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Statement statement;
        this.checkConn(".createStatement()");
        try {
            statement = this.conn.createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return statement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement;
        this.checkConn(".prepareStatement()");
        try {
            preparedStatement = this.conn.prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement;
        this.checkConn(".prepareCall()");
        try {
            callableStatement = this.conn.prepareCall(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        this.checkConn(".prepareCall()");
        try {
            callableStatement = this.conn.prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement;
        this.checkConn(".prepareCall()");
        try {
            callableStatement = this.conn.prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return callableStatement;
    }

    public int getHoldability() throws SQLException {
        int n;
        this.checkConn(".getHoldability()");
        try {
            n = this.conn.getHoldability();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return n;
    }

    public void setHoldability(int n) throws SQLException {
        this.checkConn(".setHoldability()");
        try {
            this.conn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkConn(".nativeSQL()");
        try {
            string = this.conn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return string;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData;
        this.checkConn(".getMetaData()");
        try {
            databaseMetaData = this.conn.getMetaData();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return databaseMetaData;
    }

    public String getCatalog() throws SQLException {
        String string;
        this.checkConn(".getCatalog()");
        try {
            string = this.conn.getCatalog();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return string;
    }

    public void setCatalog(String string) throws SQLException {
        this.checkConn(".setCatalog()");
        try {
            this.conn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        Map<String, Class<?>> map;
        this.checkConn(".getTypeMap()");
        try {
            map = this.conn.getTypeMap();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return map;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkConn(".setTypeMap()");
        try {
            this.conn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        boolean bl;
        this.checkConn(".isReadOnly()");
        try {
            bl = this.conn.isReadOnly();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return bl;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkConn(".setReadOnly()");
        try {
            this.conn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        int n;
        this.checkConn(".getTransactionIsolation()");
        try {
            n = this.conn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return n;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkConn(".setTransactionIsolation()");
        try {
            this.conn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        boolean bl;
        this.checkConn(".getAutoCommit()");
        try {
            bl = this.conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return bl;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkConn(".setAutoCommit()");
        try {
            this.conn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public void commit() throws SQLException {
        this.checkConn(".commit()");
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        this.checkConn(".rollback()");
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkConn(".rollback()");
        try {
            this.conn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        Savepoint savepoint;
        this.checkConn(".setSavepoint()");
        try {
            savepoint = this.conn.setSavepoint();
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return savepoint;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        Savepoint savepoint;
        this.checkConn(".setSavepoint()");
        try {
            savepoint = this.conn.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
        return savepoint;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkConn(".releaseSavepoint()");
        try {
            this.conn.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            if (this.conn.isClosed()) {
                this.errorEvent(sQLException);
            }
            throw sQLException;
        }
    }

    protected void checkConn(String string) throws SqlEx {
        if (this.conn == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + string + ": virtual connection closed!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4004_CONNECTION_CLOSED);
        }
    }

    private void closeEvent() {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": closing virtual connection");
        }
        if (this.listener != null) {
            this.listener.connectionClosed(new ConnectionEvent(this.pool));
        }
        this.listener = null;
        this.pool = null;
        this.conn = null;
    }

    private void errorEvent(SQLException sQLException) {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ": virtual connection error");
            if (this.trace.enabled(1)) {
                ((SqlEx)sQLException).trace(this.trace);
            }
        }
        if (this.listener != null) {
            this.listener.connectionErrorOccurred(new ConnectionEvent(this.pool, sQLException));
        }
        this.listener = null;
        this.pool = null;
        this.conn = null;
    }
}

