/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvPrep;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.ParamSet;
import com.ingres.gcf.jdbc.RsltCurs;
import com.ingres.gcf.jdbc.RsltUpd;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlWarn;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.NoSuchElementException;

class JdbcPrep
extends JdbcStmt
implements PreparedStatement,
DbmsConst {
    protected ParamSet params;
    private String query_text = null;
    private JdbcRSMD prepRSMD = null;
    private JdbcRSMD emptyRSMD = null;
    private JdbcRSMD localRSMD = null;

    public JdbcPrep(DrvConn drvConn, String string, int n, int n2, int n3) throws SqlEx {
        this(drvConn, n, n2, n3);
        this.title = this.trace.getTraceName() + "-PreparedStatement[" + this.inst_id + "]";
        this.tr_id = "Prep[" + this.inst_id + "]";
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": '" + string + "'");
        }
        try {
            DrvPrep drvPrep = drvConn.getPrepStmt(string);
            this.query_text = string;
            this.prepRSMD = drvPrep.getMetaData();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ": error preparing statement");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
    }

    protected JdbcPrep(DrvConn drvConn, int n, int n2, int n3) {
        super(drvConn, n, n2, n3);
        this.params = new ParamSet(drvConn);
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery()");
        }
        if (this.prepRSMD == null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".executeQuery(): statement is not a query");
            }
            this.clearResults();
            throw SqlEx.get(GcfErr.ERR_GC4017_NO_RESULT_SET);
        }
        this.exec(this.params);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery(): " + this.resultSet);
        }
        return this.resultSet;
    }

    public int executeUpdate() throws SQLException {
        int n;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate()");
        }
        if (this.prepRSMD != null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".executeUpdate(): statement is a query");
            }
            this.clearResults();
            throw SqlEx.get(GcfErr.ERR_GC4018_RESULT_SET_NOT_PERMITTED);
        }
        this.exec(this.params);
        int n2 = n = this.rslt_rowcount ? this.rslt_val_rows : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + n);
        }
        return n;
    }

    public boolean execute() throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute()");
        }
        this.exec(this.params);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery('" + string + "')");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "')");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + n + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + nArray + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + stringArray + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public boolean execute(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "' )");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public boolean execute(String string, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "'," + n + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "'," + nArray + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "'," + stringArray + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".addBatch()");
        }
        if (this.prepRSMD != null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".addBatch(): statement is a query");
            }
            throw SqlEx.get(GcfErr.ERR_GC4018_RESULT_SET_NOT_PERMITTED);
        }
        if (this.batch == null) {
            this.newBatch();
        }
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            this.batch.addLast(this.params);
            this.params = new ParamSet(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeBatch()");
        }
        if (this.batch == null) {
            return new int[0];
        }
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            int n = this.batch.size();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                try {
                    ParamSet paramSet = (ParamSet)this.batch.removeFirst();
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + i + "] ");
                    }
                    this.exec(paramSet);
                    int n2 = nArray[i] = this.rslt_rowcount ? this.rslt_val_rows : -2;
                    if (!this.trace.enabled()) continue;
                    this.trace.log(this.title + ".executeBatch[" + i + "] = " + nArray[i]);
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    int[] nArray2 = new int[i];
                    if (i > 0) {
                        System.arraycopy(nArray, 0, nArray2, 0, i);
                    }
                    nArray = nArray2;
                    break;
                }
                catch (SQLException sQLException) {
                    int[] nArray3 = new int[i];
                    if (i > 0) {
                        System.arraycopy(nArray, 0, nArray3, 0, i);
                    }
                    BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray3);
                    batchUpdateException.setNextException(sQLException.getNextException());
                    this.batch.clear();
                    throw batchUpdateException;
                }
            }
            this.batch.clear();
        }
        return nArray;
    }

    private void exec(ParamSet paramSet) throws SqlEx {
        DrvPrep drvPrep;
        int n;
        this.clearResults();
        int n2 = paramSet.getCount();
        for (n = 0; n < n2; ++n) {
            if (paramSet.isSet(n)) continue;
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": parameter not set: " + (n + 1));
            }
            throw SqlEx.get(GcfErr.ERR_GC4020_NO_PARAM);
        }
        try {
            drvPrep = this.conn.getPrepStmt(this.query_text);
            this.prepRSMD = drvPrep.getMetaData();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ": error preparing statement");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        this.msg.lock();
        try {
            if (this.prepRSMD == null) {
                this.msg.begin((byte)4);
                this.msg.write((short)4);
                this.msg.write((short)3);
                this.msg.write(drvPrep.getStmtName());
                this.msg.done(n2 <= 0);
                if (n2 > 0) {
                    paramSet.sendDesc(false);
                    paramSet.sendData(true);
                }
                this.readResults(this.timeout, true);
            } else {
                JdbcRSMD jdbcRSMD;
                String string;
                n = this.getConcurrency(drvPrep.getConcurrency());
                short s = 0;
                boolean bl = true;
                String string2 = drvPrep.getStmtName();
                String string3 = string = this.crsr_name != null ? this.crsr_name : this.conn.getUniqueID("JDBC_CRSR_");
                if (n == 0) {
                    if (this.conn.msg_protocol_level < 2) {
                        string2 = string2 + " for readonly";
                    } else if (this.conn.msg_protocol_level < 3) {
                        s = (short)(s | 1);
                    } else {
                        s = (short)(s | 5);
                        bl = false;
                    }
                }
                if (this.conn.msg_protocol_level >= 3) {
                    s = (short)(s | 2);
                }
                this.msg.begin((byte)4);
                this.msg.write((short)5);
                if (s != 0) {
                    this.msg.write((short)6);
                    this.msg.write((short)2);
                    this.msg.write(s);
                }
                this.msg.write((short)2);
                this.msg.write(string);
                this.msg.write((short)3);
                this.msg.write(string2);
                this.msg.done(n2 <= 0);
                if (n2 > 0) {
                    paramSet.sendDesc(false);
                    paramSet.sendData(true);
                }
                if ((jdbcRSMD = this.readResults(this.timeout, bl)) == null) {
                    jdbcRSMD = this.prepRSMD;
                }
                if ((this.rslt_flags & 2) == 0) {
                    this.resultSet = new RsltUpd(this.conn, this, jdbcRSMD, this.rslt_val_stmt, string, drvPrep.getTableName());
                    if (this.msg.moreMessages()) {
                        this.readResults(this.timeout, true);
                    }
                } else {
                    if (this.rs_concur == 1) {
                        this.warnings = SqlWarn.get(GcfErr.ERR_GC4016_RS_CHANGED);
                    }
                    this.resultSet = new RsltCurs(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.crsr_name, this.getPreFetchSize(), this.msg.moreMessages());
                }
            }
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".execute(): error executing query");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }

    public void close() throws SQLException {
        super.close();
        this.params.clear(true);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMetaData(): " + this.prepRSMD);
        }
        if (this.prepRSMD == null && this.emptyRSMD == null) {
            this.emptyRSMD = new JdbcRSMD(0, this.trace);
        }
        return this.prepRSMD == null ? this.emptyRSMD : this.prepRSMD;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMetaData()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void clearParameters() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".clearParameters()");
        }
        this.params.clear(false);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setNull( " + n + ", " + n2 + (string == null ? " )" : ", " + string + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, n2);
        this.params.setNull(n);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBoolean( " + n + ", " + bl + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 16);
        this.params.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setByte( " + n + ", " + by + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -6);
        this.params.setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setShort( " + n + ", " + s + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 5);
        this.params.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + " setInt( " + n + ", " + n2 + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 4);
        this.params.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setLong( " + n + ", " + l + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -5);
        this.params.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFloat( " + n + ", " + f + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 7);
        this.params.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setDouble( " + n + ", " + d + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 8);
        this.params.setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBigDecimal( " + n + ", " + bigDecimal + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 3);
        this.params.setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setString( " + n + ", " + string + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 12);
        this.params.setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBytes( " + n + ", " + byArray + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -3);
        this.params.setBytes(n, byArray);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setDate( " + n + ", " + date + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, 91);
        this.params.setDate(n, date, calendar == null ? null : calendar.getTimeZone());
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTime( " + n + ", " + time + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, 92);
        this.params.setTime(n, time, calendar == null ? null : calendar.getTimeZone());
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTimestamp( " + n + ", " + timestamp + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, 93);
        this.params.setTimestamp(n, timestamp, calendar == null ? null : calendar.getTimeZone());
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBinaryStream( " + n + ", " + n2 + " )");
        }
        if (n2 >= 0 && n2 <= this.conn.max_vbyt_len) {
            byte[] byArray = new byte[n2];
            if (n2 > 0) {
                try {
                    int n3 = inputStream.read(byArray);
                    if (n3 != n2) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ".setBinaryStream: read only " + n3 + " of " + n2 + " bytes!");
                        }
                        this.setWarning(new DataTruncation(n, true, false, n2, n3));
                    }
                }
                catch (IOException iOException) {
                    throw SqlEx.get(GcfErr.ERR_GC4007_BLOB_IO);
                }
            }
            n = this.paramMap(n);
            this.params.init(n, -3);
            this.params.setBytes(n, byArray);
        } else {
            n = this.paramMap(n);
            this.params.init(n, -4);
            this.params.setBinaryStream(n, inputStream);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setAsciiStream( " + n + ", " + n2 + " )");
        }
        if (n2 >= 0 && n2 <= (this.conn.ucs2_supported ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            char[] cArray = new char[n2];
            if (n2 > 0) {
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
                    int n3 = inputStreamReader.read(cArray);
                    if (n3 != n2) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ".setAsciiStream: read only " + n3 + " of " + n2 + " characters!");
                        }
                        this.setWarning(new DataTruncation(n, true, false, n2, n3));
                    }
                }
                catch (IOException iOException) {
                    throw SqlEx.get(GcfErr.ERR_GC4007_BLOB_IO);
                }
            }
            n = this.paramMap(n);
            this.params.init(n, 12);
            this.params.setString(n, new String(cArray));
        } else {
            n = this.paramMap(n);
            this.params.init(n, -1);
            this.params.setAsciiStream(n, inputStream);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setUnicodeStream( " + n + ", " + n2 + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -1);
        this.params.setUnicodeStream(n, inputStream);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCharacterStream( " + n + ", " + n2 + " )");
        }
        if (n2 >= 0 && n2 <= (this.conn.ucs2_supported ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            char[] cArray = new char[n2];
            if (n2 > 0) {
                try {
                    int n3 = reader.read(cArray);
                    if (n3 != n2) {
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ".setCharacterStream: read only " + n3 + " of " + n2 + " characters!");
                        }
                        this.setWarning(new DataTruncation(n, true, false, n2, n3));
                    }
                }
                catch (IOException iOException) {
                    throw SqlEx.get(GcfErr.ERR_GC4007_BLOB_IO);
                }
            }
            n = this.paramMap(n);
            this.params.init(n, 12);
            this.params.setString(n, new String(cArray));
        } else {
            n = this.paramMap(n);
            this.params.init(n, -1);
            this.params.setCharacterStream(n, reader);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setObject( " + n + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, object);
        this.params.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setObject( " + n + ", " + n2 + ", " + n3 + " )");
        }
        n = this.paramMap(n);
        if (n2 == 1111) {
            this.params.init(n, object, true);
            n2 = SqlData.getSqlType(object);
        } else {
            this.params.init(n, n2);
        }
        this.params.setObject(n, object, n2, n3);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setNull(n, n2, null);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setArray(int n, Array array) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setArray(" + n + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBlob(" + n + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setClob(" + n + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setRef(" + n + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setURL(" + n + ")");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    protected int paramMap(int n) throws SqlEx {
        if (n < 1) {
            throw SqlEx.get(GcfErr.ERR_GC4011_INDEX_RANGE);
        }
        return n - 1;
    }

    protected JdbcRSMD readDesc() throws SqlEx {
        this.localRSMD = this.readDesc(this.localRSMD);
        return this.localRSMD;
    }
}

