/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConn;
import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IdMap;
import com.ingres.gcf.util.SqlEx;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class JdbcRSMD
implements ResultSetMetaData,
MsgConst,
DbmsConst,
GcfErr {
    public short count = 0;
    public Desc[] desc;
    private DrvTrace trace = null;
    private String title = null;
    private String tr_id = null;
    private static int inst_count = 0;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static JdbcRSMD load(DrvConn drvConn) throws SqlEx {
        MsgConn msgConn = drvConn.msg;
        short s = msgConn.readShort();
        JdbcRSMD jdbcRSMD = new JdbcRSMD(s, drvConn.trace);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            String string;
            short s3 = msgConn.readShort();
            short s4 = msgConn.readShort();
            short s5 = msgConn.readShort();
            byte by = msgConn.readByte();
            byte by2 = msgConn.readByte();
            boolean bl = (msgConn.readByte() & 1) != 0;
            jdbcRSMD.desc[s2].name = string = msgConn.readString();
            jdbcRSMD.desc[s2].sql_type = s3;
            jdbcRSMD.desc[s2].dbms_type = s4;
            jdbcRSMD.desc[s2].length = s5;
            jdbcRSMD.desc[s2].precision = by;
            jdbcRSMD.desc[s2].scale = by2;
            jdbcRSMD.desc[s2].nullable = bl;
        }
        return jdbcRSMD;
    }

    public JdbcRSMD(short n, DrvTrace drvTrace) {
        this.count = n;
        this.trace = drvTrace;
        this.desc = new Desc[n];
        for (int i = 0; i < n; ++i) {
            this.desc[i] = new Desc();
        }
        this.title = drvTrace.getTraceName() + "-ResultSetMetaData[" + inst_count + "]";
        this.tr_id = "RSMD[" + inst_count + "]";
        ++inst_count;
    }

    public String toString() {
        return this.title;
    }

    public void reload(DrvConn drvConn) throws SqlEx {
        MsgConn msgConn = drvConn.msg;
        short s = msgConn.readShort();
        short s2 = (short)Math.min(s, this.count);
        if (s != this.count) {
            this.resize(s);
        }
        for (short s3 = 0; s3 < this.count; s3 = (short)(s3 + 1)) {
            short s4 = msgConn.readShort();
            short s5 = msgConn.readShort();
            short s6 = msgConn.readShort();
            byte by = msgConn.readByte();
            byte by2 = msgConn.readByte();
            boolean bl = (msgConn.readByte() & 1) != 0;
            String string = msgConn.readString();
            if (s3 < s2 && this.trace.enabled(5)) {
                if (s4 != this.desc[s3].sql_type) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] sql_type " + this.desc[s3].sql_type + " => " + s4);
                }
                if (s5 != this.desc[s3].dbms_type) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] dbms_type " + this.desc[s3].dbms_type + " => " + s5);
                }
                if (s6 != this.desc[s3].length) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] length " + this.desc[s3].length + " => " + s6);
                }
                if (by != this.desc[s3].precision) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] precision " + this.desc[s3].precision + " => " + by);
                }
                if (by2 != this.desc[s3].scale) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] scale " + this.desc[s3].scale + " => " + by2);
                }
                if (bl != this.desc[s3].nullable) {
                    this.trace.write(this.tr_id + ": reload[" + s3 + "] nullable " + this.desc[s3].nullable + " => " + bl);
                }
            }
            this.desc[s3].name = string;
            this.desc[s3].sql_type = s4;
            this.desc[s3].dbms_type = s5;
            this.desc[s3].length = s6;
            this.desc[s3].precision = by;
            this.desc[s3].scale = by2;
            this.desc[s3].nullable = bl;
        }
    }

    public void setColumnInfo(String string, int n, int n2, short s, short s2, byte by, byte by2, boolean bl) throws SqlEx {
        n = this.columnMap(n);
        this.desc[n].name = string;
        this.desc[n].sql_type = n2;
        this.desc[n].dbms_type = s;
        this.desc[n].length = s2;
        this.desc[n].precision = by;
        this.desc[n].scale = by2;
        this.desc[n].nullable = bl;
    }

    public int getColumnCount() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnCount: " + this.count);
        }
        return this.count;
    }

    public String getColumnName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnName( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnName: " + this.desc[n].name);
        }
        return this.desc[n].name;
    }

    public String getColumnLabel(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnLabel( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnLabel: " + this.desc[n].name);
        }
        return this.desc[n].name;
    }

    public String getTableName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTableName( " + n + " ): ''");
        }
        n = this.columnMap(n);
        return "";
    }

    public String getSchemaName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getSchemaName( " + n + " ): ''");
        }
        n = this.columnMap(n);
        return "";
    }

    public String getCatalogName(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCatalogName( " + n + " ): ''");
        }
        n = this.columnMap(n);
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnType( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnType: " + this.desc[n].sql_type);
        }
        return this.desc[n].sql_type;
    }

    public String getColumnTypeName(int n) throws SQLException {
        String string = null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnTypeName( " + n + " )");
        }
        n = this.columnMap(n);
        switch (this.desc[n].dbms_type) {
            case 30: {
                string = IdMap.get(this.desc[n].length, DbmsConst.intMap);
                break;
            }
            case 31: {
                string = IdMap.get(this.desc[n].length, DbmsConst.floatMap);
                break;
            }
            default: {
                string = IdMap.get(this.desc[n].dbms_type, DbmsConst.typeMap);
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnTypeName: " + string);
        }
        return string;
    }

    public String getColumnClassName(int n) throws SQLException {
        Class clazz;
        Class clazz2 = clazz = class$java$lang$Object == null ? (class$java$lang$Object = JdbcRSMD.class$("java.lang.Object")) : class$java$lang$Object;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnTypeName( " + n + " )");
        }
        n = this.columnMap(n);
        switch (this.desc[n].sql_type) {
            case -7: 
            case 16: {
                clazz = class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdbcRSMD.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                clazz = class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcRSMD.class$("java.lang.Integer")) : class$java$lang$Integer;
                break;
            }
            case -5: {
                clazz = class$java$lang$Long == null ? (class$java$lang$Long = JdbcRSMD.class$("java.lang.Long")) : class$java$lang$Long;
                break;
            }
            case 7: {
                clazz = class$java$lang$Float == null ? (class$java$lang$Float = JdbcRSMD.class$("java.lang.Float")) : class$java$lang$Float;
                break;
            }
            case 6: 
            case 8: {
                clazz = class$java$lang$Double == null ? (class$java$lang$Double = JdbcRSMD.class$("java.lang.Double")) : class$java$lang$Double;
                break;
            }
            case 2: 
            case 3: {
                clazz = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JdbcRSMD.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = JdbcRSMD.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                clazz = class$java$lang$Byte == null ? (class$java$lang$Byte = JdbcRSMD.class$("java.lang.Byte")) : class$java$lang$Byte;
                break;
            }
            case 91: {
                clazz = class$java$sql$Date == null ? (class$java$sql$Date = JdbcRSMD.class$("java.sql.Date")) : class$java$sql$Date;
                break;
            }
            case 92: {
                clazz = class$java$sql$Time == null ? (class$java$sql$Time = JdbcRSMD.class$("java.sql.Time")) : class$java$sql$Time;
                break;
            }
            case 93: {
                clazz = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JdbcRSMD.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
                break;
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.title + ": invalid SQL type " + this.desc[n].sql_type);
                }
                throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
            }
        }
        String string = clazz.getName();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnClassName: " + string);
        }
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPrecision( " + n + " )");
        }
        n = this.columnMap(n);
        int n2 = 0;
        switch (this.desc[n].sql_type) {
            case -6: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 10;
                break;
            }
            case -5: {
                n2 = 19;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 6: 
            case 8: {
                n2 = 15;
                break;
            }
            case 2: 
            case 3: {
                n2 = this.desc[n].precision;
                break;
            }
            case -3: 
            case -2: {
                n2 = this.desc[n].length;
                break;
            }
            case 1: {
                n2 = this.desc[n].length;
                if (this.desc[n].dbms_type != 26) break;
                n2 /= 2;
                break;
            }
            case 12: {
                n2 = this.desc[n].length;
                if (this.desc[n].dbms_type != 27) break;
                n2 /= 2;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getPrecision: " + n2);
        }
        return n2;
    }

    public int getScale(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getScale( " + n + " )");
        }
        n = this.columnMap(n);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getScale: " + this.desc[n].scale);
        }
        return this.desc[n].scale;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnDisplaySize( " + n + " )");
        }
        n = this.columnMap(n);
        int n2 = 0;
        switch (this.desc[n].sql_type) {
            case -7: 
            case 16: {
                n2 = 5;
                break;
            }
            case -6: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 11;
                break;
            }
            case -5: {
                n2 = 20;
                break;
            }
            case 7: {
                n2 = 14;
                break;
            }
            case 6: 
            case 8: {
                n2 = 24;
                break;
            }
            case 91: {
                n2 = 10;
                break;
            }
            case 92: {
                n2 = 8;
                break;
            }
            case 93: {
                n2 = 26;
                break;
            }
            case -3: 
            case -2: {
                n2 = this.desc[n].length;
                break;
            }
            case -4: 
            case -1: {
                n2 = 0;
                break;
            }
            case 2: 
            case 3: {
                n2 = this.desc[n].precision + 1;
                if (this.desc[n].scale <= 0) break;
                ++n2;
                break;
            }
            case 1: {
                n2 = this.desc[n].length;
                if (this.desc[n].dbms_type != 26) break;
                n2 /= 2;
                break;
            }
            case 12: {
                n2 = this.desc[n].length;
                if (this.desc[n].dbms_type != 27) break;
                n2 /= 2;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getColumnDisplaySize: " + n2);
        }
        return n2;
    }

    public int isNullable(int n) throws SQLException {
        int n2;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isNullable( " + n + " )");
        }
        n = this.columnMap(n);
        int n3 = n2 = this.desc[n].nullable ? 1 : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isNullable: " + (this.desc[n].nullable ? "columnNullable" : "columnNoNulls"));
        }
        return n2;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSearchable( " + n + " ): " + true);
        }
        n = this.columnMap(n);
        return true;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCaseSensitive( " + n + " ): " + true);
        }
        n = this.columnMap(n);
        boolean bl = false;
        switch (this.desc[n].sql_type) {
            case -1: 
            case 1: 
            case 12: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCaseSensitive: " + bl);
        }
        return bl;
    }

    public boolean isSigned(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSigned( " + n + " )");
        }
        n = this.columnMap(n);
        boolean bl = false;
        switch (this.desc[n].sql_type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isSigned: " + bl);
        }
        return bl;
    }

    public boolean isCurrency(int n) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCurrency( " + n + " )");
        }
        n = this.columnMap(n);
        boolean bl2 = bl = this.desc[n].dbms_type == 5;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isCurrency: " + bl);
        }
        return bl;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isAutoIncrement( " + n + " ): " + false);
        }
        n = this.columnMap(n);
        return false;
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isReadOnly( " + n + " ): " + false);
        }
        n = this.columnMap(n);
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWritable( " + n + " ): " + true);
        }
        n = this.columnMap(n);
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isDefinitelyWritable( " + n + " ): " + true);
        }
        n = this.columnMap(n);
        return true;
    }

    private void resize(short s) {
        if (s == this.count) {
            return;
        }
        Desc[] descArray = new Desc[s];
        if (this.trace.enabled(4)) {
            this.trace.write(this.tr_id + ": resize " + this.count + " to " + s);
        }
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            descArray[s2] = s2 < this.count ? this.desc[s2] : new Desc();
        }
        this.count = s;
        this.desc = descArray;
    }

    private int columnMap(int n) throws SqlEx {
        if (n < 1 || n > this.count) {
            throw SqlEx.get(GcfErr.ERR_GC4011_INDEX_RANGE);
        }
        return n - 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Desc {
        int sql_type = 1111;
        short dbms_type = 0;
        short length = 0;
        byte precision = 0;
        byte scale = 0;
        boolean nullable = false;
        String name = null;

        private Desc() {
        }
    }
}

