/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvConst;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlWarn;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

abstract class JdbcRslt
extends DrvObj
implements ResultSet,
DrvConst {
    protected static final int POS_CLOSED = -1;
    protected static final int POS_ON_ROW = 0;
    protected static final int POS_BEFORE = 1;
    protected static final int POS_AFTER = 2;
    protected static final int ROW_IS_FIRST = 1;
    protected static final int ROW_IS_LAST = 2;
    protected static final int ROW_UPDATED = 4;
    protected static final int ROW_DELETED = 8;
    protected JdbcRSMD rsmd = null;
    protected int pos_status = 1;
    protected int row_status = 0;
    protected int row_number = 0;
    protected SqlData[] columns = null;
    protected int rs_type = 1003;
    protected int rs_concur = 1007;
    protected int rs_fetch_dir = 1000;
    protected int rs_fetch_size = 0;
    protected int rs_max_rows = 0;
    protected int rs_max_len = 0;
    private boolean isNull = false;

    protected abstract void load() throws SqlEx;

    protected JdbcRslt(DrvConn drvConn, JdbcRSMD jdbcRSMD) throws SqlEx {
        super(drvConn);
        this.rsmd = jdbcRSMD;
        this.title = this.trace.getTraceName() + "-ResultSet[" + this.inst_id + "]";
        this.tr_id = "Rslt[" + this.inst_id + "]";
    }

    protected void finalize() throws Throwable {
        if (this.pos_status != -1) {
            try {
                this.shut();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public synchronized boolean next() throws SQLException {
        boolean bl = false;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".next()");
        }
        this.warnings = null;
        this.isNull = false;
        switch (this.pos_status) {
            case -1: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".next: result-set closed");
                break;
            }
            case 2: {
                if (!this.trace.enabled(3)) break;
                this.trace.write(this.tr_id + ".next: result-set at EOD");
                break;
            }
            default: {
                if (this.rs_max_rows > 0 && this.row_number >= this.rs_max_rows) {
                    try {
                        this.shut();
                    }
                    catch (SqlEx sqlEx) {
                        // empty catch block
                    }
                    if (!this.trace.enabled(3)) break;
                    this.trace.write(this.tr_id + ".next: max row limit reached");
                    break;
                }
                try {
                    this.load();
                }
                catch (SqlEx sqlEx) {
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".next(): error loading row");
                    }
                    if (this.trace.enabled(1)) {
                        sqlEx.trace(this.trace);
                    }
                    try {
                        this.shut();
                    }
                    catch (SqlEx sqlEx2) {
                        // empty catch block
                    }
                    throw sqlEx;
                }
                boolean bl2 = bl = this.pos_status == 0;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".next: " + bl);
        }
        return bl;
    }

    public void close() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".close()");
        }
        this.warnings = null;
        this.isNull = false;
        try {
            if (!this.shut() && this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ": result-set already closed!");
            }
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".close(): error closing result-set");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shut() throws SqlEx {
        JdbcRslt jdbcRslt = this;
        synchronized (jdbcRslt) {
            if (this.pos_status == -1) {
                return false;
            }
            this.pos_status = -1;
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ": result-set closed");
        }
        this.row_status = 0;
        this.row_number = 0;
        this.columns = null;
        return true;
    }

    public Statement getStatement() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getStatement(): " + null);
        }
        return null;
    }

    public int getType() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getType(): " + this.rs_type);
        }
        return this.rs_type;
    }

    public int getConcurrency() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConcurrency(): " + this.rs_concur);
        }
        return this.rs_concur;
    }

    public int getFetchDirection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchDirection(): " + this.rs_fetch_dir);
        }
        return this.rs_fetch_dir;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchDirection( " + n + " )");
        }
        if (n != 1000) {
            throw SqlEx.get(GcfErr.ERR_GC4010_PARAM_VALUE);
        }
    }

    public int getFetchSize() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFetchSize(): " + this.rs_fetch_size);
        }
        return this.rs_fetch_size;
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFetchSize( " + n + " )");
        }
        if (n < 0 || this.rs_max_rows > 0 && n > this.rs_max_rows) {
            throw SqlEx.get(GcfErr.ERR_GC4010_PARAM_VALUE);
        }
        this.rs_fetch_size = n;
    }

    public String getCursorName() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCursorName(): " + null);
        }
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMetaData(): " + this.rsmd);
        }
        if (this.pos_status == -1) {
            throw SqlEx.get(GcfErr.ERR_GC401D_RESULTSET_CLOSED);
        }
        return this.rsmd;
    }

    public int getRow() throws SQLException {
        int n;
        int n2 = n = this.pos_status != 0 ? 0 : this.row_number;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRow(): " + n);
        }
        return n;
    }

    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.pos_status == 1;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isBeforeFirst(): " + bl);
        }
        return bl;
    }

    public boolean isAfterLast() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.pos_status == 2 && this.row_number > 1;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isAfterLast(): " + bl);
        }
        return bl;
    }

    public boolean isFirst() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.pos_status == 0 && (this.row_status & 1) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isFirst(): " + bl);
        }
        return bl;
    }

    public boolean isLast() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.pos_status == 0 && (this.row_status & 2) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isLast(): " + bl);
        }
        return bl;
    }

    public void beforeFirst() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".beforeFirst()");
        }
        this.absolute(0);
    }

    public void afterLast() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".afterLast()");
        }
        switch (this.pos_status) {
            case 1: {
                throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
            }
            case 0: {
                if ((this.row_status & 2) == 0) {
                    throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
                }
                this.next();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw SqlEx.get(GcfErr.ERR_GC401D_RESULTSET_CLOSED);
            }
        }
    }

    public boolean first() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".first()");
        }
        boolean bl = this.absolute(1);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".first: " + bl);
        }
        return bl;
    }

    public boolean last() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".last()");
        }
        boolean bl = this.absolute(-1);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".last: " + bl);
        }
        return bl;
    }

    public boolean previous() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".previous()");
        }
        boolean bl = this.relative(-1);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".previous: " + bl);
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".relative( " + n + " )");
        }
        switch (this.pos_status) {
            case 1: {
                bl = n > 0 ? this.absolute(n) : false;
                break;
            }
            case 0: {
                bl = this.absolute(this.row_number + n);
                break;
            }
            case 2: {
                bl = n < 0 ? this.absolute(n) : false;
                break;
            }
            default: {
                throw SqlEx.get(GcfErr.ERR_GC401D_RESULTSET_CLOSED);
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".relative: " + bl);
        }
        return bl;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.pos_status == 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".absolute( " + n + " )");
        }
        block0 : switch (this.pos_status) {
            case 1: {
                switch (n) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        bl = this.next();
                        break block0;
                    }
                }
                throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
            }
            case 0: {
                if (n == this.row_number) break;
                if (n == this.row_number + 1) {
                    bl = this.next();
                    break;
                }
                if (n < 0 && n == -1 && (this.row_status & 2) != 0) break;
                if ((this.row_status & 2) != 0) {
                    // empty if block
                }
                throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
            }
            case 2: {
                throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
            }
            default: {
                throw SqlEx.get(GcfErr.ERR_GC401D_RESULTSET_CLOSED);
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".absolute: " + bl);
        }
        return bl;
    }

    public boolean rowUpdated() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.pos_status == 0 && (this.row_status & 4) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rowUpdated(): " + bl);
        }
        return bl;
    }

    public boolean rowDeleted() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.pos_status == 0 && (this.row_status & 8) != 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rowDeleted(): " + bl);
        }
        return bl;
    }

    public boolean rowInserted() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rowInserted(): " + false);
        }
        return false;
    }

    public void insertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".insertRow()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRow()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void deleteRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".deleteRow()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void refreshRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".refreshRow()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void moveToInsertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToInsertRow()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToCurrentRow()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".cancelRowUpdates() ");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateNull(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNull()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBoolean()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateByte()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateShort(int n, short s) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateShort()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateInt()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateLong(int n, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateLong()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateFloat()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDouble()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBigDecimal()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateString(int n, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateString()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBytes()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDate()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTime()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTimestamp()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBinaryStream()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateAsciiStream()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateCharacterStream()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateArray(int n, Array array) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateArray()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBlob()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateClob()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRef()");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.columnByName(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.columnByName(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.columnByName(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.columnByName(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.columnByName(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.columnByName(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.columnByName(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.columnByName(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.columnByName(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.columnByName(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.columnByName(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.columnByName(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.columnByName(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.columnByName(string), timestamp);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.columnByName(string), inputStream, n);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.columnByName(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.columnByName(string), reader, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.columnByName(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.columnByName(string), object, n);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.columnByName(string), array);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.columnByName(string), blob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.columnByName(string), clob);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.columnByName(string), ref);
    }

    public int findColumn(String string) throws SQLException {
        int n;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".findColumn('" + string + "')");
        }
        try {
            n = this.columnByName(string);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".findColumn: not found");
            }
            throw sqlEx;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".findColumn: " + n);
        }
        return n;
    }

    public boolean wasNull() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".wasNull(): " + this.isNull);
        }
        return this.isNull;
    }

    public boolean getBoolean(int n) throws SQLException {
        SqlData sqlData;
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean( " + n + " )");
        }
        boolean bl2 = bl = (sqlData = this.columnDataValue(n)).isNull() ? false : sqlData.getBoolean();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBoolean: " + bl);
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        SqlData sqlData;
        byte by;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte( " + n + " )");
        }
        byte by2 = by = (sqlData = this.columnDataValue(n)).isNull() ? (byte)0 : sqlData.getByte();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getByte: " + by);
        }
        return by;
    }

    public short getShort(int n) throws SQLException {
        SqlData sqlData;
        short s;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort( " + n + " )");
        }
        short s2 = s = (sqlData = this.columnDataValue(n)).isNull() ? (short)0 : sqlData.getShort();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getShort: " + s);
        }
        return s;
    }

    public int getInt(int n) throws SQLException {
        SqlData sqlData;
        int n2;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt( " + n + " )");
        }
        int n3 = n2 = (sqlData = this.columnDataValue(n)).isNull() ? 0 : sqlData.getInt();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getInt: " + n2);
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        SqlData sqlData;
        long l;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong( " + n + " )");
        }
        long l2 = l = (sqlData = this.columnDataValue(n)).isNull() ? 0L : sqlData.getLong();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getLong: " + l);
        }
        return l;
    }

    public float getFloat(int n) throws SQLException {
        SqlData sqlData;
        float f;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat( " + n + " )");
        }
        float f2 = f = (sqlData = this.columnDataValue(n)).isNull() ? 0.0f : sqlData.getFloat();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getFloat: " + f);
        }
        return f;
    }

    public double getDouble(int n) throws SQLException {
        SqlData sqlData;
        double d;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble( " + n + " )");
        }
        double d2 = d = (sqlData = this.columnDataValue(n)).isNull() ? 0.0 : sqlData.getDouble();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDouble: " + d);
        }
        return d;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        SqlData sqlData;
        BigDecimal bigDecimal;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal( " + n + " )");
        }
        BigDecimal bigDecimal2 = bigDecimal = (sqlData = this.columnDataValue(n)).isNull() ? null : sqlData.getBigDecimal();
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        SqlData sqlData;
        BigDecimal bigDecimal;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal( " + n + ", " + n2 + " )");
        }
        BigDecimal bigDecimal2 = bigDecimal = (sqlData = this.columnDataValue(n)).isNull() ? null : sqlData.getBigDecimal(n2);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    public String getString(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString( " + n + " )");
        }
        String string = (sqlData = this.columnDataValue(n)).isNull() ? null : (this.rs_max_len > 0 ? sqlData.getString(this.rs_max_len) : sqlData.getString());
        if (sqlData instanceof IngresDate && ((IngresDate)sqlData).isInterval()) {
            this.warnings = null;
            this.setWarning(SqlWarn.get(GcfErr.ERR_GC401B_INVALID_DATE));
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getString: " + string);
        }
        return string;
    }

    public byte[] getBytes(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes( " + n + " )");
        }
        byte[] byArray = (sqlData = this.columnDataValue(n)).isNull() ? null : (this.rs_max_len > 0 ? sqlData.getBytes(this.rs_max_len) : sqlData.getBytes());
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBytes: " + byArray);
        }
        return byArray;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate( " + n + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
        SqlData sqlData = this.columnDataValue(n);
        Date date2 = date = sqlData.isNull() ? null : sqlData.getDate(timeZone);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getDate: " + date);
        }
        return date;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime( " + n + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
        SqlData sqlData = this.columnDataValue(n);
        Time time2 = time = sqlData.isNull() ? null : sqlData.getTime(timeZone);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTime: " + time);
        }
        return time;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp( " + n + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        TimeZone timeZone = calendar == null ? null : calendar.getTimeZone();
        SqlData sqlData = this.columnDataValue(n);
        Timestamp timestamp2 = timestamp = sqlData.isNull() ? null : sqlData.getTimestamp(timeZone);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getTimestamp: " + timestamp);
        }
        return timestamp;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBinaryStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            inputStream = sqlData.isNull() ? null : sqlData.getBinaryStream();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getBinaryStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBinaryStream: " + inputStream);
        }
        return inputStream;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAsciiStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            inputStream = sqlData.isNull() ? null : sqlData.getAsciiStream();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getAsciiStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getAsciiStream: " + inputStream);
        }
        return inputStream;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUnicodeStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            inputStream = sqlData.isNull() ? null : sqlData.getUnicodeStream();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getUnicodeStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getUnicodeStream: " + inputStream);
        }
        return inputStream;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Reader reader;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream( " + n + " )");
        }
        SqlData sqlData = this.columnDataValue(n);
        try {
            reader = sqlData.isNull() ? null : sqlData.getCharacterStream();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getCharacterStream: error accessing BLOB data");
            }
            if (this.trace.enabled(1)) {
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getCharacterStream: " + reader);
        }
        return reader;
    }

    public Object getObject(int n) throws SQLException {
        SqlData sqlData;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject( " + n + " )");
        }
        Object object = (sqlData = this.columnDataValue(n)).isNull() ? null : (this.rs_max_len > 0 ? sqlData.getObject(this.rs_max_len) : sqlData.getObject());
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getObject: " + object);
        }
        return object;
    }

    public Array getArray(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getArray( " + n + " )");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public Blob getBlob(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getBlob( " + n + " )");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public Clob getClob(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getClob( " + n + " )");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public Ref getRef(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getRef( " + n + " )");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public URL getURL(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getURL( " + n + " )");
        }
        throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.columnByName(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.columnByName(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.columnByName(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.columnByName(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.columnByName(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.columnByName(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.columnByName(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.columnByName(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.columnByName(string), n);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.columnByName(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.columnByName(string));
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.columnByName(string), null);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.columnByName(string), calendar);
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.columnByName(string), null);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.columnByName(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.columnByName(string), null);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.columnByName(string), calendar);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.columnByName(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.columnByName(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.columnByName(string));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.columnByName(string));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.columnByName(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.columnByName(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.columnByName(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.columnByName(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.columnByName(string));
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.columnByName(string));
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.columnByName(string));
    }

    protected int columnMap(int n) throws SqlEx {
        if (this.pos_status == -1) {
            throw SqlEx.get(GcfErr.ERR_GC401D_RESULTSET_CLOSED);
        }
        if (this.pos_status != 0 || (this.row_status & 8) != 0) {
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        if (n < 1 || n > this.rsmd.count) {
            throw SqlEx.get(GcfErr.ERR_GC4011_INDEX_RANGE);
        }
        return n - 1;
    }

    protected SqlData getSqlData(int n) throws SqlEx {
        return this.columns[n];
    }

    private int columnByName(String string) throws SqlEx {
        for (int i = 0; i < this.rsmd.count; ++i) {
            if (this.rsmd.desc[i].name == null || !this.rsmd.desc[i].name.equalsIgnoreCase(string)) continue;
            ++i;
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ": column '" + string + "' => " + i);
            }
            return i;
        }
        if (this.trace.enabled(5)) {
            this.trace.write(this.tr_id + ": column '" + string + "' not found!");
        }
        throw SqlEx.get(GcfErr.ERR_GC4012_INVALID_COLUMN_NAME);
    }

    private synchronized SqlData columnDataValue(int n) throws SqlEx {
        this.warnings = null;
        SqlData sqlData = this.getSqlData(this.columnMap(n));
        this.isNull = sqlData.isNull();
        if (!this.isNull && sqlData.isTruncated()) {
            this.setWarning(new DataTruncation(n, false, true, sqlData.getDataSize(), sqlData.getTruncSize()));
        }
        return sqlData;
    }
}

