/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import java.sql.SQLException;
import java.sql.Savepoint;

abstract class JdbcSP
implements Savepoint {
    private JdbcSP next = null;

    JdbcSP() {
    }

    public abstract String getSavepointName() throws SQLException;

    public abstract int getSavepointId() throws SQLException;

    public abstract String getName();

    static JdbcSP getNamedSP(String string) throws SqlEx {
        return new SpName(string);
    }

    static JdbcSP getUnnamedSP() {
        return new SpId();
    }

    public String toString() {
        return "JdbcSP." + this.getName();
    }

    JdbcSP getNext() {
        return this.next;
    }

    JdbcSP setNext(JdbcSP jdbcSP) {
        JdbcSP jdbcSP2 = this.next;
        this.next = jdbcSP;
        return jdbcSP2;
    }

    private static class SpId
    extends JdbcSP
    implements GcfErr {
        private static int count = 0;
        private int id = ++count;

        SpId() {
        }

        public String getSavepointName() throws SQLException {
            throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
        }

        public int getSavepointId() throws SQLException {
            return this.id;
        }

        public String getName() {
            return Integer.toString(this.id);
        }
    }

    private static class SpName
    extends JdbcSP
    implements GcfErr {
        private String name = null;

        SpName(String string) throws SqlEx {
            if (string == null || string.length() == 0 || Character.isDigit(string.charAt(0))) {
                throw SqlEx.get(GcfErr.ERR_GC4010_PARAM_VALUE);
            }
            this.name = string;
        }

        public String getSavepointName() throws SQLException {
            return this.name;
        }

        public int getSavepointId() throws SQLException {
            throw SqlEx.get(GcfErr.ERR_GC4019_UNSUPPORTED);
        }

        public String getName() {
            return this.name;
        }
    }
}

