/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvTrace;
import com.ingres.gcf.jdbc.JdbcCPConn;
import com.ingres.gcf.jdbc.JdbcConn;
import com.ingres.gcf.jdbc.JdbcXAVirt;
import com.ingres.gcf.jdbc.XARsrcMgr;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.XaXid;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class JdbcXAConn
extends JdbcCPConn
implements XAConnection,
XAResource,
GcfErr {
    private static final int TX_ST_IDLE = 0;
    private static final int TX_ST_ACTIVE = 1;
    private static final int TX_ST_WAIT = 2;
    private static final int TX_ST_READY = 3;
    private static final int TX_ST_FAIL = 4;
    private static final int TX_ST_ABORT = 5;
    private static final Xid[] noXIDs = new Xid[0];
    private XARsrcMgr xarm = null;
    private int tx_state = 0;
    private boolean autoCommit = false;
    private XaXid xid = null;
    private Thread xa_thread = null;
    private String serverID = null;

    public JdbcXAConn(JdbcConn jdbcConn, XARsrcMgr xARsrcMgr, DrvTrace drvTrace) throws SQLException {
        super(jdbcConn, drvTrace);
        this.xarm = xARsrcMgr;
        this.title = drvTrace.getTraceName() + "-XAConnection[" + this.inst_id + "]";
        this.tr_id = "XAConn[" + this.inst_id + "]";
        this.serverID = jdbcConn.getTransactionServer();
        if (this.serverID != null) {
            this.serverID = this.serverID.trim();
            int n = this.serverID.indexOf("::");
            n = this.serverID.indexOf("/@", n < 0 ? 0 : n + 2);
            if (n >= 0) {
                this.serverID = this.serverID.substring(n + 2);
            }
            if (this.serverID.length() == 0) {
                this.serverID = null;
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection()");
        }
        if (this.physConn == null) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": physical connection is closed");
            }
            throw SqlEx.get(GcfErr.ERR_GC4004_CONNECTION_CLOSED);
        }
        switch (this.tx_state) {
            case 0: {
                this.clearConnection();
                if (!this.physConn.getAutoCommit()) {
                    this.physConn.setAutoCommit(true);
                }
                this.virtConn = new JdbcXAVirt(this.physConn, this, this, this.trace, false);
                break;
            }
            case 1: {
                this.clearConnection();
                this.virtConn = new JdbcXAVirt(this.physConn, this, this, this.trace, true);
                break;
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": invalid transaction state: " + this.tx_state);
                }
                throw SqlEx.get(GcfErr.ERR_GC401F_XACT_STATE);
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getConnection(): " + this.virtConn);
        }
        return this.virtConn;
    }

    public void close() throws SQLException {
        if (this.physConn != null && this.xid != null) {
            switch (this.tx_state) {
                case 0: {
                    this.xid = null;
                    this.xa_thread = null;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".close()");
                    }
                    if (this.trace.enabled(2)) {
                        this.trace.write(this.tr_id + ".close(): aborting transaction!");
                    }
                    try {
                        this.rollback(this.xid);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        super.close();
    }

    public XAResource getXAResource() throws SQLException {
        if (this.physConn == null) {
            throw SqlEx.get(GcfErr.ERR_GC4004_CONNECTION_CLOSED);
        }
        return this;
    }

    public boolean isSameRM(XAResource xAResource) {
        return this == xAResource;
    }

    public void start(Xid xid, int n) throws XAException {
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".start( '" + xaXid + "', " + n + " )");
        }
        switch (this.tx_state) {
            case 5: {
                if (this.trace.enabled(2)) {
                    this.trace.write(this.tr_id + ".start(): aborting transaction!");
                }
                try {
                    this.rollback(this.xid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 0: {
                if (n != 0) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".start(): unsupported flags: " + n);
                    }
                    throw new XAException(-5);
                }
                if (this.physConn != null) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".start(): connection closed");
                }
                throw new XAException(-6);
            }
            case 2: {
                if (n == 0x200000 && xaXid.equals(this.xid)) {
                    if (this.trace.enabled(2)) {
                        this.trace.write(this.tr_id + ".start(): JOIN current transaction.");
                    }
                    this.xa_thread = Thread.currentThread();
                    this.tx_state = 1;
                    return;
                }
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".start(): invalid transaction state");
                }
                throw new XAException(-6);
            }
        }
        this.xarm.registerXID(this, xaXid);
        this.xid = xaXid;
        try {
            this.autoCommit = this.physConn.getAutoCommit();
            if (this.autoCommit) {
                this.physConn.setAutoCommit(false);
            }
            this.physConn.startTransaction(this.xid);
            if (this.virtConn != null) {
                ((JdbcXAVirt)this.virtConn).setActiveDTX(true);
            }
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".start: error starting transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            this.xarm.deregisterXID(this, this.xid);
            this.xid = null;
            throw new XAException(-7);
        }
        this.xa_thread = Thread.currentThread();
        this.tx_state = 1;
    }

    public void end(Xid xid, int n) throws XAException {
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".end( '" + xaXid + "', " + n + " )");
        }
        if (n != 0x4000000 && n != 0x20000000) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end(): unsupported flags: " + n);
            }
            throw new XAException(-5);
        }
        if (this.xid == null || !xaXid.equals(this.xid)) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".end(): invalid XID");
            }
            throw new XAException(-4);
        }
        switch (this.tx_state) {
            case 1: {
                break;
            }
            case 5: {
                if (n == 0x20000000) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".end(): transaction aborted");
                }
                throw new XAException(100);
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".end(): invalid transaction state");
                }
                throw new XAException(-6);
            }
        }
        this.tx_state = n == 0x20000000 ? 4 : 2;
    }

    public int prepare(Xid xid) throws XAException {
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".prepare( '" + xaXid + "' )");
        }
        if (this.xid == null || !xaXid.equals(this.xid)) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".prepare(): passing request to XARM");
            }
            return this.xarm.prepareXID(xaXid);
        }
        switch (this.tx_state) {
            case 2: {
                if (this.physConn != null) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".prepare(): connection closed");
                }
                throw new XAException(-6);
            }
            case 5: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".prepare(): transaction aborted");
                }
                throw new XAException(100);
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".prepare(): invalid transaction state");
                }
                throw new XAException(-6);
            }
        }
        try {
            this.physConn.prepareTransaction();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".prepare(): error preparing transaction");
                ((SqlEx)sQLException).trace(this.trace);
            }
            this.tx_state = 4;
            throw new XAException(-3);
        }
        this.tx_state = 3;
        return 0;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".commit( '" + xaXid + "', " + bl + " )");
        }
        if (this.xid == null || !xaXid.equals(this.xid)) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".commit(): passing request to XARM");
            }
            this.xarm.commitXID(xaXid, bl);
            return;
        }
        switch (this.tx_state) {
            case 2: {
                if (this.physConn != null && bl) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".commit(): invalid 1PC transaction state");
                }
                throw new XAException(-6);
            }
            case 3: {
                if (this.physConn != null && !bl) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".commit(): invalid 2PC transaction state");
                }
                throw new XAException(-6);
            }
            case 5: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".end(): transaction aborted");
                }
                throw new XAException(100);
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".commit(): invalid transaction state");
                }
                throw new XAException(-6);
            }
        }
        try {
            block19: {
                try {
                    this.physConn.commit();
                    if (this.virtConn == null || !this.autoCommit) break block19;
                    this.physConn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".commit(): error committing transaction");
                        ((SqlEx)sQLException).trace(this.trace);
                    }
                    try {
                        this.physConn.rollback();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    throw new XAException(-3);
                }
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.xarm.deregisterXID(this, this.xid);
            this.xid = null;
            this.xa_thread = null;
            this.tx_state = 0;
            throw throwable;
        }
        this.xarm.deregisterXID(this, this.xid);
        this.xid = null;
        this.xa_thread = null;
        this.tx_state = 0;
    }

    public void rollback(Xid xid) throws XAException {
        XaXid xaXid;
        XaXid xaXid2 = xaXid = xid instanceof XaXid ? (XaXid)xid : new XaXid(xid);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".rollback( '" + xaXid + "' )");
        }
        if (this.xid == null || !xaXid.equals(this.xid)) {
            if (this.trace.enabled(2)) {
                this.trace.write(this.tr_id + ".rollback(): passing request to XARM");
            }
            this.xarm.rollbackXID(xaXid);
            return;
        }
        switch (this.tx_state) {
            case 1: {
                if (this.physConn == null) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".rollback(): connection closed");
                    }
                    throw new XAException(-6);
                }
                if (this.xa_thread.equals(Thread.currentThread())) break;
                if (this.trace.enabled(2)) {
                    this.trace.write(this.tr_id + ".rollback(): abort transaction at TM request");
                }
                this.abort();
                return;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.physConn != null) break;
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".rollback(): connection closed");
                }
                throw new XAException(-6);
            }
            default: {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".rollback(): invalid transaction state");
                }
                throw new XAException(-6);
            }
        }
        try {
            block17: {
                try {
                    this.physConn.rollback();
                    if (this.virtConn == null || !this.autoCommit) break block17;
                    this.physConn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".rollback(): error aborting transaction");
                        ((SqlEx)sQLException).trace(this.trace);
                    }
                    throw new XAException(-3);
                }
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.xarm.deregisterXID(this, this.xid);
            this.xid = null;
            this.xa_thread = null;
            this.tx_state = 0;
            throw throwable;
        }
        this.xarm.deregisterXID(this, this.xid);
        this.xid = null;
        this.xa_thread = null;
        this.tx_state = 0;
    }

    private void abort() throws XAException {
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".abort()");
        }
        if (this.serverID != null) {
            this.xarm.abortXID(this.xid, this.serverID);
        } else if (this.physConn != null) {
            this.physConn.abort();
            this.physConn = null;
            this.connectionErrorOccurred(new ConnectionEvent(this));
        }
        this.tx_state = 5;
    }

    public Xid[] recover(int n) throws XAException {
        if ((n & 0x1000000) == 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".recover(): no XIDs (non-start request)");
            }
            return noXIDs;
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".recover()");
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ".recover(): passing request to XARM");
        }
        return this.xarm.recoverXID();
    }

    public void forget(Xid xid) throws XAException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".forget(): not supported!");
        }
        throw new XAException(-4);
    }

    public int getTransactionTimeout() {
        return 0;
    }

    public boolean setTransactionTimeout(int n) {
        return false;
    }
}

