/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlBool;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlNull;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

class ParamSet
extends DrvObj
implements DbmsConst,
GcfErr {
    public static final short PS_FLG_PROC_PARAM = 1;
    public static final short PS_FLG_PROC_BYREF = 2;
    public static final short PS_FLG_PROC_GTT = 4;
    public static final short PS_FLG_ALT = 16;
    private static final short PS_FLG_SET = 128;
    private static final SqlVarChar emptyVarChar = new SqlVarChar(new CharSet(), 0);
    private static final SqlNVarChar emptyNVarChar = new SqlNVarChar(0);
    private static final SqlVarByte emptyVarByte = new SqlVarByte(0);
    private static final int EXPAND_SIZE = 10;
    private int param_cnt = 0;
    private Param[] params;
    private short dflt_flags = 0;
    private SqlLongChar tempLongChar = null;
    private SqlLongNChar tempLongNChar = null;
    private SqlLongByte tempLongByte = null;

    public ParamSet(DrvConn drvConn) {
        this(drvConn, 10);
    }

    public ParamSet(DrvConn drvConn, int n) {
        super(drvConn);
        this.params = new Param[n < 0 ? 0 : n];
        this.title = this.trace.getTraceName() + "-ParamSet[" + this.inst_id + "]";
        this.tr_id = "Param[" + this.inst_id + "]";
    }

    public void setDefaultFlags(short s) {
        this.dflt_flags = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear(boolean bl) {
        if (bl) {
            this.param_cnt = this.params.length;
        }
        for (int i = 0; i < this.param_cnt; ++i) {
            if (this.params[i] == null) continue;
            if (bl) {
                this.params[i].clear();
                this.params[i] = null;
                continue;
            }
            Param param = this.params[i];
            synchronized (param) {
                this.params[i].flags = (short)(this.params[i].flags & 0x10);
                this.params[i].name = null;
                continue;
            }
        }
        this.param_cnt = 0;
    }

    public int getCount() {
        return this.param_cnt;
    }

    public synchronized boolean isSet(int n) {
        return n < this.param_cnt && this.params[n] != null && (this.params[n].flags & 0x80) != 0;
    }

    public int getType(int n) {
        return this.check((int)n).type;
    }

    public SqlData getValue(int n) {
        return this.check((int)n).value;
    }

    public short getFlags(int n) {
        return this.check((int)n).flags;
    }

    public String getName(int n) {
        return this.check((int)n).name;
    }

    public void init(int n, int n2) throws SqlEx {
        this.init(n, n2, this.useAltStorage(n2));
    }

    public void init(int n, Object object) throws SqlEx {
        int n2 = SqlData.getSqlType(object);
        this.init(n, n2, this.useAltStorage(n2));
    }

    public void init(int n, Object object, boolean bl) throws SqlEx {
        this.init(n, SqlData.getSqlType(object), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int n, int n2, boolean bl) throws SqlEx {
        Param param = this.check(n);
        n2 = this.checkSqlType(n2);
        Param param2 = param;
        synchronized (param2) {
            if (param.value == null || n2 != param.type || bl != ((param.flags & 0x10) != 0)) {
                this.set(param, n2, bl);
            }
            param.flags = (short)(param.flags & 0xFFFFFF7F);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlags(int n, short s) {
        Param param = this.check(n);
        s = (short)(s & 0xFFFFFF6F);
        Param param2 = param;
        synchronized (param2) {
            param.flags = (short)(param.flags | s);
        }
    }

    public void setName(int n, String string) {
        this.check((int)n).name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int n) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 0, this.useAltStorage(0));
            }
            param.value.setNull();
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(int n, boolean bl) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 16, this.useAltStorage(16));
            }
            param.value.setBoolean(bl);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(int n, byte by) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, -6, this.useAltStorage(-6));
            }
            param.value.setByte(by);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(int n, short s) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 5, this.useAltStorage(5));
            }
            param.value.setShort(s);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int n, int n2) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 4, this.useAltStorage(4));
            }
            param.value.setInt(n2);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int n, long l) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, this.checkSqlType(-5), this.useAltStorage(-5));
            }
            param.value.setLong(l);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(int n, float f) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 7, this.useAltStorage(7));
            }
            param.value.setFloat(f);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int n, double d) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 8, this.useAltStorage(8));
            }
            param.value.setDouble(d);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 3, this.useAltStorage(3));
            }
            param.value.setBigDecimal(bigDecimal);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int n, String string) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 12, this.useAltStorage(12));
            }
            param.value.setString(string);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int n, byte[] byArray) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, -3, this.useAltStorage(-3));
            }
            param.value.setBytes(byArray);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int n, Date date, TimeZone timeZone) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 91, this.useAltStorage(91));
            }
            param.value.setDate(date, timeZone);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int n, Time time, TimeZone timeZone) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 92, this.useAltStorage(92));
            }
            param.value.setTime(time, timeZone);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int n, Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, 93, this.useAltStorage(93));
            }
            param.value.setTimestamp(timestamp, timeZone);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, -4, this.useAltStorage(-4));
            }
            param.value.setBinaryStream(inputStream);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, -1, this.useAltStorage(-1));
            }
            param.value.setAsciiStream(inputStream);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(int n, InputStream inputStream) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, -1, this.useAltStorage(-1));
            }
            param.value.setUnicodeStream(inputStream);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, -1, this.useAltStorage(-1));
            }
            param.value.setCharacterStream(reader);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object) throws SqlEx {
        Param param;
        Param param2 = param = this.check(n);
        synchronized (param2) {
            if (param.value == null) {
                int n2 = SqlData.getSqlType(object);
                this.set(param, this.checkSqlType(n2), this.useAltStorage(n2));
            }
            param.value.setObject(object);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2) throws SqlEx {
        Param param = this.check(n);
        n2 = this.checkSqlType(n2);
        Param param2 = param;
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, n2, this.useAltStorage(n2));
            }
            param.value.setObject(ParamSet.coerce(object, n2));
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2, int n3) throws SqlEx {
        Param param = this.check(n);
        n2 = this.checkSqlType(n2);
        Param param2 = param;
        synchronized (param2) {
            if (param.value == null) {
                this.set(param, n2, this.useAltStorage(n2));
            }
            param.value.setObject(ParamSet.coerce(object, n2), n3);
            param.flags = (short)(param.flags | (0x80 | this.dflt_flags));
        }
    }

    private void set(Param param, int n, boolean bl) throws SqlEx {
        short s = (short)(param.flags & 0xFFFFFFEF);
        if (bl) {
            s = (short)(s | 0x10);
        }
        param.type = n;
        param.value = this.getStorage(n, bl);
        param.flags = s;
    }

    private synchronized Param check(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n >= this.params.length) {
            int n2 = this.params.length + 10;
            if (n >= n2) {
                n2 = n + 10;
            }
            Param[] paramArray = new Param[n2];
            System.arraycopy(this.params, 0, paramArray, 0, this.params.length);
            this.params = paramArray;
        }
        if (this.params[n] == null) {
            this.params[n] = new Param();
        }
        if (this.param_cnt <= n) {
            this.param_cnt = n + 1;
        }
        return this.params[n];
    }

    private boolean useAltStorage(int n) {
        switch (n) {
            case -7: 
            case 16: {
                return true;
            }
            case -5: {
                if (this.conn.db_protocol_level >= 3) {
                    return false;
                }
            }
            case 2: 
            case 3: {
                return !this.conn.is_ingres && this.conn.db_protocol_level < 1;
            }
            case -1: 
            case 1: 
            case 12: {
                return !this.conn.ucs2_supported;
            }
        }
        return false;
    }

    private SqlData getStorage(int n, boolean bl) throws SqlEx {
        SqlData sqlData;
        switch (n) {
            case 0: {
                sqlData = new SqlNull();
                break;
            }
            case -6: {
                sqlData = new SqlTinyInt();
                break;
            }
            case 5: {
                sqlData = new SqlSmallInt();
                break;
            }
            case 4: {
                sqlData = new SqlInt();
                break;
            }
            case 7: {
                sqlData = new SqlReal();
                break;
            }
            case 8: {
                sqlData = new SqlDouble();
                break;
            }
            case -2: {
                sqlData = new SqlByte();
                break;
            }
            case -3: {
                sqlData = new SqlVarByte();
                break;
            }
            case -4: {
                sqlData = new SqlLongByte();
                break;
            }
            case 16: {
                sqlData = bl ? new SqlTinyInt() : new SqlBool();
                break;
            }
            case -5: {
                sqlData = bl ? new SqlDouble() : new SqlBigInt();
                break;
            }
            case 3: {
                sqlData = bl ? new SqlDouble() : new SqlDecimal();
                break;
            }
            case 1: {
                sqlData = bl ? new SqlChar(this.msg.getCharSet()) : new SqlNChar();
                break;
            }
            case 12: {
                sqlData = bl ? new SqlVarChar(this.msg.getCharSet()) : new SqlNVarChar();
                break;
            }
            case -1: {
                sqlData = bl ? new SqlLongChar(this.msg.getCharSet()) : new SqlLongNChar();
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                sqlData = new IngresDate(this.timeValuesInGMT());
                break;
            }
            default: {
                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
            }
        }
        return sqlData;
    }

    private int checkSqlType(int n) throws SqlEx {
        switch (n) {
            case -7: {
                return 16;
            }
            case 6: {
                return 8;
            }
            case 2: {
                return 3;
            }
            case -5: {
                return this.conn.db_protocol_level >= 3 ? -5 : 3;
            }
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return n;
            }
        }
        throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
    }

    private static Object coerce(Object object, int n) throws SqlEx {
        block34: {
            int n2 = SqlData.getSqlType(object);
            block6 : switch (n) {
                case 91: {
                    switch (n2) {
                        case 1: {
                            if (((char[])object).length == 0) break;
                            try {
                                object = Date.valueOf(String.copyValueOf((char[])object));
                                break;
                            }
                            catch (Exception exception) {
                                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                            }
                        }
                        case 12: {
                            if (((String)object).length() == 0) break;
                            try {
                                object = Date.valueOf((String)object);
                                break;
                            }
                            catch (Exception exception) {
                                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                            }
                        }
                        case 93: {
                            object = new Date(((Timestamp)object).getTime());
                        }
                    }
                    break;
                }
                case 92: {
                    switch (n2) {
                        case 1: {
                            if (((char[])object).length == 0) break;
                            try {
                                object = Time.valueOf(String.copyValueOf((char[])object));
                                break;
                            }
                            catch (Exception exception) {
                                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                            }
                        }
                        case 12: {
                            if (((String)object).length() == 0) break;
                            try {
                                object = Time.valueOf((String)object);
                                break;
                            }
                            catch (Exception exception) {
                                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                            }
                        }
                        case 93: {
                            object = new Time(((Timestamp)object).getTime());
                        }
                    }
                    break;
                }
                case 93: {
                    switch (n2) {
                        case 1: {
                            if (((char[])object).length != 0) {
                                try {
                                    object = Timestamp.valueOf(String.copyValueOf((char[])object));
                                    break block6;
                                }
                                catch (Exception exception) {
                                    throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                                }
                            }
                            break block34;
                        }
                        case 12: {
                            if (((String)object).length() != 0) {
                                try {
                                    object = Timestamp.valueOf((String)object);
                                    break block6;
                                }
                                catch (Exception exception) {
                                    throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                                }
                            }
                            break block34;
                        }
                        case 91: {
                            object = new Timestamp(((Date)object).getTime());
                        }
                    }
                }
            }
        }
        return object;
    }

    public synchronized void sendDesc(boolean bl) throws SqlEx {
        int n;
        short s = 0;
        for (n = 0; n < this.param_cnt; ++n) {
            if (this.params[n] == null || (this.params[n].flags & 0x80) == 0) continue;
            s = (short)(s + 1);
        }
        this.msg.begin((byte)6);
        this.msg.write(s);
        for (n = 0; n < this.param_cnt; ++n) {
            if (this.params[n] == null || (this.params[n].flags & 0x80) == 0) continue;
            SqlData sqlData = this.params[n].value;
            short s2 = (short)this.params[n].type;
            short s3 = this.params[n].flags;
            boolean bl2 = (s3 & 0x10) != 0;
            short s4 = 0;
            int n2 = 0;
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            switch (s2) {
                case 0: {
                    s4 = 41;
                    by3 = (byte)(by3 | 1);
                    break;
                }
                case 16: {
                    if (bl2) {
                        s2 = -6;
                        s4 = 30;
                        n2 = 1;
                        break;
                    }
                    s2 = -6;
                    s4 = 30;
                    n2 = 1;
                    break;
                }
                case -6: {
                    s4 = 30;
                    n2 = 1;
                    break;
                }
                case 5: {
                    s4 = 30;
                    n2 = 2;
                    break;
                }
                case 4: {
                    s4 = 30;
                    n2 = 4;
                    break;
                }
                case -5: {
                    if (bl2) {
                        s2 = 8;
                        s4 = 31;
                        n2 = 8;
                        break;
                    }
                    s4 = 30;
                    n2 = 8;
                    break;
                }
                case 7: {
                    s4 = 31;
                    n2 = 4;
                    break;
                }
                case 8: {
                    s4 = 31;
                    n2 = 8;
                    break;
                }
                case 3: {
                    if (bl2) {
                        s2 = 8;
                        s4 = 31;
                        n2 = 8;
                        break;
                    }
                    s4 = 10;
                    by = 15;
                    if (sqlData.isNull()) break;
                    BigDecimal bigDecimal = sqlData.getBigDecimal();
                    String string = sqlData.getString();
                    by = (byte)(string.length() - (bigDecimal.signum() < 0 ? 1 : 0) - (bigDecimal.scale() > 0 ? 1 : 0));
                    by2 = (byte)bigDecimal.scale();
                    if (by2 <= 0 || bigDecimal.longValue() != 0L) break;
                    by = (byte)(by - 1);
                    break;
                }
                case 91: {
                    s2 = 93;
                    s4 = 3;
                    break;
                }
                case 92: {
                    s2 = 93;
                    s4 = 3;
                    break;
                }
                case 93: {
                    s4 = 3;
                    break;
                }
                case 1: {
                    n2 = sqlData.isNull() ? 1 : (bl2 ? ((SqlChar)sqlData).length() : ((SqlNChar)sqlData).length());
                    if (n2 <= 0) {
                        s2 = 12;
                        s4 = bl2 ? (short)21 : 27;
                        break;
                    }
                    if (bl2 && n2 <= this.conn.max_char_len) {
                        s4 = 20;
                        break;
                    }
                    if (!bl2 && n2 <= this.conn.max_nchr_len) {
                        s4 = 26;
                        n2 *= 2;
                        break;
                    }
                    s2 = -1;
                    s4 = bl2 ? (short)22 : 28;
                    n2 = 0;
                    break;
                }
                case 12: {
                    n2 = sqlData.isNull() ? 1 : (bl2 ? ((SqlVarChar)sqlData).length() : ((SqlNVarChar)sqlData).length());
                    if (bl2 && n2 <= this.conn.max_vchr_len) {
                        s4 = 21;
                        break;
                    }
                    if (!bl2 && n2 <= this.conn.max_nvch_len) {
                        s4 = 27;
                        n2 *= 2;
                        break;
                    }
                    s2 = -1;
                    s4 = bl2 ? (short)22 : 28;
                    n2 = 0;
                    break;
                }
                case -1: {
                    s4 = bl2 ? (short)22 : 28;
                    n2 = 0;
                    break;
                }
                case -2: {
                    int n3 = n2 = sqlData.isNull() ? 1 : ((SqlByte)sqlData).length();
                    if (n2 <= 0) {
                        s2 = -3;
                        s4 = 24;
                        break;
                    }
                    if (n2 <= this.conn.max_byte_len) {
                        s4 = 23;
                        break;
                    }
                    s2 = -4;
                    s4 = 25;
                    n2 = 0;
                    break;
                }
                case -3: {
                    int n4 = n2 = sqlData.isNull() ? 1 : ((SqlVarByte)sqlData).length();
                    if (n2 <= this.conn.max_vbyt_len) {
                        s4 = 24;
                        break;
                    }
                    s2 = -4;
                    s4 = 25;
                    n2 = 0;
                    break;
                }
                case -4: {
                    s4 = 25;
                    n2 = 0;
                }
            }
            if (sqlData.isNull()) {
                by3 = (byte)(by3 | 1);
            }
            if ((s3 & 1) != 0) {
                by3 = (byte)(by3 | 2);
            }
            if ((s3 & 2) != 0) {
                by3 = (byte)(by3 | 4);
            }
            if ((s3 & 4) != 0) {
                by3 = (byte)(by3 | 8);
            }
            this.msg.write(s2);
            this.msg.write(s4);
            this.msg.write((short)n2);
            this.msg.write(by);
            this.msg.write(by2);
            this.msg.write(by3);
            if (this.params[n].name == null) {
                this.msg.write((short)0);
                continue;
            }
            this.msg.write(this.params[n].name);
        }
        this.msg.done(bl);
    }

    public synchronized void sendData(boolean bl) throws SqlEx {
        this.msg.begin((byte)7);
        block18: for (int i = 0; i < this.param_cnt; ++i) {
            if (this.params[i] == null || (this.params[i].flags & 0x80) == 0) continue;
            SqlData sqlData = this.params[i].value;
            short s = (short)this.params[i].type;
            boolean bl2 = (this.params[i].flags & 0x10) != 0;
            switch (s) {
                case 0: {
                    this.msg.write((SqlNull)sqlData);
                    continue block18;
                }
                case -6: {
                    this.msg.write((SqlTinyInt)sqlData);
                    continue block18;
                }
                case 5: {
                    this.msg.write((SqlSmallInt)sqlData);
                    continue block18;
                }
                case 4: {
                    this.msg.write((SqlInt)sqlData);
                    continue block18;
                }
                case 7: {
                    this.msg.write((SqlReal)sqlData);
                    continue block18;
                }
                case 8: {
                    this.msg.write((SqlDouble)sqlData);
                    continue block18;
                }
                case 91: 
                case 92: 
                case 93: {
                    this.msg.write((IngresDate)sqlData);
                    continue block18;
                }
                case 16: {
                    if (bl2) {
                        this.msg.write((SqlTinyInt)sqlData);
                        continue block18;
                    }
                    if (sqlData.isNull()) {
                        this.msg.write((byte)0);
                        continue block18;
                    }
                    this.msg.write((byte)1);
                    this.msg.write((byte)(sqlData.getBoolean() ? 1 : 0));
                    continue block18;
                }
                case -5: {
                    if (bl2) {
                        this.msg.write((SqlDouble)sqlData);
                        continue block18;
                    }
                    this.msg.write((SqlBigInt)sqlData);
                    continue block18;
                }
                case 3: {
                    if (bl2) {
                        this.msg.write((SqlDouble)sqlData);
                        continue block18;
                    }
                    this.msg.write((SqlDecimal)sqlData);
                    continue block18;
                }
                case 1: {
                    int n = sqlData.isNull() ? 1 : (bl2 ? ((SqlChar)sqlData).length() : ((SqlNChar)sqlData).length());
                    if (bl2) {
                        if (n <= 0) {
                            this.msg.write(emptyVarChar);
                            continue block18;
                        }
                        if (n <= this.conn.max_char_len) {
                            this.msg.write((SqlChar)sqlData);
                            continue block18;
                        }
                        if (this.tempLongChar == null) {
                            this.tempLongChar = new SqlLongChar(this.msg.getCharSet());
                        }
                        this.tempLongChar.set((SqlChar)sqlData);
                        this.msg.write(this.tempLongChar);
                        continue block18;
                    }
                    if (n <= 0) {
                        this.msg.write(emptyNVarChar);
                        continue block18;
                    }
                    if (n <= this.conn.max_nchr_len) {
                        this.msg.write((SqlNChar)sqlData);
                        continue block18;
                    }
                    if (this.tempLongNChar == null) {
                        this.tempLongNChar = new SqlLongNChar();
                    }
                    this.tempLongNChar.set((SqlNChar)sqlData);
                    this.msg.write(this.tempLongNChar);
                    continue block18;
                }
                case 12: {
                    int n = sqlData.isNull() ? 1 : (bl2 ? ((SqlVarChar)sqlData).length() : ((SqlNVarChar)sqlData).length());
                    if (bl2) {
                        if (n <= this.conn.max_vchr_len) {
                            this.msg.write((SqlVarChar)sqlData);
                            continue block18;
                        }
                        if (this.tempLongChar == null) {
                            this.tempLongChar = new SqlLongChar(this.msg.getCharSet());
                        }
                        this.tempLongChar.set((SqlVarChar)sqlData);
                        this.msg.write(this.tempLongChar);
                        continue block18;
                    }
                    if (n <= this.conn.max_nvch_len) {
                        this.msg.write((SqlNVarChar)sqlData);
                        continue block18;
                    }
                    if (this.tempLongNChar == null) {
                        this.tempLongNChar = new SqlLongNChar();
                    }
                    this.tempLongNChar.set((SqlNVarChar)sqlData);
                    this.msg.write(this.tempLongNChar);
                    continue block18;
                }
                case -1: {
                    if (bl2) {
                        this.msg.write((SqlLongChar)sqlData);
                        continue block18;
                    }
                    this.msg.write((SqlLongNChar)sqlData);
                    continue block18;
                }
                case -2: {
                    int n;
                    int n2 = n = sqlData.isNull() ? 1 : ((SqlByte)sqlData).length();
                    if (n <= 0) {
                        this.msg.write(emptyVarByte);
                        continue block18;
                    }
                    if (n <= this.conn.max_byte_len) {
                        this.msg.write((SqlByte)sqlData);
                        continue block18;
                    }
                    if (this.tempLongByte == null) {
                        this.tempLongByte = new SqlLongByte();
                    }
                    this.tempLongByte.set((SqlByte)sqlData);
                    this.msg.write(this.tempLongByte);
                    continue block18;
                }
                case -3: {
                    int n;
                    int n3 = n = sqlData.isNull() ? 1 : ((SqlVarByte)sqlData).length();
                    if (n <= this.conn.max_vbyt_len) {
                        this.msg.write((SqlVarByte)sqlData);
                        continue block18;
                    }
                    if (this.tempLongByte == null) {
                        this.tempLongByte = new SqlLongByte();
                    }
                    this.tempLongByte.set((SqlVarByte)sqlData);
                    this.msg.write(this.tempLongByte);
                    continue block18;
                }
                case -4: {
                    this.msg.write((SqlLongByte)sqlData);
                }
            }
        }
        this.msg.done(bl);
    }

    static {
        emptyVarChar.clear();
        emptyNVarChar.clear();
        emptyVarByte.clear();
    }

    private static class Param {
        public int type = 1111;
        public SqlData value = null;
        public short flags = 0;
        public String name = null;

        public Param() {
        }

        public Param(int n, SqlData sqlData, short s, String string) {
            this.type = n;
            this.value = sqlData;
            this.flags = s;
            this.name = string;
        }

        public synchronized void clear() {
            this.type = 1111;
            this.value = null;
            this.flags = 0;
            this.name = null;
        }

        public synchronized void set(int n, SqlData sqlData, short s, String string) {
            this.type = n;
            this.value = sqlData;
            this.flags = s;
            this.name = string;
        }
    }
}

