/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;

class ProcInfo
extends DrvObj
implements GcfErr {
    public static final int PARAM_DEFAULT = 0;
    public static final int PARAM_DYNAMIC = 1;
    public static final int PARAM_CHAR = 2;
    public static final int PARAM_BYTE = 3;
    public static final int PARAM_INT = 4;
    public static final int PARAM_DEC = 5;
    public static final int PARAM_FLOAT = 6;
    public static final int PARAM_SESSION = 7;
    private static final int ARRAY_INC = 10;
    private String schema = null;
    private String name = null;
    private boolean hasRetVal = false;
    private int param_cnt = 0;
    private Param[] params = new Param[10];
    private static JdbcRSMD rsmd = null;
    private boolean haveParamNames = false;
    private int current = 0;

    ProcInfo(DrvConn drvConn) {
        super(drvConn);
        this.title = this.trace.getTraceName() + "-ProcInfo[" + this.inst_id + "]";
        this.tr_id = "ProcInfo[" + this.inst_id + "]";
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setReturn(boolean bl) {
        this.hasRetVal = bl;
    }

    public boolean getReturn() {
        return this.hasRetVal;
    }

    public void clearParams() {
        this.param_cnt = 0;
        this.haveParamNames = false;
    }

    public void setParamName(int n, String string) throws SqlEx {
        this.check(n, true);
        this.params[n].name = string;
        this.haveParamNames = true;
    }

    public void setParam(int n, int n2, Object object) throws SqlEx {
        this.check(n, true);
        this.params[n].type = n2;
        this.params[n].value = object;
    }

    public int getParamCount() {
        return this.param_cnt;
    }

    public int getParamType(int n) throws SqlEx {
        this.check(n, false);
        return this.params[n].type;
    }

    public Object getParamValue(int n) throws SqlEx {
        this.check(n, false);
        return this.params[n].value;
    }

    public String getParamName(int n) throws SqlEx {
        this.check(n, false);
        return this.params[n].name;
    }

    public boolean paramNamesLoaded() {
        return this.haveParamNames;
    }

    public void loadParamNames() throws SqlEx {
        if (this.param_cnt < 1 || this.haveParamNames || this.name == null) {
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": skip loading parameter names (" + this.param_cnt + "," + this.haveParamNames + "," + this.name + ")");
            }
            return;
        }
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": loading procedure parameter names");
        }
        this.haveParamNames = true;
        this.current = 0;
        this.msg.lock();
        try {
            this.msg.begin((byte)10);
            this.msg.write((short)2);
            if (this.schema != null) {
                this.msg.write((short)1);
                this.msg.write(this.schema);
            }
            this.msg.write((short)2);
            this.msg.write(this.name);
            this.msg.done(true);
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": error loading procedure parameter names");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
            this.clearResults();
        }
    }

    protected JdbcRSMD readDesc() throws SqlEx {
        if (rsmd == null) {
            rsmd = JdbcRSMD.load(this.conn);
        } else {
            rsmd.reload(this.conn);
        }
        return rsmd;
    }

    protected boolean readData() throws SqlEx {
        while (this.msg.moreData()) {
            this.msg.readByte();
            if (this.current < this.param_cnt) {
                ++this.current;
                this.params[this.current].name = this.msg.readString();
                continue;
            }
            this.msg.skip(this.msg.readShort());
        }
        return false;
    }

    private synchronized void check(int n, boolean bl) throws SqlEx {
        if (n < 0 || n >= this.param_cnt && !bl) {
            throw SqlEx.get(GcfErr.ERR_GC4011_INDEX_RANGE);
        }
        if (n >= this.params.length) {
            int n2;
            for (n2 = this.params.length + 10; n >= n2; n2 += 10) {
            }
            Param[] paramArray = new Param[n2];
            System.arraycopy(this.params, 0, paramArray, 0, this.params.length);
            this.params = paramArray;
        }
        while (this.param_cnt <= n) {
            if (this.params[this.param_cnt] == null) {
                this.params[this.param_cnt] = new Param();
            }
            ++this.param_cnt;
        }
    }

    private static class Param {
        public int type = 0;
        public Object value = null;
        public String name = null;

        private Param() {
        }
    }
}

