/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlNull;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;

class RsltFtch
extends JdbcRslt
implements MsgConst,
DbmsConst,
SqlStream.StreamListener {
    protected boolean cursorClosed = false;
    protected SqlStream activeStream = null;
    private JdbcStmt stmt = null;
    private long stmt_id = 0L;
    private int column_count = 0;
    private boolean rowCacheEnabled = true;
    private LinkedList rowCache = null;
    private LinkedList freeCache = null;

    public RsltFtch(DrvConn drvConn, JdbcStmt jdbcStmt, JdbcRSMD jdbcRSMD, long l, int n) throws SqlEx {
        super(drvConn, jdbcRSMD);
        this.stmt = jdbcStmt;
        this.stmt_id = l;
        this.rs_max_len = jdbcStmt.rs_max_len;
        this.rs_fetch_dir = jdbcStmt.rs_fetch_dir;
        this.rs_max_rows = jdbcStmt.rs_max_rows;
        this.rs_fetch_size = this.rs_max_rows > 0 && this.rs_max_rows < n ? this.rs_max_rows : n;
        this.tr_id = "Ftch[" + this.inst_id + "]";
        for (int i = 0; i < jdbcRSMD.count; ++i) {
            if (jdbcRSMD.desc[i].sql_type != -1 && jdbcRSMD.desc[i].sql_type != -4) continue;
            this.rowCacheEnabled = false;
            break;
        }
    }

    public Statement getStatement() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getStatement(): " + this.stmt);
        }
        return this.stmt;
    }

    protected void disablePreFetch() {
        if (this.rowCacheEnabled) {
            if (this.rowCache == null) {
                this.rowCacheEnabled = false;
            } else if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": attempt to disable pre-fetch after init");
            }
        }
    }

    protected boolean preLoad() throws SqlEx {
        if (this.msg.moreMessages()) {
            this.initRowCache();
            this.readResults();
        }
        return (this.rslt_flags & 4) != 0 && this.activeStream == null;
    }

    protected void load() throws SqlEx {
        if (this.rowCacheEnabled && this.rowCache == null) {
            this.initRowCache();
        }
        if (this.activeStream != null) {
            this.flush();
        }
        this.column_count = 0;
        if (!(this.cursorClosed || this.rowCacheEnabled && !this.rowCache.isEmpty())) {
            this.fetch();
            if ((this.rslt_flags & 4) != 0 && this.activeStream == null) {
                try {
                    this.closeCursor();
                }
                catch (SqlEx sqlEx) {
                    // empty catch block
                }
            }
        }
        if (this.rowCacheEnabled && !this.rowCache.isEmpty()) {
            this.columns = (SqlData[])this.rowCache.removeFirst();
            this.freeCache.addLast(this.columns);
            this.column_count = this.rsmd.count;
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ".load(): returning cached row");
            }
        }
        if (this.column_count > 0) {
            this.pos_status = 0;
            this.row_status = 0;
            ++this.row_number;
            if (this.row_number == 1) {
                this.row_status |= 1;
            }
            if (this.cursorClosed && (!this.rowCacheEnabled || this.rowCache.isEmpty())) {
                this.row_status |= 2;
            }
        } else {
            this.pos_status = 2;
            this.row_status = 0;
            ++this.row_number;
            this.columns = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shut() throws SqlEx {
        try {
            if (this.activeStream != null) {
                this.flush();
            }
            this.closeCursor();
            Object var3_1 = null;
            if (this.rowCache != null) {
                this.rowCache.clear();
                this.freeCache.clear();
            }
            this.column_count = 0;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (this.rowCache != null) {
                this.rowCache.clear();
                this.freeCache.clear();
            }
            this.column_count = 0;
            boolean bl = super.shut();
            throw throwable;
        }
        boolean bl = super.shut();
        return bl;
    }

    protected int columnMap(int n) throws SqlEx {
        if ((n = super.columnMap(n)) >= this.column_count) {
            this.flush(n);
        }
        return n;
    }

    protected void fetch() throws SqlEx {
        this.msg.begin((byte)5);
        this.msg.write((short)2);
        this.msg.write((short)1);
        this.msg.write((short)8);
        this.msg.write((int)(this.stmt_id >> 32 & 0xFFFFFFFFFFFFFFFFL));
        this.msg.write((int)(this.stmt_id & 0xFFFFFFFFFFFFFFFFL));
        if (this.rowCacheEnabled && this.rs_fetch_size > 1) {
            this.msg.write((short)2);
            this.msg.write((short)4);
            this.msg.write(this.rs_fetch_size);
        }
        this.msg.done(true);
        this.readResults();
    }

    protected void resume() throws SqlEx {
        if (this.msg.moreData()) {
            if (this.trace.enabled(5)) {
                this.trace.write(this.tr_id + ".resume: continue current message");
            }
            if (this.readData()) {
                return;
            }
        }
        if (this.trace.enabled(5)) {
            this.trace.write(this.tr_id + ".resume: read next message");
        }
        this.readResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCursor() throws SqlEx {
        block12: {
            RsltFtch rsltFtch = this;
            synchronized (rsltFtch) {
                if (this.cursorClosed) {
                    return;
                }
                this.cursorClosed = true;
            }
            if ((this.rslt_flags & 8) != 0) {
                if (this.trace.enabled(3)) {
                    this.trace.write(this.tr_id + ": cursor automatically closed at EOD!");
                }
                return;
            }
            if (this.msg.isClosed()) {
                return;
            }
            if (this.trace.enabled(3)) {
                this.trace.write(this.tr_id + ": closing cursor");
            }
            try {
                this.msg.begin((byte)5);
                this.msg.write((short)1);
                this.msg.write((short)1);
                this.msg.write((short)8);
                this.msg.write((int)(this.stmt_id >> 32 & 0xFFFFFFFFFFFFFFFFL));
                this.msg.write((int)(this.stmt_id & 0xFFFFFFFFFFFFFFFFL));
                this.msg.done(true);
                this.readResults();
            }
            catch (SqlEx sqlEx) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ".shut(): error closing cursor");
                    sqlEx.trace(this.trace);
                }
                if (sqlEx.getErrorCode() == 804881) break block12;
                throw sqlEx;
            }
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ": cursor closed!");
        }
    }

    public void streamClosed(SqlStream sqlStream) {
        if (this.activeStream == null || this.activeStream != sqlStream) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": invalid BLOB stream closure!");
            }
            return;
        }
        if (this.trace.enabled(4)) {
            this.trace.write(this.tr_id + ": BLOB stream closed");
        }
        try {
            this.activeStream = null;
            this.resume();
            if ((this.rslt_flags & 4) != 0 && this.activeStream == null) {
                try {
                    this.closeCursor();
                }
                catch (SqlEx sqlEx) {}
            }
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.log(this.tr_id + ": error loading remainder of row");
                sqlEx.trace(this.trace);
            }
            try {
                this.shut();
            }
            catch (SqlEx sqlEx2) {
                // empty catch block
            }
        }
    }

    protected void flush() throws SqlEx {
        while (this.activeStream != null) {
            this.activeStream.closeStream();
        }
    }

    protected void flush(int n) throws SqlEx {
        while (n >= this.column_count && this.activeStream != null) {
            this.activeStream.closeStream();
        }
    }

    protected void setProcResult(int n) throws SqlEx {
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".setProcResult(" + n + ")");
        }
        this.stmt.setProcResult(n);
    }

    protected boolean readData() throws SqlEx {
        if (this.rowCacheEnabled) {
            this.loadRowCache();
            return false;
        }
        if (this.column_count >= this.rsmd.count) {
            this.column_count = 0;
        }
        int n = this.column_count;
        if (this.columns == null) {
            this.columns = this.allocateRowBuffer(this.rsmd);
        }
        boolean bl = this.readColumns(this.rsmd, this.columns);
        if (this.column_count > 0 && this.column_count < this.rsmd.count && !bl) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": failed to load entire row");
            }
            throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
        }
        if (this.trace.enabled(3) && this.column_count > n) {
            this.trace.write(this.tr_id + ".load(): read " + (this.column_count - n) + " of " + this.rsmd.count + " columns starting with " + (n + 1));
        }
        return bl;
    }

    private void initRowCache() {
        if (this.rowCacheEnabled && this.rowCache == null) {
            this.rowCache = new LinkedList();
            this.freeCache = new LinkedList();
        }
    }

    private void loadRowCache() throws SqlEx {
        int n = 0;
        if (this.column_count <= 0 || this.column_count >= this.rsmd.count) {
            this.column_count = 0;
        } else {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": can't load row cache due to partial row");
            }
            throw new SqlEx("JDBC DRIVER INTERNAL ERROR: invalid row cache state");
        }
        while (this.msg.moreData()) {
            SqlData[] sqlDataArray = this.freeCache.isEmpty() ? this.allocateRowBuffer(this.rsmd) : (SqlData[])this.freeCache.removeFirst();
            if (this.readColumns(this.rsmd, sqlDataArray)) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": BLOB column loaded during pre-fetch");
                }
                throw new SqlEx("JDBC DRIVER INTERNAL ERROR: BLOB columns not supported when cacheing rows");
            }
            if (this.column_count < this.rsmd.count) {
                if (this.trace.enabled(1)) {
                    this.trace.write(this.tr_id + ": pre-fetch failed to load entire row");
                }
                throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
            }
            this.rowCache.addLast(sqlDataArray);
            ++n;
            this.column_count = 0;
        }
        if (this.trace.enabled(3)) {
            this.trace.write(this.tr_id + ".load(): Loaded " + n + " rows into cache");
        }
    }

    private SqlData[] allocateRowBuffer(JdbcRSMD jdbcRSMD) throws SqlEx {
        SqlData[] sqlDataArray = new SqlData[jdbcRSMD.count];
        block17: for (int i = 0; i < jdbcRSMD.count; ++i) {
            switch (jdbcRSMD.desc[i].sql_type) {
                case 0: {
                    sqlDataArray[i] = new SqlNull();
                    continue block17;
                }
                case -6: {
                    sqlDataArray[i] = new SqlTinyInt();
                    continue block17;
                }
                case 5: {
                    sqlDataArray[i] = new SqlSmallInt();
                    continue block17;
                }
                case 4: {
                    sqlDataArray[i] = new SqlInt();
                    continue block17;
                }
                case -5: {
                    sqlDataArray[i] = new SqlBigInt();
                    continue block17;
                }
                case 7: {
                    sqlDataArray[i] = new SqlReal();
                    continue block17;
                }
                case 6: 
                case 8: {
                    sqlDataArray[i] = new SqlDouble();
                    continue block17;
                }
                case 2: 
                case 3: {
                    sqlDataArray[i] = new SqlDecimal();
                    continue block17;
                }
                case 93: {
                    sqlDataArray[i] = new IngresDate(this.timeValuesInGMT());
                    continue block17;
                }
                case -2: {
                    sqlDataArray[i] = new SqlByte(jdbcRSMD.desc[i].length);
                    continue block17;
                }
                case -3: {
                    sqlDataArray[i] = new SqlVarByte(jdbcRSMD.desc[i].length);
                    continue block17;
                }
                case 1: {
                    if (jdbcRSMD.desc[i].dbms_type != 26) {
                        sqlDataArray[i] = new SqlChar(this.msg.getCharSet(), jdbcRSMD.desc[i].length);
                        continue block17;
                    }
                    sqlDataArray[i] = new SqlNChar(jdbcRSMD.desc[i].length / 2);
                    continue block17;
                }
                case 12: {
                    if (jdbcRSMD.desc[i].dbms_type != 27) {
                        sqlDataArray[i] = new SqlVarChar(this.msg.getCharSet(), jdbcRSMD.desc[i].length);
                        continue block17;
                    }
                    sqlDataArray[i] = new SqlNVarChar(jdbcRSMD.desc[i].length / 2);
                    continue block17;
                }
                case -4: {
                    sqlDataArray[i] = new SqlLongByte(this);
                    continue block17;
                }
                case -1: {
                    if (jdbcRSMD.desc[i].dbms_type != 28) {
                        sqlDataArray[i] = new SqlLongChar(this.msg.getCharSet(), this);
                        continue block17;
                    }
                    sqlDataArray[i] = new SqlLongNChar(this);
                    continue block17;
                }
                default: {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": unexpected SQL type " + jdbcRSMD.desc[i].sql_type);
                    }
                    throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                }
            }
        }
        return sqlDataArray;
    }

    private boolean readColumns(JdbcRSMD jdbcRSMD, SqlData[] sqlDataArray) throws SqlEx {
        while (this.column_count < jdbcRSMD.count) {
            int n = this.column_count++;
            if (!this.msg.moreData()) {
                return false;
            }
            switch (jdbcRSMD.desc[n].sql_type) {
                case 0: {
                    this.msg.readSqlData((SqlNull)sqlDataArray[n]);
                    break;
                }
                case -6: {
                    this.msg.readSqlData((SqlTinyInt)sqlDataArray[n]);
                    break;
                }
                case 5: {
                    this.msg.readSqlData((SqlSmallInt)sqlDataArray[n]);
                    break;
                }
                case 4: {
                    this.msg.readSqlData((SqlInt)sqlDataArray[n]);
                    break;
                }
                case -5: {
                    this.msg.readSqlData((SqlBigInt)sqlDataArray[n]);
                    break;
                }
                case 7: {
                    this.msg.readSqlData((SqlReal)sqlDataArray[n]);
                    break;
                }
                case 6: 
                case 8: {
                    this.msg.readSqlData((SqlDouble)sqlDataArray[n]);
                    break;
                }
                case 2: 
                case 3: {
                    this.msg.readSqlData((SqlDecimal)sqlDataArray[n]);
                    break;
                }
                case 93: {
                    this.msg.readSqlData((IngresDate)sqlDataArray[n]);
                    break;
                }
                case -2: {
                    this.msg.readSqlData((SqlByte)sqlDataArray[n]);
                    break;
                }
                case -3: {
                    this.msg.readSqlData((SqlVarByte)sqlDataArray[n]);
                    break;
                }
                case 1: {
                    if (jdbcRSMD.desc[n].dbms_type != 26) {
                        this.msg.readSqlData((SqlChar)sqlDataArray[n]);
                        break;
                    }
                    this.msg.readSqlData((SqlNChar)sqlDataArray[n]);
                    break;
                }
                case 12: {
                    if (jdbcRSMD.desc[n].dbms_type != 27) {
                        this.msg.readSqlData((SqlVarChar)sqlDataArray[n]);
                        break;
                    }
                    this.msg.readSqlData((SqlNVarChar)sqlDataArray[n]);
                    break;
                }
                case -4: {
                    this.msg.readSqlData((SqlLongByte)sqlDataArray[n]);
                    if (sqlDataArray[n].isNull()) break;
                    this.activeStream = (SqlStream)sqlDataArray[n];
                    return true;
                }
                case -1: {
                    if (jdbcRSMD.desc[n].dbms_type != 28) {
                        this.msg.readSqlData((SqlLongChar)sqlDataArray[n]);
                    } else {
                        this.msg.readSqlData((SqlLongNChar)sqlDataArray[n]);
                    }
                    if (sqlDataArray[n].isNull()) break;
                    this.activeStream = (SqlStream)sqlDataArray[n];
                    ++this.column_count;
                    return true;
                }
                default: {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": unexpected SQL type " + jdbcRSMD.desc[n].sql_type);
                    }
                    throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                }
            }
            ++this.column_count;
        }
        return false;
    }
}

