/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.dam.MsgConst;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.ParamSet;
import com.ingres.gcf.jdbc.RsltCurs;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.IngresDate;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlByte;
import com.ingres.gcf.util.SqlChar;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlNChar;
import com.ingres.gcf.util.SqlNVarChar;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlTinyInt;
import com.ingres.gcf.util.SqlVarByte;
import com.ingres.gcf.util.SqlVarChar;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class RsltUpd
extends RsltCurs
implements MsgConst,
DbmsConst,
GcfErr {
    private String table = null;
    private ParamSet params = null;
    private boolean insert = false;

    public RsltUpd(DrvConn drvConn, JdbcStmt jdbcStmt, JdbcRSMD jdbcRSMD, long l, String string, String string2) throws SqlEx {
        super(drvConn, jdbcStmt, jdbcRSMD, l, string, 1, false);
        this.rs_concur = 1008;
        this.table = string2;
        this.params = new ParamSet(drvConn, jdbcRSMD.count);
        this.tr_id = "Upd[" + this.inst_id + "]";
        this.disablePreFetch();
    }

    protected void load() throws SqlEx {
        if (this.insert) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".load(): invalid row");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        this.params.clear(false);
        super.load();
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToInsertRow()");
        }
        if (!this.insert) {
            this.params.clear(false);
            this.insert = true;
        }
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".moveToCurrentRow()");
        }
        if (this.insert) {
            this.params.clear(false);
            this.insert = false;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".cancelRowUpdates()");
        }
        this.params.clear(false);
    }

    public int getRow() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".getRow(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.getRow();
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isBeforeFirst(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isAfterLast(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isFirst(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.isFirst();
    }

    public boolean isLast() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".isLast(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.isLast();
    }

    public boolean rowUpdated() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rowUpdated(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.rowUpdated();
    }

    public boolean rowDeleted() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rowDeleted(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".rowInserted(): insert row!");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        return super.rowInserted();
    }

    public void updateNull(int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateNull(" + n + ")");
        }
        n = this.columnMap(n);
        if (!this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setNull(n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBoolean( " + n + "," + bl + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setBoolean(n, bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateByte(" + n + "," + by + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setByte(n, by);
    }

    public void updateShort(int n, short s) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateShort(" + n + "," + s + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setShort(n, s);
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateInt(" + n + "," + n2 + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setInt(n, n2);
    }

    public void updateLong(int n, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateLong(" + n + "," + l + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setLong(n, l);
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateFloat(" + n + "," + f + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setFloat(n, f);
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDouble(" + n + "," + d + ")");
        }
        n = this.columnMap(n);
        this.initParam(n);
        this.params.setDouble(n, d);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBigDecimal(" + n + "," + bigDecimal + ")");
        }
        n = this.columnMap(n);
        if (bigDecimal == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setBigDecimal(n, bigDecimal);
    }

    public void updateString(int n, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateString(" + n + "," + string + ")");
        }
        n = this.columnMap(n);
        if (string == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setString(n, string);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBytes(" + n + "," + byArray + ")");
        }
        n = this.columnMap(n);
        if (byArray == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setBytes(n, byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateDate(" + n + "," + date + ")");
        }
        n = this.columnMap(n);
        if (date == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setDate(n, date, null);
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTime(" + n + "," + time + ")");
        }
        n = this.columnMap(n);
        if (time == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setTime(n, time, null);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateTimestamp(" + n + "," + timestamp + ")");
        }
        n = this.columnMap(n);
        if (timestamp == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setTimestamp(n, timestamp, null);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateBinaryStream(" + n + "," + n2 + ")");
        }
        n = this.columnMap(n);
        if (inputStream == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setBinaryStream(n, inputStream);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateAsciiStream(" + n + "," + n2 + ")");
        }
        n = this.columnMap(n);
        if (inputStream == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setAsciiStream(n, inputStream);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateCharacterStream(" + n + "," + n2 + ")");
        }
        n = this.columnMap(n);
        if (reader == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setCharacterStream(n, reader);
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject(" + n + "," + object + ")");
        }
        n = this.columnMap(n);
        if (object == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.initParam(n);
        this.params.setObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateObject(" + n + "," + object + "," + n2 + ")");
        }
        n = this.columnMap(n);
        if (object == null && !this.rsmd.desc[n].nullable) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        int n3 = this.rsmd.desc[n].sql_type;
        this.initParam(n);
        this.params.setObject(n, object, n3, n2);
    }

    public void refreshRow() throws SQLException {
        if (this.insert) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".refreshRow(): invalid row");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        this.params.clear(false);
        super.refreshRow();
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".deleteRow()");
        }
        if (this.insert || this.pos_status != 0 || (this.row_status & 8) != 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".deleteRow(): invalid row");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        try {
            if (this.activeStream != null) {
                this.flush();
            }
            this.exec((short)7, "delete from " + this.table, null);
            this.row_status |= 8;
            this.row_status &= 0xFFFFFFFB;
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".deleteRow(): error deleting row");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.params.clear(false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".deleteRow(): row deleted!");
        }
    }

    public synchronized void updateRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRow()");
        }
        if (this.insert || this.pos_status != 0 || (this.row_status & 8) != 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".updateRow(): invalid row");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rsmd.count; ++i) {
            if (!this.params.isSet(i)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.rsmd.desc[i].name);
            stringBuffer.append(" = ~V ");
        }
        if (stringBuffer.length() <= 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".updateRow(): no columns updated, request ignored.");
            }
            return;
        }
        String string = "update " + this.table + " set " + stringBuffer.toString();
        try {
            if (this.activeStream != null) {
                this.flush();
            }
            this.exec((short)8, string, this.params);
            this.row_status |= 4;
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".updateRow(): error updating row");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.copyParams();
            this.params.clear(false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".updateRow(): row updated!");
        }
    }

    public synchronized void insertRow() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".insertRow()");
        }
        if (!this.insert || this.pos_status == -1) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".insertRow(): invalid row");
            }
            throw SqlEx.get(GcfErr.ERR_GC4021_INVALID_ROW);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < this.rsmd.count; ++i) {
            if (!this.params.isSet(i)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
                stringBuffer2.append(",");
            }
            stringBuffer.append(this.rsmd.desc[i].name);
            stringBuffer2.append(" ~V ");
        }
        if (stringBuffer.length() <= 0) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".insertRow(): no values");
            }
            throw SqlEx.get(GcfErr.ERR_GC4020_NO_PARAM);
        }
        String string = "insert into " + this.table + "(" + stringBuffer.toString() + ") values(" + stringBuffer2.toString() + ")";
        try {
            if (this.activeStream != null) {
                this.flush();
            }
            this.exec((short)1, string, this.params);
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ".insertRow(): error inserting row");
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.params.clear(false);
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".insertRow(): row inserted!");
        }
    }

    private synchronized int initParam(int n) throws SqlEx {
        boolean bl = false;
        switch (this.rsmd.desc[n].sql_type) {
            case 1: {
                bl = this.rsmd.desc[n].dbms_type != 26;
                break;
            }
            case 12: {
                bl = this.rsmd.desc[n].dbms_type != 27;
                break;
            }
            case -1: {
                bl = this.rsmd.desc[n].dbms_type != 28;
            }
        }
        this.params.init(n, this.rsmd.desc[n].sql_type, bl);
        return n;
    }

    private void copyParams() throws SqlEx {
        block16: for (int i = 0; i < this.rsmd.count; ++i) {
            if (!this.params.isSet(i)) continue;
            switch (this.rsmd.desc[i].sql_type) {
                case 0: {
                    continue block16;
                }
                case -6: {
                    ((SqlTinyInt)this.columns[i]).set((SqlTinyInt)this.params.getValue(i));
                    continue block16;
                }
                case 5: {
                    ((SqlSmallInt)this.columns[i]).set((SqlSmallInt)this.params.getValue(i));
                    continue block16;
                }
                case 4: {
                    ((SqlInt)this.columns[i]).set((SqlInt)this.params.getValue(i));
                    continue block16;
                }
                case -5: {
                    ((SqlBigInt)this.columns[i]).set((SqlBigInt)this.params.getValue(i));
                    continue block16;
                }
                case 7: {
                    ((SqlReal)this.columns[i]).set((SqlReal)this.params.getValue(i));
                    continue block16;
                }
                case 6: 
                case 8: {
                    ((SqlDouble)this.columns[i]).set((SqlDouble)this.params.getValue(i));
                    continue block16;
                }
                case 2: 
                case 3: {
                    ((SqlDecimal)this.columns[i]).set((SqlDecimal)this.params.getValue(i));
                    continue block16;
                }
                case 93: {
                    ((IngresDate)this.columns[i]).set((IngresDate)this.params.getValue(i));
                    continue block16;
                }
                case -2: {
                    ((SqlByte)this.columns[i]).set((SqlByte)this.params.getValue(i));
                    continue block16;
                }
                case -3: {
                    ((SqlVarByte)this.columns[i]).set((SqlVarByte)this.params.getValue(i));
                    continue block16;
                }
                case 1: {
                    if (this.rsmd.desc[i].dbms_type != 26) {
                        ((SqlChar)this.columns[i]).set((SqlChar)this.params.getValue(i));
                        continue block16;
                    }
                    ((SqlNChar)this.columns[i]).set((SqlNChar)this.params.getValue(i));
                    continue block16;
                }
                case 12: {
                    if (this.rsmd.desc[i].dbms_type != 27) {
                        ((SqlVarChar)this.columns[i]).set((SqlVarChar)this.params.getValue(i));
                        continue block16;
                    }
                    ((SqlNVarChar)this.columns[i]).set((SqlNVarChar)this.params.getValue(i));
                    continue block16;
                }
                case -4: 
                case -1: {
                    continue block16;
                }
                default: {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ": unexpected SQL type " + this.rsmd.desc[i].sql_type);
                    }
                    throw SqlEx.get(GcfErr.ERR_GC4002_PROTOCOL_ERR);
                }
            }
        }
    }

    protected int columnMap(int n) throws SqlEx {
        if (!this.insert) {
            return super.columnMap(n);
        }
        if (this.pos_status == -1) {
            throw SqlEx.get(GcfErr.ERR_GC401D_RESULTSET_CLOSED);
        }
        if (n < 1 || n > this.rsmd.count) {
            throw SqlEx.get(GcfErr.ERR_GC4011_INDEX_RANGE);
        }
        return n - 1;
    }

    protected SqlData getSqlData(int n) throws SqlEx {
        SqlData sqlData;
        if (this.params.isSet(n)) {
            sqlData = this.params.getValue(n);
        } else if (!this.insert) {
            sqlData = super.getSqlData(n);
        } else {
            throw SqlEx.get(GcfErr.ERR_GC4011_INDEX_RANGE);
        }
        return sqlData;
    }

    private void exec(short s, String string, ParamSet paramSet) throws SqlEx {
        this.clearResults();
        this.msg.lock();
        try {
            this.msg.begin((byte)4);
            this.msg.write(s);
            if (s == 7 || s == 8) {
                this.msg.write((short)2);
                this.msg.write(this.cursor);
            }
            this.msg.write((short)1);
            this.msg.write(string);
            if (paramSet == null) {
                this.msg.done(true);
            } else {
                this.msg.done(false);
                paramSet.sendDesc(false);
                paramSet.sendData(true);
            }
            this.readResults();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.write(this.tr_id + ": error executing query: " + string);
                sqlEx.trace(this.trace);
            }
            throw sqlEx;
        }
        finally {
            this.msg.unlock();
        }
    }
}

