/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcRslt;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlBigInt;
import com.ingres.gcf.util.SqlBool;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDecimal;
import com.ingres.gcf.util.SqlDouble;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlInt;
import com.ingres.gcf.util.SqlReal;
import com.ingres.gcf.util.SqlSmallInt;
import com.ingres.gcf.util.SqlString;
import com.ingres.gcf.util.SqlTinyInt;
import java.sql.SQLException;

class RsltXlat
extends JdbcRslt {
    protected JdbcRslt dbmsRS = null;

    public RsltXlat(DrvConn drvConn, JdbcRSMD jdbcRSMD, JdbcRslt jdbcRslt) throws SqlEx {
        super(drvConn, jdbcRSMD);
        this.dbmsRS = jdbcRslt;
        this.columns = this.allocateRowBuffer(jdbcRSMD);
        this.tr_id = "Xlat[" + this.inst_id + "]";
    }

    protected void load() throws SqlEx {
        try {
            if (!this.dbmsRS.next()) {
                this.pos_status = 2;
                ++this.row_number;
                this.row_status = 0;
                this.columns = null;
            } else {
                this.load_data();
                this.pos_status = 0;
                ++this.row_number;
                this.row_status = 0;
                if (this.dbmsRS.isFirst()) {
                    this.row_status |= 1;
                }
                if (this.dbmsRS.isLast()) {
                    this.row_status |= 2;
                }
            }
        }
        catch (SQLException sQLException) {
            throw (SqlEx)sQLException;
        }
    }

    boolean shut() throws SqlEx {
        boolean bl = super.shut();
        if (bl) {
            try {
                this.dbmsRS.close();
            }
            catch (SQLException sQLException) {
                throw (SqlEx)sQLException;
            }
        }
        return bl;
    }

    protected void load_data() throws SQLException {
        for (int i = 0; i < this.rsmd.count; ++i) {
            this.convert(i, i + 1);
        }
    }

    protected void convert(int n, int n2) throws SQLException {
        switch (this.rsmd.desc[n].sql_type) {
            case 5: {
                short s = this.dbmsRS.getShort(n2);
                if (!this.dbmsRS.wasNull()) {
                    ((SqlSmallInt)this.columns[n]).set(s);
                    break;
                }
                this.columns[n].setNull();
                break;
            }
            case 4: {
                int n3 = this.dbmsRS.getInt(n2);
                if (!this.dbmsRS.wasNull()) {
                    ((SqlInt)this.columns[n]).set(n3);
                    break;
                }
                this.columns[n].setNull();
                break;
            }
            case 12: {
                String string = this.dbmsRS.getString(n2);
                if (string != null) {
                    ((SqlString)this.columns[n]).set(string.trim());
                    break;
                }
                this.columns[n].setNull();
                break;
            }
            default: {
                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    private SqlData[] allocateRowBuffer(JdbcRSMD jdbcRSMD) throws SqlEx {
        SqlData[] sqlDataArray = new SqlData[jdbcRSMD.count];
        block11: for (int i = 0; i < jdbcRSMD.count; ++i) {
            switch (jdbcRSMD.desc[i].sql_type) {
                case 16: {
                    sqlDataArray[i] = new SqlBool();
                    continue block11;
                }
                case -6: {
                    sqlDataArray[i] = new SqlTinyInt();
                    continue block11;
                }
                case 5: {
                    sqlDataArray[i] = new SqlSmallInt();
                    continue block11;
                }
                case 4: {
                    sqlDataArray[i] = new SqlInt();
                    continue block11;
                }
                case -5: {
                    sqlDataArray[i] = new SqlBigInt();
                    continue block11;
                }
                case 7: {
                    sqlDataArray[i] = new SqlReal();
                    continue block11;
                }
                case 8: {
                    sqlDataArray[i] = new SqlDouble();
                    continue block11;
                }
                case 3: {
                    sqlDataArray[i] = new SqlDecimal();
                    continue block11;
                }
                case 12: {
                    sqlDataArray[i] = new SqlString();
                    continue block11;
                }
                default: {
                    throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                }
            }
        }
        return sqlDataArray;
    }
}

