/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class IngresDate
extends SqlData {
    private String value = null;
    private boolean use_gmt = false;
    private boolean interval = false;

    public IngresDate(boolean bl) {
        super(true);
        this.use_gmt = bl;
    }

    public void set(String string) {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = string;
            this.interval = false;
        }
    }

    public void set(IngresDate ingresDate) {
        if (ingresDate == null || ingresDate.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = ingresDate.value;
            this.interval = ingresDate.interval;
        }
    }

    public String get() {
        return this.value;
    }

    public boolean isInterval() {
        return !this.isNull() && this.interval;
    }

    public boolean isTruncated() {
        return !this.isNull() && !this.interval && this.value.length() != "yyyy-MM-dd HH:mm:ss".length();
    }

    public int getDataSize() {
        return "yyyy-MM-dd HH:mm:ss".length();
    }

    public int getTruncSize() {
        return this.value.length();
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else if (string.length() == 0) {
            this.setNotNull();
            this.value = string;
            this.interval = false;
        } else {
            Timestamp timestamp;
            try {
                timestamp = Timestamp.valueOf(string);
            }
            catch (Exception exception) {
                java.sql.Date date;
                try {
                    date = java.sql.Date.valueOf(string);
                }
                catch (Exception exception2) {
                    Time time;
                    try {
                        time = Time.valueOf(string);
                    }
                    catch (Exception exception3) {
                        throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
                    }
                    this.setTime(time, null);
                    return;
                }
                this.setDate(date, null);
                return;
            }
            this.setTimestamp(timestamp, null);
        }
    }

    public void setDate(java.sql.Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.interval = false;
            this.value = timeZone != null ? SqlDates.formatDate((Date)date, timeZone) : SqlDates.formatDate((Date)date, false);
        }
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        if (time == null) {
            this.setNull();
        } else {
            if (timeZone != null && !this.use_gmt) {
                String string = SqlDates.formatTime((Date)time, timeZone);
                time = SqlDates.parseTime(string, false);
            }
            this.setNotNull();
            this.value = SqlDates.formatTimestamp((Date)time, this.use_gmt);
            this.interval = false;
        }
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        if (timestamp == null) {
            this.setNull();
        } else {
            if (timeZone != null && !this.use_gmt) {
                String string = SqlDates.formatTimestamp((Date)timestamp, timeZone);
                timestamp = SqlDates.parseTimestamp(string, false);
            }
            this.setNotNull();
            this.value = SqlDates.formatTimestamp((Date)timestamp, this.use_gmt);
            this.interval = false;
        }
    }

    public String getString() throws SqlEx {
        String string;
        try {
            if (this.value.length() == 0) {
                string = this.value;
            } else if (this.value.length() == "yyyy-MM-dd".length()) {
                java.sql.Date date = SqlDates.parseDate(this.value, false);
                string = SqlDates.formatDate((Date)date, false);
            } else if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                Timestamp timestamp = SqlDates.parseTimestamp(this.value, this.use_gmt);
                string = SqlDates.formatTimestamp((Date)timestamp, false);
            } else {
                this.interval = true;
                string = this.value;
            }
        }
        catch (SqlEx sqlEx) {
            this.interval = true;
            string = this.value;
        }
        return string;
    }

    public java.sql.Date getDate(TimeZone timeZone) throws SqlEx {
        try {
            if (this.value.length() == 0) {
                return timeZone == null ? SqlDates.getEpochDate() : SqlDates.parseDate("1970-01-01", timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd".length()) {
                return timeZone == null ? SqlDates.parseDate(this.value, false) : SqlDates.parseDate(this.value, timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                Timestamp timestamp = SqlDates.parseTimestamp(this.value, this.use_gmt);
                String string = SqlDates.formatDate((Date)timestamp, false);
                return timeZone == null ? SqlDates.parseDate(string, false) : SqlDates.parseDate(string, timeZone);
            }
            throw SqlEx.get(GcfErr.ERR_GC401B_INVALID_DATE);
        }
        catch (SqlEx sqlEx) {
            this.interval = true;
            throw sqlEx;
        }
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        try {
            if (this.value.length() == 0 || this.value.length() == "yyyy-MM-dd".length()) {
                return timeZone == null ? SqlDates.getEpochTime() : SqlDates.parseTime("00:00:00", timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                Timestamp timestamp = SqlDates.parseTimestamp(this.value, this.use_gmt);
                String string = SqlDates.formatTime((Date)timestamp, false);
                return timeZone == null ? SqlDates.parseTime(string, false) : SqlDates.parseTime(string, timeZone);
            }
            throw SqlEx.get(GcfErr.ERR_GC401B_INVALID_DATE);
        }
        catch (SqlEx sqlEx) {
            this.interval = true;
            throw sqlEx;
        }
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        try {
            if (this.value.length() == 0) {
                return timeZone == null ? SqlDates.getEpochTimestamp() : SqlDates.parseTimestamp("1970-01-01 00:00:00", timeZone);
            }
            if (this.value.length() == "yyyy-MM-dd".length()) {
                java.sql.Date date = timeZone == null ? SqlDates.parseDate(this.value, false) : SqlDates.parseDate(this.value, timeZone);
                return new Timestamp(date.getTime());
            }
            if (this.value.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                Timestamp timestamp = SqlDates.parseTimestamp(this.value, this.use_gmt);
                if (timeZone != null) {
                    String string = SqlDates.formatTimestamp((Date)timestamp, false);
                    timestamp = SqlDates.parseTimestamp(string, timeZone);
                }
                return timestamp;
            }
            throw SqlEx.get(GcfErr.ERR_GC401B_INVALID_DATE);
        }
        catch (SqlEx sqlEx) {
            this.interval = true;
            throw sqlEx;
        }
    }

    public Object getObject() throws SqlEx {
        return this.getTimestamp(null);
    }
}

