/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;

public class SqlBigInt
extends SqlData {
    private long value = 0L;

    public SqlBigInt() {
        super(true);
    }

    public SqlBigInt(long l) {
        super(false);
        this.value = l;
    }

    public void set(long l) {
        this.setNotNull();
        this.value = l;
    }

    public void set(SqlBigInt sqlBigInt) {
        if (sqlBigInt == null || sqlBigInt.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlBigInt.value;
        }
    }

    public long get() {
        return this.value;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setNotNull();
        this.value = bl ? 1L : 0L;
    }

    public void setByte(byte by) throws SqlEx {
        this.setNotNull();
        this.value = by;
    }

    public void setShort(short s) throws SqlEx {
        this.setNotNull();
        this.value = s;
    }

    public void setInt(int n) throws SqlEx {
        this.setNotNull();
        this.value = n;
    }

    public void setLong(long l) throws SqlEx {
        this.setNotNull();
        this.value = l;
    }

    public void setFloat(float f) throws SqlEx {
        this.setNotNull();
        this.value = (long)f;
    }

    public void setDouble(double d) throws SqlEx {
        this.setNotNull();
        this.value = (long)d;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = bigDecimal.longValue();
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Long.parseLong(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    public boolean getBoolean() throws SqlEx {
        return this.value != 0L;
    }

    public byte getByte() throws SqlEx {
        return (byte)this.value;
    }

    public short getShort() throws SqlEx {
        return (short)this.value;
    }

    public int getInt() throws SqlEx {
        return (int)this.value;
    }

    public long getLong() throws SqlEx {
        return this.value;
    }

    public float getFloat() throws SqlEx {
        return this.value;
    }

    public double getDouble() throws SqlEx {
        return this.value;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return BigDecimal.valueOf(this.value);
    }

    public String getString() throws SqlEx {
        return Long.toString(this.value);
    }

    public Object getObject() throws SqlEx {
        return new Long(this.value);
    }
}

