/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;

public class SqlBool
extends SqlData {
    private boolean value = false;

    public SqlBool() {
        super(true);
    }

    public SqlBool(boolean bl) {
        super(false);
        this.value = bl;
    }

    public void set(boolean bl) {
        this.setNotNull();
        this.value = bl;
    }

    public void set(SqlBool sqlBool) {
        if (sqlBool == null || sqlBool.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlBool.value;
        }
    }

    public boolean get() {
        return this.value;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setNotNull();
        this.value = bl;
    }

    public void setByte(byte by) throws SqlEx {
        this.setNotNull();
        this.value = by != 0;
    }

    public void setShort(short s) throws SqlEx {
        this.setNotNull();
        this.value = s != 0;
    }

    public void setInt(int n) throws SqlEx {
        this.setNotNull();
        this.value = n != 0;
    }

    public void setLong(long l) throws SqlEx {
        this.setNotNull();
        this.value = l != 0L;
    }

    public void setFloat(float f) throws SqlEx {
        this.setNotNull();
        this.value = f != 0.0f;
    }

    public void setDouble(double d) throws SqlEx {
        this.setNotNull();
        this.value = d != 0.0;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = bigDecimal.signum() != 0;
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = Boolean.valueOf(string.trim());
        }
    }

    public boolean getBoolean() throws SqlEx {
        return this.value;
    }

    public byte getByte() throws SqlEx {
        return (byte)(this.value ? 1 : 0);
    }

    public short getShort() throws SqlEx {
        return (short)(this.value ? 1 : 0);
    }

    public int getInt() throws SqlEx {
        return this.value ? 1 : 0;
    }

    public long getLong() throws SqlEx {
        return this.value ? 1L : 0L;
    }

    public float getFloat() throws SqlEx {
        return this.value ? 1.0f : 0.0f;
    }

    public double getDouble() throws SqlEx {
        return this.value ? 1.0 : 0.0;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return BigDecimal.valueOf(this.value ? 1L : 0L);
    }

    public String getString() throws SqlEx {
        return Boolean.toString(this.value);
    }

    public Object getObject() throws SqlEx {
        return new Boolean(this.value);
    }
}

