/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ByteArray;
import com.ingres.gcf.util.CharSet;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlVarChar;
import java.io.UnsupportedEncodingException;

public class SqlChar
extends SqlVarChar
implements ByteArray {
    public SqlChar(CharSet charSet) {
        super(charSet);
    }

    public SqlChar(CharSet charSet, int n) {
        super(charSet, n);
        this.ensure(n);
    }

    public void limit(int n) {
        super.limit(n, true);
    }

    public void limit(int n, boolean bl) {
        super.limit(n, true);
    }

    public int length() {
        return this.limit >= 0 ? this.limit : this.length;
    }

    public void set(SqlChar sqlChar) {
        if (sqlChar == null || sqlChar.isNull()) {
            this.setNull();
        } else {
            this.clear();
            this.put(sqlChar.value, 0, sqlChar.length);
        }
    }

    public byte get(int n) {
        if (n >= this.length) {
            this.extend();
        }
        return super.get(n);
    }

    public byte[] get() {
        this.extend();
        return super.get();
    }

    public int get(int n, int n2, byte[] byArray, int n3) {
        if (n + n2 > this.length) {
            this.extend();
        }
        return super.get(n, n2, byArray, n3);
    }

    public String getString() throws SqlEx {
        this.extend();
        return super.getString();
    }

    public String getString(int n) throws SqlEx {
        if (n > this.length) {
            this.extend();
        }
        return super.getString(n);
    }

    void extend() {
        int n;
        try {
            n = this.charSet.getSpaceChar();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            n = 32;
        }
        while (this.length < this.limit) {
            this.value[this.length] = n;
            ++this.length;
        }
    }
}

