/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SqlDates
implements GcfErr {
    public static final String D_EPOCH = "1970-01-01";
    public static final String T_EPOCH = "00:00:00";
    public static final String TS_EPOCH = "1970-01-01 00:00:00";
    public static final String D_FMT = "yyyy-MM-dd";
    public static final String T_FMT = "HH:mm:ss";
    public static final String TS_FMT = "yyyy-MM-dd HH:mm:ss";
    public static final String D_LIT_FMT = "yyyy_MM_dd";
    public static final String T_LIT_FMT = "HH:mm:ss";
    public static final String TS_LIT_FMT = "yyyy_MM_dd HH:mm:ss";
    private static TimeZone tz_gmt = TimeZone.getTimeZone("GMT");
    private static TimeZone tz_lcl = TimeZone.getDefault();
    private static DateFormat df_ts_val = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat df_d_val = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat df_t_val = new SimpleDateFormat("HH:mm:ss");
    private static DateFormat df_ts_lit = new SimpleDateFormat("yyyy_MM_dd HH:mm:ss");
    private static DateFormat df_d_lit = new SimpleDateFormat("yyyy_MM_dd");
    private static DateFormat df_t_lit = new SimpleDateFormat("HH:mm:ss");
    private static java.sql.Date epochDate = null;
    private static Time epochTime = null;
    private static Timestamp epochTS = null;

    public static java.sql.Date getEpochDate() throws SqlEx {
        if (epochDate == null) {
            epochDate = SqlDates.parseDate(D_EPOCH, tz_lcl);
        }
        return epochDate;
    }

    public static Time getEpochTime() throws SqlEx {
        if (epochTime == null) {
            epochTime = SqlDates.parseTime(T_EPOCH, tz_lcl);
        }
        return epochTime;
    }

    public static Timestamp getEpochTimestamp() throws SqlEx {
        if (epochTS == null) {
            epochTS = SqlDates.parseTimestamp(TS_EPOCH, tz_lcl);
        }
        return epochTS;
    }

    public static Time parseTime(String string, boolean bl) throws SqlEx {
        return SqlDates.parseTime(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time parseTime(String string, TimeZone timeZone) throws SqlEx {
        Date date;
        DateFormat dateFormat = df_t_val;
        synchronized (dateFormat) {
            df_t_val.setTimeZone(timeZone);
            try {
                date = df_t_val.parse(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(GcfErr.ERR_GC401B_INVALID_DATE);
            }
        }
        return new Time(date.getTime());
    }

    public static String formatTime(Date date, boolean bl) {
        return SqlDates.formatTime(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTime(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_t_val;
        synchronized (dateFormat) {
            df_t_val.setTimeZone(timeZone);
            string = df_t_val.format(date);
        }
        return string;
    }

    public static String formatTimeLit(Date date, boolean bl) {
        return SqlDates.formatTimeLit(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimeLit(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_t_lit;
        synchronized (dateFormat) {
            df_t_lit.setTimeZone(timeZone);
            string = df_t_lit.format(date);
        }
        return string;
    }

    public static java.sql.Date parseDate(String string, boolean bl) throws SqlEx {
        return SqlDates.parseDate(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date parseDate(String string, TimeZone timeZone) throws SqlEx {
        Date date;
        DateFormat dateFormat = df_d_val;
        synchronized (dateFormat) {
            df_d_val.setTimeZone(timeZone);
            try {
                date = df_d_val.parse(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(GcfErr.ERR_GC401B_INVALID_DATE);
            }
        }
        return new java.sql.Date(date.getTime());
    }

    public static String formatDate(Date date, boolean bl) {
        return SqlDates.formatDate(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_d_val;
        synchronized (dateFormat) {
            df_d_val.setTimeZone(timeZone);
            string = df_d_val.format(date);
        }
        return string;
    }

    public static String formatDateLit(Date date, boolean bl) {
        return SqlDates.formatDateLit(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateLit(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_d_lit;
        synchronized (dateFormat) {
            df_d_lit.setTimeZone(timeZone);
            string = df_d_lit.format(date);
        }
        return string;
    }

    public static Timestamp parseTimestamp(String string, boolean bl) throws SqlEx {
        return SqlDates.parseTimestamp(string, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp parseTimestamp(String string, TimeZone timeZone) throws SqlEx {
        Date date;
        DateFormat dateFormat = df_ts_val;
        synchronized (dateFormat) {
            df_ts_val.setTimeZone(timeZone);
            try {
                date = df_ts_val.parse(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(GcfErr.ERR_GC401B_INVALID_DATE);
            }
        }
        return new Timestamp(date.getTime());
    }

    public static String formatTimestamp(Date date, boolean bl) {
        return SqlDates.formatTimestamp(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestamp(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_ts_val;
        synchronized (dateFormat) {
            df_ts_val.setTimeZone(timeZone);
            string = df_ts_val.format(date);
        }
        return string;
    }

    public static String formatTimestampLit(Date date, boolean bl) {
        return SqlDates.formatTimestampLit(date, bl ? tz_gmt : tz_lcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimestampLit(Date date, TimeZone timeZone) {
        String string;
        DateFormat dateFormat = df_ts_lit;
        synchronized (dateFormat) {
            df_ts_lit.setTimeZone(timeZone);
            string = df_ts_lit.format(date);
        }
        return string;
    }

    private SqlDates() {
    }
}

