/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;

public class SqlDecimal
extends SqlData {
    private BigDecimal value = null;
    private boolean truncated = false;
    private static final int maxPrecision = 31;

    public SqlDecimal() {
        super(true);
    }

    public void set(String string) {
        if (string == null) {
            this.setNull();
            this.truncated = false;
        } else if (string.length() > 0) {
            this.value = new BigDecimal(string);
            this.setNotNull();
            this.truncated = false;
        } else {
            this.value = new BigDecimal(0.0);
            this.setNotNull();
            this.truncated = true;
        }
    }

    public void set(SqlDecimal sqlDecimal) {
        if (sqlDecimal == null || sqlDecimal.isNull()) {
            this.setNull();
            this.truncated = false;
        } else {
            this.setNotNull();
            this.value = sqlDecimal.value;
            this.truncated = sqlDecimal.truncated;
        }
    }

    public String get() {
        return this.value.toString();
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(bl ? 1L : 0L);
    }

    public void setByte(byte by) throws SqlEx {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(by);
    }

    public void setShort(short s) throws SqlEx {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(s);
    }

    public void setInt(int n) throws SqlEx {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(n);
    }

    public void setLong(long l) throws SqlEx {
        this.setNotNull();
        this.truncated = false;
        this.value = BigDecimal.valueOf(l);
    }

    public void setFloat(float f) throws SqlEx {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(f);
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.value = SqlDecimal.checkPrecision(bigDecimal);
        this.setNotNull();
        this.truncated = false;
    }

    public void setDouble(double d) throws SqlEx {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(d);
        }
        catch (NumberFormatException numberFormatException) {
            throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
        }
        this.value = SqlDecimal.checkPrecision(bigDecimal);
        this.setNotNull();
        this.truncated = false;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.value = SqlDecimal.checkPrecision(bigDecimal);
            this.setNotNull();
        }
        this.truncated = false;
    }

    public void setBigDecimal(BigDecimal bigDecimal, int n) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            bigDecimal = bigDecimal.setScale(n, 4);
            this.value = SqlDecimal.checkPrecision(bigDecimal);
            this.setNotNull();
        }
        this.truncated = false;
    }

    protected void setScale(int n) throws SqlEx {
        if (this.value != null) {
            this.value = this.value.scale() < n ? SqlDecimal.checkPrecision(this.value.setScale(n, 4)) : this.value.setScale(n, 4);
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
            }
            this.value = SqlDecimal.checkPrecision(bigDecimal);
            this.setNotNull();
        }
        this.truncated = false;
    }

    public boolean getBoolean() throws SqlEx {
        return this.value.signum() != 0;
    }

    public byte getByte() throws SqlEx {
        return this.value.byteValue();
    }

    public short getShort() throws SqlEx {
        return this.value.shortValue();
    }

    public int getInt() throws SqlEx {
        return this.value.intValue();
    }

    public long getLong() throws SqlEx {
        return this.value.longValue();
    }

    public float getFloat() throws SqlEx {
        return this.value.floatValue();
    }

    public double getDouble() throws SqlEx {
        return this.value.doubleValue();
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return this.value;
    }

    public String getString() throws SqlEx {
        return this.value.toString();
    }

    public Object getObject() throws SqlEx {
        return this.getBigDecimal();
    }

    private static BigDecimal checkPrecision(BigDecimal bigDecimal) throws SqlEx {
        int n;
        int n2 = bigDecimal.unscaledValue().toString().length() - (bigDecimal.signum() < 0 ? 1 : 0);
        int n3 = Math.max(n2, n = bigDecimal.scale()) - 31;
        if (n3 > 0) {
            if (n >= n3) {
                bigDecimal = bigDecimal.setScale(n - n3, 4);
            } else {
                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
            }
        }
        return bigDecimal;
    }
}

