/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.ErrRsrc;
import com.ingres.gcf.util.Trace;
import java.sql.SQLException;

public class SqlEx
extends SQLException {
    public static SqlEx get(ErrInfo errInfo) {
        String string;
        try {
            string = ErrRsrc.getResource().getString(errInfo.id);
        }
        catch (Exception exception) {
            string = errInfo.name;
        }
        return new SqlEx(string, errInfo.sqlState, errInfo.code);
    }

    public static SqlEx get(ErrInfo errInfo, SqlEx sqlEx) {
        SqlEx sqlEx2 = SqlEx.get(errInfo);
        sqlEx2.setNextException(sqlEx);
        return sqlEx2;
    }

    public static SqlEx get(ErrInfo errInfo, Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        SqlEx sqlEx = string == null ? SqlEx.get(errInfo) : SqlEx.get(errInfo, new SqlEx(string));
        return sqlEx;
    }

    public SqlEx(String string) {
        super(string);
    }

    public SqlEx(String string, String string2, int n) {
        super(string, string2, n);
    }

    public void trace(Trace trace) {
        for (SqlEx sqlEx = this; sqlEx != null; sqlEx = (SqlEx)sqlEx.getNextException()) {
            trace.write("Exception: " + sqlEx.getSQLState() + ", 0x" + Integer.toHexString(sqlEx.getErrorCode()));
            trace.write("  Message: " + sqlEx.getMessage());
        }
    }

    public static class ErrInfo {
        public int code;
        public String sqlState;
        public String id;
        public String name;

        public ErrInfo(int n, String string, String string2, String string3) {
            this.code = n;
            this.sqlState = string;
            this.id = string2;
            this.name = string3;
        }
    }
}

