/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.CharArray;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlNVarChar
extends SqlData
implements CharArray {
    private static final char[] empty = new char[0];
    protected char[] value = empty;
    protected int limit = -1;
    protected int length = 0;

    public SqlNVarChar() {
        super(true);
    }

    public SqlNVarChar(int n) {
        this();
        this.limit = n;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int n) {
        this.ensure(n);
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int n) {
        int n2 = this.limit = n < 0 ? -1 : n;
        if (this.limit >= 0 && this.length > this.limit) {
            this.length = this.limit;
        }
    }

    public void limit(int n, boolean bl) {
        this.limit(n);
        if (bl) {
            this.ensure(n);
        }
    }

    public int length() {
        return this.length;
    }

    public void clear() {
        this.setNotNull();
        this.length = 0;
    }

    public void set(SqlNVarChar sqlNVarChar) {
        if (sqlNVarChar == null || sqlNVarChar.isNull()) {
            this.setNull();
        } else {
            this.clear();
            this.put(sqlNVarChar.value, 0, sqlNVarChar.length);
        }
    }

    public int put(char c) {
        if (this.limit >= 0 && this.length >= this.limit) {
            return 0;
        }
        this.ensure(this.length + 1);
        this.value[this.length++] = c;
        return 1;
    }

    public int put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public int put(char[] cArray, int n, int n2) {
        int n3;
        int n4 = n3 = this.limit < 0 ? n2 : this.limit - this.length;
        if (n2 > n3) {
            n2 = n3;
        }
        this.ensure(this.length + n2);
        System.arraycopy(cArray, n, this.value, this.length, n2);
        this.length += n2;
        return n2;
    }

    public char get(int n) {
        return n >= this.length ? (char)'\u0000' : this.value[n];
    }

    public char[] get() {
        char[] cArray = new char[this.length];
        System.arraycopy(this.value, 0, cArray, 0, this.length);
        return cArray;
    }

    public int get(char[] cArray) {
        return this.get(0, cArray.length, cArray, 0);
    }

    public int get(int n, int n2, char[] cArray, int n3) {
        int n4;
        int n5 = n4 = n >= this.length ? 0 : this.length - n;
        if (n2 > n4) {
            n2 = n4;
        }
        System.arraycopy(this.value, n, cArray, n3, n2);
        return n2;
    }

    protected void ensure(int n) {
        if (this.limit >= 0 && n > this.limit) {
            n = this.limit;
        }
        if (n > this.value.length) {
            char[] cArray = new char[n];
            System.arraycopy(this.value, 0, cArray, 0, this.length);
            this.value = cArray;
        }
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setString(Boolean.toString(bl));
    }

    public void setByte(byte by) throws SqlEx {
        this.setString(Byte.toString(by));
    }

    public void setShort(short s) throws SqlEx {
        this.setString(Short.toString(s));
    }

    public void setInt(int n) throws SqlEx {
        this.setString(Integer.toString(n));
    }

    public void setLong(long l) throws SqlEx {
        this.setString(Long.toString(l));
    }

    public void setFloat(float f) throws SqlEx {
        this.setString(Float.toString(f));
    }

    public void setDouble(double d) throws SqlEx {
        this.setString(Double.toString(d));
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            int n = string.length();
            if (this.limit >= 0 && n >= this.limit) {
                n = this.limit;
            }
            this.clear();
            this.ensure(n);
            string.getChars(0, n, this.value, 0);
            this.length = n;
        }
    }

    public void setDate(java.sql.Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatDate((Date)date, timeZone));
        } else {
            this.setString(SqlDates.formatDate((Date)date, false));
        }
    }

    public void setTime(Time time, TimeZone timeZone) throws SqlEx {
        if (time == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTime((Date)time, timeZone));
        } else {
            this.setString(SqlDates.formatTime((Date)time, false));
        }
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        if (timestamp == null) {
            this.setNull();
        } else if (timeZone != null) {
            this.setString(SqlDates.formatTimestamp((Date)timestamp, timeZone));
        } else {
            this.setString(SqlDates.formatTimestamp((Date)timestamp, false));
        }
    }

    public boolean getBoolean() throws SqlEx {
        String string = this.getString(this.length).trim();
        return string.equals("1") ? true : Boolean.valueOf(string);
    }

    public byte getByte() throws SqlEx {
        return Byte.parseByte(this.getString(this.length).trim());
    }

    public short getShort() throws SqlEx {
        return Short.parseShort(this.getString(this.length).trim());
    }

    public int getInt() throws SqlEx {
        return Integer.parseInt(this.getString(this.length).trim());
    }

    public long getLong() throws SqlEx {
        return Long.parseLong(this.getString(this.length).trim());
    }

    public float getFloat() throws SqlEx {
        return Float.parseFloat(this.getString(this.length).trim());
    }

    public double getDouble() throws SqlEx {
        return Double.parseDouble(this.getString(this.length).trim());
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return new BigDecimal(this.getString(this.length).trim());
    }

    public String getString() throws SqlEx {
        return this.getString(this.length);
    }

    public String getString(int n) throws SqlEx {
        if (n > this.length) {
            n = this.length;
        }
        return String.valueOf(this.value, 0, n);
    }

    public java.sql.Date getDate(TimeZone timeZone) throws SqlEx {
        String string = this.getString(this.length).trim();
        return timeZone == null ? SqlDates.parseDate(string, false) : SqlDates.parseDate(string, timeZone);
    }

    public Time getTime(TimeZone timeZone) throws SqlEx {
        String string = this.getString(this.length).trim();
        return timeZone == null ? SqlDates.parseTime(string, false) : SqlDates.parseTime(string, timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        String string = this.getString(this.length).trim();
        return timeZone == null ? SqlDates.parseTimestamp(string, false) : SqlDates.parseTimestamp(string, timeZone);
    }

    public InputStream getAsciiStream() throws SqlEx {
        return SqlNVarChar.getAscii(this.getString());
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return SqlNVarChar.getUnicode(this.getString());
    }

    public Reader getCharacterStream() throws SqlEx {
        return SqlNVarChar.getCharacter(this.value, 0, this.length);
    }

    public Object getObject() throws SqlEx {
        return this.getString();
    }

    public Object getObject(int n) throws SqlEx {
        return this.getString(n);
    }
}

