/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class SqlStream
extends SqlData
implements GcfErr {
    private Object stream = null;
    private boolean active = false;
    private StreamListener listener = null;
    private byte[] bbuff = null;
    private char[] cbuff = null;

    protected abstract Reader cnvtIS2Rdr(InputStream var1) throws SqlEx;

    protected SqlStream() {
        super(true);
    }

    protected SqlStream(StreamListener streamListener) {
        this();
        this.listener = streamListener;
    }

    public synchronized void setNull() {
        super.setNull();
        this.stream = null;
        this.active = false;
    }

    public String toString() {
        return "SqlStream: " + (this.stream == null ? "NULL" : this.stream.toString());
    }

    public synchronized void closeStream() {
        this.active = true;
        if (this.stream == null) {
            return;
        }
        try {
            if (this.stream instanceof InputStream) {
                ((InputStream)this.stream).close();
            } else if (this.stream instanceof Reader) {
                ((Reader)this.stream).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected synchronized void setStream(Object object) throws SqlEx {
        if (object == null) {
            this.setNull();
        } else {
            if (!(object instanceof InputStream) && !(object instanceof Reader)) {
                throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
            }
            this.setNotNull();
            this.active = false;
            this.stream = object;
            if (object instanceof StreamSource) {
                ((StreamSource)object).addStreamListener(this.listener, this);
            }
        }
    }

    protected Object getStream() throws SqlEx {
        this.checkAccess();
        return this.stream;
    }

    protected InputStream getBinary() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return (InputStream)this.stream;
        }
        throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
    }

    protected InputStream getAscii() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return new Rdr2IS(this.cnvtIS2Rdr((InputStream)this.stream), "US-ASCII");
        }
        if (this.stream instanceof Reader) {
            return new Rdr2IS((Reader)this.stream, "US-ASCII");
        }
        throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
    }

    protected InputStream getUnicode() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return new Rdr2IS(this.cnvtIS2Rdr((InputStream)this.stream), "UTF-8");
        }
        if (this.stream instanceof Reader) {
            return new Rdr2IS((Reader)this.stream, "UTF-8");
        }
        throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
    }

    protected Reader getCharacter() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return this.cnvtIS2Rdr((InputStream)this.stream);
        }
        if (this.stream instanceof Reader) {
            return (Reader)this.stream;
        }
        throw SqlEx.get(GcfErr.ERR_GC401A_CONVERSION_ERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyIs2Os(InputStream inputStream, OutputStream outputStream) throws SqlEx {
        Object object;
        if (this.bbuff == null) {
            object = this;
            synchronized (object) {
                if (this.bbuff == null) {
                    this.bbuff = new byte[8192];
                }
            }
        }
        try {
            object = this.bbuff;
            synchronized (this.bbuff) {
                int n = inputStream.read(this.bbuff);
                while (n >= 0) {
                    outputStream.write(this.bbuff, 0, n);
                    n = inputStream.read(this.bbuff);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                inputStream.close();
                outputStream.flush();
            }
        }
        catch (Exception exception) {
            try {
                inputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                outputStream.flush();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw SqlEx.get(GcfErr.ERR_GC4007_BLOB_IO, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyRdr2Wtr(Reader reader, Writer writer) throws SqlEx {
        Object object;
        if (this.cbuff == null) {
            object = this;
            synchronized (object) {
                if (this.cbuff == null) {
                    this.cbuff = new char[4096];
                }
            }
        }
        try {
            object = this.cbuff;
            synchronized (this.cbuff) {
                int n = reader.read(this.cbuff);
                while (n >= 0) {
                    writer.write(this.cbuff, 0, n);
                    n = reader.read(this.cbuff);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                reader.close();
                writer.flush();
            }
        }
        catch (Exception exception) {
            try {
                reader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                writer.flush();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw SqlEx.get(GcfErr.ERR_GC4007_BLOB_IO, exception);
        }
    }

    private synchronized void checkAccess() throws SqlEx {
        if (this.active) {
            throw SqlEx.get(GcfErr.ERR_GC401C_BLOB_DONE);
        }
        this.active = true;
    }

    private static class Rdr2IS
    extends InputStream {
        private static final int EOI_RDR = 1;
        private static final int EOI_ENC = 2;
        private static final int EOI_OUT = 4;
        private static final int EOI = 7;
        private Reader rdr = null;
        private CharsetEncoder encoder = null;
        private CharBuffer inBuff = CharBuffer.allocate(8192);
        private ByteBuffer outBuff = ByteBuffer.allocate(8192);
        private int eoi_flags = 0;
        private byte[] ba = new byte[1];

        public Rdr2IS(Reader reader, String string) {
            this.rdr = reader;
            this.encoder = Charset.forName(string).newEncoder();
            this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.inBuff.flip();
            this.outBuff.flip();
        }

        public int read() throws IOException {
            return this.read(this.ba, 0, 1) == -1 ? -1 : this.ba[0] & 0xFF;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            int n4 = n;
            if ((this.eoi_flags & 4) == 0) {
                while (n < n3) {
                    if (!this.outBuff.hasRemaining() && !this.fillOutput()) {
                        this.eoi_flags |= 4;
                        break;
                    }
                    n2 = Math.min(n3 - n, this.outBuff.remaining());
                    this.outBuff.get(byArray, n, n2);
                    n += n2;
                }
            }
            return n2 > 0 && n == n4 ? -1 : n - n4;
        }

        public long skip(long l) throws IOException {
            long l2 = l;
            if ((this.eoi_flags & 4) == 0) {
                while (l > 0L) {
                    if (!this.outBuff.hasRemaining() && !this.fillOutput()) {
                        this.eoi_flags |= 4;
                        break;
                    }
                    long l3 = Math.min(l, (long)this.outBuff.remaining());
                    this.outBuff.position(this.outBuff.position() + (int)l3);
                    l -= l3;
                }
            }
            return l2 - l;
        }

        public void close() throws IOException {
            this.rdr.close();
            this.eoi_flags |= 7;
        }

        private boolean fillInput() throws IOException {
            boolean bl = false;
            this.inBuff.clear();
            if ((this.eoi_flags & 1) == 0) {
                int n = this.rdr.read(this.inBuff.array());
                if (n < 0) {
                    this.eoi_flags |= 1;
                } else {
                    this.inBuff.position(this.inBuff.position() + n);
                    bl = true;
                }
            }
            this.inBuff.flip();
            return bl;
        }

        private boolean fillOutput() throws IOException {
            this.outBuff.clear();
            if ((this.eoi_flags & 2) == 0) {
                do {
                    if (this.inBuff.hasRemaining() || this.fillInput()) continue;
                    if (this.outBuff.position() != 0) break;
                    this.encoder.encode(this.inBuff, this.outBuff, true);
                    this.encoder.flush(this.outBuff);
                    this.eoi_flags |= 2;
                    break;
                } while (this.encoder.encode(this.inBuff, this.outBuff, false) == CoderResult.UNDERFLOW);
            }
            this.outBuff.flip();
            return this.outBuff.hasRemaining();
        }
    }

    public static interface StreamSource {
        public void addStreamListener(StreamListener var1, SqlStream var2);
    }

    public static interface StreamListener {
        public void streamClosed(SqlStream var1);
    }
}

