/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.Config;
import com.ingres.gcf.util.ConfigEmpty;
import com.ingres.gcf.util.ConfigKey;
import com.ingres.gcf.util.ConfigSys;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class TraceLog {
    private static final String TRACE_KEY_PREFIX = "trace";
    private static final String TRACE_LOG_KEY = "log";
    private static final String TRACE_TIME_KEY = "timestamp";
    private Config config = null;
    private PrintWriter trace_log = null;
    private Hashtable levels = new Hashtable();
    private boolean trace_time = false;
    private static Hashtable trace_logs = new Hashtable();
    private static TraceLog default_log = null;
    private static Date now = new Date();
    private static long last_time = 0L;
    private static String last_ts = "";
    private static DateFormat df_ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static char[] hex_buff = new char[68];
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static TraceLog getTraceLog() {
        if (default_log == null) {
            default_log = new TraceLog(new ConfigEmpty());
        }
        return default_log;
    }

    public static TraceLog getTraceLog(String string) {
        TraceLog traceLog = (TraceLog)trace_logs.get(string);
        if (traceLog == null) {
            Config config = new ConfigSys();
            config = new ConfigKey(string, config);
            traceLog = new TraceLog(config);
            trace_logs.put(string, traceLog);
        }
        return traceLog;
    }

    public static TraceLog getTraceLog(Config config) {
        return new TraceLog(config);
    }

    private TraceLog(Config config) {
        this.config = new ConfigKey(TRACE_KEY_PREFIX, config);
        String string = this.config.get(TRACE_LOG_KEY);
        if (string != null) {
            this.setTraceLog(string);
        }
        if ((string = this.config.get(TRACE_TIME_KEY)) != null && (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enable") || string.equalsIgnoreCase("enabled"))) {
            this.trace_time = true;
        }
    }

    protected void finalize() throws Throwable {
        this.setTraceLog(null);
        super.finalize();
    }

    public boolean enabled() {
        return this.trace_log != null;
    }

    public boolean setTraceLog(String string) {
        boolean bl = true;
        if (this.trace_log != null) {
            this.trace_log.close();
            this.trace_log = null;
        }
        if (string != null) {
            try {
                this.trace_log = new PrintWriter(new FileOutputStream(string), true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.trace_log = null;
                bl = false;
            }
        }
        return bl;
    }

    public TraceLevel getTraceLevel(String string) {
        TraceLevel traceLevel = (TraceLevel)this.levels.get(string);
        if (traceLevel == null) {
            int n = 0;
            String string2 = this.config.get(string);
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            traceLevel = new TraceLevel(n);
            this.levels.put(string, traceLevel);
        }
        return traceLevel;
    }

    public void write(String string) {
        if (this.trace_log != null) {
            if (this.trace_time) {
                this.trace_log.print(TraceLog.timestamp());
                this.trace_log.print(": ");
            }
            this.trace_log.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void hexdump(byte[] byArray, int n, int n2) {
        if (this.trace_log == null) return;
        char[] cArray = hex_buff;
        synchronized (hex_buff) {
            while (n2 > 0) {
                int n3;
                for (n3 = 0; n3 < hex_buff.length; ++n3) {
                    TraceLog.hex_buff[n3] = 32;
                }
                for (n3 = 0; n2 > 0 && n3 < 16; --n2, ++n3) {
                    TraceLog.hex_buff[n3 * 3] = hex[byArray[n] >> 4 & 0xF];
                    TraceLog.hex_buff[n3 * 3 + 1] = hex[byArray[n] & 0xF];
                    TraceLog.hex_buff[52 + n3] = byArray[n] >= 32 && byArray[n] < 127 ? (int)byArray[n] : 46;
                    ++n;
                }
                this.trace_log.println(hex_buff);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String timestamp() {
        long l = System.currentTimeMillis();
        if (l != last_time) {
            Date date = now;
            synchronized (date) {
                last_time = l;
                now.setTime(last_time);
                last_ts = df_ts.format(now);
            }
        }
        return last_ts;
    }

    public static class TraceLevel {
        private int level;

        public TraceLevel(int n) {
            this.level = n;
        }

        public int get() {
            return this.level;
        }

        public synchronized int set(int n) {
            int n2 = this.level;
            this.level = n;
            return n2;
        }
    }
}

