import java.awt.*;
import java.applet.*;
import JMapCanvas;
import JMapObserverFeatures;
import JMapObserverIcons;
import JMapObserverGridLines;
import JMapObserverPosition;
import JMapObserverZoom;
import JMapTransformMercator;
import JMapDataRepository;
import symantec.itools.lang.Context;
import java.net.URL;

public class GeoMap extends Applet {
    
	//{{DECLARE_CONTROLS
	//}}
	
	private JMapCanvas canvasMap;
	private JMapDataRepository dataRep;


	public void init() {

		super.init();

	    Context.setDocumentBase(getDocumentBase());
        Context.setApplet(this);

		//{{INIT_CONTROLS
		setLayout(null);
		addNotify();
		resize(640,500);
		//}}
		
        //Build the data repository and have it grab data from the given URLs
        String strData = getParameter("DATAFILE");
        String strTag = getParameter("TAGFILE");
        dataRep = new JMapDataRepository(strData,strTag);

        //Build the map canvas
		canvasMap = new JMapCanvas();
		canvasMap.reshape(0,0,bounds().width,bounds().height);
		canvasMap.setBackground(Color.white);
		JMapRectangle rec = dataRep.getMapRectangle();
		canvasMap.pushTransform(new JMapTransformMercator(new Rectangle(0,42,bounds().width,bounds().height),rec.x1,rec.y1,rec.x2,rec.y2));
		add(canvasMap);

        //Build the Observers for the map.. perhaps this info should be specified in
        //a config file on the server so as to make the maps user definable.
		new JMapObserverIcons(canvasMap, dataRep);
		new JMapObserverFeatures(canvasMap, dataRep);
		new JMapObserverGridLines(canvasMap);
		new JMapObserverZoom(canvasMap);
		new JMapObserverPosition(canvasMap);
        new JMapObserverTransform(canvasMap);

	}

	public boolean handleEvent(Event event) {
	
		return super.handleEvent(event);
	}

	
}
