import JMapObservable;
import JMapTransformBase;
import java.awt.*;
import java.util.*;

class JMapCanvas extends java.awt.Canvas
{
    private Point p1_, p2_, pCurrent_;
    private boolean isPressed_;
    private Image imgCanvas_ = null;

    private JMapTransformBase lastTransform_ = null;
    private JMapTransformBase prevTransform_ = null;
    private Vector vecTransform = new Vector();
    private Vector vecImages = new Vector();
    
    private JMapObservable obDraw_;
    private JMapObservable obConfigure_;
    private JMapObservable obMouseAreaSelection_;
    private JMapObservable obMouseButtonPressed_;
    private JMapObservable obMouseMove_;
    private JMapObservable obMouseDrag_;
   
    public JMapObservable obDraw(){return obDraw_;}
    public JMapObservable obConfigure(){return obConfigure_;}
    public JMapObservable obMouseAreaSelection(){return obMouseAreaSelection_;}
    public JMapObservable obMouseButtonPressed(){return obMouseButtonPressed_;}
    public JMapObservable obMouseMove(){return obMouseMove_;}
    public JMapObservable obMouseDrag(){return obMouseDrag_;}
    
    
    
    public void pushTransform(JMapTransformBase mt){
        vecTransform.addElement(mt);
    }
    
    public JMapTransformBase popTransform(){
        if(vecTransform.size()>1)
            vecTransform.removeElement(vecTransform.lastElement());
        return (JMapTransformBase)(vecTransform.lastElement());   
    }
    
    public JMapTransformBase prevTransform(){
        if(vecTransform.size() > 1)
            return (JMapTransformBase)(vecTransform.elementAt(vecTransform.size()-2));   
        return null;
    }
    
    public JMapTransformBase getTransform(){
        return (JMapTransformBase)(vecTransform.lastElement());   
    }
    
    JMapCanvas(){
        p1_ = new Point(0,0);
        p2_ = new Point(0,0);
        pCurrent_ = new Point(0,0);
        obDraw_ = new JMapObservable();
        obConfigure_ = new JMapObservable();
        obMouseAreaSelection_ = new JMapObservable();
        obMouseButtonPressed_ = new JMapObservable();
    	obMouseMove_ = new JMapObservable();
    	obMouseDrag_ = new JMapObservable();
	}

    void drawAreaSelection(){
        Graphics g = getGraphics();
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        Point p0_ = pCurrent_;
        if(p1_.x == p0_.x && p1_.y == p0_.y)
            return;
        if(p1_.x == p0_.x || p1_.y == p0_.y){
    		g.drawLine(p1_.x,p1_.y,p0_.x,p0_.y);
    	}
        else if(p1_.x < p0_.x){
    		if(p1_.y<p0_.y)   
    			g.drawRect(p1_.x,p1_.y,p0_.x-p1_.x,p0_.y-p1_.y);
    		else    
    			g.drawRect(p1_.x,p0_.y,p0_.x-p1_.x,p1_.y-p0_.y);
        }
        else{
    		if(p1_.y > p0_.y)    
                g.drawRect(p0_.x,p0_.y,p1_.x-p0_.x,p1_.y-p0_.y);
    		else    
    			g.drawRect(p0_.x,p1_.y,p1_.x-p0_.x,p0_.y-p1_.y);
        }
    }
    
   	void JMapCanvas_MouseDrag(Event event) {
        drawAreaSelection();
        pCurrent_.x = event.x;
        pCurrent_.y = event.y;
        drawAreaSelection();
        isPressed_ = true;
        obMouseDrag_.notifyObservers(pCurrent_);
	}

	void JMapCanvas_MouseMove(Event event) {
        pCurrent_.x = event.x;
        pCurrent_.y = event.y;
        isPressed_ = false;
        obMouseMove_.notifyObservers(pCurrent_);
	}

    void JMapCanvas_MouseUp(Event event) {
        int minZoomSize = 10;
        p2_.x = event.x;
        p2_.y = event.y;
        if(isPressed_){
            Graphics g = getGraphics();
            g.setPaintMode();
            if(p2_.x == p1_.x && p2_.y == p1_.y)
                obMouseButtonPressed_.notifyObservers(pCurrent_);
    		else if(p1_.x+minZoomSize < p2_.x){
    		    if(p1_.y+minZoomSize < p2_.y)
    				obMouseAreaSelection_.notifyObservers(new Rectangle(p1_.x,p1_.y,p2_.x-p1_.x,p2_.y-p1_.y));
    			else if(p1_.y > p2_.y+minZoomSize)
    				obMouseAreaSelection_.notifyObservers(new Rectangle(p1_.x,p2_.y,p2_.x-p1_.x,p1_.y-p2_.y));
    		}
    		else if(p1_.x > p2_.x+minZoomSize){
    		    if(p1_.y > p2_.y+minZoomSize)
    				obMouseAreaSelection_.notifyObservers(new Rectangle(p2_.x,p2_.y,p1_.x-p2_.x,p1_.y-p2_.y));
    			else if(p1_.y+minZoomSize < p2_.y)
    				obMouseAreaSelection_.notifyObservers(new Rectangle(p2_.x,p1_.y,p1_.x-p2_.x,p2_.y-p1_.y));
    		}
    		else
    		     drawAreaSelection();
    	}
        isPressed_ = false;
	}

	void JMapCanvas_MouseDown(Event event) {
        p1_.x = event.x;
        p1_.y = event.y;
        pCurrent_.x = p1_.x;
        pCurrent_.y = p1_.y;
        p2_.x = p1_.x;
        p2_.y = p1_.y;
        isPressed_ = true;
	}

    //Double buffered paint method.
    public void paint(Graphics g){
        //This uses image and transform cacheing.. if the display data becomes
        //dynamic (i.e. drawing graph circles on the map you'll want to ditch
        //the image cacheing so that the screen gets redrawn from scratch
        //as you zoom out.  
        
        //Image cache
        if(getTransform() == prevTransform_){
            vecImages.removeElement(vecImages.lastElement());
            imgCanvas_ = (Image)vecImages.lastElement();
        }
        else if(vecTransform.size() == 1 && vecImages.size() == 1){
            imgCanvas_ = (Image)vecImages.lastElement();
        }
        //end Image cache block
        
        else if(getTransform() != lastTransform_ || imgCanvas_ == null){
            lastTransform_ = getTransform();
        	imgCanvas_ = createImage(size().width,size().height);
        	vecImages.addElement(imgCanvas_);
            Graphics ig = imgCanvas_.getGraphics();
            ig.setPaintMode();
            obConfigure_.notifyObservers(getTransform());        
            obDraw_.notifyObservers(ig);
            ig.setColor(new Color(0,0,0));
            ig.drawRect(0,0,imgCanvas_.getWidth(this)-1,imgCanvas_.getHeight(this)-1);
        }
        
        prevTransform_ = prevTransform();
        g.drawImage(imgCanvas_,0,0,this);
    }

	public boolean handleEvent(Event event) {
		if (event.target == this && event.id == Event.MOUSE_UP) {
			JMapCanvas_MouseUp(event);
			return true;
		}
		if (event.target == this && event.id == Event.MOUSE_DOWN) {
			JMapCanvas_MouseDown(event);
			return true;
		}
		if (event.target == this && event.id == Event.MOUSE_MOVE) {
			JMapCanvas_MouseMove(event);
			return true;
		}
		if (event.target == this && event.id == Event.MOUSE_DRAG) {
			JMapCanvas_MouseDrag(event);
			return true;
		}
		return super.handleEvent(event);
	}
}

