import java.net.*;
import java.io.*;
import java.util.*;
import JMapObject;


class JMapContentHandler extends java.net.ContentHandler
{
    String strBuffer_ = "";
    int iBufPos = 0;
    int iLength = 0;    
    Vector vecMapObjects_;
    Vector vecTags_;
    
    JMapContentHandler(Vector tags){
        super();
        vecTags_ = tags;   
    }
    
    public Object getContent(URLConnection urlc){
        vecMapObjects_ = new Vector();
	    byte bBuffer[];
	    try{
            InputStream is = urlc.getInputStream();
            DataInputStream ds = new DataInputStream(is);
            iLength = urlc.getContentLength();
            if(iLength != -1){
                bBuffer = new byte[iLength];
                ds.readFully(bBuffer);
                strBuffer_ = new String(bBuffer,0);
            }
            else{
                int i = is.read();
                while(i != -1){
                       strBuffer_ = strBuffer_+(char)i;
                       i = is.read();
                }
            }
            return parseDataBuffer();
    	}
	    catch (IOException e) {}
        return null;        
    }

	private protected Object parseDataBuffer(){

        String strToken, lineToken = "", charHeading;
        int isMatch;
        int endPos;
        int iStart, iStop;
        Integer deglon, minlon, seclon, deglat, minlat, seclat;
        double lat, lon;
        String strObjType, strObjLabel, tagName;
        StringTokenizer sts;
        JMapObject mapObject;
        JMapPoint mapPoint;
        isMatch =0;
        
        StringTokenizer st = new StringTokenizer(strBuffer_,"\t\n\r"); 
        while (st.hasMoreTokens()) { 
            
            strToken = st.nextToken(); 
            isMatch =0;
            for(int j=0;j<vecTags_.size();j++){
                tagName = vecTags_.elementAt(j).toString();
                if(strToken.startsWith(tagName)){
                    isMatch = 1;
                    sts = new StringTokenizer(strToken," \t\n\r"); 
                    strObjType = sts.nextToken(); 
                    if(sts.hasMoreTokens()){
                        strObjLabel = new String(sts.nextToken());
                    }
                    else 
                        strObjLabel = new String("no label");
                    mapObject = new JMapObject(strObjType,strObjLabel); 
                    lineToken = new String(strObjType);
                    while(st.hasMoreTokens() && !lineToken.equals("end")){
                        strToken = st.nextToken();
                        sts = new StringTokenizer(strToken," \t\n\r"); 
                        lineToken = sts.nextToken(); //latlon
                        if(lineToken.equals("latlon") || lineToken.equals("icon_location")){
                            try{
                                deglat = Integer.valueOf(sts.nextToken());
                                minlat = Integer.valueOf(sts.nextToken());
                                seclat = Integer.valueOf(sts.nextToken());
                                charHeading = sts.nextToken();
                                deglon = Integer.valueOf(sts.nextToken());
                                minlon = Integer.valueOf(sts.nextToken());
                                seclon = Integer.valueOf(sts.nextToken());
                                charHeading = sts.nextToken();
                                lat = deglat.doubleValue() + minlat.doubleValue()/60.0 + seclat.doubleValue()/3600.0;
                    			lon = deglon.doubleValue() + minlon.doubleValue()/60.0 + seclon.doubleValue()/3600.0;
                    			mapObject.insert(lon,lat);
                    		}catch(NoSuchElementException e){}
                		}
                		if(lineToken.equals("end")){
                		    //strObjLabel = sts.nextToken();    
                		    vecMapObjects_.addElement(mapObject);// build object and insert it into a vector;   
                		    break;
                		}
                	}//while parsing object
                }//if starts with type
                if(isMatch == 1)
                    break;
           }//for num types
        }//while more tokens
        isMatch = 0;
   	    return vecMapObjects_;	    
	}
	
    private protected int buildMapObject(int type, String label){ 
        
        return 0;
    }

}

