import java.util.*;
import java.awt.*;
import java.net.*;
import java.io.*;
import JMapPoint;
import JMapRectangle;
import JMapObject;
import JMapContentHandler;
import JMapTagsContentHandler;
import symantec.itools.lang.Context;

class JMapDataRepository {

    private Vector vecFeatures_ = new Vector();
    private Vector vecIcons_ = new Vector();
    private Vector vecTags_ = new Vector();
    private JMapRectangle recInitialMap_;
    private URL urlDataSource_;  //map input file
    private URL urlTagSource_;  //map input file
    
    JMapContentHandler handler;
    JMapTagsContentHandler tagHandler;
    
    public JMapDataRepository(String dataSource,String tagSource){
        getDataFromSource(dataSource, tagSource);
    }
    public JMapDataRepository(){
        
    }
    public JMapRectangle getMapRectangle(){
        return new JMapRectangle(recInitialMap_);
    }
    public boolean getDataFromSource(String dataSource, String tagSource){
       
        tagHandler = new JMapTagsContentHandler();
        try{
            urlTagSource_ = new URL(Context.getApplet().getDocumentBase(),tagSource);
        }
        catch (MalformedURLException e) {}
        try {
            URLConnection urlConnect = urlTagSource_.openConnection();
            urlConnect.connect();
            Object o = tagHandler.getContent(urlConnect);
            if(o instanceof Vector){
                vecTags_ = (Vector)o;
            }
            recInitialMap_ = tagHandler.getInitialMap();
        }
        catch (IOException e) {}
        
        if(vecTags_.size() > 0){
            handler = new JMapContentHandler(vecTags_);
            try{
                urlDataSource_ = new URL(Context.getApplet().getDocumentBase(),dataSource);
            }
            catch (MalformedURLException e) {}
            try {
                URLConnection urlConnect = urlDataSource_.openConnection();
                urlConnect.connect();
                Object o = handler.getContent(urlConnect);
                if(o instanceof Vector){
                    vecFeatures_ = (Vector)o;
                }
            }
            catch (IOException e) {}
        }
        
        return true;
    }
    
    public int getFeatureEntries(){
        return vecFeatures_.size();
    }
	public int getIconEntries(){
	    return vecIcons_.size();
	}
	public int getTagEntries(){
	    return vecTags_.size();
	}
	public JMapObject getFeatureAt(int i){
        return (JMapObject)vecFeatures_.elementAt(i);
    }
	public JMapObject getIconAt(int i){
	    return (JMapObject)vecIcons_.elementAt(i);
	}
    public Vector getVecFeatures(){ 
        return vecFeatures_; 
    }
    public Vector getVecIcon(){ 
        return vecIcons_;
    }
    public Vector getVecTags(){ 
        return vecTags_;
    }

}



