import java.util.*;
import JMapPoint;

class JMapObject extends Object {
  
    private protected double dMaxX,dMaxY,dMinX,dMinY; // max and min points in the object;
    private protected Vector vecPointList_;   
    private protected String strObjType_;
    private protected String strObjLabel_;
    private protected int init_;

    
    JMapObject(String objType, String objLabel){
        init_ = 0;    
        strObjType_ = new String(objType);
        strObjLabel_ = new String(objLabel);
        vecPointList_ =  new Vector();
    }
    
    public int entries(){ 
		return vecPointList_.size();
	}
	
    public int clear(){
		vecPointList_.removeAllElements();
		return vecPointList_.size();
    }
    
    public JMapPoint at(int i){
		return (JMapPoint)vecPointList_.elementAt(i);
    }
	
	public String getLabel(){	
		return strObjLabel_; 
	}
	
	public void setLabel(String label){
		strObjLabel_ = new String(label);
	}
    
    public Vector getVector(){ 
		return vecPointList_; 
	}
	
    public String getObjType(){
		return strObjType_;
	}
	
	public JMapPoint getMin(){ 
	    return new JMapPoint(dMinX,dMinY); 
	}
	
	public JMapPoint getMax(){ 
	    return new JMapPoint(dMaxX,dMaxY); 
	}
	
    public int insert(double x, double y){
        setMinMax(x,y);
        vecPointList_.addElement(new JMapPoint(x,y));
        return vecPointList_.size();
    }

    public int insert(JMapPoint mp){
        setMinMax(mp.x,mp.y);
        vecPointList_.addElement(new JMapPoint(mp.x,mp.y));
        return vecPointList_.size();
    }
    
    public int intersects(double x1, double y1, double x2, double y2){
        double X, Y;
        if(x1>x2){X=x2;x2=x1;x1=X;}
        if(y1>y2){Y=y2;y2=y1;y1=Y;}
    	if(x1>=dMinX && x1<=dMaxX && y1>=dMinY && y1<=dMaxY) return 1; //x1,y1
    	if(x2>=dMinX && x2<=dMaxX && y2>=dMinY && y2<=dMaxY) return 1; //x2,y2
        if(x1<=dMinX && x2>=dMinX && y1<=dMinY && y2>=dMinY) return 1; //dMinX,dMinY
        if(x1<=dMaxX && x2>=dMaxX && y1<=dMaxY && y2>=dMaxY) return 1; //dMaxX,dMaxY

    	if(x1>=dMinX && x1<=dMaxX && y2>=dMinY && y2<=dMaxY) return 1; //x1,y2
    	if(x2>=dMinX && x2<=dMaxX && y1>=dMinY && y1<=dMaxY) return 1; //x2,y1
        if(x1<=dMinX && x2>=dMinX && y1<=dMaxY && y2>=dMaxY) return 1; //dMinX,dMaxY
        if(x1<=dMaxX && x2>=dMaxX && y1<=dMinY && y2>=dMinY) return 1; //dMaxX,dMinY

    	if(x1>=dMinX && x2<=dMaxX && y1<=dMinY && y2>=dMaxY) return 1; // No verticies, just center sections.
    	if(x1<=dMinX && x2>=dMaxX && y1>=dMinY && y2<=dMaxY) return 1;
        return 0;
 
    }
    
	public int intersects(JMapPoint p1, JMapPoint p2){
        return intersects(p1.x,p1.y, p2.x,p2.y);
	    
	}
    
    private protected void setMinMax(double x, double y){
        if(init_ == 0){
        	dMinX=x;
        	dMaxX=x;
        	dMinY=y;
        	dMaxY=y;
        	init_++;
        }
        else{
        	if(x<dMinX)dMinX=x;
        	if(x>dMaxX)dMaxX=x;
        	if(y<dMinY)dMinY=y;
        	if(y>dMaxY)dMaxY=y;
        }
    }
}

