import java.awt.*;
import java.util.*;
import JMapCanvas;
import JMapTransformBase;

abstract class JMapObserverBase implements Observer {
    
   protected JMapCanvas canvas_;
   protected JMapTransformBase transform_;
   
   public JMapObserverBase(JMapCanvas canvas){
        canvas_ = canvas; 
   }
   
   public void update(Observable o, Object obj){
        if(canvas_.isVisible() && canvas_.isValid()){
            transform_ = canvas_.getTransform();
            if(obj instanceof Graphics){
                draw((Graphics)obj);            
            }
        }
   }
   
   protected void draw(Graphics g){
        if(canvas_.isVisible() && canvas_.isValid()){
            canvas_.getGraphics().drawString("WARNING: Derived classes should override JMapObserverBase::draw().",50,50);
        }
   }

}

