import java.awt.*;
import java.util.*;
import JMapObserverBase;
import JMapTransformBase;
import JMapPoint;
import JMapObject;
import JMapDataRepository;

class JMapObserverFeatures extends JMapObserverBase
{
    int lock_ =0;
    JMapDataRepository dataRepository_;
    
    JMapObserverFeatures(JMapCanvas canvas, JMapDataRepository drep){
        super(canvas);
        dataRepository_ = drep;
        canvas.obDraw().addObserver(this);
    }
    
    protected void draw(Graphics g){
						 	
    	Rectangle r;
    	Vector itr, pItr;
    	JMapPoint mp0, mp1;
    	JMapObject mo;		
        Color c;
        Point p0, p1;
        
    	if(lock_ == 0 && canvas_.isVisible() && canvas_.isValid()){
    		lock_=1;
    		r = new Rectangle();
    		r  = canvas_.bounds();
    		
    		itr = dataRepository_.getVecFeatures();
            
    		for(int i=0;i<itr.size();i++){
    		    mo = (JMapObject)itr.elementAt(i);
    		    c = getColor(mo.getObjType());
    		    if(c == null)
    		        continue;
    		    else
    		        g.setColor(c);
    		    mp0 = transform_.getPoint(0,0);
    		    mp1 = transform_.getPoint(r.width,r.height);
    			if(mo.intersects(mp0,mp1) == 1){
    				pItr=mo.getVector();
				    for(int j=0;j<pItr.size()-1;j++){
    					mp0=(JMapPoint)pItr.elementAt(j);
    					mp1=(JMapPoint)pItr.elementAt(j+1);
    					p0 = transform_.getPoint(mp0.x, mp0.y);
    					p1 = transform_.getPoint(mp1.x, mp1.y);
    					g.drawLine(p0.x,p0.y,p1.x,p1.y);    					
    				}
    			}
    		}
    		lock_=0;
    	}
    }

    private Color getColor(String type){
        Vector tags = dataRepository_.getVecTags();
        String tag;
        for(int i=0;i<tags.size();i++){
            tag = ((JMapTag)tags.elementAt(i)).getObjType();
            if(type.equals(tag))
                return ((JMapTag)tags.elementAt(i)).getColor();
        }
        return new Color(255,0,0);
    }
}