import java.awt.image.*;
import java.awt.*;
import java.util.*;
import JMapObserverBase;
import JMapTransformBase;
import JMapPoint;
import JMapObject;
import JMapDataRepository;

class JMapObserverIcons extends JMapObserverBase
{
    int lock_ = 0;
    JMapDataRepository dataRepository_;

    JMapObserverIcons(JMapCanvas canvas, JMapDataRepository data){
        super(canvas);
        dataRepository_ = data;
        canvas.obDraw().addObserver(this);
    }

    protected void draw(Graphics g){

    	Rectangle r;
    	Vector itr, pItr;
    	JMapPoint mp0, mp1;
    	JMapObject mo;
        Point p0;
        Image im;
        
    	if(lock_ == 0 && canvas_.isVisible() && canvas_.isValid()){
    		lock_=1;
    		r = new Rectangle();
    		r  = canvas_.bounds();
    		r = new Rectangle(0,0,r.width,r.height);
    		itr = dataRepository_.getVecFeatures();
    		for(int i=0;i<itr.size();i++){
    		    g.setColor(new Color(0,0,228));
    		    mo = (JMapObject)itr.elementAt(i);
    		    im = getImage(mo.getObjType());
    		    if(im == null)
    		        continue;
    		    mp0 = transform_.getPoint(0,0);
    		    mp1 = transform_.getPoint(r.width,r.height);
                if(mo.intersects(mp0,mp1) == 1){
		        	pItr=mo.getVector();
				    mp0=(JMapPoint)pItr.elementAt(0);
				    p0 = transform_.getPoint(mp0);
				    g.drawImage(im,p0.x-im.getWidth(canvas_)/2,
				                   p0.y-im.getHeight(canvas_)/2,
				                   canvas_);
                }
            }
    		lock_=0;
    	}
    }
    private Image getImage(String type){
        Vector tags = dataRepository_.getVecTags();
        String tag;
        for(int i=0;i<tags.size();i++){
            tag = ((JMapTag)tags.elementAt(i)).getObjType();
            if(type.equals(tag))
                return ((JMapTag)tags.elementAt(i)).getImage();
        }
        return null;
    }
}
