import java.awt.*;
import java.util.*;
import JMapObserverBase;
import JMapPoint;
import JMapTransformMercator;

class JMapObserverPosition extends JMapObserverBase
{
    int lock_ =0;
    int width_=0;
    JMapObserverPosition(JMapCanvas canvas){
        super(canvas);
   		canvas.obMouseMove().addObserver(this);
		canvas.obMouseDrag().addObserver(this);
    }

    public void update(Observable o, Object obj){
        if(lock_ == 0){
            lock_ = 1;
            if(canvas_.isVisible() && canvas_.isValid()){
                transform_ = canvas_.getTransform();
                if(obj instanceof Point){
                    drawPosition((Point)obj);
                }
            }
            lock_ = 0;
        }
    }

    public void drawPosition(Point p){
        Graphics g = canvas_.getGraphics();
        JMapPoint mp = transform_.getPoint(p);
        Double dx = new Double(mp.x);
        Double dy = new Double(mp.y);
        String sdx = dx.toString();
        String sdy = dy.toString();
        while(sdx.length()<8)
            sdx = sdx+" ";
        while(sdy.length()<8)
            sdy = sdy+" ";
        String sLat = "LAT: "+sdy;
        String sLon = "LON: "+sdx;
        FontMetrics fm = g.getFontMetrics();
        if(width_ == 0)
            width_ = fm.stringWidth(sLat)+20;
        g.setColor(Color.white);
        
        g.fillRect(canvas_.bounds().width-width_,
                    canvas_.bounds().height-fm.getHeight()*3-10,
                    width_-1,
                    fm.getHeight()*2+5);
        g.setColor(Color.black);

        g.drawString(sLat,canvas_.bounds().width-width_,
                    canvas_.bounds().height-fm.getHeight()*2-10);
        g.drawString(sLon,canvas_.bounds().width-width_,
                    canvas_.bounds().height-fm.getHeight()-5);
    }

}

