import java.awt.*;
import java.util.*;
import JMapObserverBase;
import JMapPoint;
import JMapTransformMercator;

class JMapObserverZoom extends JMapObserverBase
{
    int lock_ =0;

    JMapObserverZoom(JMapCanvas canvas){
        super(canvas);
   		canvas.obMouseAreaSelection().addObserver(this);
		canvas.obMouseButtonPressed().addObserver(this);
    }

    public void update(Observable o, Object obj){
        if(lock_ == 0){
            lock_ = 1;
            if(canvas_.isVisible() && canvas_.isValid()){
                transform_ = canvas_.getTransform();
                if(obj instanceof Rectangle){
                    zoom((Rectangle)obj);
                }
                if(obj instanceof Point){
                    dezoom();
                }
            }
            lock_ = 0;
        }
    }
    
    public void dezoom(){
        transform_ = canvas_.popTransform();
        canvas_.repaint();
    }
    
    public void zoom(Rectangle zr){
        JMapPoint mp0;
        JMapPoint mp1;
        JMapPoint mp2;
        JMapPoint mp3;
        
        Rectangle r = new Rectangle();
        r = canvas_.bounds();
        double oldAspect = (double)r.width/(double)r.height;        
        double newAspect = (double)zr.width/(double)zr.height;        
        int xshift=0;
        int yshift=0;
        
	    if(oldAspect > newAspect){
			xshift = (int)((((oldAspect/newAspect)-1.0)*(double)zr.width)/2.0);
		}
		if(oldAspect < newAspect){
			yshift = (int)((((newAspect/oldAspect)-1.0)*(double)zr.height)/2.0);
		}

        mp0 = transform_.getPoint(zr.x-xshift,zr.y-yshift);
        mp1 = transform_.getPoint(zr.x+zr.width+xshift,zr.y+zr.height+yshift);
        canvas_.pushTransform(new JMapTransformMercator(r,mp0.x,mp0.y,mp1.x,mp1.y));
        canvas_.repaint();
        

        JMapTransformMercator lastTransform_ = (JMapTransformMercator)canvas_.getTransform();
        Point p1 = lastTransform_.getPoint(mp0.x,mp0.y);
        Point p2 = lastTransform_.getPoint(mp1.x,mp1.y);
        mp2 = lastTransform_.getPoint(p1.x,p1.y);
        mp3 = lastTransform_.getPoint(p2.x,p2.y);

        if(p1 == p2){
            Graphics g = canvas_.getGraphics();
        }
            
        //
        /*
        //Rectangle r = new Rectangle();
        //r = bounds();
        mp0 = lastTransform_.getPoint(r.x,r.y);
        mp1 = lastTransform_.getPoint(r.x+r.width,r.y+r.height);
        g.drawLine(p1.x,p1.y,p2.x,p2.y);
        g.drawLine(p2.x,p1.y,p1.x,p2.y);
        */

    }

}

