import java.awt.*;
import java.util.*;


class JMapTag extends Object {

    private protected Color color_;
    private protected Image image_;
    private protected String strObjType_;
    private protected boolean isColor_ = false;
    private protected boolean isImage_ = false;
    private protected Vector displayLevels_ = new Vector();

    JMapTag(String objType){
        strObjType_ = new String(objType);
    }
    JMapTag(String objType, Color c){
        strObjType_ = new String(objType);
        color_ = c;
        isColor_ = true;
    }
    JMapTag(String objType, Image im){
        strObjType_ = new String(objType);
        image_ = im;
        isImage_ = true;
    }

    public void addLevel(Integer level){
        if(level == null)
            return;
        displayLevels_.addElement(level);
    }
    public void addLevels(Vector levels){
        if(levels == null)
            return;
        for(int i=0;i<levels.size();i++){
            if(levels.elementAt(i) instanceof Integer){
                displayLevels_.addElement(levels.elementAt(i));
            }
        }
    }
    public boolean isColor(){
		return isColor_;
	}
    public boolean isImage(){
        return isImage_;
	}
    public String toString(){
        return strObjType_;
    }
    public String getObjType(){
		return strObjType_;
	}
    public Color getColor(){
        if(isColor_)
    		return color_;
    	return null;
	}
    public boolean setColor(Vector v){
       if(v == null)
            return false;
       if(v.size() == 3){
            if((v.elementAt(0) instanceof Integer) && 
               (v.elementAt(1) instanceof Integer) &&
               (v.elementAt(2) instanceof Integer)){
                color_ = new Color(((Integer)v.elementAt(0)).intValue(),
                                   ((Integer)v.elementAt(1)).intValue(),
                                   ((Integer)v.elementAt(2)).intValue()); 
                isColor_ = true;
            }
        }
    	return false;
	}
    public Image getImage(){
        if(isImage_)
    		return image_;
    	return null;
	}
    public void setImage(Image im){
        if(im != null){
            image_ = im;
            isImage_= true;
        }
	}

}

